/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.common;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.dfw.common.DiagnosticsEvent;
import oracle.dfw.common.DiagnosticsListener;

public class DiagnosticsEventManager {
    private static Map<Class<? extends DiagnosticsEvent>, List<DiagnosticsListener>> m_listeners = new HashMap<Class<? extends DiagnosticsEvent>, List<DiagnosticsListener>>();
    private static List<DiagnosticsListener> m_allEventsListeners = new LinkedList<DiagnosticsListener>();
    private static List<DiagnosticsEvent> m_queue = new LinkedList<DiagnosticsEvent>();
    private static NotifierThread m_notifierThread;

    private DiagnosticsEventManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerListener(DiagnosticsListener listener) {
        Class<? extends DiagnosticsEvent>[] clazzes = listener.getHandledEventClasses();
        if (clazzes == null) {
            return;
        }
        int size = clazzes.length;
        if (size == 0) {
            List<DiagnosticsListener> list = m_allEventsListeners;
            synchronized (list) {
                m_allEventsListeners.add(listener);
            }
            return;
        }
        for (int i = 0; i < size; ++i) {
            List<DiagnosticsListener> l;
            Class<? extends DiagnosticsEvent> c = clazzes[i];
            Object object = m_listeners;
            synchronized (object) {
                l = m_listeners.get(c);
                if (l == null) {
                    l = new LinkedList<DiagnosticsListener>();
                    m_listeners.put(c, l);
                }
            }
            object = l;
            synchronized (object) {
                l.add(listener);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterListener(DiagnosticsListener listener) {
        Class<? extends DiagnosticsEvent>[] clazzes = listener.getHandledEventClasses();
        if (clazzes == null) {
            return;
        }
        int size = clazzes.length;
        if (size == 0) {
            List<DiagnosticsListener> list = m_allEventsListeners;
            synchronized (list) {
                m_allEventsListeners.remove(listener);
            }
            return;
        }
        for (int i = 0; i < size; ++i) {
            Class<? extends DiagnosticsEvent> c = clazzes[i];
            Map<Class<? extends DiagnosticsEvent>, List<DiagnosticsListener>> map = m_listeners;
            synchronized (map) {
                List<DiagnosticsListener> l = m_listeners.get(c);
                if (l != null) {
                    List<DiagnosticsListener> list = l;
                    synchronized (list) {
                        l.remove(listener);
                        if (l.size() == 0) {
                            m_listeners.remove(c);
                        }
                    }
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends DiagnosticsEvent> void notifyListeners(T event) {
        List<DiagnosticsListener> l;
        Map<Class<? extends DiagnosticsEvent>, List<DiagnosticsListener>> map = m_listeners;
        synchronized (map) {
            l = m_listeners.get(event.getClass());
        }
        List<DiagnosticsListener> l1 = m_allEventsListeners;
        while (l != null || l1 != null) {
            DiagnosticsListener[] list;
            if (l == null) {
                l = l1;
                l1 = null;
            }
            List<DiagnosticsListener> list2 = l;
            synchronized (list2) {
                list = l.toArray(new DiagnosticsListener[0]);
            }
            for (DiagnosticsListener listener : list) {
                if (listener == null) continue;
                listener.handleEvent(event);
            }
            l = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends DiagnosticsEvent> void notifyListeners(T event, boolean immediately) {
        if (immediately) {
            DiagnosticsEventManager.notifyListeners(event);
        } else {
            if (m_notifierThread == null) {
                m_notifierThread = new NotifierThread();
            }
            List<DiagnosticsEvent> list = m_queue;
            synchronized (list) {
                m_queue.add(event);
                m_queue.notify();
            }
        }
    }

    private static class NotifierThread
    implements Runnable {
        protected NotifierThread() {
            final Thread th = new Thread((Runnable)this, "oracle.dfw.common.DiagnosticsEventManager.NotifierThread");
            th.setDaemon(true);
            final ClassLoader systemLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return this.getClass().getClassLoader();
                }
            });
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    th.setContextClassLoader(systemLoader);
                    return null;
                }
            });
            th.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                DiagnosticsEvent de;
                List list = m_queue;
                synchronized (list) {
                    if (m_queue.size() == 0) {
                        try {
                            m_queue.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        continue;
                    }
                    de = (DiagnosticsEvent)m_queue.remove(0);
                }
                DiagnosticsEventManager.notifyListeners(de);
            }
        }
    }
}

