/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.jmx.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.as.management.exception.ASException;
import oracle.as.management.streaming.Streamer;
import oracle.dms.ParameterDescriptor;
import oracle.dms.config.paramscopedmetrics.ParamScopedMetricsConfig;
import oracle.dms.context.ContextParameterDescriptor;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.internal.ContextParameterDescriptorInternal;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.instrument.ActivationParameterDescriptor;
import oracle.dms.instrument.ActivationParameterFactory;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.internal.ParamScopedMetricsRuntimeManager;
import oracle.dms.instrument.internal.ParamScopedMetricsSystem;
import oracle.dms.instrument.internal.SensorCoreData;
import oracle.dms.jmx.ParamScopedMetricsRuntimeMXBean;
import oracle.dms.jmx.ParameterConstraint;
import oracle.dms.jmx.ParameterScopedMetricsRule;
import oracle.dms.table.TableName;

public class ParamScopedMetricsRuntimeMXBeanImpl
implements ParamScopedMetricsRuntimeMXBean {
    private static final String CLASS_NAME = ParamScopedMetricsRuntimeMXBeanImpl.class.getName();
    private final Logger mLogger = Logger.getLogger("oracle.dms.instrument");
    private static final String[] PHASE_EVENT_SUFFIXES = new String[10];
    private static final String[] PHASE_EVENT_UNITS;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getParameterScopedMetricsStreamHandle(String ruleId) throws Exception {
        String METHOD_NAME = "getParameterScopedMetricsStreamHandle";
        String retVal = null;
        ParamScopedMetricsConfig psmc = ParamScopedMetricsConfig.getCurrentParamScopedMetricsConfig();
        if (psmc == null) return retVal;
        Map<String, ParameterScopedMetricsRule> mConfig = psmc.getConfigRules();
        if (mConfig != null && !mConfig.isEmpty()) {
            ParamScopedMetricsRuntimeManager rMgr = ParamScopedMetricsSystem.getRuntimeManager();
            if (rMgr != null) {
                ParameterScopedMetricsRule rule = mConfig.get(ruleId);
                if (rule != null) {
                    try {
                        File dumpFile = File.createTempFile("dmsParameterScopedMetrics", ".txt");
                        dumpFile.deleteOnExit();
                        FileOutputStream outputStream = ParamScopedMetricsRuntimeMXBeanImpl.getFileOutputStream(dumpFile);
                        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, "UTF-8"));
                        boolean wroteSomething = false;
                        if (this.mLogger.isLoggable(Level.FINE)) {
                            this.mLogger.log(Level.FINE, "Opened file " + dumpFile.getAbsolutePath() + " for writing parameter scoped metrics.");
                        }
                        Set<ParameterDescriptor> paramDescriptors = this.getParameterDescriptorsForRule(rule);
                        for (String nounType : this.getNounTypesForRule(rule)) {
                            Noun[] nouns;
                            NounDescriptor nd = Noun.getDescriptorByType(nounType);
                            if (nd == null || (nouns = Noun.getNounsByType(nounType)) == null || nouns.length <= 0) continue;
                            for (Noun noun : nouns) {
                                for (ParameterDescriptor pd : paramDescriptors) {
                                    Sensor[] sensors = noun.getSensors();
                                    if (sensors == null || sensors.length <= 0) continue;
                                    HashSet<String> paramValues = new HashSet<String>();
                                    for (Sensor sensor : sensors) {
                                        Map<String, SensorCoreData> data;
                                        Map<ParameterDescriptor, Map<String, SensorCoreData>> scopedMetrics = rMgr.getAllParameterScopedDataForSensor(sensor);
                                        if (scopedMetrics == null || (data = scopedMetrics.get(pd)) == null) continue;
                                        paramValues.addAll(data.keySet());
                                    }
                                    for (String paramValue : paramValues) {
                                        HashMap<String, String> tableNameAttributes = new HashMap<String, String>(3);
                                        if (pd instanceof ContextParameterDescriptor) {
                                            tableNameAttributes.put("scopingParamType", "ctx");
                                        } else if (pd instanceof ActivationParameterDescriptor) {
                                            tableNameAttributes.put("scopingParamType", "act");
                                        }
                                        tableNameAttributes.put("scopingParamName", pd.getName());
                                        tableNameAttributes.put("scopingParamValue", paramValue);
                                        TableName nounName = TableName.createName(noun.toString(), tableNameAttributes);
                                        TableName typeName = TableName.createName(nd.getName(), tableNameAttributes);
                                        String apparentNounName = nounName.getNormalName();
                                        String apparentTypeName = typeName.getNormalName();
                                        boolean writtenApparentNounName = false;
                                        for (Sensor sensor : sensors) {
                                            Map<String, SensorCoreData> data;
                                            Map<ParameterDescriptor, Map<String, SensorCoreData>> scopedMetrics = rMgr.getAllParameterScopedDataForSensor(sensor);
                                            if (scopedMetrics == null || (data = scopedMetrics.get(pd)) == null || data.get(paramValue) == null) continue;
                                            SensorCoreData d = data.get(paramValue);
                                            Object[] values = d.getValues();
                                            if (!writtenApparentNounName) {
                                                w.write("\n");
                                                w.write(apparentNounName);
                                                w.write(" [type=");
                                                w.write(apparentTypeName);
                                                w.write("]");
                                                writtenApparentNounName = true;
                                                wroteSomething = true;
                                            }
                                            if (sensor instanceof Event) {
                                                w.write("\n  ");
                                                w.write(sensor.getName());
                                                w.write(".count:  ");
                                                w.write(values[1].toString());
                                                w.write(" ops");
                                                wroteSomething = true;
                                            }
                                            if (!(sensor instanceof PhaseEvent)) continue;
                                            PhaseEvent pe = (PhaseEvent)sensor;
                                            int derivations = pe.getDerivedMetrics();
                                            for (int i = 0; i < 10; ++i) {
                                                if ((derivations & 1 << i) <= 0) continue;
                                                w.write("\n  ");
                                                w.write(sensor.getName());
                                                w.write(PHASE_EVENT_SUFFIXES[i]);
                                                w.write(":  ");
                                                w.write(values[i].toString());
                                                ((Writer)w).write(32);
                                                w.write(PHASE_EVENT_UNITS[i]);
                                                wroteSomething = true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ((Writer)w).close();
                        if (!wroteSomething) return retVal;
                        FileInputStream inputStream = ParamScopedMetricsRuntimeMXBeanImpl.getFileInputStream(dumpFile);
                        if (!this.mLogger.isLoggable(Level.FINE)) return Streamer.addInputStream(inputStream);
                        this.mLogger.log(Level.FINE, "Opened file " + dumpFile.getAbsolutePath() + " for reading (relaying) parameter scoped metrics.");
                        return Streamer.addInputStream(inputStream);
                    }
                    catch (Throwable t) {
                        Exception re = ASException.toException(t, Exception.class);
                        this.mLogger.logp(Level.WARNING, CLASS_NAME, "getParameterScopedMetricsStreamHandle", "Problem preparing parameter scoped metric report.", re);
                        throw re;
                    }
                }
                if (!this.mLogger.isLoggable(Level.FINE)) return retVal;
                this.mLogger.logp(Level.FINE, CLASS_NAME, "getParameterScopedMetricsStreamHandle", "Rule does not exist : " + ruleId);
                return retVal;
            } else {
                if (!this.mLogger.isLoggable(Level.FINE)) return retVal;
                this.mLogger.logp(Level.FINE, CLASS_NAME, "getParameterScopedMetricsStreamHandle", "There is no runtime manager in place.");
            }
            return retVal;
        } else {
            if (!this.mLogger.isLoggable(Level.FINE)) return retVal;
            this.mLogger.logp(Level.FINE, CLASS_NAME, "getParameterScopedMetricsStreamHandle", "There is no param scoped metric config.");
        }
        return retVal;
    }

    @Override
    public Set<ParameterScopedMetricsRule> resetParameterScopedMetrics(String[] ruleIds) {
        Map<String, ParameterScopedMetricsRule> mConfig;
        HashSet<ParameterScopedMetricsRule> retVal = new HashSet<ParameterScopedMetricsRule>();
        ParamScopedMetricsConfig psmc = ParamScopedMetricsConfig.getCurrentParamScopedMetricsConfig();
        if (psmc != null && (mConfig = psmc.getConfigRules()) != null && !mConfig.isEmpty()) {
            ParamScopedMetricsRuntimeManager rMgr = ParamScopedMetricsSystem.getRuntimeManager();
            if (ruleIds != null && rMgr != null) {
                for (String ruleId : ruleIds) {
                    ParameterScopedMetricsRule rule = mConfig.get(ruleId);
                    if (rule == null) continue;
                    Set<ParameterDescriptor> paramDescriptors = this.getParameterDescriptorsForRule(rule);
                    retVal.add(rule);
                    for (String nounType : this.getNounTypesForRule(rule)) {
                        Noun[] nouns;
                        NounDescriptor nd = Noun.getDescriptorByType(nounType);
                        if (nd == null || (nouns = Noun.getNounsByType(nounType)) == null || nouns.length <= 0) continue;
                        for (Noun noun : nouns) {
                            Sensor[] sensors = noun.getSensors();
                            if (sensors == null || sensors.length <= 0) continue;
                            for (Sensor sensor : sensors) {
                                Map<ParameterDescriptor, Map<String, SensorCoreData>> scopedMetrics = rMgr.getAllParameterScopedDataForSensor(sensor);
                                if (scopedMetrics == null) continue;
                                for (ParameterDescriptor pd : paramDescriptors) {
                                    Map<String, SensorCoreData> data = scopedMetrics.get(pd);
                                    if (data == null) continue;
                                    for (SensorCoreData d : data.values()) {
                                        d.reset();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return retVal.size() > 0 ? retVal : null;
    }

    private Set<String> getNounTypesForRule(ParameterScopedMetricsRule rule) {
        HashSet<String> retVal;
        block5: {
            retVal = new HashSet<String>();
            String[] allNounTypes = Noun.getAllTypes();
            if (allNounTypes == null) break block5;
            if (rule.getNounTypePatterns() != null && rule.getNounTypePatterns().length > 0) {
                block0: for (String nounType : allNounTypes) {
                    for (ParameterScopedMetricsRule.NounTypePattern nounPattern : rule.getNounTypePatterns()) {
                        if (!nounPattern.isMatch(nounType)) continue;
                        retVal.add(nounType);
                        continue block0;
                    }
                }
            } else {
                for (String nounType : allNounTypes) {
                    retVal.add(nounType);
                }
            }
        }
        return retVal;
    }

    private Set<ParameterDescriptor> getParameterDescriptorsForRule(ParameterScopedMetricsRule rule) {
        HashSet<ParameterDescriptor> retVal = new HashSet<ParameterDescriptor>();
        ActivationParameterFactory apf = DMSConsole.getActivationParameterFactory();
        if (rule.getActivationParameterConstraints() != null && apf != null) {
            for (ParameterConstraint pc : rule.getActivationParameterConstraints()) {
                ActivationParameterDescriptor pd = apf.findDescriptor(pc.getParameterName());
                if (pd == null) continue;
                retVal.add(pd);
            }
        }
        DomainContextManager dcm = DMSContextManager.getDomainContextManager();
        if (rule.getContextParameterConstraints() != null && dcm != null) {
            for (ParameterConstraint pc : rule.getContextParameterConstraints()) {
                ContextParameterDescriptorInternal pd = dcm.findContextParameterDescriptor(pc.getParameterName());
                if (pd == null) continue;
                retVal.add(pd);
            }
        }
        return retVal;
    }

    @Override
    public String getParameterScopedMetricsConfig() {
        String retVal = null;
        ParamScopedMetricsConfig psmc = ParamScopedMetricsConfig.getCurrentParamScopedMetricsConfig();
        if (psmc != null) {
            Map<String, ParameterScopedMetricsRule> rulesMap = psmc.getConfigRules();
            StringBuilder sb = new StringBuilder(1024);
            sb.append('{');
            sb.append("runtimeParamScopedMetricsRules");
            sb.append(':');
            if (rulesMap != null && !rulesMap.isEmpty()) {
                boolean firstTime = true;
                sb.append('[');
                for (ParameterScopedMetricsRule rule : rulesMap.values()) {
                    if (firstTime) {
                        firstTime = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(rule.toString());
                }
                sb.append(']');
            }
            sb.append('}');
            retVal = sb.toString();
        }
        return retVal;
    }

    @Override
    public Set<ParameterScopedMetricsRule> getParameterScopedMetricsRules(String pRuleId) {
        Set<ParameterScopedMetricsRule> retVal = null;
        ParamScopedMetricsConfig psmc = ParamScopedMetricsConfig.getCurrentParamScopedMetricsConfig();
        if (psmc != null) {
            retVal = psmc.getParameterScopedMetricsRules(pRuleId);
        }
        return retVal;
    }

    private static FileOutputStream getFileOutputStream(final File file) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private static FileInputStream getFileInputStream(final File file) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    static {
        ParamScopedMetricsRuntimeMXBeanImpl.PHASE_EVENT_SUFFIXES[0] = ".time";
        ParamScopedMetricsRuntimeMXBeanImpl.PHASE_EVENT_SUFFIXES[1] = ".completed";
        ParamScopedMetricsRuntimeMXBeanImpl.PHASE_EVENT_SUFFIXES[3] = ".maxTime";
        ParamScopedMetricsRuntimeMXBeanImpl.PHASE_EVENT_SUFFIXES[2] = ".minTime";
        ParamScopedMetricsRuntimeMXBeanImpl.PHASE_EVENT_SUFFIXES[5] = ".avg";
        ParamScopedMetricsRuntimeMXBeanImpl.PHASE_EVENT_SUFFIXES[6] = ".active";
        ParamScopedMetricsRuntimeMXBeanImpl.PHASE_EVENT_SUFFIXES[7] = ".maxActive";
        PHASE_EVENT_UNITS = new String[10];
        ParamScopedMetricsRuntimeMXBeanImpl.PHASE_EVENT_UNITS[0] = "msecs";
        ParamScopedMetricsRuntimeMXBeanImpl.PHASE_EVENT_UNITS[1] = "ops";
        ParamScopedMetricsRuntimeMXBeanImpl.PHASE_EVENT_UNITS[3] = "msecs";
        ParamScopedMetricsRuntimeMXBeanImpl.PHASE_EVENT_UNITS[2] = "msecs";
        ParamScopedMetricsRuntimeMXBeanImpl.PHASE_EVENT_UNITS[5] = "msecs";
        ParamScopedMetricsRuntimeMXBeanImpl.PHASE_EVENT_UNITS[6] = "ops";
        ParamScopedMetricsRuntimeMXBeanImpl.PHASE_EVENT_UNITS[7] = "ops";
    }
}

