/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context.internal.was;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.context.RID;
import oracle.dms.context.internal.AbstractContextManager;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.context.internal.was.WASContextFamily;
import oracle.dms.context.internal.was.WASExecutionContext;
import oracle.dms.util.DMSProperties;

public class WASContextManager
extends AbstractContextManager<WASContextFamily, WASExecutionContext>
implements DomainContextManager<WASContextFamily, WASExecutionContext> {
    private ThreadLocal<ThreadLocalTuple> tContextTuple;
    private Map<WeakThreadReference, WASExecutionContext> mThreadRefToContextMap;
    private ReentrantLock mPurgeThreadRefMapLock;
    private volatile int mPurgeCountdown = 0;
    private static int DEFAULT_PURGE_COUNT_MAX = 50;
    private int mPurgeCountMax;

    private void initLocalVars() {
        this.tContextTuple = new ThreadLocal();
        this.mThreadRefToContextMap = new ConcurrentHashMap<WeakThreadReference, WASExecutionContext>();
        this.mPurgeThreadRefMapLock = new ReentrantLock();
        this.mPurgeCountMax = DMSProperties.getPropertyInt("oracle.dms.context.internal.jse.purgeCount", DEFAULT_PURGE_COUNT_MAX, 1);
    }

    private void clearLocalVars() {
        this.tContextTuple = null;
        this.mThreadRefToContextMap = null;
    }

    @Override
    protected void initNoLogging2() {
        this.initLocalVars();
    }

    @Override
    public WASExecutionContext getContext(long threadId) {
        WASExecutionContext retVal = null;
        Set<Map.Entry<WeakThreadReference, WASExecutionContext>> wtfSet = this.mThreadRefToContextMap.entrySet();
        for (Map.Entry<WeakThreadReference, WASExecutionContext> wtfEntry : wtfSet) {
            WeakThreadReference tRef = wtfEntry.getKey();
            Thread t = (Thread)tRef.get();
            if (t == null || t.getId() != threadId) continue;
            retVal = wtfEntry.getValue();
            break;
        }
        return retVal;
    }

    @Override
    public void stashNewChild(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        WASExecutionContext pctx = this.getContext(true);
        if (pctx != null) {
            WASExecutionContext ctx = (WASExecutionContext)pctx.createChild();
            if (ctx == null) {
                throw new IllegalStateException("failed to create a child execution when required to do so");
            }
            this.mCtxStashMap.put(key, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int purgeThreadRefMap() {
        int retVal = -1;
        if (this.mPurgeThreadRefMapLock.tryLock()) {
            try {
                int newPurgeVal;
                this.mPurgeCountdown = newPurgeVal = (this.mPurgeCountdown + 1) % this.mPurgeCountMax;
                if (newPurgeVal == 0) {
                    int[] variousCounters = new int[6];
                    if (sLogger.isLoggable(Level.FINER)) {
                        variousCounters[0] = this.mThreadRefToContextMap.size();
                    }
                    Set<Map.Entry<WeakThreadReference, WASExecutionContext>> wtfSet = this.mThreadRefToContextMap.entrySet();
                    for (Map.Entry<WeakThreadReference, WASExecutionContext> wtfEntry : wtfSet) {
                        WASExecutionContext o;
                        WeakThreadReference tRef = wtfEntry.getKey();
                        Thread t = (Thread)tRef.get();
                        if (t == null) {
                            variousCounters[1] = variousCounters[1] + 1;
                            o = this.mThreadRefToContextMap.remove(tRef);
                            if (o == null) continue;
                            variousCounters[2] = variousCounters[2] + 1;
                            continue;
                        }
                        if (t.getState() != Thread.State.TERMINATED) continue;
                        variousCounters[3] = variousCounters[3] + 1;
                        o = this.mThreadRefToContextMap.remove(tRef);
                        if (o == null) continue;
                        variousCounters[4] = variousCounters[4] + 1;
                    }
                    if (sLogger.isLoggable(Level.FINER)) {
                        variousCounters[5] = this.mThreadRefToContextMap.size();
                        String message = "Removed " + variousCounters[2] + " of " + variousCounters[1] + " empty thread references. " + "Removed " + variousCounters[4] + " of " + variousCounters[3] + " references to terminated threads. " + "mThreadRefToContextMap size has gone from " + variousCounters[0] + " to " + variousCounters[5] + ".";
                        sLogger.log(Level.FINER, message);
                    }
                    retVal = variousCounters[2] + variousCounters[4];
                }
            }
            finally {
                this.mPurgeThreadRefMapLock.unlock();
            }
        }
        return retVal;
    }

    @Override
    public WASExecutionContext getContext(boolean inheritable) {
        ThreadLocalTuple contextTuple = this.tContextTuple.get();
        WASExecutionContext ctx = null;
        WASExecutionContext currentContext = null;
        if (contextTuple != null) {
            currentContext = ctx = contextTuple.mWASContext;
        }
        if (ctx != null && !ctx.isActive()) {
            ctx.activate(true, currentContext);
        }
        return ctx;
    }

    @Override
    public WASExecutionContext getActiveContext() {
        ThreadLocalTuple pair = this.tContextTuple.get();
        WASExecutionContext currentContext = null;
        if (pair != null) {
            currentContext = pair.mWASContext;
        }
        return currentContext;
    }

    Collection<? extends WeakReference<WASContextFamily>> getFamilies() {
        return this.mFamilyMap.values();
    }

    boolean attachToThread(WASExecutionContext ctx, Boolean oldContextKnown, WASExecutionContext oldContext) {
        WASExecutionContext octx;
        if (ctx == null) {
            return false;
        }
        WASExecutionContext wASExecutionContext = octx = oldContextKnown != false ? oldContext : this.getActiveContext();
        if (octx != null && octx != ctx) {
            if (sLogger.isLoggable(Level.FINE)) {
                Object[] msg = new String[]{octx.toString(), ctx.toString(), Thread.currentThread().getName()};
                sLogger.log(Level.FINE, "Deactivating {0}, active in this thread ({2}), and now activating {1}.", msg);
            }
            octx.deactivate();
        }
        this.tContextTuple.set(new ThreadLocalTuple(ctx));
        Thread currThread = Thread.currentThread();
        ctx.setThread(currThread);
        this.purgeThreadRefMap();
        this.mThreadRefToContextMap.put(new WeakThreadReference(currThread), ctx);
        return true;
    }

    boolean detachFromThread(WASExecutionContext ctx, boolean onCurrentThread) {
        if (ctx == null) {
            return false;
        }
        if (onCurrentThread) {
            WASExecutionContext octx = this.getActiveContext();
            if (octx == ctx) {
                this.tContextTuple.remove();
                Thread currThread = Thread.currentThread();
                this.mThreadRefToContextMap.remove(new WeakThreadReference(currThread));
                ctx.setThread(null);
                return true;
            }
            throw new IllegalArgumentException("Attempt made to detach a context from the current thread but the context is not on this thread!");
        }
        ctx.setThread(null);
        return true;
    }

    @Override
    public WASExecutionContext findContext(String ecid, String ridStr) {
        if (ecid == null || ridStr == null) {
            return null;
        }
        WASContextFamily ctf = (WASContextFamily)this.findFamily(ecid);
        if (ctf != null) {
            return (WASExecutionContext)ctf.getExecutionContext(ridStr);
        }
        return null;
    }

    @Override
    public int getActiveCount(String ecid) {
        int retVal = 0;
        Set<Map.Entry<WeakThreadReference, WASExecutionContext>> wtfSet = this.mThreadRefToContextMap.entrySet();
        for (Map.Entry<WeakThreadReference, WASExecutionContext> wtfEntry : wtfSet) {
            WASExecutionContext ctx = wtfEntry.getValue();
            if (!ctx.getECID().equals(ecid) || !ctx.isActive()) continue;
            ++retVal;
        }
        return retVal;
    }

    int removeFromStash(String ecid, int count) {
        if (count <= 0) {
            return count;
        }
        if (ecid == null) {
            return 0;
        }
        int succeed = 0;
        Collection values = this.mCtxStashMap.values();
        for (WASExecutionContext ctx : values) {
            if (count == 0) {
                return succeed;
            }
            if (!ecid.equals(ctx.getECID())) continue;
            values.remove(ctx);
            --count;
            ++succeed;
        }
        return succeed;
    }

    int removeFromSuspended(String ecid, int count) {
        if (count <= 0) {
            return count;
        }
        if (ecid == null) {
            return 0;
        }
        int succeed = 0;
        Collection values = this.mCtxSuspendMap.values();
        for (WASExecutionContext ctx : values) {
            if (count == 0) {
                return succeed;
            }
            if (!ecid.equals(ctx.getECID())) continue;
            values.remove(ctx);
            --count;
            ++succeed;
        }
        return succeed;
    }

    private int cleanupContextsOnTerminatedThreads() {
        int droppedCount = 0;
        Set<Map.Entry<WeakThreadReference, WASExecutionContext>> wtfSet = this.mThreadRefToContextMap.entrySet();
        Iterator<Map.Entry<WeakThreadReference, WASExecutionContext>> wtfI = wtfSet.iterator();
        while (wtfI.hasNext()) {
            Map.Entry<WeakThreadReference, WASExecutionContext> wtfEntry = wtfI.next();
            WeakThreadReference tRef = wtfEntry.getKey();
            Thread t = (Thread)tRef.get();
            if (t != null && t.getState() != Thread.State.TERMINATED) continue;
            WASExecutionContext ctx = wtfEntry.getValue();
            ctx.deactivate(false);
            wtfI.remove();
            ++droppedCount;
        }
        return droppedCount;
    }

    @Override
    protected void cleanup2(long timeNow) {
        this.cleanupContextsOnTerminatedThreads();
    }

    @Override
    protected void shutdown2() {
        this.clearLocalVars();
    }

    @Override
    protected String getPrettyInstanceStateSummary(Level level) {
        StringBuffer sb = new StringBuffer();
        sb.append("WASContextManager Class: ").append("\n      mFamilyMap:").append(this.mFamilyMap.size()).append("\n    mCtxStashMap:").append(this.mCtxStashMap.size()).append("\n  mCtxSuspendMap:").append(this.mCtxSuspendMap.size()).append("\n");
        return sb.toString();
    }

    int getContextsOnThreadsCount() {
        int recordedValue = this.mThreadRefToContextMap.size();
        return recordedValue;
    }

    int getStashedMapSize() {
        return this.mCtxStashMap.size();
    }

    int getSuspendedMapSize() {
        return this.mCtxSuspendMap.size();
    }

    List<String> getThreadNamesForECIDs(String id) {
        Map contexts;
        LinkedList<String> retVal = new LinkedList<String>();
        WeakReference ctfRef = (WeakReference)this.mFamilyMap.get(id);
        WASContextFamily ctf = (WASContextFamily)ctfRef.get();
        if (ctf != null && (contexts = ctf.getContexts()) != null) {
            for (WASExecutionContext context : contexts.values()) {
                if (context.getThread() == null) continue;
                retVal.add(context.getRIDasString() + " - " + context.getThread().getName());
            }
        }
        return retVal;
    }

    @Override
    public WASExecutionContext newFamily(String ecid, RID rid) {
        if (ecid == null || rid == null) {
            throw new IllegalArgumentException("ecid (" + ecid + ") and rid (" + rid + ") must not be null.");
        }
        WASContextFamily ctf = new WASContextFamily(this, ecid);
        this.registerFamily(ctf);
        WASExecutionContext ctx = new WASExecutionContext(this, ctf, rid);
        ctf.addContext(ctx);
        return ctx;
    }

    @Override
    public WASContextFamily newFamily(String ecid) {
        if (ecid == null) {
            throw new IllegalArgumentException("ecid (" + ecid + ") must not be null.");
        }
        WASContextFamily ctf = new WASContextFamily(this, ecid);
        this.registerFamily(ctf);
        return ctf;
    }

    @Override
    public WASExecutionContext createContextForUnwrap(WASContextFamily ctf, RID rid) {
        if (ctf == null) {
            throw new IllegalArgumentException("ContextFamily ctf must not be null");
        }
        if (rid == null) {
            throw new IllegalArgumentException("RID rid must not be null");
        }
        WASExecutionContext ctx = new WASExecutionContext(this, ctf, rid);
        return ctx;
    }

    @Override
    protected Logger getLogger() {
        return sLogger;
    }

    private static class WeakThreadReference
    extends WeakReference<Thread> {
        int mHashCode;

        WeakThreadReference(Thread t) {
            super(t);
            this.mHashCode = t.hashCode();
        }

        public boolean equals(Object o) {
            boolean retVal = false;
            if (o instanceof WeakThreadReference) {
                WeakThreadReference wtf = (WeakThreadReference)o;
                Thread myThread = (Thread)this.get();
                Thread yourThread = (Thread)wtf.get();
                if (myThread != null && yourThread != null) {
                    retVal = myThread == yourThread;
                } else if (myThread == null && yourThread == null) {
                    retVal = true;
                }
            }
            return retVal;
        }

        public int hashCode() {
            return this.mHashCode;
        }
    }

    private static class ThreadLocalTuple {
        WASExecutionContext mWASContext;

        private ThreadLocalTuple() {
        }

        private ThreadLocalTuple(WASExecutionContext liveCtx) {
            this.mWASContext = liveCtx;
        }
    }
}

