/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvmmon.dfwdump;

import java.util.EnumSet;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriter;
import oracle.jvmmon.agent.DeadLockDetector;
import oracle.jvmmon.agent.JVMMonitor;
import oracle.jvmmon.common.StringID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeadlockedThreads
extends ComponentDiagnosticDump {
    @Override
    public DumpResult executeDump(DumpContext context) throws DumpExecutionException {
        DumpWriter dw = new DumpWriter(context);
        try {
            DeadLockDetector d = JVMMonitor.getDataProcessor().getDeadLockDetector();
            Object output = null;
            if (d != null && d.getThreadCount() > 0) {
                dw.dump(d.toString());
            } else {
                dw.dump(StringID.translate("901", new Object[0]));
            }
        }
        catch (Exception ex) {
            throw new DumpExecutionException("56000", (Throwable)ex, "DMS", "oracle.jvmmon.messages.Translation");
        }
        return dw.getDumpResult();
    }

    @Override
    public String getName() {
        return StringID.translate("1016", new Object[0]);
    }

    @Override
    public String getOwner() {
        return "jvmmon";
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return EnumSet.of(DiagnosticsCategory.THREADS);
    }

    @Override
    public String getDumpDescription() {
        return StringID.translate("1017", new Object[0]);
    }
}

