/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import oracle.dms.spy.ErrorObject;
import oracle.dms.table.ColumnDefinition;
import oracle.dms.table.ColumnDefinitionSupport;
import oracle.dms.table.Key;
import oracle.dms.table.Row;
import oracle.dms.table.RowComparator;
import oracle.dms.table.RowSelector;
import oracle.dms.table.RowSupport;
import oracle.dms.table.Schema;
import oracle.dms.table.SchemaSupport;
import oracle.dms.table.Table;
import oracle.dms.table.ValueType;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.NameSupport;
import oracle.dms.util.QueryOptions;
import oracle.dms.util.TableQueryDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSupport
extends NameSupport
implements Table {
    protected LinkedHashMap<Key, RowSupport> m_rows = new LinkedHashMap();
    protected SchemaSupport m_schema = null;
    private Set<String> m_keys = new TreeSet<String>();
    protected Hashtable<String, ValueType> m_types = new Hashtable();
    static final Logger LOGGER = Logger.getLogger("oracle.dms.aggregator.table", "oracle.dms.util.dms");
    private static final String OMB = "OMB_";
    private static final long serialVersionUID = -1150676101857L;

    public TableSupport() {
    }

    protected TableSupport(TableSupport table, QueryOptions.QueryType queryType) {
        this();
        this.setName(table.m_name);
        this._copyFrom(table, new QueryOptions(queryType));
    }

    public void setName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("name=" + name);
        }
        this.m_name = name;
    }

    @Override
    public Schema getSchema() {
        return this.m_schema;
    }

    protected void setSchema(SchemaSupport schema) {
        if (schema == null) {
            throw new IllegalArgumentException("schema=" + schema);
        }
        this.m_schema = schema;
    }

    @Override
    public int rowCount() {
        return this.m_rows.size();
    }

    @Override
    public Row getRow(Key key) {
        if (key == null) {
            return null;
        }
        return this.m_rows.get(key);
    }

    public RowSupport[] getRows() {
        RowSupport[] rows = new RowSupport[this.m_rows.size()];
        this.m_rows.values().toArray(rows);
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRows(RowSupport[] rows) {
        if (rows == null) {
            throw new IllegalArgumentException("rows=" + rows);
        }
        if (rows.length == 0) {
            return;
        }
        TableSupport tableSupport = this;
        synchronized (tableSupport) {
            for (RowSupport row : rows) {
                if (row == null) continue;
                row.setTable(this);
                Key key = row.getKey(true);
                this.m_rows.put(key, row);
            }
        }
    }

    @Override
    public Enumeration<? extends Row> enumerateRows() {
        return this.enumerateRows((RowComparator)null);
    }

    @Override
    public Enumeration<? extends Row> enumerateRows(RowComparator comparator) {
        if (comparator == null) {
            return Collections.enumeration(this.m_rows.values());
        }
        Vector<RowSupport> vec = new Vector<RowSupport>(this.m_rows.values());
        Collections.sort(vec, comparator);
        return vec.elements();
    }

    @Override
    public Enumeration<? extends Row> enumerateRows(RowSelector selector) {
        if (selector == null) {
            return Collections.enumeration(this.m_rows.values());
        }
        Vector<RowSupport> selected = new Vector<RowSupport>();
        for (RowSupport row : this.m_rows.values()) {
            if (!selector.select(row)) continue;
            selected.add(row);
        }
        return selected.elements();
    }

    @Override
    public int keyCount() {
        return this.m_keys.size();
    }

    @Override
    public String[] getKeys() {
        String[] ret = new String[this.m_keys.size()];
        this.m_keys.toArray(ret);
        return ret;
    }

    @Override
    public boolean containsKey(String name) {
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        return this.m_keys.contains(name);
    }

    @Override
    public Enumeration<String> enumerateKeys(boolean sorted) {
        return Collections.enumeration(this.m_keys);
    }

    @Override
    public boolean containsColumn(String column) {
        if (column == null || column.trim().length() == 0) {
            return false;
        }
        return this.m_types.containsKey(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRow(RowSupport row) {
        if (row == null) {
            return;
        }
        Key key = row.getKey(true);
        TableSupport tableSupport = this;
        synchronized (tableSupport) {
            this.m_rows.put(key, row);
        }
    }

    @Override
    public boolean hasSchema() {
        return this.m_schema != null;
    }

    @Override
    public boolean hasRows() {
        return this.m_rows.size() > 0;
    }

    @Override
    public boolean hasKeys() {
        return this.m_keys.size() > 0;
    }

    protected void addKey(String keyName) {
        if (keyName != null && keyName.trim().length() > 0) {
            this.m_keys.add(keyName);
        }
    }

    protected void setKeys(Set<String> keyNames) {
        if (keyNames == null) {
            throw new IllegalArgumentException("keyNames=" + keyNames);
        }
        this.m_keys = new TreeSet<String>();
        for (String key : keyNames) {
            if (key == null || key.trim().length() == 0) continue;
            this.m_keys.add(key);
        }
    }

    protected void setKeys(String[] keyNames) {
        this.m_keys = new TreeSet<String>();
        this.addKeys(keyNames);
    }

    protected void addKeys(String[] keyNames) {
        if (keyNames == null) {
            throw new IllegalArgumentException("keyNames=" + keyNames);
        }
        for (String key : keyNames) {
            if (key == null || key.trim().length() == 0) continue;
            this.m_keys.add(key);
        }
    }

    protected void setColumnType(String name, ValueType typeId) {
        if (name == null || name.trim().length() == 0 || typeId == null) {
            throw new IllegalArgumentException("name=" + name + " typeId=" + (Object)((Object)typeId));
        }
        this.m_types.put(name, typeId);
    }

    ValueType getColumnType(String name) {
        if (name == null || name.trim().length() == 0) {
            return ValueType.UNKNOWN;
        }
        ValueType type = this.m_types.get(name);
        if (type == null) {
            return ValueType.UNKNOWN;
        }
        return type;
    }

    protected void setColumnTypes(Map<String, ValueType> columnTypes) {
        if (columnTypes == null || columnTypes.size() == 0) {
            return;
        }
        for (Map.Entry<String, ValueType> entry : columnTypes.entrySet()) {
            String name = entry.getKey();
            ValueType typeId = entry.getValue();
            this.setColumnType(name, typeId);
        }
    }

    public Map<String, ValueType> getColumnTypes() {
        return new TreeMap<String, ValueType>(this.m_types);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.appendNameHeader(buf);
        for (RowSupport row : this.m_rows.values()) {
            buf.append('\n');
            row.appendRow(buf);
        }
        return buf.toString();
    }

    public static String toString(CompositeData table) {
        Collection<?> rowCollection;
        if (table == null) {
            return "";
        }
        Object name = null;
        if (table.containsKey("Table")) {
            name = table.get("Table");
        }
        if (name == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        NameSupport.appendNameHeader(name.toString(), buf);
        Object rows = null;
        if (table.containsKey("Rows")) {
            rows = table.get("Rows");
        }
        if (rows == null || !(rows instanceof TabularData)) {
            return buf.toString();
        }
        Object schemaObj = null;
        if (table.containsKey("Schema")) {
            schemaObj = table.get("Schema");
        }
        TabularData schema = null;
        if (schemaObj != null && schemaObj instanceof TabularData) {
            schema = (TabularData)schemaObj;
        }
        if ((rowCollection = ((TabularData)rows).values()) == null) {
            return buf.toString();
        }
        for (CompositeData row : rowCollection) {
            buf.append('\n');
            Set<String> columns = row.getCompositeType().keySet();
            for (String column : columns) {
                CompositeData cdesc;
                Object value = row.get(column);
                String unit = null;
                if (schema != null && (cdesc = schema.get(new String[]{column})) != null && cdesc.containsKey("Unit")) {
                    unit = (String)cdesc.get("Unit");
                }
                RowSupport.appendColumn(column, value, unit, buf);
            }
        }
        return buf.toString();
    }

    public static String[] toStrings(CompositeData[] tables) {
        if (tables == null) {
            return null;
        }
        String[] metrics = new String[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            metrics[i] = TableSupport.toString(tables[i]);
        }
        return metrics;
    }

    protected synchronized TableSupport clone(QueryOptions options) {
        TableSupport clone = null;
        try {
            clone = (TableSupport)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (options == null) {
            options = new QueryOptions();
        }
        clone.m_rows = new LinkedHashMap();
        clone._copyFrom(this, options);
        return clone;
    }

    protected Object clone() {
        return this.clone(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LinkedHashMap<Key, RowSupport> rows;
        TableSupport tableSupport = this;
        synchronized (tableSupport) {
            rows = new LinkedHashMap<Key, RowSupport>(this.m_rows);
            this.m_rows.clear();
            this.m_types.clear();
        }
        if (this.m_schema != null) {
            this.m_schema.close();
        }
        for (RowSupport row : rows.values()) {
            row.close();
        }
        rows.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _copyFrom(TableSupport from, QueryOptions options) {
        TableSupport tableSupport = from;
        synchronized (tableSupport) {
            QueryOptions.QueryType queryType = options.getQueryType(from.m_name);
            boolean includeSchema = from.hasSchema() & queryType.includeSchema();
            boolean includeRows = from.hasRows() & queryType.includeRows();
            this.m_keys = from.m_keys;
            this.m_types = new Hashtable<String, ValueType>(from.m_types);
            this.m_schema = includeSchema ? from.m_schema.clone(this) : null;
            if (!includeRows) {
                return;
            }
            RowSelector selector = this.getRowSelector(options);
            for (RowSupport row : from.m_rows.values()) {
                if (selector != null && !selector.select(row)) continue;
                RowSupport newRow = row.clone(this);
                Key key = newRow.getKey();
                this.m_rows.put(key, newRow);
            }
        }
    }

    public void printTbml(PrintWriter out, QueryOptions options) {
        out.print('<');
        out.print("table");
        out.print(' ');
        out.print("name");
        out.print("='");
        out.print(this.m_name);
        out.print("' ");
        if (this.m_keys.size() > 0) {
            out.print("keys");
            out.print("='");
            Iterator<String> iter = this.m_keys.iterator();
            while (iter.hasNext()) {
                out.print(iter.next());
                if (!iter.hasNext()) continue;
                out.print(' ');
            }
            out.print("' ");
        }
        this.printTableAttributes(out);
        out.print(">\n");
        boolean includeSchema = true;
        boolean includeRows = true;
        TableQueryDescriptor qdesc = null;
        if (options != null) {
            qdesc = options.getTableQueryDescriptor(this.m_name);
            if (qdesc != null) {
                includeSchema = qdesc.includeSchema();
                includeRows = qdesc.includeRows();
            } else {
                includeSchema = options.includeSchema();
                includeRows = options.includeRows();
            }
        }
        if (this.hasSchema()) {
            long schemaRefreshTime = 0L;
            this.m_schema.printTbml(schemaRefreshTime, includeSchema, out);
        } else {
            for (Map.Entry<String, ValueType> entry : this.m_types.entrySet()) {
                String column = entry.getKey();
                ValueType type = entry.getValue();
                ColumnDefinitionSupport.printTbml(column, type.toString(), false, null, null, out);
            }
        }
        if (includeRows) {
            long valueRefreshTime = 0L;
            for (RowSupport row : this.m_rows.values()) {
                row.printTbml(valueRefreshTime, out);
            }
        }
        out.print("</");
        out.print("table");
        out.print(">\n");
        out.flush();
    }

    protected void printTableAttributes(PrintWriter out) {
    }

    public String toTbml(QueryOptions options) {
        StringWriter buf = new StringWriter();
        if (options == null) {
            options = new QueryOptions(QueryOptions.QueryType.ALL);
        }
        this.printTbml(new PrintWriter(buf), options);
        return buf.toString();
    }

    @Override
    public CompositeData toOpenMBean() throws OpenDataException {
        ArrayList<String> tableFields = new ArrayList<String>(4);
        ArrayList<String> tableFieldDescs = new ArrayList<String>(4);
        ArrayList<OpenType> tableFieldTypes = new ArrayList<OpenType>(4);
        ArrayList<Object> tableFieldValues = new ArrayList<Object>(4);
        tableFields.add("Table");
        tableFieldDescs.add(DMSNLSupport.getString("OMB_Table"));
        tableFieldTypes.add(SimpleType.STRING);
        tableFieldValues.add(this.getName());
        if (this.hasRows()) {
            int i = 0;
            boolean hasKeys = true;
            String[] keys = this.getKeys();
            String rowId = "RowID";
            if (keys == null || keys.length == 0) {
                hasKeys = false;
                while (this.containsColumn(rowId)) {
                    rowId = rowId + i++;
                }
                keys = new String[]{rowId};
            }
            int size = this.m_types.size();
            String[] columnNames = new String[hasKeys ? size : size + 1];
            SimpleType[] columnTypes = new SimpleType[hasKeys ? size : size + 1];
            i = 0;
            for (Map.Entry<String, ValueType> entry : this.m_types.entrySet()) {
                columnNames[i] = entry.getKey();
                ValueType columnType = entry.getValue();
                switch (columnType) {
                    case INTEGER: {
                        columnTypes[i] = SimpleType.INTEGER;
                        break;
                    }
                    case DOUBLE: {
                        columnTypes[i] = SimpleType.DOUBLE;
                        break;
                    }
                    case LONG: {
                        columnTypes[i] = SimpleType.LONG;
                        break;
                    }
                    default: {
                        columnTypes[i] = SimpleType.STRING;
                    }
                }
                ++i;
            }
            if (!hasKeys) {
                columnNames[size] = rowId;
                columnTypes[size] = SimpleType.INTEGER;
            }
            CompositeType rowType = new CompositeType("MetricRow", DMSNLSupport.getString("OMB_MetricRow"), columnNames, columnNames, columnTypes);
            TabularType rowsType = new TabularType("MetricRows", DMSNLSupport.getString("OMB_MetricRows"), rowType, keys);
            TabularDataSupport rows = new TabularDataSupport(rowsType);
            i = 0;
            Enumeration<? extends Row> iter = this.enumerateRows();
            while (iter.hasMoreElements()) {
                RowSupport row = (RowSupport)iter.nextElement();
                HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                for (int j = 0; j < size; ++j) {
                    Object value = row.getValue(columnNames[j]);
                    if (value != null) {
                        if (value instanceof ErrorObject) {
                            value = null;
                        } else if (columnTypes[j] == SimpleType.STRING && !(value instanceof String)) {
                            value = value.toString();
                        }
                    }
                    map.put(columnNames[j], (Serializable)value);
                }
                if (!hasKeys) {
                    map.put(columnNames[size], Integer.valueOf(i));
                }
                CompositeDataSupport openRows = new CompositeDataSupport(rowType, map);
                rows.put(openRows);
                ++i;
            }
            tableFields.add("Rows");
            tableFieldDescs.add(DMSNLSupport.getString("OMB_Rows"));
            tableFieldTypes.add(rowsType);
            tableFieldValues.add(rows);
        }
        if (this.hasSchema()) {
            CompositeType columnSchemaType = new CompositeType("MetricColumnSchema", DMSNLSupport.getString("OMB_ColumnTypeSchema"), new String[]{"Column", "Type", "Unit", "Description"}, new String[]{DMSNLSupport.getString("OMB_Column"), DMSNLSupport.getString("OMB_Type"), DMSNLSupport.getString("OMB_Unit"), DMSNLSupport.getString("OMB_Description")}, new SimpleType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
            TabularType rowSchemaType = new TabularType("MetricRowSchema", DMSNLSupport.getString("OMB_RowTypeSchema"), columnSchemaType, new String[]{"Column"});
            TabularDataSupport rschema = new TabularDataSupport(rowSchemaType);
            Enumeration<? extends ColumnDefinition> iter = this.m_schema.enumerateColumnDefinitions(false);
            while (iter.hasMoreElements()) {
                ColumnDefinitionSupport cdef = (ColumnDefinitionSupport)iter.nextElement();
                String name = cdef.getName();
                String unit = cdef.getUnit();
                String description = cdef.getDescription();
                String type = cdef.getType();
                CompositeDataSupport columnSchema = new CompositeDataSupport(columnSchemaType, new String[]{"Column", "Type", "Unit", "Description"}, new String[]{name, type, unit, description});
                rschema.put(columnSchema);
            }
            tableFields.add("Schema");
            tableFieldDescs.add(DMSNLSupport.getString("OMB_Schema"));
            tableFieldTypes.add(rowSchemaType);
            tableFieldValues.add(rschema);
        }
        String[] fields = new String[tableFields.size()];
        String[] fieldDescs = new String[tableFieldDescs.size()];
        OpenType[] fieldTypes = new OpenType[tableFieldTypes.size()];
        Object[] fieldValues = new Object[tableFieldValues.size()];
        tableFields.toArray(fields);
        tableFieldDescs.toArray(fieldDescs);
        tableFieldTypes.toArray(fieldTypes);
        tableFieldValues.toArray(fieldValues);
        CompositeType tableType = new CompositeType("MetricTable", DMSNLSupport.getString("OMB_TableType"), fields, fieldDescs, fieldTypes);
        CompositeDataSupport ret = new CompositeDataSupport(tableType, fields, fieldValues);
        return ret;
    }

    public static CompositeData[] toOpenMBeans(Table[] tables) throws OpenDataException {
        if (tables == null) {
            return null;
        }
        CompositeData[] ret = new CompositeData[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            if (tables[i] == null) continue;
            ret[i] = tables[i].toOpenMBean();
        }
        return ret;
    }

    protected RowSelector getRowSelector(QueryOptions options) {
        return null;
    }
}

