/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import oracle.dms.table.Table;
import oracle.dms.table.TableSupport;
import oracle.dms.util.QueryOptions;

public abstract class TableSource {
    protected static final TableSupport[] EMPTY_TABLES = new TableSupport[0];

    protected TableSource() {
    }

    public abstract String[] getTableNames(QueryOptions var1);

    public abstract int tableCount(QueryOptions var1);

    public abstract Table getTable(String var1, QueryOptions var2);

    public abstract boolean containsTable(String var1, QueryOptions var2);

    public Table[] getTables(String[] names, QueryOptions options) {
        if (names == null || names.length == 0) {
            names = this.getTableNames(options);
        }
        if (names == null || names.length == 0) {
            return EMPTY_TABLES;
        }
        long timestamp = 0L;
        int timeout = 30000;
        if (options != null) {
            timestamp = options.getTimestamp();
            timeout = options.getTimeout();
        }
        if (timestamp == 0L) {
            timestamp = System.currentTimeMillis();
        }
        Table[] tables = new TableSupport[names.length];
        for (int i = 0; i < names.length; ++i) {
            tables[i] = (TableSupport)this.getTable(names[i], options);
        }
        return tables;
    }
}

