/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.MetricDescriptor;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.spy.Metric;
import oracle.dms.table.ColumnDefinitionSupport;
import oracle.dms.table.ColumnGroupSupport;
import oracle.dms.table.RankingElement;
import oracle.dms.table.RowSupport;
import oracle.dms.table.SchemaSupport;
import oracle.dms.table.Table;
import oracle.dms.table.TableSource;
import oracle.dms.table.TableSupport;
import oracle.dms.table.ValueType;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.QueryOptions;
import oracle.dms.util.TableQueryDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpyTableSource
extends TableSource {
    private static TableSource s_tableSource = null;

    private SpyTableSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableSource getTableSource() {
        if (s_tableSource != null) {
            return s_tableSource;
        }
        Class<SpyTableSource> clazz = SpyTableSource.class;
        synchronized (SpyTableSource.class) {
            if (s_tableSource != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return s_tableSource;
            }
            s_tableSource = new SpyTableSource();
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_tableSource;
        }
    }

    @Override
    public String[] getTableNames(QueryOptions options) {
        return Noun.getAllTypes();
    }

    @Override
    public int tableCount(QueryOptions options) {
        return Noun.getTypeCount();
    }

    @Override
    public Table getTable(String name, QueryOptions options) {
        Noun[] nouns;
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        boolean includeSchema = true;
        boolean includeRows = true;
        long timestamp = 0L;
        int timeout = 30000;
        TableQueryDescriptor qdesc = null;
        if (options != null) {
            qdesc = options.getTableQueryDescriptor(name);
            if (qdesc != null) {
                includeSchema = qdesc.includeSchema();
                includeRows = qdesc.includeRows();
            } else {
                includeSchema = options.includeSchema();
                includeRows = options.includeRows();
            }
            timestamp = options.getTimestamp();
            timeout = options.getTimeout();
        }
        if ((nouns = Noun.getNounsByType(name)) == null || nouns.length == 0) {
            return null;
        }
        NounDescriptor ndesc = Noun.getDescriptorByType(name);
        if (ndesc == null) {
            return null;
        }
        long lastSchemaUpdate = ndesc.getLastUpdateTime();
        TableSupport table = new TableSupport();
        table.setName(name);
        table.setKeys(Table.DEFAULT_KEYS);
        long schemaRefreshTime = qdesc == null ? 0L : qdesc.schemaRefreshTime();
        includeSchema = includeSchema && schemaRefreshTime <= lastSchemaUpdate;
        this._parseNounDescriptor(name, table, ndesc, includeSchema);
        if (!includeRows) {
            return table;
        }
        HashSet<GroupRefresh> gRefresh = new HashSet<GroupRefresh>();
        TableQueryDescriptor.RankingSelection rankSelect = null;
        if (qdesc != null) {
            rankSelect = qdesc.getRankingSelection();
        }
        if (rankSelect != null) {
            nouns = RankingElement.rankingSelect(nouns, ndesc, gRefresh, rankSelect);
        }
        ArrayList<Metric> metricList = new ArrayList<Metric>();
        HashMap<Metric, RowSupport> rowMap = new HashMap<Metric, RowSupport>();
        long valueRefreshTime = qdesc == null ? 0L : qdesc.valueRefreshTime();
        for (int i = nouns.length - 1; i >= 0; --i) {
            RowSupport row = new RowSupport(table);
            this._updateRow(nouns[i], row, metricList, rowMap, valueRefreshTime, qdesc);
            table.addRow(row);
        }
        int size = metricList.size();
        if (size > 0) {
            Metric[] metrics = new Metric[size];
            metricList.toArray(metrics);
            Serializable[] values = Metric.getSerializableValues(metrics, gRefresh);
            for (int i = 0; i < size; ++i) {
                RowSupport row = rowMap.get(metrics[i]);
                row.updateValue(metrics[i].getName(), values[i]);
            }
        }
        metricList.clear();
        rowMap.clear();
        gRefresh.clear();
        return table;
    }

    private void _parseNounDescriptor(String tableName, TableSupport table, NounDescriptor ndesc, boolean includeSchema) {
        String[] ancestorTypes;
        String[] sensorNames;
        SchemaSupport schema = null;
        if (includeSchema) {
            String tnlsId = "QU_" + tableName;
            schema = new SchemaSupport(tableName, tnlsId, DMSNLSupport.getString(tnlsId), table);
        }
        if ((sensorNames = ndesc.getSensorNames()) != null) {
            for (int i = sensorNames.length - 1; i >= 0; --i) {
                String[] metricNames = null;
                String description = null;
                String sensorType = null;
                SensorDescriptor sdesc = ndesc.getSensorDescriptor(sensorNames[i]);
                if (sdesc != null) {
                    metricNames = sdesc.getMetricNames();
                    if (includeSchema) {
                        description = sdesc.getDescription();
                        sensorType = sdesc.getType();
                    }
                }
                if (metricNames == null || metricNames.length == 0) continue;
                ColumnGroupSupport group = null;
                if (includeSchema) {
                    group = new ColumnGroupSupport(sensorNames[i], sensorType, description);
                }
                for (int j = metricNames.length - 1; j >= 0; --j) {
                    MetricDescriptor mdesc = sdesc.getMetricDescriptor(metricNames[j]);
                    if (mdesc == null) continue;
                    ValueType valuetype = ColumnDefinitionSupport.getValueTypeCode(mdesc.getValueType());
                    table.setColumnType(metricNames[j], valuetype);
                    if (!includeSchema) continue;
                    new ColumnDefinitionSupport(schema, metricNames[j], metricNames[j], description, mdesc.getUnit());
                    group.addMember(metricNames[j]);
                }
                if (!includeSchema || group.memberCount() <= 0) continue;
                schema.addColumnGroup(group);
            }
        }
        if ((ancestorTypes = ndesc.getAncestorTypes()) != null) {
            for (int i = ancestorTypes.length - 1; i >= 0; --i) {
                table.setColumnType(ancestorTypes[i], ValueType.STRING);
                if (!includeSchema) continue;
                String nlsId = "QU_" + tableName + '_' + ancestorTypes[i];
                new ColumnDefinitionSupport(schema, ancestorTypes[i], ancestorTypes[i], DMSNLSupport.getString(nlsId), null);
            }
        }
        for (String key : Table.DEFAULT_KEYS) {
            table.setColumnType(key, ValueType.STRING);
            if (!includeSchema) continue;
            String nlsId = "QU_" + key;
            new ColumnDefinitionSupport(schema, key, key, nlsId, DMSNLSupport.getString(nlsId), null);
        }
    }

    private void _updateRow(Noun noun, RowSupport row, List<Metric> metrics, Map<Metric, RowSupport> rowMap, long valueRefreshTime, TableQueryDescriptor qdesc) {
        Noun parent;
        Sensor[] sensors;
        Set<String> columnRetained = null;
        if (qdesc != null) {
            columnRetained = qdesc.getColumns();
        }
        if ((sensors = noun.getSensors()) != null) {
            for (int i = sensors.length - 1; i >= 0; --i) {
                long lastSensorUpdate = sensors[i].getUpdateTime();
                if (valueRefreshTime > lastSensorUpdate && lastSensorUpdate != 0L) continue;
                Vector metricVect = new Vector();
                sensors[i].getMetrics(metricVect);
                Enumeration iter = metricVect.elements();
                while (iter.hasMoreElements()) {
                    Metric metric = (Metric)iter.nextElement();
                    String metricName = metric.getName();
                    if (columnRetained != null && columnRetained.size() > 0 && !columnRetained.contains(metricName)) continue;
                    metrics.add(metric);
                    rowMap.put(metric, row);
                }
            }
        }
        row.updateValue("Name", (Serializable)((Object)noun.getName()));
        row.updateValue("Parent", (Serializable)((Object)parent.toString()));
        row.updateValue("Host", (Serializable)((Object)DMSUtil.getLocalHostname()));
        row.updateValue("Process", (Serializable)((Object)DMSUtil.getProcessName()));
        long lastNounUpdate = noun.getCreateTime();
        if (valueRefreshTime > lastNounUpdate) {
            return;
        }
        Noun root = Noun.getRoot();
        for (parent = noun.getParent(); parent != root; parent = parent.getParent()) {
            String type = parent.getType();
            if (type.trim().length() == 0 || "n/a".equals(type) || columnRetained != null && columnRetained.size() > 0 && !columnRetained.contains(type)) continue;
            row.updateValue(type, (Serializable)((Object)parent.getName()));
        }
    }

    @Override
    public boolean containsTable(String name, QueryOptions options) {
        return Noun.getDescriptorByType(name) != null;
    }
}

