/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.dms.spy.ErrorObject;
import oracle.dms.table.Bool;
import oracle.dms.table.TableSupport;
import oracle.dms.table.ValueComparator;
import oracle.dms.table.ValueType;

public class Selector {
    protected Operator m_operator;
    private ValueComparator m_valueComparator = new ValueComparator();

    protected Selector(Operator operator) {
        this.m_operator = operator;
    }

    protected Bool selectObject(Serializable value1, Serializable value2, ValueType typeId) {
        boolean bool;
        if (typeId == null) {
            throw new IllegalArgumentException("invalid value type=" + (Object)((Object)typeId));
        }
        if (value1 instanceof ErrorObject) {
            return Bool.UNKNOWN;
        }
        switch (this.m_operator) {
            case IS_NULL: {
                if (value1 == null) {
                    return Bool.TRUE;
                }
                return Bool.FALSE;
            }
            case NOT_NULL: {
                if (value1 != null) {
                    return Bool.TRUE;
                }
                return Bool.FALSE;
            }
        }
        if (value1 == null) {
            return Bool.UNKNOWN;
        }
        if (value2 == null || value2 instanceof ErrorObject) {
            return Bool.UNKNOWN;
        }
        block4 : switch (this.m_operator) {
            case GT: {
                bool = this.m_valueComparator.compare(value1, value2, typeId) > 0;
                break;
            }
            case GE: {
                bool = this.m_valueComparator.compare(value1, value2, typeId) >= 0;
                break;
            }
            case LT: {
                bool = this.m_valueComparator.compare(value1, value2, typeId) < 0;
                break;
            }
            case LE: {
                bool = this.m_valueComparator.compare(value1, value2, typeId) <= 0;
                break;
            }
            case EQ: {
                bool = this.m_valueComparator.compare(value1, value2, typeId) == 0;
                break;
            }
            case EQNOCASE: {
                bool = value1.toString().equalsIgnoreCase(value2.toString());
                break;
            }
            case NE: {
                bool = this.m_valueComparator.compare(value1, value2, typeId) != 0;
                break;
            }
            case CONTAINS: {
                bool = value1.toString().indexOf(value2.toString()) != -1;
                break;
            }
            case CONTAINSTOKEN: {
                String val2 = value2.toString();
                bool = false;
                StringTokenizer tok = new StringTokenizer(value1.toString());
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (!token.equals(val2)) continue;
                    bool = true;
                    break block4;
                }
                break;
            }
            case STARTSWITH: {
                bool = value1.toString().startsWith(value2.toString());
                break;
            }
            case ENDSWITH: {
                bool = value1.toString().endsWith(value2.toString());
                break;
            }
            default: {
                if (TableSupport.LOGGER.isLoggable(Level.FINE)) {
                    TableSupport.LOGGER.logp(Level.FINE, this.getClass().getName(), "compareObject", "wrong operator=" + (Object)((Object)this.m_operator));
                }
                return Bool.UNKNOWN;
            }
        }
        return bool ? Bool.TRUE : Bool.FALSE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        GT,
        GE,
        LT,
        LE,
        EQ,
        EQNOCASE,
        NE,
        CONTAINS,
        CONTAINSDESCENDANT,
        CONTAINSANCESTOR,
        CONTAINSTOKEN,
        STARTSWITH,
        ENDSWITH,
        IS_NULL,
        NOT_NULL,
        AND,
        OR,
        NOT,
        OTHER;

    }
}

