/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy.jvm;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;

public class GCStats
implements GroupRefresh {
    private static HashMap<String, GCStats> s_statMap = new HashMap();
    private static Noun s_baseNoun = null;
    private GarbageCollectorMXBean m_bean = null;
    private State m_valid = null;
    private State m_poolNames = null;
    private State m_count = null;
    private State m_time = null;

    private GCStats() {
    }

    private GCStats(Noun baseNoun, GarbageCollectorMXBean bean) {
        if (s_baseNoun == null) {
            s_baseNoun = baseNoun == null ? Noun.create("/JVM/MxBeans/GarbageCollectors") : Noun.create(baseNoun, "GarbageCollectors", "");
        }
        String name = bean.getName();
        Noun noun = Noun.create(s_baseNoun, name, "JVM_GC");
        this.m_bean = bean;
        this.m_valid = State.create(noun, "valid", (byte)5, "", "whether garbage collector is valid");
        this.m_valid.update(bean.isValid() ? "TRUE" : "FALSE");
        this.m_poolNames = State.create(noun, "pools", (byte)5, "", "Memory pools managed by this GC");
        String[] names = bean.getMemoryPoolNames();
        StringBuffer buf = new StringBuffer(512);
        int length = 0;
        for (int i = 0; i < names.length; ++i) {
            buf.append(names[i]);
            buf.append(", ");
            length += names[i].length() + 2;
        }
        String list = buf.substring(0, length -= 2);
        this.m_poolNames.update(list);
        this.m_count = State.create(noun, "count", (byte)2, "collections", "number of GCs performed");
        this.m_count.setRefresh(this);
        this.m_time = State.create(noun, "time", (byte)2, "msecs", "time spent in GCs");
        this.m_time.setRefresh(this);
        this.refresh();
    }

    public static void create(Noun base) {
        if (s_statMap.size() > 0) {
            return;
        }
        GCStats stat = null;
        String name = null;
        List<GarbageCollectorMXBean> gcMBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean bean : gcMBeans) {
            stat = new GCStats(base, bean);
            name = bean.getName();
            s_statMap.put(name, stat);
        }
    }

    public void refresh() {
        this.m_time.update(this.m_bean.getCollectionTime());
        this.m_count.update(this.m_bean.getCollectionCount());
    }

    static void exit() {
        s_statMap.clear();
        s_baseNoun = null;
    }
}

