/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import oracle.dms.clock.Clock;
import oracle.dms.clock.ClockManager;
import oracle.dms.clock.ClockState;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Level;
import oracle.dms.instrument.Log;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.dms.spy.Metric;
import oracle.dms.spy.PropertiesStates;
import oracle.dms.spy.jvm.MgmtStats;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Indentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsProducer
implements GroupRefresh {
    long _startTime = System.currentTimeMillis();
    private static Noun _cn;
    private static Noun _jn;
    private static Noun _measNoun;
    static State _nodes_state;
    private static State _freeMem;
    private static State _totalMem;
    private static State _uptime;
    private static State _threads;
    private static State _thrGrps;
    private static State _startTimeState;
    private static int _numThreads;
    private static int _numThrGrps;
    public static Event _nounCreate;
    public static Event _sensorCreate;
    public static Event _nounDestroy;
    public static Event _sensorDestroy;
    static State lastID;
    public static Event sampleVal;
    public static State _clockTime;
    public static int _nounCreateCount;
    private static final int _version = 2;
    private static boolean _alive;
    private Indentation _indent = new Indentation();
    public static final String JAVA_DMS = "DMS-Internal";
    private static final String PREFIX = "PROD_";
    private static final String MEASUREMENT = "Measurement";
    private static final String NODES = "treeNodes";
    private static final String LAST_ID = "lastTreeNodeID";
    private static final String NOUN_CREATE = "createNoun";
    private static final String NOUN_DESTROY = "destroyNoun";
    private static final String SENSOR_CREATE = "createSensor";
    private static final String SENSOR_DESTROY = "destroySensor";
    private static final String SAMPLE_VAL = "sampleMetric";
    private static final String START_TIME = "startTime";
    private static final String SENSOR_WEIGHT = "sensorWeight";
    private static final String CLOCK = "Clock";
    private static final String CLOCK_NAME = "name";
    private static final String REQUESTED_UNITS = "requestedUnits";
    private static final String MEASURED_FREQ = "measuredFrequency";
    private static final String REPORTED_FREQ = "reportedFrequency";
    private static final String CLOCK_OVERHEAD = "overheadPerCall";
    private static final String MEASURED_RESOLUTION = "measuredResolution";
    private static final String CLOCK_TIME = "clockTime";
    private static final String JVM = "JVM";
    private static final String JVM_TOTAL_MEM = "totalMemory";
    private static final String JVM_FREE_MEM = "freeMemory";
    private static final String JVM_THREADS = "activeThreads";
    private static final String JVM_THRGRPS = "activeThreadGroups";
    private static final String JSPY_UPTIME = "upTime";
    private static final String THRREFRERR = "threadRefreshError";

    StatisticsProducer(String name) {
        _alive = true;
        Noun root = Noun.getRoot();
        if (root != null) {
            root.setName(name);
        }
        this.initSpyMetrics();
    }

    synchronized void exit() {
        if (!_alive) {
            return;
        }
        if (_measNoun != null) {
            _measNoun.destroy();
        }
        if (_jn != null) {
            _jn.destroy();
        }
        if (_cn != null) {
            _cn.destroy();
        }
        _nodes_state = null;
        _freeMem = null;
        _totalMem = null;
        _uptime = null;
        _threads = null;
        _thrGrps = null;
        _startTimeState = null;
        _nounCreate = null;
        _sensorCreate = null;
        _nounDestroy = null;
        _sensorDestroy = null;
        lastID = null;
        sampleVal = null;
        _clockTime = null;
        _numThreads = 0;
        _numThrGrps = 0;
        _nounCreateCount = 1;
        PropertiesStates.exit();
        MgmtStats.exit();
        oracle.jvmmon.metrics.MgmtStats.exit();
        _alive = false;
    }

    void initSpyMetrics() {
        Noun.create("/DMS-Internal", DMSNLSupport.getString("PROD_DMS-Internal"));
        _measNoun = Noun.create(DMSUtil.genCompNounPath(MEASUREMENT), DMSNLSupport.getString("PROD_Measurement"));
        _nodes_state = new State(_measNoun, NODES, "", DMSNLSupport.getString("PROD_treeNodes"), 0);
        _nodes_state.configureLogging(null, Level.OFF);
        _nodes_state.deriveMetric(8);
        String lidMsg = DMSNLSupport.getString("PROD_lastTreeNodeID");
        lastID = new State(_measNoun, LAST_ID, "", lidMsg, 0);
        lastID.configureLogging(null, Level.OFF);
        _nounCreate = Event.create(_measNoun, NOUN_CREATE, DMSNLSupport.getString("PROD_createNoun"));
        for (int x = 0; x < _nounCreateCount; ++x) {
            _nounCreate.occurred();
        }
        _nounDestroy = Event.create(_measNoun, NOUN_DESTROY, DMSNLSupport.getString("PROD_destroyNoun"));
        _sensorCreate = Event.create(_measNoun, SENSOR_CREATE, DMSNLSupport.getString("PROD_createSensor"));
        _sensorDestroy = Event.create(_measNoun, SENSOR_DESTROY, DMSNLSupport.getString("PROD_destroySensor"));
        sampleVal = Event.create(_measNoun, SAMPLE_VAL, DMSNLSupport.getString("PROD_sampleMetric"));
        State state = State.create(_measNoun, SENSOR_WEIGHT, "", DMSNLSupport.getString("PROD_sensorWeight"), DMSConsole.getSensorWeight());
        _cn = Noun.create("/DMS-Internal/Clock", DMSNLSupport.getString("PROD_Clock"));
        Clock clock = DMSConsole.getClock();
        State cstate = State.create(_cn, CLOCK_NAME, "", DMSNLSupport.getString("PROD_Clockname"), (Object)clock.getName());
        String units = ClockManager.getUnits(DMSConsole.UNITS);
        cstate = State.create(_cn, REQUESTED_UNITS, "", DMSNLSupport.getString("PROD_requestedUnits"), (Object)DMSNLSupport.getString(units.toUpperCase()));
        cstate = State.create(_cn, MEASURED_FREQ, DMSNLSupport.getString("TICKS"), DMSNLSupport.getString("PROD_measuredFrequency"), clock.getMeasuredFrequency());
        cstate = State.create(_cn, REPORTED_FREQ, DMSNLSupport.getString("TICKS"), DMSNLSupport.getString("PROD_reportedFrequency"), clock.getReportedFrequency());
        String cunits = clock.getUnits().toUpperCase();
        cstate = State.create(_cn, CLOCK_OVERHEAD, DMSNLSupport.getString(cunits), DMSNLSupport.getString("PROD_overheadPerCall"), clock.getOverhead());
        cstate = State.create(_cn, MEASURED_RESOLUTION, DMSNLSupport.getString(cunits), DMSNLSupport.getString("PROD_measuredResolution"), clock.getDescription().getResolution());
        long time = 0L;
        _clockTime = State.create(_cn, CLOCK_TIME, DMSNLSupport.getString(cunits), DMSNLSupport.getString("PROD_clockTime"), time);
        ClockState.init(_clockTime);
        _jn = Noun.create("/JVM", DMSNLSupport.getString("PROD_JVM"));
        MgmtStats.create(_jn);
        oracle.jvmmon.metrics.MgmtStats.create(_jn);
        PropertiesStates pstates = PropertiesStates.create(_jn);
        _totalMem = State.create(_jn, JVM_TOTAL_MEM, DMSNLSupport.getString("KB"), DMSNLSupport.getString("PROD_totalMemory"), (int)(Runtime.getRuntime().totalMemory() / 1024L));
        _totalMem.deriveMetric(12);
        _freeMem = State.create(_jn, JVM_FREE_MEM, DMSNLSupport.getString("KB"), DMSNLSupport.getString("PROD_freeMemory"), (int)(Runtime.getRuntime().freeMemory() / 1024L));
        _freeMem.deriveMetric(12);
        _uptime = State.create(_jn, JSPY_UPTIME, DMSNLSupport.getString("MSECS"), DMSNLSupport.getString("PROD_upTime"), System.currentTimeMillis() - this._startTime);
        StatisticsProducer._refreshThreadStats();
        _threads = State.create(_jn, JVM_THREADS, DMSNLSupport.getString("THREADS"), DMSNLSupport.getString("PROD_activeThreads"), _numThreads);
        _threads.deriveMetric(12);
        _thrGrps = State.create(_jn, JVM_THRGRPS, DMSNLSupport.getString("GROUPS"), DMSNLSupport.getString("PROD_activeThreadGroups"), _numThrGrps);
        _thrGrps.deriveMetric(12);
        _startTimeState = State.create(_jn, START_TIME, DMSNLSupport.getString("MSECS"), DMSNLSupport.getString("PROD_startTime"), this._startTime);
        _totalMem.setRefresh(this);
        _freeMem.setRefresh(this);
        _uptime.setRefresh(this);
        _threads.setRefresh(this);
        _thrGrps.setRefresh(this);
    }

    @Override
    public void refresh() {
        _freeMem.update((int)(Runtime.getRuntime().freeMemory() / 1024L));
        _totalMem.update((int)(Runtime.getRuntime().totalMemory() / 1024L));
        _uptime.update(System.currentTimeMillis() - this._startTime);
        StatisticsProducer._refreshThreadStats();
        _threads.update(_numThreads);
        _thrGrps.update(_numThrGrps);
    }

    private static void _refreshThreadStats() {
        try {
            ThreadGroup grp = Thread.currentThread().getThreadGroup();
            if (grp == null) {
                return;
            }
            ThreadGroup parent = StatisticsProducer._getParent(grp);
            while (parent != null) {
                grp = parent;
                parent = StatisticsProducer._getParent(grp);
            }
            _numThreads = grp.activeCount();
            _numThrGrps = grp.activeGroupCount();
        }
        catch (Exception e) {
            Log.log("/JVM/threadRefreshError", DMSNLSupport.getString("PROD_threadRefreshError"), Level.ERROR, null);
        }
    }

    private static ThreadGroup _getParent(final ThreadGroup group) {
        ThreadGroup parent = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

            @Override
            public ThreadGroup run() {
                return group.getParent();
            }
        });
        return parent;
    }

    synchronized void dump(PrintWriter pw, boolean pretty) {
        pw.println("<DMSDUMP version='2.0'>");
        StringBuffer sb = new StringBuffer(64);
        long tstamp = System.currentTimeMillis();
        sb.append("<timestamp>");
        sb.append(tstamp);
        sb.append(" (");
        Date date = new Date(tstamp);
        sb.append(date);
        sb.append(")</timestamp>");
        pw.println(sb.toString());
        this._dumpNodes(Noun.getRoot(), pw, pretty, new HashSet<GroupRefresh>());
        pw.println("</DMSDUMP>");
    }

    private synchronized void _dumpNodes(Noun noun, PrintWriter pw, boolean pretty, HashSet<GroupRefresh> gRefresh) {
        if (pretty) {
            this._indent.indent(pw);
            pw.print(noun.getName() + '\n');
        }
        Vector metrics = noun.getMetrics();
        for (Metric m : metrics) {
            m.refresh(gRefresh);
            Object o = m.getValue(false);
            if (pretty) {
                this._indent.increIndent();
                this._indent.indent(pw);
                pw.println(m.getName() + ":\t" + o + " " + m.getUnits());
                this._indent.decreIndent();
                continue;
            }
            pw.println("" + m + ": " + o);
        }
        Vector nouns = noun.getNouns();
        this._indent.increIndent();
        for (Noun n : nouns) {
            this._dumpNodes(n, pw, pretty, gRefresh);
        }
        this._indent.decreIndent();
    }

    static {
        _nounCreateCount = 1;
        _alive = false;
    }
}

