/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.io.Serializable;
import oracle.dms.http.Request;
import oracle.dms.instrument.MetricDescriptor;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.reporter.TabletReporter;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.util.DMSUtil;

public class TbmlReporter
extends TabletReporter {
    public TbmlReporter(Request request) {
        super(request);
    }

    void printHeading(PrintWriter out) {
        out.print("<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE ");
        out.print("tbml");
        out.print(">\n<");
        out.print("tbml");
        out.print(" version='");
        out.print("11.0");
        out.print("' id='");
        out.print(this.m_id);
        out.print("' host='");
        out.print(DMSUtil.getLocalHostname());
        out.print("' ");
        out.print("name");
        out.print("='");
        out.print(this.m_name);
        out.print("' timestamp='");
        long tstamp = System.currentTimeMillis();
        out.print(tstamp);
        out.print("'>\n");
    }

    void printEnding(PrintWriter out) {
        out.print("</");
        out.print("tbml");
        out.print(">\n");
    }

    void printTableHeading(String table, PrintWriter out) {
        out.print('<');
        out.print("table");
        out.print(' ');
        out.print("name");
        out.print("='");
        out.print(table);
        out.print("' ");
        out.print("keys");
        out.print("='");
        out.print("Name");
        out.print(' ');
        out.print("Parent");
        out.print(' ');
        out.print("Host");
        out.print(' ');
        out.print("Process");
        out.print("'>\n");
    }

    void printTableEnding(String table, PrintWriter out) {
        out.print("</");
        out.print("table");
        out.print(">\n");
    }

    void printSchema(String table, NounDescriptor ndesc, long schemaRefreshTime, boolean verbose, PrintWriter out) {
        String[] ancestorTypes;
        long lastSchemaUpdate = ndesc.getLastUpdateTime();
        if (schemaRefreshTime > lastSchemaUpdate && lastSchemaUpdate != 0L) {
            return;
        }
        String[] sensorNames = ndesc.getSensorNames();
        if (sensorNames != null) {
            for (String sensorName : sensorNames) {
                SensorDescriptor sdesc = ndesc.getSensorDescriptor(sensorName);
                if (sdesc == null) continue;
                String[] metricNames = sdesc.getMetricNames();
                if (verbose) {
                    String description;
                    out.print('<');
                    out.print("columngroupdef");
                    out.print(' ');
                    out.print("name");
                    out.print("='");
                    out.print(sensorName);
                    String sensorType = sdesc.getType();
                    if (sensorType != null && sensorType.trim().length() > 0) {
                        out.print("' ");
                        out.print("type");
                        out.print("='");
                        out.print(sensorType);
                    }
                    if (metricNames != null && metricNames.length > 0) {
                        out.print("' ");
                        out.print("columns");
                        out.print("='");
                        for (int j = 0; j < metricNames.length; ++j) {
                            if (j != 0) {
                                out.print(' ');
                            }
                            out.print(metricNames[j]);
                        }
                    }
                    if ((description = sdesc.getDescription()) != null && description.trim().length() > 0) {
                        out.print("'>\n<");
                        out.print("description");
                        out.print("><![CDATA[");
                        out.print(description);
                        out.print("]]></");
                        out.print("description");
                        out.print(">\n</");
                        out.print("columngroupdef");
                        out.print(">\n");
                    } else {
                        out.print("'/>\n");
                    }
                }
                if (metricNames == null || metricNames.length <= 0) continue;
                for (String metricName : metricNames) {
                    MetricDescriptor mdesc = sdesc.getMetricDescriptor(metricName);
                    if (mdesc == null) continue;
                    out.print('<');
                    out.print("columndef");
                    out.print(' ');
                    out.print("name");
                    out.print("='");
                    out.print(metricName);
                    String type = mdesc.getValueType();
                    if (type != null && type.trim().length() > 0 && !"string".equalsIgnoreCase(type)) {
                        out.print("' ");
                        out.print("type");
                        out.print("='");
                        out.print(type);
                    }
                    String unit = mdesc.getUnit();
                    if (verbose && unit != null && unit.trim().length() > 0) {
                        out.print("'>\n<");
                        out.print("unit");
                        out.print("><![CDATA[");
                        out.print(unit);
                        out.print("]]></");
                        out.print("unit");
                        out.print(">\n</");
                        out.print("columndef");
                        out.print(">\n");
                        continue;
                    }
                    out.print("'/>\n");
                }
            }
        }
        if ((ancestorTypes = ndesc.getAncestorTypes()) != null) {
            for (String ancestorType : ancestorTypes) {
                this._printPropertyDefinition(ancestorType, out);
            }
        }
        this._printPropertyDefinition("Name", out);
        this._printPropertyDefinition("Parent", out);
        this._printPropertyDefinition("Host", out);
        this._printPropertyDefinition("Process", out);
    }

    void printValues(String table, Noun[] nouns, Sensor[][] sensors, Metric[][][] metrics, Serializable[][][] values, long valueRefreshTime, PrintWriter out) {
        for (int j = 0; j < nouns.length; ++j) {
            if (nouns[j] == null) continue;
            out.print('<');
            out.print("row");
            out.print(">\n");
            Noun parent = nouns[j].getParent();
            if (sensors[j] != null) {
                for (int i = 0; i < sensors[j].length; ++i) {
                    if (sensors[j][i] == null || metrics[j][i] == null) continue;
                    this._printMetrics(metrics[j][i], values[j][i], out);
                }
            }
            this._printProperty("Name", nouns[j].getName(), out);
            this._printProperty("Parent", parent.toString(), out);
            this._printProperty("Host", DMSUtil.getLocalHostname(), out);
            this._printProperty("Process", DMSUtil.getProcessName(), out);
            long lastNounUpdate = nouns[j].getCreateTime();
            if (valueRefreshTime <= lastNounUpdate || lastNounUpdate == 0L) {
                Noun root = Noun.getRoot();
                while (parent != root) {
                    String type = parent.getType();
                    if (!"n/a".equals(type) && type.trim().length() != 0) {
                        this._printProperty(type, parent.getName(), out);
                    }
                    parent = parent.getParent();
                }
            }
            out.print("</");
            out.print("row");
            out.print(">\n");
        }
    }

    private void _printMetrics(Metric[] metrics, Serializable[] values, PrintWriter out) {
        for (int i = 0; i < metrics.length; ++i) {
            if (metrics[i] == null) continue;
            out.print('<');
            out.print("column");
            out.print(' ');
            out.print("name");
            out.print("='");
            out.print(metrics[i].getName());
            if (values[i] == null) {
                out.print("' ");
                out.print("null");
                out.print("='true'/>\n");
                continue;
            }
            if (values[i] instanceof ErrorObject) {
                out.print("' ");
                out.print("error");
                out.print("='true'/>\n");
                continue;
            }
            out.print("'><![CDATA[");
            out.print(DMSUtil.xmlEscape(values[i].toString()));
            out.print("]]></");
            out.print("column");
            out.print(">\n");
        }
    }

    private void _printPropertyDefinition(String propertyName, PrintWriter out) {
        out.print('<');
        out.print("columndef");
        out.print(' ');
        out.print("name");
        out.print("='");
        out.print(propertyName);
        out.print("'/>\n");
    }

    private void _printProperty(String name, String value, PrintWriter out) {
        out.print('<');
        out.print("column");
        out.print(' ');
        out.print("name");
        out.print("='");
        out.print(name);
        out.print("'><![CDATA[");
        out.print(value);
        out.print("]]></");
        out.print("column");
        out.print(">\n");
    }
}

