/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.util.StringTokenizer;
import oracle.dms.http.Request;
import oracle.dms.reporter.Reporter;
import oracle.dms.util.QueryOptions;
import oracle.dms.util.TableQueryDescriptor;

public abstract class TableBaseReporter
extends Reporter {
    protected QueryOptions m_options;

    protected TableBaseReporter(Request request) {
        super(request);
        this.setQueryOptions();
    }

    public QueryOptions getQueryOptions() {
        return this.m_options;
    }

    public void clear() {
        this.m_options.close();
    }

    protected void setQueryOptions() {
        String[] selectString;
        String[] valueRefreshStrings;
        String[] schemaRefreshStrings;
        this.m_options = this.m_request.includeDescription() || this.m_request.includeUnits() ? (this.m_request.includeValues() ? new QueryOptions(QueryOptions.QueryType.ALL) : new QueryOptions(QueryOptions.QueryType.SCHEMA)) : new QueryOptions(QueryOptions.QueryType.ROWS);
        String[] projectionStrings = this.m_request.getParameterValues("project");
        if (projectionStrings != null && projectionStrings.length > 0) {
            this._setTableQueryDescriptors(projectionStrings);
        }
        if ((schemaRefreshStrings = this.m_request.getParameterValues("schemarefresh")) != null && schemaRefreshStrings.length > 0) {
            this._setRefreshTime(schemaRefreshStrings, true);
        }
        if ((valueRefreshStrings = this.m_request.getParameterValues("valuerefresh")) != null && valueRefreshStrings.length > 0) {
            this._setRefreshTime(valueRefreshStrings, false);
        }
        if ((selectString = this.m_request.getParameterValues("select")) != null && selectString.length > 0) {
            this._setRankingSelections(selectString);
        }
    }

    private void _setRefreshTime(String[] refreshStrings, boolean isSchema) {
        for (String refreshString : refreshStrings) {
            long refreshTime;
            int index;
            if (refreshString == null || refreshString.trim().length() == 0 || (index = refreshString.indexOf(58)) <= 0) continue;
            String table = refreshString.substring(index + 1);
            String refresh = refreshString.substring(0, index);
            try {
                refreshTime = Long.parseLong(refresh.trim());
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (refreshTime <= 0L || table.trim().length() == 0) continue;
            TableQueryDescriptor desc = this.m_options.getTableQueryDescriptor(table);
            if (desc == null) {
                desc = new TableQueryDescriptor(table, this.m_options.getQueryType());
                this.m_options.setTableQueryDescriptor(desc);
            }
            if (isSchema) {
                desc.setSchemaRefreshTime(refreshTime);
                continue;
            }
            desc.setValueRefreshTime(refreshTime);
        }
    }

    private void _setTableQueryDescriptors(String[] projectionStrings) {
        for (String projectionString : projectionStrings) {
            if (projectionString == null || projectionString.trim().length() == 0) continue;
            String table = null;
            int i = 0;
            StringTokenizer tok = new StringTokenizer(projectionString, " ");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (i == 0) {
                    table = token;
                } else if (i == 1) {
                    QueryOptions.QueryType queryType = "rows".equalsIgnoreCase(token) ? QueryOptions.QueryType.ROWS : ("schema".equalsIgnoreCase(token) ? QueryOptions.QueryType.SCHEMA : QueryOptions.QueryType.ALL);
                    this.m_options.setQueryType(queryType, table);
                } else {
                    TableQueryDescriptor desc = this.m_options.getTableQueryDescriptor(table);
                    if (desc == null) {
                        desc = new TableQueryDescriptor(table, this.m_options.getQueryType());
                        this.m_options.setTableQueryDescriptor(desc);
                    }
                    desc.addColumn(token);
                }
                ++i;
            }
        }
    }

    private void _setRankingSelections(String[] selectionStrings) {
        block4: for (String selectionString : selectionStrings) {
            if (selectionString == null || selectionString.trim().length() == 0) continue;
            String table = null;
            TableQueryDescriptor.Order order = null;
            int numRows = 0;
            String column = null;
            int i = 0;
            StringTokenizer tok = new StringTokenizer(selectionString, " ");
            while (tok.hasMoreTokens()) {
                block12: {
                    String token = tok.nextToken();
                    if (i == 0) {
                        table = token;
                    } else if (i == 1) {
                        order = "asc".equalsIgnoreCase(token) ? TableQueryDescriptor.Order.ASC : TableQueryDescriptor.Order.DESC;
                    } else {
                        if (i == 2) {
                            try {
                                numRows = Integer.parseInt(token);
                                break block12;
                            }
                            catch (NumberFormatException e) {
                                continue block4;
                            }
                        }
                        column = token;
                    }
                }
                ++i;
            }
            try {
                TableQueryDescriptor.RankingSelection selection = new TableQueryDescriptor.RankingSelection(order, numRows, column);
                TableQueryDescriptor desc = this.m_options.getTableQueryDescriptor(table);
                if (desc == null) {
                    desc = new TableQueryDescriptor(table, this.m_options.getQueryType());
                    this.m_options.setTableQueryDescriptor(desc);
                }
                desc.setRankingSelection(selection);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }
}

