/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import oracle.core.ojdl.LogMessage;
import oracle.dms.instrument.DMSFileUtil;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDumpListener;
import oracle.dms.instrument.State;
import oracle.dms.instrument.Tracer;
import oracle.dms.instrument.TransTraceIntf;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.OHSBase64Encoder;

public class TransTrace
implements TransTraceIntf,
NounDumpListener {
    private static boolean s_dollarStrippingEnabled = true;
    private static boolean s_dumpEnabled = false;
    private static boolean s_debugEnabled = false;
    private static boolean s_transTraceEnabled = false;
    private static boolean s_ecidEnabled = true;
    private static int s_maxdumps;
    private static int s_maxrecords;
    private static int s_maxtraces;
    private static int s_maxaggregates;
    private static int s_dumpinterval;
    private static String s_dumpdestination;
    private static String s_debugdestination;
    private static Cookie s_cookie;
    private static String s_cookieString;
    private static String s_portStr;
    static String NOUN_PATHNAME;

    public void init(String vmid, String portStr) {
        StringBuffer nameBuf;
        String ohome;
        int ival;
        String DMS_PROP = "oracle.dms";
        String TT_PROP = DMS_PROP + ".transtrace";
        String TT_ENABLED_PROP = TT_PROP + ".enabled";
        String TT_ECIDENABLED_PROP = TT_PROP + ".ecidenabled";
        String TT_DUMPENABLED_PROP = TT_PROP + ".dumpenabled";
        String TT_DEBUGENABLED_PROP = TT_PROP + ".debugenabled";
        String TT_MAXRECORDS_PROP = TT_PROP + ".maxrecords";
        String TT_MAXTRACES_PROP = TT_PROP + ".maxtraces";
        String TT_MAXAGGREGATES_PROP = TT_PROP + ".maxaggregates";
        String TT_MAXDUMPS_PROP = TT_PROP + ".maxdumps";
        String TT_DOLLARSTRIPPING_PROP = TT_PROP + ".dollarstrippingenabled";
        String TT_DUMPDESTINATION_PROP = TT_PROP + ".dumpdestination";
        String TT_DEBUGDESTINATION_PROP = TT_PROP + ".debugdestination";
        String TT_DUMPINTERVAL_PROP = TT_PROP + ".dumpinterval";
        String TT_DUMPDETAIL_PROP = TT_PROP + ".dumpdetail";
        String pval = DMSProperties.getProperty(TT_ENABLED_PROP);
        if (pval != null && pval.equalsIgnoreCase("true")) {
            s_transTraceEnabled = true;
            s_dumpEnabled = true;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setProperty("oracle.jdbc.DMSStatementMetrics", "true");
                    return null;
                }
            });
            System.err.println("NOTIFICATION: " + TT_ENABLED_PROP + "=" + pval);
        }
        if (s_transTraceEnabled) {
            s_ecidEnabled = true;
        } else {
            pval = DMSProperties.getProperty(TT_ECIDENABLED_PROP);
            if (pval != null) {
                s_ecidEnabled = !pval.equalsIgnoreCase("false");
            }
        }
        pval = DMSProperties.getProperty(TT_DUMPENABLED_PROP);
        if (pval != null) {
            s_dumpEnabled = !pval.equalsIgnoreCase("false");
        }
        if ((pval = DMSProperties.getProperty(TT_DEBUGENABLED_PROP)) != null) {
            s_debugEnabled = !pval.equalsIgnoreCase("false");
        }
        if ((pval = DMSProperties.getProperty(TT_DUMPINTERVAL_PROP)) != null) {
            try {
                ival = Integer.parseInt(pval);
                if (ival >= 1) {
                    s_dumpinterval = ival;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((pval = DMSProperties.getProperty(TT_MAXDUMPS_PROP)) != null) {
            try {
                ival = Integer.parseInt(pval);
                if (ival > 0) {
                    s_maxdumps = ival;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((pval = DMSProperties.getProperty(TT_MAXRECORDS_PROP)) != null) {
            try {
                int ival2 = Integer.parseInt(pval);
                if (ival2 >= 1) {
                    s_maxrecords = ival2;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((pval = DMSProperties.getProperty(TT_MAXTRACES_PROP)) != null) {
            try {
                int ival3 = Integer.parseInt(pval);
                if (ival3 >= 1) {
                    s_maxtraces = ival3;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((pval = DMSProperties.getProperty(TT_MAXAGGREGATES_PROP)) != null) {
            try {
                int ival4 = Integer.parseInt(pval);
                if (ival4 >= 1) {
                    s_maxaggregates = ival4;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((pval = DMSProperties.getProperty(TT_DUMPDESTINATION_PROP)) != null) {
            s_dumpdestination = pval;
        }
        if ((pval = DMSProperties.getProperty(TT_DEBUGDESTINATION_PROP)) != null) {
            s_debugdestination = pval;
        }
        if ((pval = DMSProperties.getProperty(TT_DOLLARSTRIPPING_PROP)) != null && pval.equalsIgnoreCase("false")) {
            s_dollarStrippingEnabled = false;
        }
        if (s_dumpEnabled) {
            File dir;
            if (s_dumpdestination != null) {
                dir = new File(s_dumpdestination);
                DMSFileUtil.mkdirs(dir);
            } else {
                ohome = DMSProperties.getProperty("oracle.home");
                if (ohome == null) {
                    ohome = ".";
                }
                nameBuf = new StringBuffer();
                nameBuf.append(ohome);
                nameBuf.append(File.separator);
                nameBuf.append("diagnostics");
                dir = new File(nameBuf.toString());
                DMSFileUtil.mkdir(dir);
                nameBuf.append(File.separator);
                nameBuf.append("transtrace");
                dir = new File(nameBuf.toString());
                DMSFileUtil.mkdir(dir);
                s_dumpdestination = nameBuf.toString();
            }
            if (vmid != null) {
                s_dumpdestination = s_dumpdestination + File.separator + vmid;
                dir = new File(s_dumpdestination);
                DMSFileUtil.mkdir(dir);
            }
        }
        if (s_debugEnabled) {
            File dir;
            if (s_debugdestination != null) {
                dir = new File(s_debugdestination);
                DMSFileUtil.mkdir(dir);
            } else {
                ohome = DMSProperties.getProperty("oracle.home");
                if (ohome == null) {
                    ohome = ".";
                }
                nameBuf = new StringBuffer();
                nameBuf.append(ohome);
                nameBuf.append(File.separator);
                nameBuf.append("diagnostics");
                dir = new File(nameBuf.toString());
                DMSFileUtil.mkdir(dir);
                nameBuf.append(File.separator);
                nameBuf.append("transtrace");
                dir = new File(nameBuf.toString());
                DMSFileUtil.mkdir(dir);
                nameBuf.append(File.separator);
                nameBuf.append("debug");
                dir = new File(nameBuf.toString());
                DMSFileUtil.mkdir(dir);
                s_debugdestination = nameBuf.toString();
            }
            if (vmid != null) {
                s_debugdestination = s_debugdestination + File.separator + vmid;
                dir = new File(s_debugdestination);
                DMSFileUtil.mkdir(dir);
            }
        }
        s_portStr = portStr;
        if (s_dumpEnabled) {
            try {
                Noun noun = Noun.create(NOUN_PATHNAME, "n/a");
                pval = DMSProperties.getProperty(TT_DUMPDETAIL_PROP);
                if (pval != null && pval.equalsIgnoreCase("full")) {
                    noun = Noun.getRoot();
                }
                noun.enableDumping(s_dumpinterval, s_dumpdestination, s_maxdumps, this);
            }
            catch (Exception e) {
                TransTrace.debug("WARNING: DMS exception ignored initializing aggregate dumping: " + e);
                e.printStackTrace();
            }
        }
        TransTrace.recordConfigParams();
    }

    private static void initRoutingCookie() {
        if (s_cookie == null) {
            String ajp13Host = DMSUtil.getLocalHostname();
            int ajp13Port = 0;
            try {
                ajp13Port = Integer.parseInt(s_portStr);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            State uidSt = (State)State.get("/oc4j/opmnInfo/vmId");
            String uid = null;
            if (uidSt == null) {
                return;
            }
            uid = (String)uidSt.getValue();
            String cookStr = OHSBase64Encoder.createCookie(ajp13Host, ajp13Port, uid);
            s_cookie = new Cookie("fake-JSESSIONID", cookStr);
            s_cookieString = "fake-JSESSIONID=" + cookStr;
            s_cookie.setPath("/");
        }
    }

    public boolean isEnabled() {
        return s_transTraceEnabled;
    }

    public static boolean _isEnabled() {
        return s_transTraceEnabled;
    }

    public boolean isEcidEnabled() {
        return s_ecidEnabled;
    }

    public static boolean _isEcidEnabled() {
        return s_ecidEnabled;
    }

    public boolean isDumpEnabled() {
        return s_dumpEnabled;
    }

    public static boolean _isDumpEnabled() {
        return s_dumpEnabled;
    }

    public static boolean _isDebugEnabled() {
        return s_debugEnabled;
    }

    public static String _getDebugDestination() {
        return s_debugdestination;
    }

    public static boolean _isDollarStrippingEnabled() {
        return s_dollarStrippingEnabled;
    }

    public int getMaxRecords() {
        return s_maxrecords;
    }

    public static int _getMaxRecords() {
        return s_maxrecords;
    }

    public static int getMaxTraces() {
        return s_maxtraces;
    }

    public static int _getMaxTraces() {
        return s_maxtraces;
    }

    public static int getMaxAggregates() {
        return s_maxaggregates;
    }

    public static int _getMaxAggregates() {
        return s_maxaggregates;
    }

    public void servletRequestStart(HttpServletRequest request, HttpServletResponse response) {
        if (!s_ecidEnabled) {
            return;
        }
        try {
            String trCtxStr;
            String clientID;
            LogMessage.InstanceId ctxId = null;
            Cookie[] cookies = null;
            String ecHdrStr = null;
            String ecidStr = null;
            ExecutionContext ectx = ExecutionContext.get();
            ecHdrStr = request.getHeader("Oracle-ECID");
            String ecCookStr = null;
            if (ecHdrStr != null) {
                ecidStr = ecHdrStr;
            } else {
                cookies = request.getCookies();
                if (cookies != null) {
                    for (int i = 0; i < cookies.length; ++i) {
                        Cookie c = cookies[i];
                        String cname = c.getName();
                        if (!cname.equals("Oracle-ECID")) continue;
                        ecidStr = ecCookStr = c.getValue();
                        break;
                    }
                }
            }
            if (ecidStr != null) {
                ctxId = ExecutionContext.parseECID(ecidStr);
            }
            if (ctxId != null) {
                ectx.setECID(ctxId);
                ectx.incrementECIDSequenceNumber();
            } else {
                ctxId = ectx.getECID();
            }
            if (!s_transTraceEnabled) {
                return;
            }
            if (ecidStr == null) {
                ecidStr = ectx.getECIDasString();
            }
            if (ecidStr != null && ecCookStr == null) {
                Cookie cookie = new Cookie("Oracle-ECID", ecidStr);
                cookie.setPath("/");
                response.addCookie(cookie);
            }
            if ((clientID = request.getRemoteUser()) != null) {
                ectx.setAttribute("ClientID", clientID);
            }
            if (ectx.getAttributeMap().get("URI") == null) {
                String qstring;
                StringBuffer uriBuf = HttpUtils.getRequestURL((HttpServletRequest)request);
                if (uriBuf != null && (qstring = request.getQueryString()) != null) {
                    uriBuf.append("?");
                    uriBuf.append(qstring);
                }
                String uri = uriBuf.toString();
                ectx.getAttributeMap().put("URI", uri);
            }
            String ttHdrStr = null;
            String ttCookStr = null;
            String traceTrigger = null;
            ttHdrStr = request.getHeader("Oracle-TraceTrigger");
            if (ttHdrStr != null) {
                traceTrigger = ttHdrStr;
            } else {
                if (cookies != null || (cookies = request.getCookies()) != null) {
                    for (int i = 0; i < cookies.length; ++i) {
                        Cookie c = cookies[i];
                        String cname = c.getName();
                        if (!cname.equals("Oracle-TraceTrigger")) continue;
                        ttCookStr = c.getValue();
                        break;
                    }
                }
                if (ttCookStr != null) {
                    traceTrigger = ttCookStr;
                }
            }
            if (traceTrigger != null) {
                Tracer trac = ectx.getTracer();
                trac.setTriggered(true);
                if (!(ttHdrStr == null || ttCookStr != null && ttHdrStr.equals(ttCookStr))) {
                    Cookie cookie = new Cookie("Oracle-TraceTrigger", ttHdrStr);
                    cookie.setPath("/");
                    response.addCookie(cookie);
                }
                response.addCookie(this.getRoutingCookie());
            }
            if ((trCtxStr = request.getHeader("Oracle-TraceContext")) != null) {
                ectx.getAttributeMap().put("Oracle-TraceContext", trCtxStr);
            }
        }
        catch (Exception e) {
            TransTrace.debug("WARNING: DMS TransTrace caught (and ignored) exception: " + e);
            e.printStackTrace();
        }
    }

    private static void debug(String msg) {
        System.err.println(msg);
    }

    public void servletRequestStop(HttpServletRequest request, HttpServletResponse response) {
    }

    public void requestStart() {
        ExecutionContext ectx = ExecutionContext.get();
        if (!s_transTraceEnabled) {
            return;
        }
        Tracer trac = ectx.getTracer();
        trac.beginRequest();
    }

    public void requestStop() {
        if (!s_ecidEnabled) {
            return;
        }
        ExecutionContext ectx = ExecutionContext.get();
        if (s_transTraceEnabled) {
            Tracer trac = ectx.getTracer();
            trac.endRequest();
        }
        ectx.reset();
    }

    public Cookie getRoutingCookie() {
        return TransTrace._getRoutingCookie();
    }

    public static Cookie _getRoutingCookie() {
        TransTrace.initRoutingCookie();
        return s_cookie;
    }

    public void preNounDump(Noun n) {
    }

    public void postNounDump(Noun n) {
        Noun urinoun = Noun.get(NOUN_PATHNAME);
        if (urinoun != null) {
            urinoun.invalidateSubtree();
        }
    }

    private static void recordConfigParams() {
        Noun ttNoun = Noun.create("/DMS-Internal/transtrace", "transtrace info");
        State.create(ttNoun, "s_transTraceEnabled", "", "indicates whether transtrace feature is enabled", (Object)(s_transTraceEnabled ? "true" : "false"));
        State.create(ttNoun, "s_ecidEnabled", "", "indicates whether ECID feature is enabled", (Object)(s_ecidEnabled ? "true" : "false"));
        if (s_transTraceEnabled) {
            State.create(ttNoun, "s_maxrecords", "trace records", "max records allowed per trace", s_maxrecords);
            State.create(ttNoun, "s_maxtraces", "traces", "max traces allowed in memory", s_maxtraces);
            State.create(ttNoun, "s_dollarStrippingEnabled", "", "if true then URIs will be stripped after dollar $ char", (Object)(s_dollarStrippingEnabled ? "true" : "false"));
        }
        State.create(ttNoun, "s_dumpEnabled", "", "true if aggregate dumping enabled", (Object)(s_dumpEnabled ? "true" : "false"));
        if (s_dumpEnabled) {
            State.create(ttNoun, "s_dumpdestination", "", "destination for aggregate dumps", (Object)s_dumpdestination);
            State.create(ttNoun, "s_maxdumps", "dumps", "max dumps allowed on disk", s_maxdumps);
            State.create(ttNoun, "s_maxaggregates", "URIs", "max URIs allowed in memory", s_maxaggregates);
            State.create(ttNoun, "s_dumpinterval", "secs", "time delay between dumps", s_dumpinterval);
        }
        State.create(ttNoun, "s_debugEnabled", "", "true if transtrace debugging enabled", (Object)(s_debugEnabled ? "true" : "false"));
        if (s_debugEnabled) {
            State.create(ttNoun, "s_debugdestination", "", "destination for debug info", (Object)s_debugdestination);
        }
    }

    static synchronized void shutdown() {
        s_dollarStrippingEnabled = true;
        s_dumpEnabled = false;
        s_debugEnabled = false;
        s_transTraceEnabled = false;
        s_ecidEnabled = true;
        s_maxdumps = 8;
        s_maxrecords = 5000;
        s_maxtraces = 5;
        s_maxaggregates = 500;
        s_dumpinterval = 900;
        s_dumpdestination = null;
        s_cookie = null;
        s_cookieString = null;
        s_portStr = null;
        NOUN_PATHNAME = "/oc4j/URIs";
    }

    static {
        String pval = DMSProperties.getProperty("oracle.dms.transtrace.ecidenabled");
        if (pval != null && pval.equalsIgnoreCase("false")) {
            s_ecidEnabled = false;
        }
        s_maxdumps = 8;
        s_maxrecords = 5000;
        s_maxtraces = 5;
        s_maxaggregates = 500;
        s_dumpinterval = 900;
        s_dumpdestination = null;
        s_debugdestination = null;
        s_cookie = null;
        s_cookieString = null;
        s_portStr = null;
        NOUN_PATHNAME = "/oc4j/URIs";
    }
}

