/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oracle.core.ojdl.BusStopLogWriter;
import oracle.core.ojdl.FileLogWriter;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogWriter;
import oracle.core.ojdl.OutputStreamLogWriter;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.Level;
import oracle.dms.instrument.LogLevel;
import oracle.dms.instrument.Logger;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.dms.spy.ConfigurationError;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;

public class Log {
    public static final String MAXSIZE_KEY = "MaxSize";
    public static final String SEGSIZE_KEY = "SegmentSize";
    public static final String ENCODING_KEY = "Encoding";
    public static final String PATH_KEY = "Path";
    private static boolean _initialized = false;
    private static boolean s_isLoggingEnabled = false;
    private static HashMap s_logWriters = new HashMap();
    private static LogWriter s_stdoutLogWriter;
    private static LogWriter s_stderrLogWriter;
    private static final String LOGBASE;
    private static Noun _logNoun;
    private static Event s_msgsLogged;
    private static State s_logStatus;

    private Log() {
    }

    public static final synchronized void init() throws ConfigurationError, PrivilegedActionException {
        if (_initialized) {
            return;
        }
        Log.initMetrics();
        _initialized = true;
        try {
            LogManager.getLogManager().init(null);
        }
        catch (Exception e) {
            throw new ConfigurationError("50700", e);
        }
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws ConfigurationError {
                Log.initLogWriters();
                return null;
            }
        });
        Log.configureRootNoun();
        Log.setEnableLogging(true);
        Event evt = Event.create(LOGBASE + '/' + "initLogging", DMSNLSupport.getString("LOG_INIT_MESG"));
        evt.occurred();
    }

    public static final synchronized void shutdown() {
        Log.log(LOGBASE + "/shutdown", DMSNLSupport.getString("LOG_SHUTDOWN_MESG"), Level.DEBUG, null);
        Log.closeLogWriters();
        LogManager.getLogManager().term();
        Log.setEnableLogging(false);
        _logNoun.destroy();
        _logNoun = null;
        s_msgsLogged = null;
        s_logStatus = null;
        s_stdoutLogWriter = null;
        s_stderrLogWriter = null;
        _initialized = false;
    }

    public static void setEnableLogging(boolean enable) {
        s_isLoggingEnabled = enable;
        if (enable) {
            s_logStatus.update(DMSNLSupport.getString("LOG_STATUS_ENABLED"));
        } else {
            s_logStatus.update(DMSNLSupport.getString("LOG_STATUS_DISABLED"));
        }
    }

    public static boolean isLoggingEnabled() {
        return s_isLoggingEnabled;
    }

    private static void initMetrics() {
        _logNoun = Noun.create(LOGBASE, DMSNLSupport.getString("LOG_NOUN_DESC"));
        s_msgsLogged = Event.create(_logNoun, "messagesLogged", DMSNLSupport.getString("LOG_MSGS_WRITTEN"));
        s_msgsLogged.configureLogging(null, Level.OFF);
        s_logStatus = new State(_logNoun, "status", "", DMSNLSupport.getString("LOG_STATUS"), DMSNLSupport.getString("LOG_STATUS_ENABLED"));
    }

    protected static void logMsgEventOccurred() {
        s_msgsLogged.occurred();
    }

    private static void configureRootNoun() {
        HashMap<String, Object> prop = DMSProperties.getNounProperties("/");
        if (prop != null) {
            List logwriters;
            String strLev = (String)prop.get("loglevel");
            if (strLev != null) {
                Noun.getRoot().setLogLevel(Level.getLevel(strLev), false);
            }
            if ((logwriters = (List)prop.get("logwriter")) != null) {
                for (int i = 0; i < logwriters.size(); ++i) {
                    String lwName = (String)logwriters.get(i);
                    LogWriter lw = Log.getLogWriter(lwName);
                    if (lw == null) continue;
                    Noun.getRoot().addLogWriter(lw);
                }
            }
        }
    }

    public static LogWriter getLogWriter(String name) {
        LogWriter lw = (LogWriter)s_logWriters.get(name);
        if (lw == null) {
            if (s_stdoutLogWriter == null && name.equals("stdout")) {
                s_stdoutLogWriter = OutputStreamLogWriter.create(System.out);
                s_logWriters.put("stdout", s_stdoutLogWriter);
                lw = s_stdoutLogWriter;
            }
            if (s_stderrLogWriter == null && name.equals("stderr")) {
                s_stderrLogWriter = OutputStreamLogWriter.create(System.err);
                s_logWriters.put("stderr", s_stderrLogWriter);
                lw = s_stderrLogWriter;
            }
        }
        return lw;
    }

    private static void initLogWriters() throws ConfigurationError {
        Map<String, Properties> lws = DMSProperties.getLogWriterProperties();
        if (lws == null) {
            return;
        }
        Set<String> keys = lws.keySet();
        for (String lwName : keys) {
            if (lwName.equals("stdout") || lwName.equals("stderr")) {
                throw new ConfigurationError("50703", lwName);
            }
            try {
                LogWriter lw = Log.createLogWriter(lws.get(lwName));
                s_logWriters.put(lwName, lw);
            }
            catch (ConfigurationError e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigurationError("50704", lwName);
            }
        }
    }

    private static void closeLogWriters() {
        Iterator it = s_logWriters.values().iterator();
        while (it.hasNext()) {
            LogWriter lw = (LogWriter)it.next();
            if (lw != s_stdoutLogWriter && lw != s_stderrLogWriter) {
                try {
                    lw.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                it.remove();
                continue;
            }
            lw.flush();
        }
    }

    private static LogWriter createLogWriter(Properties properties) throws Exception {
        String clazz = properties.getProperty("Class");
        String path = properties.getProperty(PATH_KEY);
        boolean isXML = false;
        if (path.regionMatches(true, 0, "xml:", 0, 4)) {
            path = path.substring(4);
            isXML = true;
        }
        if (clazz != null && clazz.equals("oracle.core.ojdl.BusStopLogWriter") || isXML) {
            long maxSize = Log.getSizeProperty(properties, MAXSIZE_KEY);
            long segSize = Log.getSizeProperty(properties, SEGSIZE_KEY);
            String enc = properties.getProperty(ENCODING_KEY);
            return BusStopLogWriter.create(path, segSize, maxSize, enc);
        }
        if (clazz == null || clazz.equals("oracle.core.ojdl.FileLogWriter")) {
            long maxSize = Log.getSizeProperty(properties, MAXSIZE_KEY);
            long segSize = Log.getSizeProperty(properties, SEGSIZE_KEY);
            String enc = properties.getProperty(ENCODING_KEY);
            return FileLogWriter.create(path, segSize, maxSize, enc);
        }
        throw new ConfigurationError("50705", clazz);
    }

    private static long getSizeProperty(Properties prop, String key) throws ConfigurationError {
        String strSz = prop.getProperty(key);
        long size = Long.MAX_VALUE;
        if (strSz != null) {
            try {
                size = Long.parseLong(strSz);
            }
            catch (Exception e) {
                ConfigurationError ce = new ConfigurationError("50706", e);
                ce.addToken(key);
                ce.addToken(strSz);
                throw ce;
            }
        }
        return size;
    }

    public static void log(String pathname, String msg, Level level, Object[] inserts) {
        Logger evt = Logger.create(pathname, msg);
        evt.log(level, msg, inserts);
    }

    public static void log(String pathname, String msg, LogLevel level, Object[] inserts) {
        Log.log(pathname, msg, (Level)level, inserts);
    }

    static {
        LOGBASE = DMSUtil.genCompNounPath("Log");
    }
}

