/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.impl.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class ByteBuf {
    private byte[] m_buf;
    private int m_length = 0;

    public ByteBuf(byte[] buf) {
        if (buf == null) {
            throw new IllegalArgumentException(this.getClass().getName() + ": buf=" + buf);
        }
        this.m_buf = buf;
        this.m_length = buf.length;
    }

    public ByteBuf(byte[] buf, int length) {
        if (buf == null || length < 0 || buf.length < length) {
            throw new IllegalArgumentException(this.getClass().getName() + ": buf=" + buf + " length=" + length);
        }
        this.m_buf = buf;
        this.m_length = length;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.m_buf, 0, this.m_length);
    }

    public Reader getReader() {
        try {
            return new InputStreamReader(this.getInputStream(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new InputStreamReader(this.getInputStream());
        }
    }

    public String toString() {
        try {
            return new String(this.m_buf, 0, this.m_length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.m_buf, 0, this.m_length);
        }
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.m_length];
        System.arraycopy(this.m_buf, 0, bytes, 0, this.m_length);
        return bytes;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(this.getClass().getName() + ".writeTo() out=" + out);
        }
        out.write(this.m_buf, 0, this.m_length);
    }

    public void append(byte[] bytes, int offset, int length) {
        int newcount = this.m_length + length;
        if (newcount > this.m_buf.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(bytes, offset, this.m_buf, this.m_length, length);
        this.m_length = newcount;
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.m_buf.length + 1) * 2;
        if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        byte[] newBuf = new byte[newCapacity];
        System.arraycopy(this.m_buf, 0, newBuf, 0, this.m_length);
        this.m_buf = newBuf;
    }
}

