/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.http.DMSBindException;
import oracle.dms.http.DmsHttplet;
import oracle.dms.http.HttpAuthorizer;
import oracle.dms.http.HttpdThread;
import oracle.dms.impl.reporter.ReporterService;
import oracle.dms.impl.reporter.SpyAgency;
import oracle.dms.spy.Authorizer;
import oracle.dms.spy.Publisher;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;

public class Httpd
implements Publisher {
    public static final String THREADS_COUNT = "oracle.dms.http.threads";
    public static final String SERVER_PORT_START_KEY = "oracle.dms.httpd.port.start";
    public static final String SERVER_PORT_LEN_KEY = "oracle.dms.httpd.port.len";
    public static final String SERVER_LOCAL_HOST_KEY = "oracle.dms.httpd.host";
    static final String DEFAULT_PATH = '/' + DMSUtil.getDMSMount() + "/Spy";
    private static final int SERVER_PORT_START;
    private static final int SERVER_PORT_LEN;
    private static final String SERVER_LOCAL_HOST;
    private static final long SERVER_PORT_SEARCH_TIME = 20000L;
    private static final int SERVER_PORT_SO_TIMEOUT = 8000;
    private static final int EXIT_TIMEOUT = 10000;
    private static final int SERVER_PORT_LEN_MAX = 500;
    private static final String SERVER_NAME = "DMS HTTP Listener";
    public static final String LISTENER = "HTTP";
    static final String PREFIX = "HTTP_";
    private int m_threadcount = 3;
    static final Logger LOGGER;
    private ArrayList<HttpdThread> m_threads = new ArrayList();
    private HttpAuthorizer m_autherizor = new HttpAuthorizer();
    private ServerSocket m_serverSocket = null;
    private boolean m_shutdown = false;
    private Hashtable<String, DmsHttplet> m_httplets = new Hashtable();

    public Httpd() throws DMSBindException {
        this(-1, 0);
        ReporterService service = new ReporterService(new SpyAgency());
        this.mapHttplet(DEFAULT_PATH, service);
    }

    public Httpd(int port, int threadCount) throws DMSBindException {
        if (threadCount > 0 && threadCount < 30) {
            this.m_threadcount = threadCount;
        } else {
            this._setThreadCount();
        }
        this._findPort(port);
        for (int i = 0; i < this.m_threadcount; ++i) {
            this.m_threads.add(new HttpdThread(this, i));
        }
    }

    public Authorizer getAuthorizer() {
        return this.m_autherizor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publisherExit() {
        HttpdThread thread;
        Httpd httpd = this;
        synchronized (httpd) {
            if (this.m_shutdown) {
                return;
            }
            this.m_shutdown = true;
        }
        for (int i = 0; i < this.m_threadcount; ++i) {
            thread = this.m_threads.get(i);
            thread.shutdown();
        }
        try {
            this.m_serverSocket.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        for (int i = 0; i < this.m_threadcount; ++i) {
            thread = this.m_threads.get(i);
            try {
                thread.join(10000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getHttpdPort() {
        return this.m_serverSocket.getLocalPort();
    }

    public static String getHttpdHost() {
        return SERVER_LOCAL_HOST;
    }

    public DmsHttplet mapHttplet(String path, DmsHttplet httpLet) {
        if (path == null || path.trim().length() == 0 || httpLet == null) {
            return null;
        }
        path = Httpd.removetrailing(path);
        return this.m_httplets.put(path, httpLet);
    }

    public DmsHttplet removeHttplet(String path) {
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        path = Httpd.removetrailing(path);
        return this.m_httplets.remove(path);
    }

    public DmsHttplet getHttplet(String path) {
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        path = Httpd.removetrailing(path);
        return this.m_httplets.get(path);
    }

    public static String removetrailing(String path) {
        if (path == null || !path.endsWith("/")) {
            return path;
        }
        int len = path.length();
        path = len == 1 ? DEFAULT_PATH : path.substring(0, len - 1);
        return path;
    }

    ServerSocket getServerSocket() {
        return this.m_serverSocket;
    }

    private void _findPort(int port) throws DMSBindException {
        if (port < -1) {
            port = -1;
        }
        if (port >= 0) {
            this._initPort(port);
        } else {
            long start = System.currentTimeMillis();
            for (port = SERVER_PORT_START; this.m_serverSocket == null && port < SERVER_PORT_START + SERVER_PORT_LEN && System.currentTimeMillis() - start < 20000L; ++port) {
                try {
                    this._initPort(port);
                    continue;
                }
                catch (DMSBindException e) {
                    // empty catch block
                }
            }
            if (this.m_serverSocket == null) {
                this._initPort(0);
            }
        }
    }

    private void _initPort(int port) throws DMSBindException {
        try {
            if (SERVER_LOCAL_HOST == null) {
                this.m_serverSocket = new ServerSocket(port);
            } else {
                InetAddress localHost = InetAddress.getByName(SERVER_LOCAL_HOST);
                this.m_serverSocket = new ServerSocket(port, 50, localHost);
            }
            this.m_serverSocket.setSoTimeout(8000);
            DMSUtil.setProcessID(this.getHttpdPort());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, this.toString(), "_initPort", "Establish DMS HTTP server socket at port " + this.getHttpdPort());
            }
        }
        catch (Exception e) {
            String mesg = this.toString() + "._initPort(): Failed to find the port: " + port;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, this.toString(), "_initPort", mesg, e);
            }
            DMSBindException dbe = new DMSBindException("50725", Integer.toString(port), e);
            if (this.m_serverSocket != null) {
                try {
                    this.m_serverSocket.close();
                }
                catch (IOException ie) {
                    // empty catch block
                }
                this.m_serverSocket = null;
            }
            throw dbe;
        }
    }

    private void _setThreadCount() {
        int threadCount = DMSProperties.getPropertyInt(THREADS_COUNT, this.m_threadcount);
        if (threadCount > 0 && threadCount < 30) {
            this.m_threadcount = threadCount;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, this.toString(), "_setThreadCount", "sets Listener thread count: " + threadCount);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.logp(Level.FINE, this.toString(), "_setThreadCount", "wrong Listener thread count: " + threadCount);
        }
    }

    static {
        LOGGER = Logger.getLogger("oracle.dms.httpd");
        int port = DMSProperties.getPropertyInt(SERVER_PORT_START_KEY, 46080);
        if (port <= 0 || port >= 65536) {
            port = 46080;
        }
        SERVER_PORT_START = port;
        int len = DMSProperties.getPropertyInt(SERVER_PORT_LEN_KEY, 100);
        if (len <= 0 || len >= 500) {
            len = 100;
        }
        SERVER_PORT_LEN = len;
        SERVER_LOCAL_HOST = DMSProperties.getProperty(SERVER_LOCAL_HOST_KEY);
    }
}

