/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.dms.http.DmsHttplet;
import oracle.dms.http.HttpException;
import oracle.dms.http.HttpRequest;
import oracle.dms.http.Httpd;
import oracle.dms.http.Postlet;
import oracle.dms.impl.util.ByteBuf;
import oracle.dms.impl.util.ReadLine;

public abstract class HttpParser {
    private static final String HTTP_GET = "get";
    private static final String HTTP_POST = "post";
    private static final String HTTP_HEAD = "head";
    static final String SPY_PATH = "Spy";

    public static void readRequest(HttpRequest httpRequest) throws HttpException {
        if (httpRequest == null) {
            return;
        }
        InputStream instm = httpRequest.getInputStream();
        try {
            int curByte = instm.read();
            ByteArrayOutputStream token = new ByteArrayOutputStream();
            curByte = HttpParser.parseToken(curByte, instm, token);
            String method = token.toString();
            if (method.trim().length() == 0) {
                if (Httpd.LOGGER.isLoggable(Level.FINE)) {
                    Httpd.LOGGER.logp(Level.FINE, HttpParser.class.getName(), "readRequest", "No method in DMS HTTP request");
                }
                throw new HttpException(400);
            }
            if (HTTP_POST.equalsIgnoreCase(method)) {
                httpRequest.setMethod(2);
            } else if (HTTP_GET.equalsIgnoreCase(method)) {
                httpRequest.setMethod(1);
            } else if (HTTP_HEAD.equalsIgnoreCase(method)) {
                httpRequest.setMethod(3);
            } else {
                if (Httpd.LOGGER.isLoggable(Level.FINE)) {
                    Httpd.LOGGER.logp(Level.FINE, HttpParser.class.getName(), "readRequest", "Wrong method in DMS Http request: " + method);
                }
                throw new HttpException(405);
            }
            curByte = HttpParser.skipSpace(curByte, instm);
            curByte = HttpParser.parseURL(curByte, httpRequest);
            curByte = HttpParser.skipSpace(curByte, instm);
            if (curByte == 10 || curByte == 13) {
                if (httpRequest.getHttpMethod() == 3) {
                    if (Httpd.LOGGER.isLoggable(Level.FINE)) {
                        Httpd.LOGGER.logp(Level.FINE, HttpParser.class.getName(), "readRequest", "Can not be both HEAD method and version 0.9");
                    }
                    throw new HttpException(400);
                }
                httpRequest.setVersion(0.9f);
                return;
            }
            curByte = HttpParser.expect(curByte, instm, 'h');
            curByte = HttpParser.expect(curByte, instm, 't');
            curByte = HttpParser.expect(curByte, instm, 't');
            curByte = HttpParser.expect(curByte, instm, 'p');
            curByte = HttpParser.expect(curByte, instm, '/');
            curByte = HttpParser.expect(curByte, instm, '1', 505);
            if ((curByte = HttpParser.expect(curByte, instm, '.')) == 48) {
                httpRequest.setVersion(1.0f);
            } else if (curByte == 49) {
                httpRequest.setVersion(1.1f);
            } else {
                if (Httpd.LOGGER.isLoggable(Level.FINE)) {
                    Httpd.LOGGER.logp(Level.FINE, HttpParser.class.getName(), "readRequest", "Wrong HTTP version in DMS Http request: " + (char)curByte);
                }
                throw new HttpException(505);
            }
            curByte = instm.read();
            if (curByte == 13) {
                curByte = instm.read();
            }
            curByte = HttpParser.expect(curByte, instm, '\n');
            if (httpRequest.getHttpMethod() == 3) {
                throw new HttpException(204);
            }
            HttpParser.parseHeaders(curByte, instm, httpRequest);
            if (httpRequest.getHttpMethod() == 2) {
                int contentLength = httpRequest.getContentLength();
                if (contentLength == Integer.MAX_VALUE) {
                    throw new HttpException(411);
                }
                if (contentLength > 0) {
                    DmsHttplet httpLet = httpRequest.getHttplet();
                    if (httpLet == null) {
                        throw new HttpException(404);
                    }
                    if (httpLet instanceof Postlet) {
                        ByteBuf postData = ReadLine.read(instm, contentLength);
                        httpRequest.setPostData(postData);
                    } else {
                        HttpParser.parseQueryStrings(instm.read(), httpRequest);
                    }
                } else if (contentLength != 0) {
                    throw new HttpException(400);
                }
            }
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException e) {
            if (Httpd.LOGGER.isLoggable(Level.FINE)) {
                Httpd.LOGGER.logp(Level.FINE, HttpParser.class.getName(), "readRequest", "DMS HTTP listener encounters read error");
            }
            throw new HttpException(400);
        }
    }

    private static int skipSpace(int curByte, InputStream instm) throws IOException {
        block4: while (true) {
            switch (curByte) {
                case -1: {
                    throw new IOException();
                }
                case 9: 
                case 32: {
                    curByte = instm.read();
                    continue block4;
                }
            }
            break;
        }
        return curByte;
    }

    private static int skipToSpace(int curByte, HttpRequest httpRequest) throws IOException {
        while (true) {
            switch (curByte) {
                case -1: {
                    throw new IOException();
                }
                case 32: {
                    return curByte;
                }
            }
            curByte = httpRequest.read();
        }
    }

    private static int parsePath(int curByte, HttpRequest instm, ByteArrayOutputStream token) throws IOException {
        block5: while (true) {
            switch (curByte) {
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 34: 
                case 59: 
                case 60: 
                case 62: 
                case 63: {
                    break block5;
                }
                case 43: {
                    token.write(32);
                    break;
                }
                case 37: {
                    token.write(HttpParser.urlDecodeHex(instm));
                    break;
                }
                default: {
                    token.write(curByte);
                }
            }
            curByte = instm.read();
        }
        return curByte;
    }

    private static int parseToken(int curByte, InputStream instm, ByteArrayOutputStream token) throws IOException {
        block3: while (true) {
            switch (curByte) {
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 34: 
                case 40: 
                case 41: 
                case 44: 
                case 47: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 91: 
                case 92: 
                case 93: 
                case 123: 
                case 125: {
                    break block3;
                }
                default: {
                    token.write(curByte);
                    curByte = instm.read();
                    continue block3;
                }
            }
            break;
        }
        return curByte;
    }

    private static int parseURL(int curByte, HttpRequest httpRequest) throws IOException {
        String absPathString;
        ByteArrayOutputStream absPath = new ByteArrayOutputStream(32);
        if (curByte != 47) {
            if (Httpd.LOGGER.isLoggable(Level.FINE)) {
                Httpd.LOGGER.logp(Level.FINE, HttpParser.class.getName(), "parseURL", "DMS HTTP request URL does not start with /");
            }
            throw new HttpException(403);
        }
        curByte = HttpParser.parsePath(curByte, httpRequest, absPath);
        int lastChar = absPath.size() - 1;
        if (lastChar == 0) {
            absPathString = Httpd.DEFAULT_PATH;
        } else {
            absPathString = absPath.toString();
            if (absPathString.charAt(lastChar) == '/') {
                absPathString = absPathString.substring(0, lastChar);
            }
        }
        httpRequest.setRequestURI(absPathString);
        switch (curByte) {
            case 59: {
                ByteArrayOutputStream urlRewrite = new ByteArrayOutputStream(128);
                curByte = httpRequest.read();
                curByte = HttpParser.parsePath(curByte, httpRequest, urlRewrite);
                if (curByte != 63) break;
            }
            case 63: {
                if (httpRequest.getHttpMethod() != 1) break;
                curByte = httpRequest.read();
                curByte = HttpParser.parseQueryStrings(curByte, httpRequest);
                break;
            }
            case 32: {
                break;
            }
            default: {
                if (Httpd.LOGGER.isLoggable(Level.FINE)) {
                    Httpd.LOGGER.logp(Level.FINE, HttpParser.class.getName(), "parseURL", "DMS HTTP request has invalid path");
                }
                throw new HttpException(400);
            }
        }
        curByte = HttpParser.skipToSpace(curByte, httpRequest);
        return curByte;
    }

    private static void parseHeaders(int curByte, InputStream instm, HttpRequest httpRequest) throws IOException {
        while (true) {
            if (curByte == 13) {
                curByte = instm.read();
            }
            if (curByte == 10) {
                return;
            }
            ByteArrayOutputStream nameToken = new ByteArrayOutputStream();
            curByte = HttpParser.parseToken(curByte, instm, nameToken);
            String headerName = nameToken.toString().toLowerCase();
            if (headerName.trim().length() == 0) {
                if (Httpd.LOGGER.isLoggable(Level.FINE)) {
                    Httpd.LOGGER.logp(Level.FINE, HttpParser.class.getName(), "parseHeaders", "DMS HTTP request has a null header name");
                }
                throw new HttpException(400);
            }
            curByte = HttpParser.skipSpace(curByte, instm);
            curByte = HttpParser.expect(curByte, instm, ':');
            curByte = HttpParser.skipSpace(curByte, instm);
            ByteArrayOutputStream headerBody = new ByteArrayOutputStream(128);
            curByte = ReadLine.parse822HeaderBody(curByte, instm, headerBody);
            String headerVal = headerBody.toString();
            if (headerVal.length() == 0) continue;
            if (Httpd.LOGGER.isLoggable(Level.FINE)) {
                Httpd.LOGGER.logp(Level.FINE, HttpParser.class.getName(), "parseHeaders", headerName + '=' + headerVal);
            }
            httpRequest.setHeader(headerName, headerVal);
        }
    }

    private static int parseQueryStrings(int curByte, HttpRequest httpRequest) throws IOException {
        InputStream instm = httpRequest.getInputStream();
        String log = "";
        while (httpRequest.getContentLength() > 0) {
            if (curByte == 38) {
                curByte = httpRequest.read();
                httpRequest.decreContentLength();
            } else if (curByte == 35) break;
            ByteArrayOutputStream nameBf = new ByteArrayOutputStream();
            curByte = HttpParser.decodeToken(curByte, httpRequest, nameBf, false);
            if (nameBf.size() == 0 || curByte == 35) break;
            curByte = HttpParser.expect(curByte, instm, '=');
            httpRequest.decreContentLength();
            ByteArrayOutputStream valueBf = new ByteArrayOutputStream();
            curByte = HttpParser.decodeToken(curByte, httpRequest, valueBf, true);
            if (valueBf.size() != 0) {
                String name = nameBf.toString().toLowerCase();
                ArrayList<String> valueVec = httpRequest.getParameters(name);
                if (valueVec == null) {
                    valueVec = new ArrayList();
                    httpRequest.setParameterValues(name, valueVec);
                }
                valueVec.add(valueBf.toString());
                if (Httpd.LOGGER.isLoggable(Level.FINEST)) {
                    log = log + '&' + nameBf.toString() + '=' + valueBf.toString();
                }
            } else if (Httpd.LOGGER.isLoggable(Level.FINEST)) {
                Httpd.LOGGER.logp(Level.FINEST, HttpParser.class.getName(), "parseQueryStrings", nameBf.toString() + '=' + valueBf.toString() + " has null query string name or value");
            }
            if (httpRequest.getContentLength() <= 0) continue;
            if (curByte == 32) break;
            if (curByte == 35 || curByte == 38) continue;
            if (Httpd.LOGGER.isLoggable(Level.FINE)) {
                Httpd.LOGGER.logp(Level.FINE, HttpParser.class.getName(), "parseQueryStrings", "DMS HTTP request has illegal char=" + (char)curByte + " in query string");
            }
            throw new HttpException(400);
        }
        if (Httpd.LOGGER.isLoggable(Level.FINEST)) {
            Httpd.LOGGER.logp(Level.FINEST, HttpParser.class.getName(), "parseQueryStrings", "querystrings: " + log);
        }
        return curByte;
    }

    private static int decodeToken(int curByte, HttpRequest httpRequest, ByteArrayOutputStream sb, boolean isValue) throws IOException {
        block9: while (true) {
            switch (curByte) {
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 34: 
                case 35: 
                case 38: 
                case 60: 
                case 62: {
                    break block9;
                }
                case 61: {
                    if (!isValue) break block9;
                    sb.write(curByte);
                    break;
                }
                case 43: {
                    sb.write(32);
                    break;
                }
                case 37: {
                    int decoded = HttpParser.urlDecodeHex(httpRequest);
                    switch (decoded) {
                        case 38: 
                        case 61: {
                            curByte = decoded;
                            continue block9;
                        }
                    }
                    sb.write(decoded);
                    break;
                }
                default: {
                    sb.write(curByte);
                }
            }
            httpRequest.decreContentLength();
            if (httpRequest.getContentLength() <= 0) break;
            curByte = httpRequest.read();
        }
        return curByte;
    }

    private static int expect(int curByte, InputStream instm, char expectedChar, int errCode) throws IOException {
        if (Character.toLowerCase((char)curByte) != expectedChar) {
            if (Httpd.LOGGER.isLoggable(Level.FINE)) {
                Httpd.LOGGER.logp(Level.FINE, HttpParser.class.getName(), "parseQueryStrings", "Character given " + (char)curByte + " is not the expected " + expectedChar);
            }
            throw new HttpException(errCode);
        }
        return instm.read();
    }

    private static int urlDecodeHex(HttpRequest httpRequest) throws IOException {
        int curByte;
        byte[] charBytes = new byte[2];
        if (httpRequest.getContentLength() <= 2 || (charBytes[0] = (byte)httpRequest.read()) == -1 || (charBytes[1] = (byte)httpRequest.read()) == -1) {
            throw new IOException();
        }
        httpRequest.decreContentLength();
        httpRequest.decreContentLength();
        String encoded = new String(charBytes, 0);
        try {
            curByte = Integer.parseInt(encoded, 16);
        }
        catch (NumberFormatException e) {
            if (Httpd.LOGGER.isLoggable(Level.FINE)) {
                Httpd.LOGGER.logp(Level.FINE, HttpParser.class.getName(), "parseQueryStrings", "Can not convert character while URL decoding: " + encoded);
            }
            throw new HttpException(400);
        }
        return curByte;
    }

    private static int expect(int curByte, InputStream instm, char expectedChar) throws IOException {
        return HttpParser.expect(curByte, instm, expectedChar, 400);
    }

    private HttpParser() {
    }
}

