/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import oracle.dms.http.Request;

public class DmsServletRequest
extends Request {
    private HttpServletRequest m_request = null;

    public DmsServletRequest(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(this.toString() + ": request=" + request);
        }
        this.m_request = request;
    }

    public String getMethod() {
        return this.m_request.getMethod();
    }

    public String getHeader(String name) {
        return this.m_request.getHeader(name);
    }

    public String getParameter(String name) {
        return this.m_request.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        return this.m_request.getParameterValues(name);
    }

    public String getRequestedSessionId() {
        return this.m_request.getRequestedSessionId();
    }

    public String getRequestURI() {
        String requestURI = this.m_request.getRequestURI();
        String pathInfo = this.m_request.getPathInfo();
        if (pathInfo != null && pathInfo.trim().length() > 0) {
            if (requestURI.endsWith(pathInfo)) {
                requestURI = requestURI.substring(0, requestURI.length() - pathInfo.length());
            } else {
                try {
                    String decoded = URLDecoder.decode(requestURI, "UTF-8").replace(' ', '+');
                    if (decoded.endsWith(pathInfo)) {
                        requestURI = decoded.substring(0, decoded.length() - pathInfo.length());
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return requestURI;
    }

    public String getServerName() {
        return this.m_request.getServerName();
    }

    public int getServerPort() {
        return this.m_request.getServerPort();
    }
}

