/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context;

public class RID {
    public static final char DELIM = ':';
    public static final RID ROOT = new RID();
    private static final String ROOT_STRING = "0";
    private static final int ROOT_HASH = "0".hashCode();
    private static int s_uniqueChild = 100000000;
    private RID m_parent = null;
    private int m_id = 0;
    private int m_kids = 0;
    private String m_stringID = null;
    private int m_hash = -1;
    private int m_depth = 1;
    private boolean m_hex = false;

    public RID() {
        this.m_stringID = ROOT_STRING;
        this.m_hash = ROOT_HASH;
    }

    private RID(RID parent) {
        this.m_parent = parent;
        this.m_id = parent.getKidCount();
        String s = Integer.toString(this.m_id);
        this.m_stringID = this.m_parent != null ? this.m_parent.toString() + ":" + s : s;
        this.m_hash = this.m_stringID.hashCode();
        this.m_depth = parent.depth() + 1;
    }

    private RID(String path, int id, int kids, boolean hex) {
        this.m_parent = null;
        this.m_id = id;
        this.m_stringID = path;
        this.m_kids = kids;
        this.m_hash = this.m_stringID.hashCode();
        this.m_hex = true;
        int idx = 0;
        int last = 0;
        int len = path.length();
        while (idx < len && (idx = path.indexOf(":", last)) >= 0) {
            ++this.m_depth;
            last = ++idx;
        }
    }

    public String toString() {
        return this.m_stringID;
    }

    public int depth() {
        return this.m_depth;
    }

    public synchronized int getKidCount() {
        return this.m_kids;
    }

    public synchronized RID createChildRID() {
        ++this.m_kids;
        return new RID(this);
    }

    public String getRID() {
        return this.toString();
    }

    public int getMyChildId() {
        return this.m_id;
    }

    public boolean equals(RID rid) {
        return this.m_hash == rid.hashCode();
    }

    public static RID createRID(String in) {
        boolean hex = false;
        if (in == null || in.charAt(0) != '0') {
            return null;
        }
        int len = in.length();
        if (len == 1) {
            return new RID();
        }
        int idx = -1;
        int kids = 0;
        String str = null;
        idx = in.indexOf(",");
        if (idx != -1) {
            if (idx + 1 > len - 1) {
                return null;
            }
            str = in.substring(idx + 1, len);
            try {
                kids = Integer.parseInt(str);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            if (kids < 0) {
                return null;
            }
        }
        int last = idx > 0 ? idx : len;
        idx = in.lastIndexOf(":");
        str = in.substring(idx + 1, last);
        String ridStr = in.substring(0, last);
        int myId = -1;
        try {
            myId = Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            try {
                String newStr = str.substring(3);
                myId = Integer.parseInt(newStr, 16);
                hex = true;
            }
            catch (IndexOutOfBoundsException ioobe) {
                ioobe.printStackTrace();
                return null;
            }
            catch (NumberFormatException nnfe) {
                nnfe.printStackTrace();
                return null;
            }
        }
        String start = in.substring(0, idx);
        if (!RID.isValidRID(start)) {
            return null;
        }
        return new RID(ridStr, myId, kids, hex);
    }

    private static boolean isValidRID(String in) {
        if (in == null || in.charAt(0) != '0') {
            return false;
        }
        int len = in.length();
        if (len == 1) {
            return true;
        }
        if (in.charAt(1) != ':') {
            return false;
        }
        int next = 1;
        int last = 2;
        String chunk = null;
        while (next > 0) {
            next = in.indexOf(":", last);
            chunk = next > 0 ? in.substring(last, next) : in.substring(last);
            try {
                int val = Integer.parseInt(chunk);
            }
            catch (NumberFormatException nfe) {
                try {
                    String nchunk = chunk.substring(3);
                    int val = Integer.parseInt(nchunk, 16);
                }
                catch (Exception e) {
                    return false;
                }
            }
            last = next + 1;
        }
        return true;
    }

    public int hashCode() {
        return this.m_hash;
    }

    public boolean descendsFrom(RID rid) {
        if (this.m_depth <= rid.depth()) {
            return false;
        }
        return this.m_stringID.startsWith(rid.toString());
    }

    private static synchronized int getUniqueId() {
        return s_uniqueChild++;
    }

    static String getUniqueHexChild() {
        int id = RID.getUniqueId();
        return "0x0" + Integer.toHexString(id);
    }
}

