/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.context.ContextCleaner;
import oracle.dms.context.ContextFamily;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.InheritedContext;
import oracle.dms.context.RID;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.util.DMSProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMSContextManager {
    private static InheritableThreadLocal<ExecutionContext> s_tlocal = new InheritedContext<ExecutionContext>();
    private static final Object s_initLock = new Object();
    private static final Object s_familyLock = new Object();
    private static HashMap<String, ContextFamily> s_familyMap = new HashMap();
    private static ConcurrentHashMap<Thread, ExecutionContext> s_threadCtxMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<Object, ExecutionContext> s_ctxStashMap = new ConcurrentHashMap();
    static HashSet<String> s_logKeys = new HashSet();
    static HashSet<String> s_propagateKeys = new HashSet();
    public static final String URI = "uri";
    public static final String SPC = "wlmPC";
    public static final String WRC = "wlmWRC";
    public static final String SQLTRACE = "sqltrace";
    public static final String TRACE = "dmsTrace";
    public static final String ACTION = "Action";
    public static final String MODULE = "Module";
    public static final String CLIENTID = "client_identifier";
    static int s_maxBytes;
    private static boolean s_initialized;
    private static boolean s_done;
    public static final int DEFAULT_MIN_LIFE = 0;
    private static int s_minLife;
    public static final int MIN_LIFE = 0;
    public static final int MAX_LIFE = 900;
    public static final long CLEANER_SLEEP_SECONDS = 300L;
    private static long s_cleanerSleepMillis;
    public static final int MAX_STASH_MINUTES = 1440;
    private static int s_maxStashMillis;
    public static final int LOG = 1;
    public static final int PROPAGATE = 2;
    public static final String LOGGER_NAME = "oracle.dms.context";
    private static Logger s_logger;
    private static int s_levels;
    private static ContextCleaner s_cleaner;
    private static Noun s_noun;
    private static PhaseEvent s_cleanerPE;
    private static Event s_cleanedEvent;
    private static Event s_notCleanedEvent;

    private DMSContextManager() {
    }

    public static void init() {
        DMSContextManager.init(null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean init(String[] params, int maxBytes) {
        Object object = s_initLock;
        synchronized (object) {
            String rotate;
            if (s_initialized) {
                return false;
            }
            if (maxBytes >= 0) {
                s_maxBytes = maxBytes;
            }
            s_done = false;
            s_cleaner = new ContextCleaner();
            s_cleaner.start();
            s_initialized = true;
            s_logger.log(Level.FINE, "CTX-00016");
            String encode = DMSProperties.getProperty("oracle.dms.context.encode");
            if (encode != null && encode.equalsIgnoreCase("false")) {
                ExecutionContext.setEncode(false);
            }
            if ((rotate = DMSProperties.getProperty("oracle.dms.context.rotate")) != null && rotate.equalsIgnoreCase("false")) {
                ExecutionContext.setRotate(false);
            }
            return true;
        }
    }

    public static boolean init(String[] params, int maxBytes, int minLife) {
        if (s_initialized) {
            return false;
        }
        DMSContextManager.init(params, maxBytes);
        DMSContextManager.setMinLife(minLife);
        return true;
    }

    private static ExecutionContext createExecutionContext() {
        ContextFamily ctf = ContextFamily.create();
        if (ctf == null) {
            s_logger.log(Level.WARNING, "CTX-00011");
            return null;
        }
        ExecutionContext ctx = ctf.getExecutionContext(RID.ROOT);
        return ctx;
    }

    public static ExecutionContext getContext() {
        ExecutionContext ctx;
        if (!s_initialized) {
            DMSContextManager.init(null, 0);
        }
        if ((ctx = (ExecutionContext)s_tlocal.get()) == null) {
            ctx = DMSContextManager.createExecutionContext();
        }
        if (ctx == null) {
            s_logger.log(Level.WARNING, "CTX-00013");
            return null;
        }
        if (!ctx.isActive()) {
            ctx.activate();
        }
        return ctx;
    }

    public static int getNewKidCount(String ecid) {
        if (ecid == null) {
            s_logger.log(Level.FINE, "CTX-00032");
            return 0;
        }
        ContextFamily ctf = DMSContextManager.getFamily(ecid);
        if (ctf == null) {
            s_logger.log(Level.FINE, "CTX-00031", ecid);
            return 0;
        }
        return ctf.getNewKids();
    }

    public static HashMap<String, ExecutionContext> getContexts(String ecid) {
        if (ecid == null) {
            s_logger.log(Level.FINE, "CTX-00032");
            return null;
        }
        ContextFamily ctf = DMSContextManager.getFamily(ecid);
        if (ctf == null) {
            s_logger.log(Level.FINE, "CTX-00031", ecid);
            return null;
        }
        return ctf.getContexts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getEcids() {
        Set<String> keys = null;
        Object object = s_familyLock;
        synchronized (object) {
            keys = s_familyMap.keySet();
            String[] ecids = new String[keys.size()];
            return keys.toArray(ecids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ContextFamily getFamily(String ecid) {
        Object object = s_familyLock;
        synchronized (object) {
            return s_familyMap.get(ecid);
        }
    }

    static boolean setContext(ExecutionContext ctx) {
        ExecutionContext octx = (ExecutionContext)s_tlocal.get();
        if (octx != null && octx != ctx) {
            if (s_logger.isLoggable(Level.FINE)) {
                Object[] msg = new String[]{octx.toString(), ctx.toString()};
                s_logger.log(Level.FINE, "CTX-00008", msg);
            }
            octx.deactivate();
        }
        s_tlocal.set(ctx);
        DMSContextManager.registerThreadContext(ctx);
        return true;
    }

    static boolean unsetContext(ExecutionContext ctx) {
        ExecutionContext octx = (ExecutionContext)s_tlocal.get();
        if (octx != null && octx != ctx) {
            Object[] msg = new String[]{ctx.toString(), octx.toString()};
            s_logger.log(Level.WARNING, "CTX-00002", msg);
            return false;
        }
        if (octx == ctx) {
            DMSContextManager.deregisterThreadContext(ctx);
            s_tlocal.remove();
            return true;
        }
        return false;
    }

    public static boolean logContext(String ecid, long rid) {
        return DMSContextManager.isInitialized();
    }

    public static boolean logContext(String ecid, String ridStr) {
        return DMSContextManager.isInitialized();
    }

    static void incrementLevels() {
        ++s_levels;
    }

    static void decrementLevels() {
        --s_levels;
    }

    public static int getLogLevelCount() {
        return s_levels;
    }

    public static boolean hasContext() {
        return s_tlocal.get() != null;
    }

    public static ExecutionContext getContext(String ecid, RID rid) {
        if (ecid == null || rid == null) {
            return null;
        }
        ContextFamily ctf = DMSContextManager.getFamily(ecid);
        if (ctf != null) {
            return ctf.getExecutionContext(rid);
        }
        return null;
    }

    public static ExecutionContext getContext(String ecid, String ridStr) {
        if (ecid == null || ridStr == null) {
            return null;
        }
        ContextFamily ctf = DMSContextManager.getFamily(ecid);
        if (ctf != null) {
            return ctf.getExecutionContext(ridStr);
        }
        return null;
    }

    public static int getActiveCount(String ecid) {
        ContextFamily ctf = DMSContextManager.getFamily(ecid);
        if (ctf != null) {
            return ctf.getActive();
        }
        return 0;
    }

    public static int getContextCount(String ecid) {
        ContextFamily ctf = DMSContextManager.getFamily(ecid);
        if (ctf != null) {
            return ctf.getCount();
        }
        return 0;
    }

    public static int getMinLife() {
        return s_minLife;
    }

    public static int setMinLife(int seconds) {
        s_minLife = seconds < 0 ? 0 : (seconds > 900 ? 900 : seconds);
        return s_minLife;
    }

    public static void setMaxStashMinutes(int minutes) {
        if (minutes < 0) {
            s_maxStashMillis = 86400000;
            return;
        }
        s_maxStashMillis = minutes * 60 * 1000;
    }

    public static long getMaxStashMillis() {
        return s_maxStashMillis;
    }

    public static void setCleanerSleepSecs(long seconds) {
        if (!s_initialized) {
            DMSContextManager.init(null, 0);
        }
        if (seconds < 0L) {
            s_cleanerSleepMillis = 300000L;
            return;
        }
        s_cleanerSleepMillis = seconds * 1000L;
        s_cleaner.interrupt();
        s_cleaner = new ContextCleaner();
        s_cleaner.start();
    }

    public static long getCleanerSleepMillis() {
        return s_cleanerSleepMillis;
    }

    public static Object getValue(String ecid, RID rid, String key) {
        ExecutionContext ctx = DMSContextManager.getContext(ecid, rid);
        if (ctx == null) {
            return null;
        }
        return ctx.getValue(key);
    }

    public static Object getValue(String ecid, String ridStr, String key) {
        ExecutionContext ctx = DMSContextManager.getContext(ecid, ridStr);
        if (ctx == null) {
            return null;
        }
        return ctx.getValue(key);
    }

    public static Object getValue(String ecid, long rid, String key) {
        return null;
    }

    public static int getMaxBytes() {
        return s_maxBytes;
    }

    private static boolean registerThreadContext(ExecutionContext ctx) {
        if (ctx == null) {
            return false;
        }
        s_threadCtxMap.put(Thread.currentThread(), ctx);
        return true;
    }

    private static boolean deregisterThreadContext(ExecutionContext ctx) {
        ExecutionContext octx = s_threadCtxMap.remove(Thread.currentThread());
        if (octx != null && octx != ctx) {
            Object[] msg = new String[]{ctx.toString(), octx.toString()};
            s_logger.log(Level.WARNING, "CTX-00002", msg);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean registerFamily(ContextFamily ctf) {
        String ecid = null;
        if (ctf == null || (ecid = ctf.getECID()) == null) {
            return false;
        }
        Object object = s_familyLock;
        synchronized (object) {
            if (s_familyMap.get(ecid) != null) {
                return false;
            }
            s_familyMap.put(ecid, ctf);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregisterFamily(ContextFamily ctf) {
        if (ctf == null) {
            s_logger.log(Level.WARNING, "CTX-00004");
            return;
        }
        String ecid = ctf.getECID();
        if (ecid == null) {
            s_logger.log(Level.WARNING, "CTX-00018");
            return;
        }
        ctf.setLogLevel(null);
        Object object = s_familyLock;
        synchronized (object) {
            ContextFamily contextFamily = s_familyMap.remove(ecid);
        }
    }

    static void stash(Object obj, ExecutionContext ctx) {
        if (obj == null) {
            s_logger.log(Level.WARNING, "CTX-00020");
            return;
        }
        if (ctx == null) {
            s_logger.log(Level.WARNING, "CTX-00021");
            return;
        }
        s_ctxStashMap.put(obj, ctx);
    }

    static ExecutionContext get(Object obj) {
        ExecutionContext ctx = null;
        if (obj != null) {
            ctx = s_ctxStashMap.remove(obj);
        }
        return ctx;
    }

    static int removeFromStash(String ecid, int count) {
        if (count <= 0) {
            return count;
        }
        if (ecid == null) {
            return 0;
        }
        int succeed = 0;
        Collection<ExecutionContext> values = s_ctxStashMap.values();
        for (ExecutionContext ctx : values) {
            if (count == 0) {
                return succeed;
            }
            if (!ecid.equals(ctx.getECID())) continue;
            values.remove(ctx);
            --count;
            ++succeed;
        }
        return succeed;
    }

    public static boolean isInitialized() {
        return s_initialized;
    }

    static Logger getLogger() {
        return s_logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanup() {
        DMSContextManager.getLogger().log(Level.FINEST, "CTX-00033");
        long token = 0L;
        try {
            token = s_cleanerPE.start();
            Object object = s_familyLock;
            synchronized (object) {
                String[] keys;
                Set<String> keySet = s_familyMap.keySet();
                for (String ecid : keys = keySet.toArray(new String[0])) {
                    ContextFamily ctf = s_familyMap.get(ecid);
                    if (ctf == null) {
                        DMSContextManager.getLogger().log(Level.WARNING, "CTX-00029", ecid);
                        continue;
                    }
                    if (ctf.isExpired()) {
                        DMSContextManager.deregisterFamily(ctf);
                        s_cleanedEvent.occurred();
                        continue;
                    }
                    s_notCleanedEvent.occurred();
                }
            }
        }
        finally {
            s_cleanerPE.stop(token);
        }
    }

    static boolean isDone() {
        return s_done;
    }

    public static void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setKeyAttribute(String key, int attribute) {
        if (key == null) {
            return;
        }
        if (attribute == 1) {
            HashSet<String> hashSet = s_logKeys;
            synchronized (hashSet) {
                s_logKeys.add(key);
            }
        }
        if (attribute == 2) {
            HashSet<String> hashSet = s_propagateKeys;
            synchronized (hashSet) {
                s_propagateKeys.add(key.intern());
            }
        }
    }

    static {
        s_propagateKeys.add(URI);
        s_propagateKeys.add(SPC);
        s_propagateKeys.add(WRC);
        s_propagateKeys.add(SQLTRACE);
        s_propagateKeys.add(TRACE);
        s_propagateKeys.add(ACTION);
        s_propagateKeys.add(MODULE);
        s_propagateKeys.add(CLIENTID);
        s_maxBytes = 0;
        s_initialized = false;
        s_done = false;
        s_minLife = 0;
        s_cleanerSleepMillis = 300000L;
        s_maxStashMillis = 86400000;
        s_logger = Logger.getLogger(LOGGER_NAME, "oracle.dms.context.ContextResourceBundle");
        s_levels = 0;
        s_cleaner = null;
        s_noun = Noun.create("/DMS-Internal/ContextManager", "ContextManager");
        s_cleanerPE = PhaseEvent.create(s_noun, "cleanup", "duration of cleanup");
        s_cleanedEvent = Event.create(s_noun, "cleaned", "Number removed by cleaner thread");
        s_notCleanedEvent = Event.create(s_noun, "notCleaned", "Number skipped by cleaner thread");
        s_cleanerPE.deriveMetric(511);
    }
}

