/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.clock;

import java.io.PrintStream;
import oracle.dms.clock.Clock;
import oracle.dms.clock.ClockDescription;
import oracle.dms.clock.SimpleClockDescription;
import oracle.dms.clock.SimpleTimestamp;
import oracle.dms.clock.Timestamp;

public class SimpleClock
implements Clock {
    protected String _name;
    protected ClockDescription _desc;
    protected String _units;
    protected long _maxFrequency;
    protected long _reportedFrequency;

    public SimpleClock() {
        this._name = "default";
        this._desc = new SimpleClockDescription();
        this._reportedFrequency = 1000L;
        this._maxFrequency = 1000L;
        this._units = "msecs";
        this.start();
    }

    SimpleClock(String name) {
        this._name = name;
    }

    final void start() {
        this._desc.discover(this);
        this.reset();
    }

    public void reset() {
    }

    public long getTime() {
        return System.currentTimeMillis();
    }

    public Timestamp getTimestamp() {
        return new SimpleTimestamp(this.getTime(), this);
    }

    public String toString() {
        return this.getTimestamp().toString();
    }

    public long convertTime(long time, long resolution) {
        if (resolution > this._reportedFrequency) {
            long fact = resolution / this._reportedFrequency;
            return time * fact;
        }
        if (resolution < this._reportedFrequency) {
            long fact = this._reportedFrequency / resolution;
            return time / fact;
        }
        return time;
    }

    public ClockDescription getDescription() {
        return this._desc;
    }

    public String getName() {
        return this._name;
    }

    public String getUnits() {
        return this._units;
    }

    public long getReportedFrequency() {
        return this._reportedFrequency;
    }

    public long getMaxFrequency() {
        return this._maxFrequency;
    }

    public long getMeasuredFrequency() {
        return this._desc.getMeasuredFrequency();
    }

    public double getOverhead() {
        return this._desc.getOverhead();
    }

    public void print(PrintStream out) {
        out.println("Clock: " + this._name);
        out.println("    units: " + this.getUnits());
        out.println("    reportedFrequency: " + this.getReportedFrequency() + " ticks per second");
        out.println("    maxFrequency: " + this.getMaxFrequency() + " ticks per second");
        out.println("    measuredFrequency: " + this.getMeasuredFrequency() + " ticks per second");
        out.println("    measuredResolution: " + this._desc.getResolution() + " " + this.getUnits() + " is the minimum nonzero time between calls");
        out.println("    overhead per call: " + this.getOverhead() + " " + this.getUnits());
    }
}

