/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.clock;

import oracle.dms.clock.ClockManager;
import oracle.dms.clock.SimpleClock;
import oracle.dms.clock.SimpleClockDescription;

public class HighResolutionClock
extends SimpleClock {
    private double _adjustment = 1.0;

    public HighResolutionClock() {
        this("highres");
        this._desc = new SimpleClockDescription();
        this._reportedFrequency = this.getHRReportedFrequency();
        this._maxFrequency = this.getHRFrequency();
        this._units = ClockManager.getUnits(this._reportedFrequency);
        this._adjustment = (double)this._reportedFrequency / (double)this._maxFrequency;
        this.start();
    }

    private HighResolutionClock(String name) {
        super(name);
    }

    public long getTime() {
        long hrtime = this.getHighResTime();
        long time = (long)((double)hrtime * this._adjustment);
        return time;
    }

    public native long getHighResTime();

    public native long getHRFrequency();

    public native long getHRReportedFrequency();

    static {
        try {
            System.loadLibrary("dms2");
        }
        catch (Throwable e) {
            try {
                System.loadLibrary("yod");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

