/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.incident;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorMessage
implements Serializable {
    private String m_errorFacility;
    private String m_errorNumber;
    private List<String> m_errorArgs;
    private static final char FACILITY_BREAK = '-';

    private ErrorMessage(String errorFacility, String errorNumber) {
        this.m_errorFacility = errorFacility;
        this.m_errorNumber = errorNumber;
    }

    public static ErrorMessage getErrorMessage(String errorFacility, String errorNumber) {
        if (errorNumber == null || errorNumber.length() == 0) {
            throw new IllegalArgumentException("errorNumber=" + errorNumber);
        }
        return new ErrorMessage(errorFacility, errorNumber);
    }

    public static ErrorMessage getErrorMessage(String errorString) {
        if (errorString == null || errorString.length() == 0) {
            throw new IllegalArgumentException("errorString=" + errorString);
        }
        int pos = errorString.indexOf(45);
        String errorFacility = null;
        String errorNumber = errorString;
        if (pos > 0 && errorString.length() > pos + 1) {
            errorFacility = errorString.substring(0, pos);
            errorNumber = errorString.substring(pos + 1, errorString.length());
        }
        return ErrorMessage.getErrorMessage(errorFacility, errorNumber);
    }

    public String getErrorFacility() {
        return this.m_errorFacility;
    }

    public String getErrorNumber() {
        return this.m_errorNumber;
    }

    public String getErrorFacilityAndNumber() {
        String fullMsg = this.m_errorFacility;
        if (fullMsg != null) {
            fullMsg = fullMsg + '-';
        }
        fullMsg = fullMsg + this.m_errorNumber;
        return fullMsg;
    }

    public List<String> getErrorArguments() {
        if (this.m_errorArgs != null) {
            return this.m_errorArgs;
        }
        return Collections.emptyList();
    }

    public void setErrorArguments(List<String> arguments) {
        this.m_errorArgs = arguments;
    }

    public String toString() {
        StringBuilder val = new StringBuilder();
        if (this.m_errorFacility != null) {
            val.append(this.m_errorFacility);
            val.append('-');
        }
        val.append(this.m_errorNumber);
        if (this.m_errorArgs != null) {
            for (String value : this.m_errorArgs) {
                val.append(" [");
                val.append(value);
                val.append(']');
            }
        }
        return val.toString();
    }
}

