/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.dfw.common.ArgumentMap;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.impl.incident.DateFormat;
import oracle.dfw.incident.Incident;
import oracle.dfw.incident.IncidentDump;
import org.w3c.dom.Element;

public class IncidentDumpImpl
implements IncidentDump,
Serializable {
    private String m_dumpId;
    private String m_dumpName;
    private Map<String, String> m_dumpArguments;
    private long m_dumpTime;
    private String m_dumpPath;
    private String m_externalDumpPath;
    private String m_oracleInstanceId;
    private String m_topologyPath;
    private String m_dumpArgsString;
    private String m_dumpFileExtension;
    private Incident.IncidentSource m_dumpSource;
    private ArgumentMap m_dumpArgs;

    public IncidentDumpImpl(DumpResult dump, Incident.IncidentSource source) {
        this.m_dumpId = dump.getDumpId();
        this.m_dumpName = dump.getDumpContext().getDumpName();
        this.m_dumpFileExtension = dump.getDumpFileExtension();
        this.m_oracleInstanceId = dump.getProcessDpsId();
        this.m_dumpPath = dump.getDumpLocation();
        this.m_externalDumpPath = dump.getExternalDumpLocation();
        this.m_dumpSource = source;
        this.m_dumpTime = System.currentTimeMillis();
        this.m_topologyPath = dump.getDumpContext().getTopologyNodeCanonicalPath();
        this.m_dumpArgs = dump.getDumpContext().getArguments();
        if (this.m_dumpArgs != null && this.m_dumpArgs.size() > 0) {
            StringBuilder argBuf = new StringBuilder();
            Enumeration<String> args = this.m_dumpArgs.enumerateKeys();
            while (args.hasMoreElements()) {
                String argName = args.nextElement();
                if (argBuf.length() > 0) {
                    argBuf.append(", ");
                }
                argBuf.append(argName);
                argBuf.append("=");
                argBuf.append(this.m_dumpArgs.getString(argName));
            }
            if (argBuf.length() > 0) {
                this.m_dumpArgsString = argBuf.toString();
            }
        }
    }

    IncidentDumpImpl(Element dump) throws Exception {
        this.m_dumpId = dump.getAttribute("id");
        this.m_dumpName = dump.getAttribute("name");
        this.m_dumpPath = dump.getAttribute("dumpPath");
        this.m_dumpFileExtension = dump.getAttribute("dumpFileExtension");
        this.m_externalDumpPath = dump.getAttribute("externalDumpPath");
        this.m_oracleInstanceId = dump.getAttribute("instanceDPSID");
        this.m_topologyPath = dump.getAttribute("tn");
        this.m_dumpArgsString = dump.getAttribute("arguments");
        this.m_dumpSource = Incident.IncidentSource.getIncidentSource(dump.getAttribute("source"));
        String incidentTime = dump.getAttribute("dateCreated");
        DatatypeFactory factory = DatatypeFactory.newInstance();
        XMLGregorianCalendar cal = factory.newXMLGregorianCalendar(incidentTime);
        this.m_dumpTime = cal.toGregorianCalendar().getTime().getTime();
    }

    public String getDumpId() {
        return this.m_dumpId;
    }

    public String getDumpName() {
        return this.m_dumpName;
    }

    public String getDumpArguments() {
        return this.m_dumpArgsString;
    }

    public long getTimeOfDump() {
        return this.m_dumpTime;
    }

    public String getDumpPath() {
        return this.m_dumpPath;
    }

    public String getExternalDumpPath() {
        return this.m_externalDumpPath;
    }

    public String getOracleInstanceId() {
        return this.m_oracleInstanceId;
    }

    public Incident.IncidentSource getDumpSource() {
        return this.m_dumpSource;
    }

    public String getTopologyNodePath() {
        return this.m_topologyPath;
    }

    public String getDumpFileExtension() {
        return this.m_dumpFileExtension;
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<diagnosticDump id=\"");
        buf.append(this.m_dumpId);
        buf.append("\" name=\"");
        buf.append(this.m_dumpName);
        buf.append("\" dateCreated=\"");
        new DateFormat().format(this.m_dumpTime, buf);
        buf.append("\" instanceDPSID=\"");
        buf.append(this.m_oracleInstanceId);
        buf.append("\" dumpPath=\"");
        buf.append(this.m_dumpPath);
        buf.append("\" source=\"");
        buf.append((Object)this.m_dumpSource);
        buf.append("\" dumpFileExtension=\"");
        buf.append(this.m_dumpFileExtension);
        if (this.m_externalDumpPath != null) {
            buf.append("\" externalDumpPath=\"");
            buf.append(this.m_externalDumpPath);
        }
        if (this.m_topologyPath != null) {
            buf.append("\" tn=\"");
            buf.append(this.m_topologyPath);
        }
        if (this.m_dumpArgs != null && this.m_dumpArgs.size() > 0) {
            StringBuilder argBuf = new StringBuilder();
            Enumeration<String> args = this.m_dumpArgs.enumerateKeys();
            while (args.hasMoreElements()) {
                String argName = args.nextElement();
                if (argBuf.length() > 0) {
                    argBuf.append(", ");
                }
                argBuf.append(argName);
                argBuf.append("=");
                argBuf.append(this.m_dumpArgs.getString(argName));
            }
            if (argBuf.length() > 0) {
                buf.append("\" arguments=\"");
                buf.append(argBuf.toString());
            }
        }
        buf.append("\"/>\n");
        return buf.toString();
    }
}

