/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dfw.common.AdvancedTopologyInfo;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.dump.DumpCatalog;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpDescriptor;
import oracle.dfw.impl.incident.DiagnosticRules;
import oracle.dfw.impl.incident.DumpAction;
import oracle.dfw.impl.incident.IncidentActionsImpl;
import oracle.dfw.impl.incident.RuleActions;
import oracle.dfw.impl.incident.TopologyNodeType;
import oracle.dfw.incident.DiagnosticRulesManager;
import oracle.dfw.incident.IncidentActions;
import oracle.dfw.incident.IncidentFacts;
import oracle.dfw.incident.IncidentRulesException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticRulesManagerImpl
implements DiagnosticRulesManager {
    private HashMap<String, DiagnosticRules> m_rules = new HashMap();
    private boolean m_shutdown;
    private Logger m_logger = LoggerFactory.getFrameworkLogger();
    private DumpCatalog m_catalog;
    private AdvancedTopologyInfo m_topoInfo;

    public DiagnosticRulesManagerImpl(AdvancedTopologyInfo topoInfo, DumpCatalog catalog) {
        this.m_topoInfo = topoInfo;
        this.m_catalog = catalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRules(Reader rules, String tnId) throws IncidentRulesException {
        if (this.m_shutdown) {
            return;
        }
        if (rules == null || tnId == null || tnId.length() == 0) {
            throw new IllegalArgumentException("Invalid arguments rules= " + rules + " tnID=" + tnId);
        }
        this.m_logger.log(Level.INFO, "MAS-40371", tnId);
        DiagnosticRules diagRules = DiagnosticRules.createRules(rules);
        if (diagRules != null) {
            HashMap<String, DiagnosticRules> hashMap = this.m_rules;
            synchronized (hashMap) {
                this.m_rules.put(tnId, diagRules);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterRules(String tnId) {
        if (this.m_shutdown) {
            return;
        }
        this.m_logger.log(Level.INFO, "MAS-40372", tnId);
        if (this.m_rules.containsKey(tnId)) {
            HashMap<String, DiagnosticRules> hashMap = this.m_rules;
            synchronized (hashMap) {
                if (this.m_rules.containsKey(tnId)) {
                    this.m_rules.remove(tnId);
                }
            }
        }
    }

    public IncidentActions evaluateRules(IncidentFacts facts) throws IncidentRulesException {
        if (this.m_shutdown) {
            return null;
        }
        IncidentActionsImpl actions = new IncidentActionsImpl();
        this.evaluateDefaultActions(facts, actions);
        return actions;
    }

    private void evaluateDefaultActions(IncidentFacts facts, IncidentActionsImpl actions) throws IncidentRulesException {
        HashSet<String> topoNodes = new HashSet<String>();
        if (facts.getIncidentFactPropertyValues(IncidentFacts.IncidentFactProperty.TOPOLOGY_NODE_ID_PROP) != null) {
            topoNodes.addAll(facts.getIncidentFactPropertyValues(IncidentFacts.IncidentFactProperty.TOPOLOGY_NODE_ID_PROP));
        }
        if (topoNodes.size() == 0) {
            if (this.m_topoInfo.getFarmId() != null) {
                topoNodes.add(this.m_topoInfo.getFarmId());
            }
            if (this.m_topoInfo.getFarmRootId() != null) {
                topoNodes.add(this.m_topoInfo.getFarmRootId());
            }
        }
        HashSet<String> uniqueNodes = new HashSet<String>();
        for (String tn : topoNodes) {
            uniqueNodes.add(tn);
            List<String> relatedIds = this.m_topoInfo.getRelatedIds(tn);
            if (relatedIds == null) continue;
            uniqueNodes.addAll(relatedIds);
        }
        this.addDefaultActions(uniqueNodes, facts, actions);
    }

    private void addDefaultActions(HashSet<String> topoNodes, IncidentFacts facts, IncidentActionsImpl actions) {
        for (String topoNode : topoNodes) {
            DiagnosticRules rules = this.m_rules.get(topoNode);
            if (rules == null) continue;
            RuleActions defActions = rules.getDefaultActions();
            for (DumpAction dumpAction : defActions.getDumpActions()) {
                if (dumpAction.getTopologyNodeType().equals((Object)TopologyNodeType.APPLICABLE)) {
                    for (String applicableNode : topoNodes) {
                        this.createDumpContext(dumpAction, facts, applicableNode, actions);
                    }
                    continue;
                }
                if (dumpAction.getTopologyNodeType() == null) continue;
                String topoNodeId = null;
                switch (dumpAction.getTopologyNodeType()) {
                    case THIS: {
                        topoNodeId = topoNode;
                        break;
                    }
                    case INSTANCE: {
                        topoNodeId = this.m_topoInfo.getInstanceId(topoNode);
                        break;
                    }
                    case FARM: {
                        topoNodeId = this.m_topoInfo.getFarmId();
                        break;
                    }
                    case FARMROOT: {
                        topoNodeId = this.m_topoInfo.getFarmRootId();
                        break;
                    }
                }
                if (topoNodeId == null) continue;
                this.createDumpContext(dumpAction, facts, topoNodeId, actions);
            }
        }
    }

    private void createDumpContext(DumpAction action, IncidentFacts facts, String topoNodeId, IncidentActionsImpl actions) {
        String topoCanonicalPath = null;
        if (topoNodeId != null) {
            topoCanonicalPath = this.m_topoInfo.getCanonicalPath(topoNodeId);
        }
        DumpDescriptor desc = this.m_catalog.getDumpDescriptor(action.getDumpName());
        boolean isActionResolved = true;
        if (desc == null || topoCanonicalPath != null && !this.m_catalog.getDumpDescriptorsByNode(topoCanonicalPath).contains(desc)) {
            isActionResolved = false;
        }
        HashMap<String, String> args = new HashMap<String, String>();
        for (Map.Entry<String, String> arg : action.getFactBasedArguments().entrySet()) {
            String name = arg.getKey();
            String value = arg.getValue();
            List<String> factValues = this.getFactBasedArg(value, facts);
            if (factValues != null && factValues.size() > 0) {
                args.put(name, factValues.get(0));
                continue;
            }
            this.m_logger.log(Level.FINER, "Value for fact based argument " + name + " not found.");
            return;
        }
        args.putAll(action.getLiteralBasedArguments());
        DumpContext ctx = DumpContext.createDumpContext(action.getDumpName());
        for (Map.Entry dumpArg : args.entrySet()) {
            ctx.addArgument((String)dumpArg.getKey(), (Serializable)dumpArg.getValue());
        }
        if (topoCanonicalPath != null) {
            ctx.setTopologyNode(topoCanonicalPath);
        }
        actions.addDumpContext(ctx, isActionResolved);
    }

    private List<String> getFactBasedArg(String factName, IncidentFacts facts) {
        IncidentFacts.IncidentFactKeyword keyword = IncidentFacts.IncidentFactKeyword.getIncidentFactKeyword(factName);
        if (keyword != null) {
            ArrayList<String> args = new ArrayList<String>();
            switch (keyword) {
                case ECID: {
                    this.addArgIfNotNull(facts.getExecutionContextId(), args);
                    break;
                }
                case INCIDENT_TIME: {
                    this.addArgIfNotNull(String.valueOf(facts.getIncidentTime()), args);
                    break;
                }
            }
            IncidentFacts.IncidentFactProperty prop = IncidentFacts.IncidentFactProperty.getProperty(keyword);
            if (prop != null) {
                args.addAll(facts.getIncidentFactPropertyValues(prop));
            }
            return args;
        }
        return null;
    }

    private void addArgIfNotNull(String value, ArrayList<String> args) {
        if (value != null) {
            args.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.m_shutdown) {
            return;
        }
        DiagnosticRulesManagerImpl diagnosticRulesManagerImpl = this;
        synchronized (diagnosticRulesManagerImpl) {
            if (this.m_shutdown) {
                return;
            }
            this.m_shutdown = true;
        }
    }
}

