/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.dump;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import oracle.as.management.translation.NLSupport;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriter;
import oracle.dfw.resource.DiagnosticTranslation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadDump
extends ComponentDiagnosticDump {
    private String m_description;
    private static final String DFW_MESSAGES = DiagnosticTranslation.class.getName();
    private static ThreadMXBean s_bean = ManagementFactory.getThreadMXBean();
    private static String INDENT = "    ";

    public ThreadDump() {
        NLSupport nls = NLSupport.getNLSupport(DFW_MESSAGES, this.getClass().getClassLoader());
        this.m_description = nls.getTranslation("DFW_THREADS_DESCRIPTION");
    }

    @Override
    public DumpResult executeDump(DumpContext context) throws DumpExecutionException {
        DumpWriter dw = new DumpWriter(context);
        ThreadDump.dumpThreadStats(dw);
        return dw.getDumpResult();
    }

    public static void dumpThreadStats(DumpWriter dw) {
        long[] tids;
        dw.dumpln("Thread Statistics\n");
        dw.dumpln("Live threads: " + s_bean.getThreadCount());
        dw.dumpln("Started threads: " + s_bean.getTotalStartedThreadCount());
        dw.dumpln("Peak live threads: " + s_bean.getPeakThreadCount());
        dw.dumpln("Daemon threads: " + s_bean.getDaemonThreadCount());
        long[] deadlocktids = ThreadDump.getDeadLockedThreads();
        if (deadlocktids != null) {
            dw.dumpln("Deadlocked threads (ids): " + deadlocktids.length + " (");
            boolean first = true;
            for (long id : deadlocktids) {
                dw.dumpln((first ? "" : ",") + id);
                first = false;
            }
            dw.dumpln(")");
        }
        dw.dumpln("\nFull Thread Dump\n");
        for (long ti : tids = ThreadDump.getThreadIds()) {
            ThreadInfo tinfo = ThreadDump.getThreadInfo(ti);
            if (tinfo == null) continue;
            ThreadDump.dumpThreadInfo(tinfo, dw);
        }
    }

    private static long[] getDeadLockedThreads() {
        long[] tids = null;
        tids = AccessController.doPrivileged(new PrivilegedAction<long[]>(){

            @Override
            public long[] run() {
                return s_bean.findMonitorDeadlockedThreads();
            }
        });
        return tids;
    }

    private static long[] getThreadIds() {
        long[] ids = new long[]{};
        ids = AccessController.doPrivileged(new PrivilegedAction<long[]>(){

            @Override
            public long[] run() {
                return s_bean.getAllThreadIds();
            }
        });
        return ids;
    }

    private static ThreadInfo getThreadInfo(final long id) {
        ThreadInfo info = null;
        info = AccessController.doPrivileged(new PrivilegedAction<ThreadInfo>(){

            @Override
            public ThreadInfo run() {
                return s_bean.getThreadInfo(id, Integer.MAX_VALUE);
            }
        });
        return info;
    }

    private static void dumpThreadInfo(ThreadInfo ti, DumpWriter dw) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append(ti.getThreadName());
        sb.append("\"");
        sb.append(" id=");
        sb.append(ti.getThreadId());
        sb.append(" ");
        sb.append((Object)ti.getThreadState());
        if (ti.getLockName() != null) {
            sb.append(" on lock=" + ti.getLockName());
        }
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (running in native)");
        }
        dw.dumpln(sb.toString());
        if (ti.getLockOwnerName() != null) {
            dw.dumpln(INDENT + " owned by " + ti.getLockOwnerName() + " id=" + ti.getLockOwnerId());
        }
        for (StackTraceElement ste : ti.getStackTrace()) {
            dw.dumpln(INDENT + "at " + ste.toString());
        }
        dw.dumpln();
    }

    @Override
    public String getName() {
        return "threads";
    }

    @Override
    public String getOwner() {
        return "jvm";
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return EnumSet.of(DiagnosticsCategory.THREADS);
    }

    @Override
    public String getDumpDescription() {
        return this.m_description;
    }
}

