/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.dump;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.dump.DiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpRegistrationEvent;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.InvalidDumpContextException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DumpManager {
    private static final DumpManager INSTANCE = new DumpManager();
    private HashMap<String, DiagnosticDump> m_dumps = new HashMap();
    private Logger m_logger = LoggerFactory.getFrameworkLogger();
    private static final String CLASSNAME = DumpManager.class.getName();
    private static final String ENTERING = "Entering " + CLASSNAME + ".";
    private static final String EXITING = "Exiting " + CLASSNAME + ".";
    private static final int DEFAULT_TIMEOUT = 120000;

    private DumpManager() {
    }

    public void registerDump(DiagnosticDump dump) {
        if (dump == null) {
            return;
        }
        this.m_dumps.put(dump.getFullDumpName(), dump);
        this.m_logger.log(Level.INFO, "MAS-40350", dump.getFullDumpName());
        DiagnosticsEventManager.notifyListeners(new DumpRegistrationEvent(dump));
    }

    public DiagnosticDump getDump(String dumpName) {
        return this.m_dumps.get(dumpName);
    }

    public Set<DiagnosticDump> getDumps() {
        return new TreeSet<DiagnosticDump>(this.m_dumps.values());
    }

    public Enumeration<String> enumerateDumpNames() {
        return Collections.enumeration(this.m_dumps.keySet());
    }

    public boolean isDumpRegistered(String dumpName) {
        return this.m_dumps.containsKey(dumpName);
    }

    public DumpResult executeDump(DumpContext context) throws DumpExecutionException, InvalidDumpContextException {
        this.m_logger.log(Level.FINER, ENTERING + "executeDump");
        String dumpName = context.getDumpName();
        DiagnosticDump dump = this.m_dumps.get(dumpName);
        if (dump == null) {
            this.m_logger.log(Level.FINE, "MAS-40352", dumpName);
            throw new InvalidDumpContextException("40352", dumpName);
        }
        dump.validateDumpContext(context);
        this.m_logger.log(Level.FINE, "MAS-40351", dumpName);
        DumpResult result = null;
        ExecutorService exec = null;
        try {
            exec = Executors.newSingleThreadExecutor();
            Future<DumpResult> fres = exec.submit(new DumpExecutor(context, dump));
            result = fres.get();
        }
        catch (Throwable t) {
            if (t instanceof DumpExecutionException) {
                throw (DumpExecutionException)t;
            }
            throw new DumpExecutionException("40389", dumpName, t);
        }
        finally {
            if (exec != null && !exec.isShutdown()) {
                exec.shutdownNow();
            }
        }
        this.m_logger.log(Level.FINER, EXITING + "executeDump");
        return result;
    }

    public static DumpManager getInstance() {
        return INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DumpExecutor
    implements Callable<DumpResult> {
        private DumpContext m_context;
        private DiagnosticDump m_dump;

        DumpExecutor(DumpContext context, DiagnosticDump dump) {
            this.m_context = context;
            this.m_dump = dump;
        }

        @Override
        public DumpResult call() throws DumpExecutionException {
            DumpResult result = null;
            try {
                result = this.m_dump.executeDump(this.m_context);
            }
            catch (Throwable t) {
                if (t instanceof DumpExecutionException) {
                    throw (DumpExecutionException)t;
                }
                throw new DumpExecutionException("40389", this.m_dump.getFullDumpName(), t);
            }
            return result;
        }
    }
}

