/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.dump;

import java.io.Serializable;
import oracle.core.ojdl.LogManager;
import oracle.dfw.common.ArgumentMap;
import oracle.dfw.impl.common.ArgumentMapImpl;

public class DumpContext
implements Serializable {
    private String m_dumpName;
    private String m_dumpID;
    private String m_incidentID;
    private String m_oracleInstancePath;
    private String m_oracleHomePath;
    private String m_topologyNodeCanonicalPath;
    private ArgumentMapImpl m_arguments = new ArgumentMapImpl();

    private DumpContext(String dumpName) {
        this.m_dumpName = dumpName;
        this.m_dumpID = LogManager.getLogManager().getUniqueId();
    }

    private DumpContext(String dumpName, String incidentID) {
        this(dumpName);
        this.m_incidentID = incidentID;
    }

    public final String getDumpName() {
        return this.m_dumpName;
    }

    public final String getDumpID() {
        return this.m_dumpID;
    }

    public final String getIncidentID() {
        return this.m_incidentID;
    }

    public String getOracleInstancePath() {
        return this.m_oracleInstancePath;
    }

    public void setOracleInstancePath(String oracleInstancePath) {
        this.m_oracleInstancePath = oracleInstancePath;
    }

    public String getOracleHomePath() {
        return this.m_oracleHomePath;
    }

    public void setOracleHomePath(String oracleHomePath) {
        this.m_oracleHomePath = oracleHomePath;
    }

    public String getTopologyNodeCanonicalPath() {
        return this.m_topologyNodeCanonicalPath;
    }

    public void setTopologyNode(String topologyNodeCanonicalPath) {
        this.m_topologyNodeCanonicalPath = topologyNodeCanonicalPath;
    }

    public void setIncidentId(String incidentId) {
        this.m_incidentID = incidentId;
    }

    public final void addArgument(String argName, Serializable argValue) {
        if (argName == null || argValue == null) {
            return;
        }
        this.m_arguments.put(argName, argValue);
    }

    public ArgumentMap getArguments() {
        return this.m_arguments;
    }

    public String toString() {
        return "[dump name=" + this.m_dumpName + " : oracle instance=" + this.m_oracleInstancePath + " : oracle home=" + this.m_oracleHomePath + "]";
    }

    public static DumpContext createDumpContext(String dumpName) {
        if (dumpName == null || dumpName.length() == 0) {
            throw new IllegalArgumentException("Illegal DumpContext arguments");
        }
        return new DumpContext(dumpName);
    }

    public static DumpContext createDumpContext(String dumpName, String incidentID) {
        if (dumpName == null || dumpName.length() == 0 || incidentID == null || incidentID.length() == 0) {
            throw new IllegalArgumentException("Illegal DumpContext arguments");
        }
        return new DumpContext(dumpName, incidentID);
    }
}

