/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.query;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.core.ojdl.query.Condition;
import oracle.core.ojdl.query.LogRecordField;
import oracle.core.ojdl.reader.LogRecord;

public class TimestampCondition
extends Condition {
    private String m_field;
    private long m_timeFrom;
    private long m_timeTo;
    private static SimpleDateFormat s_gmtDateFmt;
    private static long s_minTime;
    private static long s_maxTime;
    private static String[] s_itemNames;
    private static CompositeType s_compositeType;

    public TimestampCondition(long from, long to, boolean normalized) {
        this.m_timeFrom = from;
        this.m_timeTo = to;
        this.m_field = normalized ? "TSTZ_NORMALIZED" : "TSTZ_ORIGINATING";
    }

    public TimestampCondition(long from, long to) {
        this(from, to, false);
    }

    public TimestampCondition(long from) {
        this(from, Long.MAX_VALUE, false);
    }

    public long getFromTime() {
        return this.m_timeFrom;
    }

    public long getToTime() {
        return this.m_timeTo;
    }

    public boolean isNormalizedTime() {
        return this.m_field == "TSTZ_NORMALIZED";
    }

    void toSql(StringBuffer buf) {
        long timeTo;
        buf.append("(");
        LogRecordField f = LogRecordField.getField(this.m_field);
        boolean hasFrom = false;
        long timeFrom = this.m_timeFrom < s_maxTime ? this.m_timeFrom : s_maxTime;
        long l = timeTo = this.m_timeTo > s_minTime ? this.m_timeTo : s_minTime;
        if (timeFrom > s_minTime) {
            buf.append(f.getSqlExpr());
            buf.append(" >= '");
            buf.append(this.formatTstz(timeFrom));
            buf.append("'");
            hasFrom = true;
        }
        if (timeTo < s_maxTime) {
            if (hasFrom) {
                buf.append(" and ");
            }
            buf.append(f.getSqlExpr());
            buf.append(" <= '");
            buf.append(this.formatTstz(timeTo));
            buf.append("'");
        } else if (!hasFrom) {
            buf.append(f.getSqlExpr());
            buf.append(" >= '");
            buf.append(this.formatTstz(s_minTime));
            buf.append("'");
        }
        buf.append(")");
    }

    boolean eval(LogRecord rec) {
        Long time = (Long)rec.getField(this.m_field);
        if (time != null) {
            long t = time;
            return t >= this.m_timeFrom && t <= this.m_timeTo;
        }
        return false;
    }

    private String formatTstz(long time) {
        try {
            Date date = new Date(time);
            return s_gmtDateFmt.format(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CompositeType toCompositeType() throws OpenDataException {
        if (s_compositeType == null) {
            s_compositeType = new CompositeType(Condition.toCompositeType().getTypeName(), Condition.toCompositeType().getDescription(), s_itemNames, s_itemNames, new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.BOOLEAN});
        }
        return s_compositeType;
    }

    public CompositeData toCompositeData(CompositeType ct) throws OpenDataException {
        if (!Condition.toCompositeType().equals(ct)) {
            throw new IllegalArgumentException();
        }
        return new CompositeDataSupport(TimestampCondition.toCompositeType(), s_itemNames, new Object[]{"TimestampCondition", this.getFromTime(), this.getToTime(), this.isNormalizedTime()});
    }

    public static Condition from(CompositeData cd) throws OpenDataException {
        if (!"TimestampCondition".equals(cd.get("type"))) {
            throw new IllegalArgumentException();
        }
        long fromTime = (Long)cd.get("fromTime");
        long toTime = (Long)cd.get("toTime");
        boolean isNormalized = (Boolean)cd.get("isNormalized");
        return new TimestampCondition(fromTime, toTime, isNormalized);
    }

    static {
        s_minTime = -62135769600000L;
        s_maxTime = 253370764800000L;
        s_gmtDateFmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS0 z");
        s_gmtDateFmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        s_itemNames = new String[]{"type", "fromTime", "toTime", "isNormalized"};
    }
}

