/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ODLLogRecord
extends LogRecord {
    private String m_messageId;
    private Map m_supplAttributes;
    private String m_detailLocation;
    private String m_supplDetail;
    private String m_problemKey;
    private String m_errorId;
    private boolean m_inferCaller = true;
    private static final String LOGGER_CLASS_NAME = "oracle.core.ojdl.logging.ODLLogger";

    public ODLLogRecord(Level level, String msg) {
        super(level, msg);
    }

    public String getMessageId() {
        return this.m_messageId;
    }

    public void setMessageId(String messageId) {
        this.m_messageId = messageId;
    }

    public String getDetailLocation() {
        return this.m_detailLocation;
    }

    public void setDetailLocation(String detailLocation) {
        this.m_detailLocation = detailLocation;
    }

    public String getSupplDetail() {
        return this.m_supplDetail;
    }

    public void setSupplDetail(String supplDetail) {
        this.m_supplDetail = supplDetail;
    }

    public Map getSupplAttributes() {
        return this.m_supplAttributes;
    }

    public void setSupplAttributes(Map supplAttributes) {
        this.m_supplAttributes = supplAttributes;
    }

    public String getProblemKey() {
        return this.m_problemKey;
    }

    public void setProblemKey(String problemKey) {
        this.m_problemKey = problemKey;
    }

    public String getErrorInstanceId() {
        return this.m_errorId;
    }

    public void setErrorInstanceId(String errorId) {
        this.m_errorId = errorId;
    }

    public String getSourceClassName() {
        if (this.m_inferCaller) {
            this.inferCaller();
        }
        return super.getSourceClassName();
    }

    public void setSourceClassName(String sourceClassName) {
        this.m_inferCaller = false;
        super.setSourceClassName(sourceClassName);
    }

    public String getSourceMethodName() {
        if (this.m_inferCaller) {
            this.inferCaller();
        }
        return super.getSourceMethodName();
    }

    public void setSourceMethodName(String sourceMethodName) {
        this.m_inferCaller = false;
        super.setSourceMethodName(sourceMethodName);
    }

    private void inferCaller() {
        StackTraceElement frame;
        String cname;
        int i;
        this.m_inferCaller = false;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (i = 0; i < stack.length && !(cname = (frame = stack[i]).getClassName()).equals(LOGGER_CLASS_NAME); ++i) {
        }
        while (i < stack.length) {
            frame = stack[i];
            cname = frame.getClassName();
            if (!cname.equals(LOGGER_CLASS_NAME)) {
                this.setSourceClassName(cname);
                this.setSourceMethodName(frame.getMethodName());
                return;
            }
            ++i;
        }
    }
}

