/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.util.Date;
import java.util.Map;
import oracle.core.ojdl.DateFormat;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.MessageType;
import oracle.core.ojdl.util.XMLUtil;

public class ODL11Formatter
implements LogFormatter {
    public static final String MSG = "msg";
    public static final String TIMESTAMP = "time";
    public static final String TIMESTAMP_NORM = "time_norm";
    public static final String ORGANIZATION_ID = "org_id";
    public static final String INSTANCE_ID = "inst_id";
    public static final String COMPONENT_ID = "comp_id";
    public static final String MSG_ID = "msg_id";
    public static final String CLIENT_ID = "client_id";
    public static final String MSG_TYPE = "type";
    public static final String MSG_GROUP = "group";
    public static final String MSG_LEVEL = "level";
    public static final String HOST_ID = "host_id";
    public static final String HOST_ADDR = "host_addr";
    public static final String MODULE_ID = "module";
    public static final String PROCESS_ID = "pid";
    public static final String THREAD_ID = "tid";
    public static final String USER_ID = "user";
    public static final String SUPPL_ATTR = "attr";
    public static final String SUPPL_ATTR_NAME = "name";
    public static final String SUPPL_ATTR_VALUE = "value";
    public static final String UPSTREAM_COMP_ID = "upstream_comp";
    public static final String DOWNSTREAM_COMP_ID = "downstream_comp";
    public static final String ECID = "ecid";
    public static final String RID = "rid";
    public static final String ERROR_ID = "errid";
    public static final String ERROR_SEQ = "err_seq";
    public static final String MSG_TEXT = "txt";
    public static final String MSG_ARG = "arg";
    public static final String MSG_ARG_NAME = "name";
    public static final String MSG_ARG_VALUE = "value";
    public static final String DETAIL_PATH = "detail_path";
    public static final String SUPPL_DETAIL = "suppl_detail";
    public static final String PROBLEM_KEY = "prob_key";
    private DateFormat m_dateFmt = new DateFormat();
    private Date m_date = new Date(0L);
    private static final String LSEP = System.getProperty("line.separator");
    private boolean m_escapeChars = true;
    private boolean m_useHeadAndTail = false;

    public ODL11Formatter(boolean useHeadAndTail) {
        String escapeProp = System.getProperty("oracle.core.ojdl.ODL11Formatter.escapeChars");
        if (escapeProp == null) {
            escapeProp = LogManager.getLogManager().getProperty("ODL11Formatter.escapeChars", "true");
        }
        this.m_escapeChars = escapeProp.equalsIgnoreCase("true");
        this.m_useHeadAndTail = useHeadAndTail;
    }

    public ODL11Formatter() {
        this(false);
    }

    public String format(LogMessage msg) {
        String supplDet;
        StringBuffer buf = new StringBuffer(500);
        buf.append("<");
        buf.append(MSG);
        this.attr(buf, TIMESTAMP, msg.getTimestamp());
        if (msg.getNormalizedTimestamp() > 0L) {
            this.attr(buf, TIMESTAMP_NORM, msg.getNormalizedTimestamp());
        }
        if (msg.getOrganizationId() != null) {
            this.attr(buf, ORGANIZATION_ID, msg.getOrganizationId());
        }
        if (msg.getComponentId() != null) {
            this.attr(buf, COMPONENT_ID, msg.getComponentId());
        }
        if (msg.getInstanceId() != null) {
            this.attr(buf, INSTANCE_ID, msg.getInstanceId());
        }
        if (msg.getMessageId() != null) {
            this.attr(buf, MSG_ID, msg.getMessageId());
        }
        if (msg.getHostingClientId() != null) {
            this.attr(buf, CLIENT_ID, msg.getHostingClientId());
        }
        if (msg.getMessageType() != null) {
            this.attr(buf, MSG_TYPE, msg.getMessageType().toString());
        } else {
            this.attr(buf, MSG_TYPE, MessageType.UNKNOWN.toString());
        }
        this.attr(buf, MSG_LEVEL, msg.getMessageLevel());
        if (msg.getMessageGroup() != null) {
            this.attr(buf, MSG_GROUP, msg.getMessageGroup());
        }
        if (msg.getHostId() != null) {
            this.attr(buf, HOST_ID, msg.getHostId());
        }
        if (msg.getHostNwAddr() != null) {
            this.attr(buf, HOST_ADDR, msg.getHostNwAddr());
        }
        if (msg.getModuleId() != null) {
            this.attr(buf, MODULE_ID, msg.getModuleId());
        }
        if (msg.getProcessId() != null) {
            this.attr(buf, PROCESS_ID, msg.getProcessId());
        }
        if (msg.getThreadId() != null) {
            this.attr(buf, THREAD_ID, msg.getThreadId());
        }
        if (msg.getUserId() != null) {
            this.attr(buf, USER_ID, msg.getUserId());
        }
        if (msg.getUpstreamCompId() != null) {
            this.attr(buf, UPSTREAM_COMP_ID, msg.getUpstreamCompId());
        }
        if (msg.getDownstreamCompId() != null) {
            this.attr(buf, DOWNSTREAM_COMP_ID, msg.getDownstreamCompId());
        }
        if (msg.getExecContextId() != null) {
            this.attr(buf, ECID, msg.getExecContextId().getUniqueId());
            this.attr(buf, RID, msg.getExecContextId().getRID());
        }
        if (msg.getErrorInstanceId() != null) {
            this.attr(buf, ERROR_ID, msg.getErrorInstanceId().getUniqueId());
            String rid = msg.getErrorInstanceId().getRID();
            if (rid != null) {
                this.attr(buf, ERROR_SEQ, msg.getErrorInstanceId().getRID());
            }
        }
        if (msg.getDetailLocation() != null) {
            this.attr(buf, DETAIL_PATH, msg.getDetailLocation());
        }
        if (msg.getProblemKey() != null) {
            this.attr(buf, PROBLEM_KEY, msg.getProblemKey());
        }
        buf.append(">" + LSEP);
        Map map = msg.getSupplAttrs();
        if (map != null && !map.isEmpty()) {
            for (String name : map.keySet()) {
                Object v = map.get(name);
                if (v == null) continue;
                buf.append(" <");
                buf.append(SUPPL_ATTR);
                this.attr(buf, "name", name);
                this.attrEsc(buf, "value", v.toString());
                buf.append("/>" + LSEP);
            }
        }
        String msgText = msg.getMessageText();
        buf.append(" <txt>");
        if (this.m_escapeChars) {
            XMLUtil.escapeXMLchars(msgText, buf);
        } else {
            buf.append(msgText);
        }
        buf.append("</txt>" + LSEP);
        if (msg.getMessageArgs() != null) {
            LogMessage.MessageArgument[] args = msg.getMessageArgs();
            for (int i = 0; i < args.length; ++i) {
                buf.append(" <arg");
                if (args[i].getName() != null) {
                    this.attr(buf, "name", args[i].getName());
                }
                this.attrEsc(buf, "value", args[i].getValue());
                buf.append("/>" + LSEP);
            }
        }
        if ((supplDet = msg.getSupplDetail()) != null) {
            buf.append(" <suppl_detail>");
            if (!this.m_escapeChars || this.checkChars(supplDet)) {
                buf.append("<![CDATA[");
                buf.append(supplDet);
                buf.append("]]>");
            } else {
                XMLUtil.escapeXMLchars(supplDet, buf);
            }
            buf.append("</suppl_detail>" + LSEP);
        }
        buf.append("</msg>" + LSEP);
        return buf.toString();
    }

    public String header() {
        if (this.m_useHeadAndTail) {
            return "<?xml version='1.0'?>" + LSEP + "<LOG>" + LSEP;
        }
        return "";
    }

    public String tail() {
        if (this.m_useHeadAndTail) {
            return "</LOG>" + LSEP;
        }
        return "";
    }

    private final void attr(StringBuffer buf, String tag, String value) {
        buf.append(" ");
        buf.append(tag);
        buf.append("='");
        buf.append(value);
        buf.append("'");
    }

    private final void attrEsc(StringBuffer buf, String tag, String value) {
        buf.append(" ");
        buf.append(tag);
        buf.append("='");
        XMLUtil.escapeAttrChars(value, buf);
        buf.append("'");
    }

    private final void attr(StringBuffer buf, String tag, int value) {
        buf.append(" ");
        buf.append(tag);
        buf.append("='");
        buf.append(value);
        buf.append("'");
    }

    private final void attr(StringBuffer buf, String tag, long time) {
        buf.append(" ");
        buf.append(tag);
        buf.append("='");
        this.m_date.setTime(time);
        this.m_dateFmt.format(this.m_date, buf);
        buf.append("'");
    }

    private boolean checkChars(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if ((ch >= ' ' || ch == '\n' || ch == '\r' || ch == '\t') && (ch != ']' || i + 2 >= len || str.charAt(i + 1) != ']' || str.charAt(i + 2) != '>')) continue;
            return false;
        }
        return true;
    }
}

