/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.exception;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;
import oracle.as.management.exception.ASExceptionHelper;
import oracle.as.management.exception.ASWrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASException
extends Exception {
    private ASExceptionHelper m_helper = null;
    public static String ACTION_SUFFIX = "-ACTION";
    public static String CAUSE_SUFFIX = "-CAUSE";
    private static final long serialVersionUID = -1153800432741L;

    @Deprecated
    protected ASException(String errorCode, Throwable cause, String prefix, String resourceLocation) {
        super(errorCode + cause);
        if (errorCode == null || errorCode.length() == 0 || prefix == null || resourceLocation == null || resourceLocation.length() == 0) {
            throw new IllegalArgumentException("errorCode=" + errorCode + " prefix=" + prefix + " resourceLocation=" + resourceLocation);
        }
        this.m_helper = new ASExceptionHelper(errorCode, prefix, resourceLocation);
        if (cause != null) {
            this.initCause(cause);
        }
    }

    @Deprecated
    protected ASException(String errorCode, String token, Throwable cause, String prefix, String resourceLocation) {
        this(errorCode, cause, prefix, resourceLocation);
        this.m_helper.addToken(token);
    }

    @Deprecated
    protected ASException(String errorCode, String prefix, String resourceLocation) {
        this(errorCode, (Throwable)null, prefix, resourceLocation);
    }

    @Deprecated
    protected ASException(String errorCode, String token, String prefix, String resourceLocation) {
        this(errorCode, (Throwable)null, prefix, resourceLocation);
        this.m_helper.addToken(token);
    }

    protected ASException(String messageID, Throwable cause, String resourceLocation) {
        super(messageID);
        if (messageID == null || messageID.trim().length() == 0 || resourceLocation == null || resourceLocation.length() == 0) {
            throw new IllegalArgumentException("messageID=" + messageID + " resourceLocation=" + resourceLocation);
        }
        this.m_helper = new ASExceptionHelper(messageID, resourceLocation);
        if (cause != null) {
            this.initCause(cause);
        }
    }

    protected ASException(String messageID, String token, Throwable cause, String resourceLocation) {
        this(messageID, cause, resourceLocation);
        this.m_helper.addToken(token);
    }

    protected ASException(String messageID, String resourceLocation) {
        this(messageID, (Throwable)null, resourceLocation);
    }

    @Override
    public Throwable initCause(Throwable cause) {
        if (cause == null || cause == this) {
            return null;
        }
        if (this.getCause() == null) {
            this.m_helper.initCauseActionMessage(cause);
            super.initCause(cause);
        }
        return this.getCause();
    }

    @Deprecated
    public void setResourceLocation(String resourceLocation, String prefix) {
        this.m_helper.setResourceLocation(resourceLocation, prefix);
    }

    public void setResourceLocation(String resourceLocation) {
        this.m_helper.setResourceLocation(resourceLocation);
    }

    @Deprecated
    public String setResourceLocation() {
        return this.m_helper.setResourceLocation();
    }

    public String getResourceLocation() {
        return this.m_helper.getResourceLocation();
    }

    public void setLocale(Locale locale) {
        this.m_helper.setLocale(locale);
    }

    public Locale getLocale() {
        return this.m_helper.getLocale();
    }

    public void setClassLoader(ClassLoader loader) {
        this.m_helper.setClassLoader(loader);
    }

    public void addToken(String token) {
        this.m_helper.addToken(token);
    }

    public void replaceToken(int pos, String token) {
        this.m_helper.replaceToken(pos, token);
    }

    public List<String> getTokens() {
        return this.m_helper.getTokens();
    }

    public void addActionToken(String token) {
        this.m_helper.addActionToken(token);
    }

    public void addCauseToken(String token) {
        this.m_helper.addCauseToken(token);
    }

    @Deprecated
    public String getErrorCode() {
        return this.m_helper.getErrorCode();
    }

    @Deprecated
    public String getPrefix() {
        return this.m_helper.getPrefix();
    }

    public String getMessageID() {
        return this.m_helper.getMessageID();
    }

    @Override
    public String getMessage() {
        if (!this.m_helper.isDisplayable() && this.getCause() != null) {
            return this.getCause().getMessage();
        }
        return this.m_helper.getMessage();
    }

    public String getMessage(Locale locale) {
        return this.m_helper.getMessage(locale);
    }

    ASExceptionHelper getHelper() {
        return this.m_helper;
    }

    public String getStackTraceAsString() {
        return ASException.getStackTraceAsString(this);
    }

    public static String getStackTraceAsString(Throwable t) {
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] stack = t.getStackTrace();
        if (stack != null) {
            for (int i = 0; i < stack.length; ++i) {
                sb.append(stack[i].toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static Throwable getCause(Throwable throwable) {
        Throwable t = throwable;
        Throwable cause = t.getCause();
        while (cause != null && cause != t) {
            t = cause;
            cause = t.getCause();
        }
        return t;
    }

    public String getCauseMessage() {
        return this.m_helper.getCauseMessage();
    }

    public String getActionMessage() {
        return this.m_helper.getActionMessage();
    }

    public static String getMessageAndTrace(Throwable t) {
        StringBuffer sb = new StringBuffer();
        String msg = t.getMessage();
        if (msg != null) {
            sb.append(msg);
            sb.append("\n");
        }
        sb.append(t.getClass().getName());
        sb.append("\n");
        sb.append(ASException.getStackTraceAsString(t));
        return sb.toString();
    }

    public void setDisplayable(boolean displayable) {
        this.m_helper.setDisplayable(displayable);
    }

    public boolean isDisplayable() {
        return this.m_helper.isDisplayable();
    }

    public <T extends Exception> T toException(Class<T> expClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ASException.toException(this, expClass);
    }

    public static <T extends Exception> T toException(Throwable exp, Class<T> expClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<T> constructor = expClass.getConstructor(String.class);
        T ret = null;
        Throwable parent = null;
        for (Throwable asExp = exp; asExp != null; asExp = asExp.getCause()) {
            T child = ASException._toException(asExp, constructor);
            if (parent == null) {
                ret = child;
            } else {
                parent.initCause((Throwable)child);
            }
            parent = child;
        }
        return ret;
    }

    private static <T extends Exception> T _toException(Throwable asExp, Constructor<T> constructor) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        String mesg = asExp.getMessage();
        if ((mesg == null || mesg.trim().length() == 0) && constructor.getDeclaringClass() == ASWrappedException.class) {
            mesg = asExp.getClass().toString();
        }
        Exception exp = (Exception)constructor.newInstance(mesg);
        StackTraceElement[] stacks = asExp.getStackTrace();
        int length = stacks.length;
        StackTraceElement[] newstacks = new StackTraceElement[length + 1];
        System.arraycopy(stacks, 0, newstacks, 1, length);
        newstacks[0] = new StackTraceElement(asExp.getClass().getName(), "", null, 0);
        exp.setStackTrace(newstacks);
        if (exp instanceof ASException && asExp instanceof ASException) {
            ASExceptionHelper sourceHelper = ((ASException)asExp).getHelper();
            ASExceptionHelper targetHelper = ((ASException)exp).getHelper();
            targetHelper.copyMessageAttributes(sourceHelper);
        } else if (exp instanceof ASException) {
            ASExceptionHelper targetHelper = ((ASException)exp).getHelper();
            String expMsg = asExp.getMessage();
            if (expMsg == null || expMsg.trim().length() == 0) {
                expMsg = asExp.getClass().getName();
            }
            targetHelper.setMessageText(expMsg);
        }
        return (T)exp;
    }
}

