/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsXASession;

public class AQjmsXAResource
implements XAResource {
    private XAResource m_jdbcXAResource;
    private AQjmsXASession m_jmsXASession;

    AQjmsXAResource(AQjmsXASession jmsXASession, XAResource jdbcXAResource) {
        this.m_jdbcXAResource = jdbcXAResource;
        this.m_jmsXASession = jmsXASession;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.commit", "enter: XAResource=" + String.valueOf(this) + ", xid=" + String.valueOf(xid) + ",  onePhase=" + onePhase);
        this.checkConsistency();
        try {
            this.m_jdbcXAResource.commit(xid, onePhase);
            if (!AQjmsConstants.ignorePriority()) {
                this.m_jmsXASession.restartConsumers();
            }
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.commit", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.commit", "exit");
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.end", "enter: XAResource=" + String.valueOf(this) + ", xid=" + String.valueOf(xid) + ", flags=" + flags);
        try {
            this.m_jdbcXAResource.end(xid, flags);
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.end", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.end", "exit");
    }

    @Override
    public void forget(Xid xid) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.forget", "enter: XAResource=" + String.valueOf(this) + ", xid=" + String.valueOf(xid));
        try {
            this.m_jdbcXAResource.forget(xid);
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.forget", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.forget", "exit");
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.getTransactionTimeout", "enter");
        int timeout = 0;
        try {
            timeout = this.m_jdbcXAResource.getTransactionTimeout();
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.getTransactionTimeout", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.getTransactionTimeout", "exit");
        return timeout;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.isSameRM", "enter: my XAResource=" + String.valueOf(this) + ", target XAResource=" + String.valueOf(xares));
        boolean isSame = false;
        try {
            isSame = xares == null ? false : (this == xares ? true : (xares instanceof AQjmsXAResource ? this.m_jdbcXAResource.isSameRM(((AQjmsXAResource)xares).getWrappedXARes()) : this.m_jdbcXAResource.isSameRM(xares)));
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.isSameRM", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.isSameRM", "exit");
        return isSame;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.prepare", "enter: XAResource=" + String.valueOf(this) + ", xid=" + String.valueOf(xid));
        this.checkConsistency();
        int result = 0;
        try {
            result = this.m_jdbcXAResource.prepare(xid);
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.prepare", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.prepare", "exit");
        return result;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.recover", "enter: XAResource=" + String.valueOf(this) + ", flag=" + flag);
        Xid[] xidList = null;
        try {
            xidList = this.m_jdbcXAResource.recover(flag);
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.recover", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.recover", "exit");
        return xidList;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.rollback", "enter: XAResource=" + String.valueOf(this) + ", xid=" + String.valueOf(xid));
        try {
            this.m_jdbcXAResource.rollback(xid);
            this.m_jmsXASession.setConsistency(true);
            this.m_jmsXASession.restartConsumers();
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.rollback", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.rollback", "exit");
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.setTransactionTimeout", "enter: XAResource=" + String.valueOf(this) + ", seconds=" + seconds);
        boolean result = false;
        try {
            result = this.m_jdbcXAResource.setTransactionTimeout(seconds);
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.setTransactionTimeout", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.setTransactionTimeout", "exit");
        return result;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.start", "enter: XAResource=" + String.valueOf(this) + ", xid=" + String.valueOf(xid) + ", flags=" + flags);
        try {
            this.m_jdbcXAResource.start(xid, flags);
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.start", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.start", "exit");
    }

    XAResource getWrappedXARes() {
        return this.m_jdbcXAResource;
    }

    private void checkConsistency() throws XAException {
        try {
            this.m_jmsXASession.checkConsistency();
        }
        catch (JMSException e) {
            throw new XAException("cannot commit the JMS session that is in inconsistent state");
        }
    }
}

