/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import oracle.jdbc.OracleData;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsObjectInputStream;
import oracle.jms.AQjmsObjectMessage_C;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsUtil;

public class AQjmsObjectMessage
extends AQjmsMessage
implements ObjectMessage {
    private byte[] m_bytesData = null;

    public AQjmsObjectMessage() {
        super(true);
        this.access_mode = 2;
    }

    AQjmsObjectMessage(AQjmsSession aQjmsSession) throws JMSException {
        super(aQjmsSession, true);
        this.access_mode = 2;
    }

    AQjmsObjectMessage(AQjmsMessage aQjmsMessage) throws JMSException {
        super(aQjmsMessage);
    }

    AQjmsObjectMessage(AQjmsSession aQjmsSession, AQjmsObjectMessage_C aQjmsObjectMessage_C) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.header_ext = aQjmsObjectMessage_C.getHeader();
            this.readObjectMessageContainer(aQjmsObjectMessage_C, false);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "Constructor w/container", sQLException);
            throw new AQjmsException(sQLException);
        }
        this.access_mode = 0;
    }

    AQjmsObjectMessage(AQjmsSession aQjmsSession, AQjmsGenMessage_C aQjmsGenMessage_C) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.header_ext = aQjmsGenMessage_C.getHeader();
            this.readGenMessageContainer(aQjmsGenMessage_C, false);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "Constructor w/container", sQLException);
            throw new AQjmsException(sQLException);
        }
        this.access_mode = 0;
    }

    AQjmsObjectMessage(AQjmsSession aQjmsSession, AQjmsObjectMessage_C aQjmsObjectMessage_C, boolean bl) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.header_ext = aQjmsObjectMessage_C.getHeader();
            this.readObjectMessageContainer(aQjmsObjectMessage_C, bl);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "Constructor w/container: xml_receive: " + bl, sQLException);
            throw new AQjmsException(sQLException);
        }
        this.access_mode = 0;
    }

    AQjmsObjectMessage(AQjmsSession aQjmsSession, byte[] byArray, boolean bl) throws JMSException {
        super(aQjmsSession, true);
        this.m_bytesData = byArray;
        this.access_mode = 0;
    }

    byte[] getSerialObject() throws JMSException {
        return this.m_bytesData;
    }

    public void setObject(Serializable serializable) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (serializable == null) {
            this.m_bytesData = null;
        } else if (serializable instanceof Serializable) {
            this.m_bytesData = AQjmsObjectMessage.convertSerializableToByteArray(serializable);
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid object type");
        }
    }

    public Serializable getObject() throws JMSException {
        return AQjmsObjectMessage.convertByteArrayToSerializable(this.m_bytesData);
    }

    @Override
    public void clearBody() throws JMSException {
        this.m_bytesData = null;
        this.setAccessMode(2);
    }

    public void setBytesData(byte[] byArray) {
        this.m_bytesData = byArray;
    }

    public byte[] getBytesData() {
        return this.m_bytesData;
    }

    @Override
    OracleData getMessageCont(AQjmsSession aQjmsSession, boolean bl, boolean bl2) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.getMessageCont", "entry");
        AQjmsObjectMessage_C aQjmsObjectMessage_C = new AQjmsObjectMessage_C();
        boolean[] blArray = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(aQjmsObjectMessage_C, 4, this.header_ext, this.m_bytesData, aQjmsSession, bl, blArray, bl2);
        this.setWriteLobLater(blArray[0]);
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.getMessageCont", "exit");
        return aQjmsObjectMessage_C;
    }

    @Override
    AQjmsGenMessage_C getGenMessageCont(AQjmsSession aQjmsSession, boolean bl, boolean bl2) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.getGenMessageCont", "entry");
        AQjmsGenMessage_C aQjmsGenMessage_C = new AQjmsGenMessage_C();
        boolean[] blArray = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(aQjmsGenMessage_C, 4, this.header_ext, this.m_bytesData, aQjmsSession, bl, blArray, bl2);
        this.setWriteLobLater(blArray[0]);
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.getGenMessageCont", "exit");
        return aQjmsGenMessage_C;
    }

    @Override
    void writeLob(AQjmsSession aQjmsSession, AQjmsDestination aQjmsDestination, byte[] byArray, boolean bl) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsObjectmessage.writeLob", "entry");
        if (this.m_writeLobLater) {
            AQjmsUtil.writeBlob(this.m_bytesData, aQjmsSession, aQjmsDestination, byArray, bl);
        }
        AQjmsOracleDebug.trace(4, "AQjmsObjectmessage.writeLob", "exit");
    }

    private void readObjectMessageContainer(AQjmsObjectMessage_C aQjmsObjectMessage_C, boolean bl) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(aQjmsObjectMessage_C.getBytesLen(), aQjmsObjectMessage_C.getBytesLob(), aQjmsObjectMessage_C.getBytesRaw());
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    private void readGenMessageContainer(AQjmsGenMessage_C aQjmsGenMessage_C, boolean bl) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(aQjmsGenMessage_C.getBytesLen(), aQjmsGenMessage_C.getBytesLob(), aQjmsGenMessage_C.getBytesRaw());
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    private static byte[] convertSerializableToByteArray(Serializable serializable) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertSerializableToByteArray", "entry");
        if (serializable == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertSerializableToByteArray", "exit");
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsObjectMessage.ioexp-1", iOException);
            AQjmsError.throwEx(157, (Throwable)iOException);
            return null;
        }
    }

    private static Serializable convertByteArrayToSerializable(byte[] byArray) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertByteArrayToSerializable", "entry");
        if (byArray == null) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertByteArrayToSerializable", "Before deserializing object using new class loader object input stream");
            ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            if (classLoader == null) {
                classLoader = AQjmsObjectMessage.class.getClassLoader();
            }
            Serializable serializable = (Serializable)new AQjmsObjectInputStream(byteArrayInputStream, classLoader).readObject();
            AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertByteArrayToSerializable", "After deserializing object using new class loader object input stream");
            AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertByteArrayToSerializable", "exit");
            return serializable;
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwEx(109, (Throwable)classNotFoundException);
        }
        catch (InvalidClassException invalidClassException) {
            AQjmsError.throwEx(109, (Throwable)invalidClassException);
        }
        catch (IOException iOException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsObjectMessage.ioexp-2", iOException);
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        return null;
    }

    @Override
    byte[] getBytesCont() throws JMSException {
        return this.m_bytesData;
    }
}

