/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsQueueConnectionFactory;
import oracle.jms.AQjmsTopicConnectionFactory;
import oracle.jms.AQjmsUtil;
import oracle.jms.AQjmsXAConnectionFactory;
import oracle.jms.AQjmsXAQueueConnectionFactory;
import oracle.jms.AQjmsXATopicConnectionFactory;
import oracle.jms.WebLogicHelper;

public class AQjmsConnectionFactory
implements ObjectFactory,
ConnectionFactory,
Serializable {
    String hostname;
    String oracle_sid;
    int portno;
    String jdbc_driver;
    String jdbc_conn_str;
    String user;
    String passwd;
    String classname;
    Properties jdbc_info;
    DataSource data_source;
    boolean compliant = AQjmsConstants.IS_COMPLIANT;
    static final String HOST_ATTR = "host";
    static final String PORT_ATTR = "port";
    static final String SID_ATTR = "sid";
    static final String JDBC_CNN_ATTR = "jdbc_connect_string";
    static final String JDBC_DRV_ATTR = "driver";
    static final String USER_NAM_ATTR = "username";
    static final String PASSWORD_ATTR = "password";

    AQjmsConnectionFactory(String string, String string2, int n, String string3) throws JMSException {
        this.hostname = string;
        this.oracle_sid = string2;
        this.portno = n;
        this.data_source = null;
        if (string3 != null) {
            if (string3.equalsIgnoreCase("thin")) {
                this.jdbc_driver = "thin";
            } else if (string3.equalsIgnoreCase("oci8")) {
                this.jdbc_driver = "oci8";
            } else if (string3.equalsIgnoreCase("oci")) {
                this.jdbc_driver = "oci";
            } else {
                AQjmsError.throwEx(135, string3);
            }
        } else {
            this.jdbc_driver = "thin";
        }
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        AQjmsOracleDebug.trace(5, "AQjmsConnectionFactory - constructor", "hostname: " + string + "  oracle_sid: " + string2 + "  port_no: " + n + "  driver: " + string3);
    }

    AQjmsConnectionFactory(String string, Properties properties) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.data_source = null;
        this.jdbc_conn_str = string;
        this.jdbc_info = properties;
        AQjmsOracleDebug.trace(5, "AQjmsConnectionFactory - constructor", "with jdbc connect string");
    }

    AQjmsConnectionFactory(DataSource dataSource) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        this.data_source = dataSource;
        AQjmsOracleDebug.trace(5, "AQjmsConnectionFactory - constructor", "data source object: " + dataSource);
    }

    AQjmsConnectionFactory(DataSource dataSource, String string, Properties properties) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.data_source = dataSource;
        this.jdbc_conn_str = string;
        this.jdbc_info = properties;
        AQjmsOracleDebug.trace(5, "AQjmsConnectionFactory - constructor", "with both ds and jdbc connect string");
    }

    AQjmsConnectionFactory(String string) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        this.data_source = (DataSource)AQjmsUtil.lookupObject(string, DataSource.class);
        AQjmsOracleDebug.trace(5, "AQjmsConnectionFactory - constructor", "data source name: " + string);
    }

    public AQjmsConnectionFactory() {
        this.jdbc_driver = "thin";
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        this.user = null;
        this.passwd = null;
        this.classname = null;
    }

    public void setJdbcURL(String string) throws JMSException {
        this.jdbc_conn_str = string;
    }

    public String getJdbcURL() {
        return this.jdbc_conn_str;
    }

    public void setUsername(String string) throws JMSException {
        if (this.jdbc_info == null) {
            this.jdbc_info = new Properties();
        }
        this.jdbc_info.put("user", string);
    }

    public String getUsername() {
        if (this.jdbc_info == null) {
            return null;
        }
        String string = (String)this.jdbc_info.get("user");
        return string;
    }

    public void setPassword(String string) throws JMSException {
        if (this.jdbc_info == null) {
            this.jdbc_info = new Properties();
        }
        this.jdbc_info.put(PASSWORD_ATTR, string);
    }

    public void setDatasource(DataSource dataSource) throws JMSException {
        this.data_source = dataSource;
    }

    public DataSource getDataSource() {
        return this.data_source;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws JMSException {
        Reference reference = (Reference)object;
        AQjmsOracleDebug.trace(4, "AQjmsConnectionFactory.getObjectInstance", "entry");
        if (reference == null) {
            AQjmsOracleDebug.trace(3, "AQjmsConnectionFactory.getObjectInstance", "Reference object is null");
            return null;
        }
        this.classname = reference.getClassName();
        if (!(this.classname.equals("oracle.jms.AQjmsQueueConnectionFactory") || this.classname.equals("oracle.jms.AQjmsTopicConnectionFactory") || this.classname.equals("oracle.jms.AQjmsConnectionFactory") || this.classname.equals("oracle.jms.AQjmsXAQueueConnectionFactory") || this.classname.equals("oracle.jms.AQjmsXATopicConnectionFactory") || this.classname.equals("oracle.jms.AQjmsXAConnectionFactory"))) {
            AQjmsOracleDebug.trace(3, "AQjmsConnectionFactory.getObjectInstance", "unable to manufacture object of class: " + this.classname);
            return null;
        }
        AQjmsConnectionFactory aQjmsConnectionFactory = null;
        try {
            SearchControls searchControls = new SearchControls();
            String[] stringArray = new String[]{"orclDBAQGeneric"};
            searchControls.setSearchScope(0);
            searchControls.setReturningAttributes(stringArray);
            DirContext dirContext = (DirContext)context;
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(name, "(objectclass=*)", searchControls);
            if (namingEnumeration != null) {
                SearchResult searchResult = namingEnumeration.next();
                Attribute attribute = searchResult.getAttributes().get("orclDBAQGeneric");
                for (int i = 0; i < attribute.size(); ++i) {
                    String string = (String)attribute.get(i);
                    if (string.toLowerCase().startsWith(HOST_ATTR)) {
                        this.hostname = string.substring(HOST_ATTR.length() + 1);
                        continue;
                    }
                    if (string.toLowerCase().startsWith(PORT_ATTR)) {
                        this.portno = Integer.valueOf(string.substring(PORT_ATTR.length() + 1));
                        continue;
                    }
                    if (string.toLowerCase().startsWith(SID_ATTR)) {
                        this.oracle_sid = string.substring(SID_ATTR.length() + 1);
                        continue;
                    }
                    if (string.toLowerCase().startsWith(JDBC_CNN_ATTR)) {
                        this.jdbc_conn_str = string.substring(JDBC_CNN_ATTR.length() + 1);
                        continue;
                    }
                    if (string.toLowerCase().startsWith(JDBC_DRV_ATTR)) {
                        this.jdbc_driver = string.substring(JDBC_DRV_ATTR.length() + 1);
                        continue;
                    }
                    if (string.toLowerCase().startsWith(USER_NAM_ATTR)) {
                        this.user = string.substring(USER_NAM_ATTR.length() + 1);
                        continue;
                    }
                    if (!string.toLowerCase().startsWith(PASSWORD_ATTR)) continue;
                    this.passwd = string.substring(PASSWORD_ATTR.length() + 1);
                }
                if (this.user != null && this.passwd != null) {
                    this.jdbc_info = new Properties();
                    this.jdbc_info.put("user", this.user);
                    this.jdbc_info.put(PASSWORD_ATTR, this.passwd);
                }
                if (this.classname.equals("oracle.jms.AQjmsQueueConnectionFactory")) {
                    aQjmsConnectionFactory = this.jdbc_conn_str != null ? new AQjmsQueueConnectionFactory(this.jdbc_conn_str, this.jdbc_info) : new AQjmsQueueConnectionFactory(this.hostname, this.oracle_sid, this.portno, this.jdbc_driver);
                } else if (this.classname.equals("oracle.jms.AQjmsTopicConnectionFactory")) {
                    aQjmsConnectionFactory = this.jdbc_conn_str != null ? new AQjmsTopicConnectionFactory(this.jdbc_conn_str, this.jdbc_info) : new AQjmsTopicConnectionFactory(this.hostname, this.oracle_sid, this.portno, this.jdbc_driver);
                } else if (this.classname.equals("oracle.jms.AQjmsConnectionFactory")) {
                    aQjmsConnectionFactory = this.jdbc_conn_str != null ? new AQjmsConnectionFactory(this.jdbc_conn_str, this.jdbc_info) : new AQjmsConnectionFactory(this.hostname, this.oracle_sid, this.portno, this.jdbc_driver);
                } else if (this.classname.equals("oracle.jms.AQjmsXAQueueConnectionFactory")) {
                    aQjmsConnectionFactory = this.jdbc_conn_str != null ? new AQjmsXAQueueConnectionFactory(this.jdbc_conn_str, this.jdbc_info) : new AQjmsXAQueueConnectionFactory(this.hostname, this.oracle_sid, this.portno, this.jdbc_driver);
                } else if (this.classname.equals("oracle.jms.AQjmsXATopicConnectionFactory")) {
                    aQjmsConnectionFactory = this.jdbc_conn_str != null ? new AQjmsXATopicConnectionFactory(this.jdbc_conn_str, this.jdbc_info) : new AQjmsXATopicConnectionFactory(this.hostname, this.oracle_sid, this.portno, this.jdbc_driver);
                } else if (this.classname.equals("oracle.jms.AQjmsXAConnectionFactory")) {
                    aQjmsConnectionFactory = this.jdbc_conn_str != null ? new AQjmsXAConnectionFactory(this.jdbc_conn_str, this.jdbc_info) : new AQjmsXAConnectionFactory(this.hostname, this.oracle_sid, this.portno, this.jdbc_driver);
                }
            }
        }
        catch (NamingException namingException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnectionFactory.getObjectInstance", namingException);
            AQjmsError.throwEx(205, (Throwable)namingException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConnectionFactory.getObjectInstance", "exit");
        return aQjmsConnectionFactory;
    }

    public Connection createConnection() throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            aQjmsConnection = new AQjmsConnection(this.data_source, null, null, 30);
        } else {
            aQjmsConnection = this.jdbc_conn_str != null ? new AQjmsConnection(this.jdbc_conn_str, this.jdbc_info, 30) : (this.data_source != null ? new AQjmsConnection(this.data_source, null, null, 30) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 30));
        }
        aQjmsConnection.setCompliant(this.compliant);
        AQjmsOracleDebug.trace(5, "AQjmConnectionFactory.createConnection", "Connection created successfully");
        return aQjmsConnection;
    }

    public Connection createConnection(String string, String string2) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        AQjmsOracleDebug.trace(5, "AQjmsConnectionFactory.createConnection", "with user/pwd");
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            aQjmsConnection = new AQjmsConnection(this.data_source, string, string2, 30);
        } else {
            Properties properties = null;
            if (this.jdbc_conn_str != null) {
                if (this.jdbc_info != null) {
                    if (string != null || string2 != null) {
                        properties = (Properties)this.jdbc_info.clone();
                        properties.put("user", string);
                        properties.put(PASSWORD_ATTR, string2);
                    } else {
                        properties = this.jdbc_info;
                    }
                    aQjmsConnection = new AQjmsConnection(this.jdbc_conn_str, properties, 30);
                } else {
                    aQjmsConnection = new AQjmsConnection(this.jdbc_conn_str, string, string2, 30);
                }
            } else {
                aQjmsConnection = this.data_source != null ? new AQjmsConnection(this.data_source, string, string2, 30) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, string, string2, this.jdbc_driver, 30);
            }
        }
        aQjmsConnection.setCompliant(this.compliant);
        AQjmsOracleDebug.trace(5, "AQjmsConnectionFactory.createConnection w/username/password", "Connection created successfully");
        return aQjmsConnection;
    }

    boolean getCompliant() {
        return this.compliant;
    }

    void setCompliant(boolean bl) {
        this.compliant = bl;
        AQjmsOracleDebug.trace(4, "AQjmsConnectionFactory.setCompliant", "Current <compliant> is set to:" + bl);
    }
}

