/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import oracle.jdbc.aq.AQAgent;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.internal.JMSConsumerExceptionListener;
import oracle.jdbc.internal.JMSMessageProperties;
import oracle.jdbc.internal.JMSNotificationEvent;
import oracle.jdbc.internal.JMSNotificationListener;
import oracle.jdbc.internal.JMSNotificationRegistration;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsConsumer;
import oracle.jms.AQjmsConsumerExceptionListener;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsObject;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsUtil;

class AQjmsNtfRegistration
extends AQjmsObject {
    private AQjmsSession session;
    private AQjmsConsumer consumer;
    private MessageListener msgListener;
    private JMSNotificationRegistration registration;
    private AQjmsNotificationListener aqjmsListener;
    private AQjmsConsumerExceptionListener consumerExcpListener;
    private byte[] lastMessageID;

    AQjmsNtfRegistration(AQjmsConsumer aQjmsConsumer, AQjmsSession aQjmsSession, MessageListener messageListener) throws JMSException {
        super("AQjmsNtfRegistration", aQjmsConsumer);
        this.consumer = aQjmsConsumer;
        this.session = aQjmsSession;
        this.msgListener = messageListener;
        this.aqjmsListener = new AQjmsNotificationListener();
    }

    synchronized void registerJdbcNotification() throws JMSException {
        Object object;
        Object object2;
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.registerJdbcNotification", "entry");
        AQjmsDestination aQjmsDestination = this.consumer.cons_dest;
        String string = aQjmsDestination.getCompleteName();
        String string2 = null;
        string2 = aQjmsDestination.isTopic() ? string + ":" + this.consumer.cons_name : string;
        String[] stringArray = new String[]{string2};
        HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
        Properties properties = new Properties();
        properties.setProperty("NTF_AQ_PAYLOAD", "true");
        properties.setProperty("NTF_QOS_SECURE", "true");
        properties.setProperty("NTF_ASYNC_DEQ", "true");
        properties.setProperty("NTF_QOS_TX_ACK", "true");
        try {
            object2 = AQjmsUtil.getSystemProperty("oracle.jms.max_ntf_connections");
            if (object2 != null) {
                object = new Properties();
                ((Properties)object).setProperty("MAX_NTF_CONNECTIONS", (String)object2);
                hashMap.put("NOTIFICATION", (Properties)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        hashMap.put(string2, properties);
        object2 = null;
        try {
            AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.registerJdbcNotification", "before session.registerJMSNotification, name: " + stringArray[0]);
            object = null;
            if (this.consumer.getAQjmsSelector() != null) {
                object = this.consumer.getAQjmsSelector().getRule();
            }
            AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.registerJdbcNotification", "selectorRule: " + (String)object);
            object2 = this.session.registerJMSNotification(stringArray, hashMap, (String)object);
            this.registration = (JMSNotificationRegistration)object2.get(string2);
            AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.registerJdbcNotification", "after session.registerJMSNotification, registration: " + this.registration);
            this.registration.addListener((JMSNotificationListener)this.aqjmsListener);
            AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.registerJdbcNotification", "listener added for the registration: " + this.registration);
            this.consumerExcpListener = new AQjmsConsumerExceptionListener(this, this.session);
            this.registration.setConsumerExceptionListener((JMSConsumerExceptionListener)this.consumerExcpListener);
            this.session.addConsumerExcpLsnr(this.consumerExcpListener);
            if (this.isStarted()) {
                this.session.startJMSNotification(this.registration);
                AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.registerJdbcNotification", "state of the registration " + this.registration.getState());
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.registerJdbcNotification", "connection is not yet started, starting the JMS Notification is deferred to the start of the Connection");
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx("Failed to register notification", (Throwable)sQLException);
        }
    }

    void disableConsumerExceptionListener() {
        if (this.consumerExcpListener == null) {
            return;
        }
        this.consumerExcpListener.disable();
    }

    private void unregisterJdbcNotification() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.unregisterJdbcNotification", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.unregisterJdbcNotification", "registration: " + this.registration);
        try {
            this.session.unregisterJMSNotification(this.registration);
            AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.unregisterJdbcNotification", "session.unregisterJMSNotification is done for registration: " + this.registration);
            this.registration = null;
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx("Failed to unregister notification", (Throwable)sQLException);
        }
    }

    synchronized void setMessageListener(MessageListener messageListener) throws JMSException {
        this.msgListener = messageListener;
        if (this.msgListener == null) {
            this.close();
        }
    }

    synchronized MessageListener getMessageListener() {
        return this.msgListener;
    }

    byte[] getLastMessageId() {
        return this.lastMessageID;
    }

    void setLastMessageId(byte[] byArray) {
        this.lastMessageID = byArray;
    }

    JMSNotificationRegistration getJDBCRegistration() {
        return this.registration;
    }

    @Override
    protected synchronized void localClose() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.localClose", "entry");
        this.msgListener = null;
        this.unregisterJdbcNotification();
    }

    private void ackLastJMSNotification(JMSNotificationRegistration.Directive directive) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.ackLastJMSNotification", "entry registration=" + this.registration + " lastMessageID=" + (this.lastMessageID == null ? "null" : RepConversion.bArray2String((byte[])this.lastMessageID)));
        if (this.registration != null && this.lastMessageID != null) {
            try {
                this.session.ackJMSNotification(this.registration, this.lastMessageID, directive);
                AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.ackLastJMSNotification", "after called session.ackJMSNotification");
                this.lastMessageID = null;
            }
            catch (SQLException sQLException) {
                AQjmsError.throwEx("failed to ack last notified message", (Throwable)sQLException);
            }
        } else {
            AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.ackLastJMSNotification", "no registration or last message id is null, nothing needs to be done");
        }
    }

    @Override
    protected void startJMSNotification() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.startJMSNotification", "entry");
        try {
            OracleConnection oracleConnection = (OracleConnection)this.session.getDBConnection();
            oracleConnection.startJMSNotification(this.registration);
            AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.startJMSNotification", "state of the registration " + this.registration.getState());
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx("failed to start the JMS Notification", (Throwable)sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.startJMSNotification", "exit");
    }

    @Override
    protected void stopJMSNotification() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.stopJMSNotification", "entry");
        try {
            OracleConnection oracleConnection = (OracleConnection)this.session.getDBConnection();
            oracleConnection.stopJMSNotification(this.registration);
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx("failed to stop the JMS Notification", (Throwable)sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsNtfRegistration.stopJMSNotification", "exit");
    }

    protected boolean isRegistrationDisabled() throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsNtfRegistration.isRegistrationDisabled", "state of the registration " + this.registration.getState());
        return "DISABLED".equalsIgnoreCase(this.registration.getState().toString());
    }

    static /* synthetic */ byte[] access$502(AQjmsNtfRegistration aQjmsNtfRegistration, byte[] byArray) {
        aQjmsNtfRegistration.lastMessageID = byArray;
        return byArray;
    }

    private class AQjmsNotificationListener
    implements JMSNotificationListener {
        private AQjmsNotificationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onJMSNotification(JMSNotificationEvent jMSNotificationEvent) {
            AQjmsOracleDebug.trace(4, "AQjmsNotificationListener.onJMSNotification", "entry registration" + AQjmsNtfRegistration.this.registration);
            AQjmsNtfRegistration aQjmsNtfRegistration = AQjmsNtfRegistration.this;
            synchronized (aQjmsNtfRegistration) {
                Object object;
                Object object2;
                Object object3;
                if (AQjmsNtfRegistration.this.registration == null) {
                    AQjmsOracleDebug.trace(4, "AQjmsNotificationListener.onJMSNotification", "Received messaged after unregistration");
                    return;
                }
                byte[] byArray = null;
                AQjmsMessage aQjmsMessage = null;
                AQjmsConsumerExceptionListener aQjmsConsumerExceptionListener = null;
                try {
                    aQjmsConsumerExceptionListener = (AQjmsConsumerExceptionListener)AQjmsNtfRegistration.this.registration.getConsumerExceptionListener();
                    if (aQjmsConsumerExceptionListener != null && !aQjmsConsumerExceptionListener.isActive()) {
                        return;
                    }
                    byArray = jMSNotificationEvent.getMessageId();
                    object3 = jMSNotificationEvent.getPayload();
                    JMSMessageProperties jMSMessageProperties = jMSNotificationEvent.getJMSMessageProperties();
                    AQMessageProperties aQMessageProperties = jMSNotificationEvent.getMessageProperties();
                    String string = jMSMessageProperties.getHeaderProperties();
                    object2 = jMSMessageProperties.getUserProperties();
                    object = jMSMessageProperties.getJMSMessageType();
                    int n = object.getCode();
                    int n2 = aQMessageProperties.getPriority();
                    int n3 = aQMessageProperties.getExpiration();
                    String string2 = aQMessageProperties.getCorrelation();
                    AQjmsOracleDebug.trace(5, "AQjmsNotificationListener.onJMSNotification", "msg_id: " + RepConversion.bArray2String((byte[])byArray) + " type: " + n + " corrid: " + string2 + " priority: " + n2 + " headerProperties: " + string + " userProperties: " + (String)object2);
                    aQjmsMessage = AQjmsConsumer.convertToAQjmsMessages(AQjmsNtfRegistration.this.session, n, object3, string, (String)object2, byArray, n2, string2, n3);
                    Timestamp timestamp = aQMessageProperties.getEnqueueTime();
                    long l = timestamp.getTime();
                    aQjmsMessage.setEnqueueTime(l);
                    aQjmsMessage.setMessageState(aQMessageProperties.getState().getCode());
                    int n4 = aQMessageProperties.getDelay();
                    aQjmsMessage.setDelay(n4);
                    int n5 = aQMessageProperties.getExpiration();
                    aQjmsMessage.setJMSExpiration(n5);
                    int n6 = aQMessageProperties.getDequeueAttemptsCount();
                    aQjmsMessage.setAttempts(n6);
                    if (n6 > 0) {
                        aQjmsMessage.setJMSRedelivered(true);
                    } else {
                        aQjmsMessage.setJMSRedelivered(false);
                    }
                    String string3 = aQMessageProperties.getExceptionQueue();
                    aQjmsMessage.setExceptionQueue(string3);
                    AQAgent aQAgent = aQMessageProperties.getSender();
                    if (aQAgent != null && aQAgent.getName() != null && !aQAgent.getName().equals("")) {
                        AQjmsAgent aQjmsAgent = new AQjmsAgent(aQAgent.getName(), aQAgent.getAddress(), aQAgent.getProtocol());
                        aQjmsMessage.setSenderID(aQjmsAgent);
                    }
                    aQjmsMessage.setOriginalMessageId(aQMessageProperties.getPreviousQueueMessageId());
                    if (aQjmsMessage.getJMSExpiration() <= 0L) {
                        aQjmsMessage.setJMSExpiration(0L);
                    } else {
                        aQjmsMessage.setJMSExpiration(aQjmsMessage.getJMSExpiration() * 1000L + aQjmsMessage.getJMSTimestamp());
                    }
                    long l2 = System.currentTimeMillis();
                    aQjmsMessage.setReceiveTime(l2);
                    aQjmsMessage.setPropReadOnly(true);
                    aQjmsMessage.setJMSDestination((Destination)((AQjmsNtfRegistration)AQjmsNtfRegistration.this).consumer.cons_dest);
                }
                catch (Exception exception) {
                    AQjmsOracleDebug.traceEx(3, "AQjmsNotificationListener.onJMSNotification: Got Exception when fetching message from JMSNotificationEvent " + jMSNotificationEvent, exception);
                    throw new RuntimeException(exception);
                }
                object3 = null;
                try {
                    if (AQjmsNtfRegistration.this.isClosed() || AQjmsNtfRegistration.this.msgListener == null) {
                        AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "consumer is closed or listener is set to null");
                        return;
                    }
                    AQjmsNtfRegistration.access$502(AQjmsNtfRegistration.this, byArray);
                    try {
                        AQjmsNtfRegistration.this.session.lock("AQjmsNotificationListener.onJMSNotification", -1L);
                        AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "locked the session");
                    }
                    catch (IllegalStateException illegalStateException) {
                        AQjmsOracleDebug.traceEx(3, "AQjmsNotificationListener.onJMSNotification: Got IllegalStateException when try to lock session", illegalStateException);
                        AQjmsNtfRegistration.this.session.stopListener();
                        return;
                    }
                    AQjmsNtfRegistration.this.session.startListener();
                    AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "before calling onMessage method");
                    AQjmsNtfRegistration.this.msgListener.onMessage((Message)aQjmsMessage);
                    AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "after calling onMessage method");
                }
                catch (Throwable throwable) {
                    object3 = (Object)new AQjmsException("Error in onMessage Method", throwable);
                    AQjmsOracleDebug.traceEx(3, "AQjmsNotificationListener.onJMSNotification: error in onMessage of MessageListener class", (Throwable)object3);
                }
                finally {
                    AQjmsNtfRegistration.this.session.stopListener();
                }
                try {
                    int n = AQjmsNtfRegistration.this.session.getAcknowledgeMode();
                    AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "session.getAcknowledgeMode: " + n);
                    if (n == 1 || n == 3) {
                        if (object3 == null) {
                            AQjmsNtfRegistration.this.ackLastJMSNotification(JMSNotificationRegistration.Directive.COMMIT);
                            AQjmsNtfRegistration.this.session.commitNoCheck();
                            AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "acknowledged the message just received");
                        } else {
                            AQjmsNtfRegistration.this.ackLastJMSNotification(JMSNotificationRegistration.Directive.ROLLBACK);
                            AQjmsNtfRegistration.this.session.forceRollback();
                            AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "recovered the message just received");
                        }
                    }
                }
                catch (JMSException jMSException) {
                    boolean bl = false;
                    try {
                        AQjmsOracleDebug.traceEx(3, "AQjmsNotificationListener.onJMSNotification: error in acknowledgement or recovery after onMessage", jMSException);
                        int n = 0;
                        object2 = jMSException.getLinkedException();
                        if (object2 instanceof SQLException) {
                            object = (SQLException)object2;
                            n = ((SQLException)object).getErrorCode();
                        }
                        if (aQjmsConsumerExceptionListener != null && n == 24035) {
                            aQjmsConsumerExceptionListener.raiseConsumerClosedException(AQjmsNtfRegistration.this.session, ((Throwable)object2).getMessage());
                        } else if (aQjmsConsumerExceptionListener != null && n == 24010) {
                            aQjmsConsumerExceptionListener.raiseDestinationClosedException(AQjmsNtfRegistration.this.session, ((Throwable)object2).getMessage());
                        } else {
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                    if (bl) {
                        throw new RuntimeException(jMSException);
                    }
                }
                catch (Exception exception) {
                    AQjmsOracleDebug.traceEx(3, "AQjmsNotificationListener.onJMSNotification: error in acknowledgement or recovery after onMessage", exception);
                    throw new RuntimeException(exception);
                }
                finally {
                    AQjmsNtfRegistration.this.session.unlock("AQjmsNotificationListener.onJMSNotification");
                    AQjmsOracleDebug.trace(3, "AQjmsNotificationListener.onJMSNotification", "unlocked the session");
                }
            }
        }
    }
}

