/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jdbc.xa.client.OracleXADataSource;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGeneralDBConnection;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsUtil;

class AQjmsDBConnMgr {
    private String oracle_sid;
    private String hostname;
    private int portno;
    private String user;
    private String password;
    private String driver = "";
    private String jdbc_url;
    private Properties jdbc_info;
    private short dbversion;
    private AQjmsGeneralDBConnection firstConn;
    private Connection externalConn;
    private boolean externalConnFree;
    private XADataSource xaDS;
    private DataSource data_source;
    private OracleOCIConnectionPool cpool;

    AQjmsDBConnMgr(String string, String string2, int n, String string3, String string4, String string5, boolean bl) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (host,sid,port,user,pass,driver)", "enter: isXA is " + bl);
        this.hostname = string;
        this.oracle_sid = string2;
        this.portno = n;
        this.driver = string5;
        this.user = string3;
        this.password = string4;
        boolean bl2 = false;
        try {
            if (bl) {
                this.xaDS = new OracleXADataSource();
                ((OracleXADataSource)this.xaDS).setURL(AQjmsDBConnMgr.createUrl(string, string2, n, string5));
                ((OracleXADataSource)this.xaDS).setUser(string3);
                ((OracleXADataSource)this.xaDS).setPassword(string4);
                this.setNativeXA((OracleXADataSource)this.xaDS);
                this.firstConn = this.getConnection(false);
            } else if (string5.equalsIgnoreCase("oci8") || string5.equalsIgnoreCase("oci")) {
                String string6 = AQjmsDBConnMgr.createUrl(string, string2, n, "oci8");
                this.cpool = AQjmsDBConnMgr.createPool(string3, string4, string6, null);
                this.driver = "oci8";
            } else {
                this.firstConn = this.getConnection(false);
            }
            bl2 = true;
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: ctor (host,sid,port,user,pass,driver)", sQLException);
            throw new AQjmsException(sQLException);
        }
        finally {
            if (!bl2) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (host,sid,port,user,pass,driver)", "exit");
    }

    AQjmsDBConnMgr(String string, Properties properties, boolean bl) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (url,info)", "enter: isXA is " + bl);
        this.jdbc_url = string;
        this.jdbc_info = properties;
        if (properties != null) {
            this.user = properties.getProperty("user");
        }
        boolean bl2 = false;
        try {
            if (bl) {
                this.xaDS = new OracleXADataSource();
                ((OracleXADataSource)this.xaDS).setURL(string);
                ((OracleXADataSource)this.xaDS).setConnectionProperties(properties);
                this.setNativeXA((OracleXADataSource)this.xaDS);
                this.firstConn = this.getConnection(false);
            } else {
                this.driver = this.getDriverFromUrl(string);
                if (this.driver.equals("oci8") || this.driver.equals("oci")) {
                    this.cpool = AQjmsDBConnMgr.createPool(string, properties);
                } else {
                    this.firstConn = this.getConnection(false);
                }
            }
            bl2 = true;
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: ctor (url, info)", sQLException);
            throw new AQjmsException(sQLException);
        }
        finally {
            if (!bl2) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (url,info)", "exit");
    }

    AQjmsDBConnMgr(String string, String string2, String string3, boolean bl) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (url,username,password)", "enter: isXA is " + bl);
        this.jdbc_url = string;
        this.user = string2;
        this.password = string3;
        this.jdbc_info = new Properties();
        this.jdbc_info.put("user", string2);
        this.jdbc_info.put("password", string3);
        boolean bl2 = false;
        try {
            if (bl) {
                this.xaDS = new OracleXADataSource();
                ((OracleXADataSource)this.xaDS).setURL(string);
                ((OracleXADataSource)this.xaDS).setUser(this.user);
                ((OracleXADataSource)this.xaDS).setPassword(string3);
                this.setNativeXA((OracleXADataSource)this.xaDS);
                this.firstConn = this.getConnection(false);
            } else {
                this.driver = this.getDriverFromUrl(string);
                if (this.driver.equals("oci8") || this.driver.equals("oci")) {
                    this.cpool = AQjmsDBConnMgr.createPool(string2, string3, string, null);
                } else {
                    this.firstConn = this.getConnection(false);
                }
            }
            bl2 = true;
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: ctor (url,username,password)", sQLException);
            throw new AQjmsException(sQLException);
        }
        finally {
            if (!bl2) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (url,username,password)", "exit");
    }

    AQjmsDBConnMgr(Connection connection) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (user jdbc conn)", "connection: " + connection);
        this.externalConn = connection;
        this.externalConnFree = true;
        try {
            this.extraInit(connection);
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: constructor (user jdbc conn) ", jMSException);
            throw jMSException;
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (user jdbc conn)", "exit");
    }

    AQjmsDBConnMgr(DataSource dataSource, String string, String string2) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (datasource)", "enter");
        this.data_source = dataSource;
        this.user = string;
        this.password = string2;
        try {
            this.firstConn = this.getConnection(false);
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: constructor (datasource) " + dataSource, jMSException);
            throw jMSException;
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (datasource)", "exit");
    }

    AQjmsDBConnMgr(OracleOCIConnectionPool oracleOCIConnectionPool) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (oci connection pool)", "enter");
        if (oracleOCIConnectionPool == null) {
            AQjmsError.throwEx(111);
        }
        this.user = oracleOCIConnectionPool.getUser();
        this.driver = "oci8";
        this.firstConn = this.getConnection(false);
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (oci connection pool)", "exit");
    }

    AQjmsDBConnMgr(XADataSource xADataSource, String string, String string2) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (XADataSource) " + xADataSource, "enter");
        this.xaDS = xADataSource;
        this.user = string;
        this.password = string2;
        try {
            this.firstConn = this.getConnection(false);
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: constructor (XADataSource) " + xADataSource, jMSException);
            throw jMSException;
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (XADataSource) " + xADataSource, "exit");
    }

    synchronized AQjmsGeneralDBConnection getConnection(boolean bl) throws JMSException {
        AQjmsGeneralDBConnection aQjmsGeneralDBConnection = null;
        try {
            if (this.externalConn != null) {
                if (bl) {
                    AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "use the external connection without usage check");
                    return new AQjmsGeneralDBConnection(this, this.externalConn, true, bl);
                }
                AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "use the external connection with usage check");
                if (this.externalConnFree) {
                    AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "passed usage check, creating from exteranl connection ");
                    this.externalConnFree = false;
                    return new AQjmsGeneralDBConnection(this, this.externalConn, true, bl);
                }
                AQjmsError.throwEx(106);
            }
            if (this.firstConn != null) {
                AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "get the firstConn created during the authentication");
                aQjmsGeneralDBConnection = this.firstConn;
                this.firstConn = null;
                return aQjmsGeneralDBConnection;
            }
            if (this.xaDS != null) {
                AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "Creating from XADataSource");
                aQjmsGeneralDBConnection = this.user != null && this.password != null ? new AQjmsGeneralDBConnection(this, this.xaDS.getXAConnection(this.user, this.password), false, bl) : new AQjmsGeneralDBConnection(this, this.xaDS.getXAConnection(), false, bl);
            } else if (this.cpool != null) {
                AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "Creating from connection pool");
                aQjmsGeneralDBConnection = new AQjmsGeneralDBConnection(this, this.cpool.getConnection(), false, bl);
            } else if (this.data_source != null) {
                AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "Creating from datasource");
                aQjmsGeneralDBConnection = this.user != null && this.password != null ? new AQjmsGeneralDBConnection(this, this.data_source.getConnection(this.user, this.password), false, bl) : new AQjmsGeneralDBConnection(this, this.data_source.getConnection(), false, bl);
            } else if (this.jdbc_url != null) {
                AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "Creating using url");
                DriverManager.registerDriver((Driver)new OracleDriver());
                aQjmsGeneralDBConnection = this.jdbc_info != null ? new AQjmsGeneralDBConnection(this, DriverManager.getConnection(this.jdbc_url, this.jdbc_info), false, bl) : new AQjmsGeneralDBConnection(this, DriverManager.getConnection(this.jdbc_url), false, bl);
            } else {
                AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "Creating from host:" + this.hostname + " sid:" + this.oracle_sid + " port:" + this.portno + " driver: " + this.driver);
                DriverManager.registerDriver((Driver)new OracleDriver());
                String string = AQjmsDBConnMgr.createUrl(this.hostname, this.oracle_sid, this.portno, this.driver);
                aQjmsGeneralDBConnection = new AQjmsGeneralDBConnection(this, DriverManager.getConnection(string, this.user, this.password), false, bl);
            }
            this.extraInit(aQjmsGeneralDBConnection.getDBConnection());
            AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr.getConnection", "generic->DB connection: " + aQjmsGeneralDBConnection.getDBConnection());
            AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr.getConnection", "generic->XA connection: " + aQjmsGeneralDBConnection.getXAConnection());
        }
        catch (SQLException sQLException) {
            if (aQjmsGeneralDBConnection != null) {
                try {
                    aQjmsGeneralDBConnection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            AQjmsDBConnMgr.checkForSecurityException(sQLException);
        }
        catch (Exception exception) {
            if (aQjmsGeneralDBConnection != null) {
                try {
                    aQjmsGeneralDBConnection.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw new AQjmsException("Error creating the db_connection", exception);
        }
        return aQjmsGeneralDBConnection;
    }

    synchronized void releaseExternalConnection() {
        this.externalConnFree = true;
        AQjmsOracleDebug.trace(3, "releaseExternalConnection", "free the external connection");
    }

    void close() throws JMSException {
        Exception exception;
        block7: {
            exception = null;
            try {
                if (this.firstConn != null) {
                    this.firstConn.close();
                }
            }
            catch (Exception exception2) {
                AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: close", exception2);
                exception = exception2;
            }
            try {
                if (this.cpool != null) {
                    this.cpool.close();
                }
            }
            catch (Exception exception3) {
                AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: close", exception3);
                if (exception == null) break block7;
                exception = exception3;
            }
        }
        this.firstConn = null;
        this.cpool = null;
        if (exception != null) {
            throw new AQjmsException("Error in close", exception);
        }
    }

    String getUserName() {
        return this.user;
    }

    String getDriver() {
        return this.driver;
    }

    short getDBVersion() {
        return this.dbversion;
    }

    public OracleOCIConnectionPool getOCIConnectionPool() {
        return this.cpool;
    }

    private String getDriverFromUrl(String string) {
        if (string != null) {
            if ((string = string.toLowerCase().trim()).startsWith("jdbc:oracle:oci") || string.startsWith("jdbc:oracle:oci8")) {
                return "oci8";
            }
            if (string.startsWith("jdbc:oracle:thin")) {
                return "thin";
            }
            return "kprb";
        }
        return "kprb";
    }

    private static String createUrl(String string, String string2, int n, String string3) throws JMSException {
        String string4;
        if (string3.equals("oci8") || string3.equals("oci")) {
            string4 = "jdbc:oracle:oci8:@(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(PORT=" + n + ")(HOST=" + string + "))(CONNECT_DATA=(SID=" + string2 + ")))";
        } else if (string3.equals("thin")) {
            string4 = "jdbc:oracle:thin:@" + string + ":" + n + ":" + string2;
        } else {
            AQjmsError.throwEx(135);
            throw new AQjmsException("unsupported driver", 0);
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr.createUrl", "The connection URL: " + string4);
        return string4;
    }

    private void extraInit(Connection connection) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.extraInit", "enter");
        if (connection == null) {
            AQjmsError.throwEx(111);
        }
        try {
            AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.extraInit", "The connection class: " + connection.getClass().getName());
            if (!(connection instanceof OracleConnection)) {
                AQjmsError.throwEx(112, "db connection is not oracle internal db connection");
            }
            if (this.dbversion == 0) {
                this.dbversion = ((OracleConnection)connection).getVersionNumber();
            }
            if (this.user == null) {
                this.user = ((oracle.jdbc.OracleConnection)connection).getUserName();
            }
            if (this.driver == null || this.driver.equals("")) {
                this.driver = this.getDriverName(connection);
            }
        }
        catch (SQLException sQLException) {
            AQjmsDBConnMgr.checkForSecurityException(sQLException);
        }
        AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.extraInit", "exit");
    }

    private String getDriverName(Connection connection) throws SQLException {
        if (connection instanceof OracleConnection) {
            String string = ((OracleConnection)connection).getURL();
            return this.getDriverFromUrl(string);
        }
        return "";
    }

    private static OracleOCIConnectionPool createPool(String string, Properties properties) throws JMSException {
        String string2 = null;
        String string3 = null;
        if (properties != null) {
            string2 = properties.getProperty("user");
            string3 = properties.getProperty("password");
        }
        return AQjmsDBConnMgr.createPool(string2, string3, string, properties);
    }

    private static OracleOCIConnectionPool createPool(String string, String string2, String string3, Properties properties) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr.createPool", "enter");
        OracleOCIConnectionPool oracleOCIConnectionPool = null;
        if (properties == null) {
            properties = new Properties();
        }
        if (!properties.containsKey("connpool_min_limit")) {
            properties.put("connpool_min_limit", Integer.toString(1));
        }
        if (!properties.containsKey("connpool_increment")) {
            properties.put("connpool_increment", Integer.toString(1));
        }
        if (!properties.containsKey("connpool_max_limit")) {
            properties.put("connpool_max_limit", Integer.toString(50));
        }
        try {
            oracleOCIConnectionPool = new OracleOCIConnectionPool(string, string2, string3, properties);
            if (oracleOCIConnectionPool != null) {
                oracleOCIConnectionPool.setPoolConfig(properties);
            }
        }
        catch (SQLException sQLException) {
            if (oracleOCIConnectionPool != null) {
                try {
                    oracleOCIConnectionPool.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            AQjmsDBConnMgr.checkForSecurityException(sQLException);
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr.createPool", "exit");
        return oracleOCIConnectionPool;
    }

    private static void checkForSecurityException(SQLException sQLException) throws JMSException {
        if (sQLException.getErrorCode() == 1017 || sQLException.getErrorCode() == 17079) {
            throw new JMSSecurityException(AQjmsError.getMessage(232));
        }
        throw new AQjmsException(sQLException);
    }

    private void setNativeXA(OracleXADataSource oracleXADataSource) {
        String string = AQjmsUtil.getSystemProperty("oracle.jms.useNativeXA");
        if (string == null) {
            return;
        }
        oracleXADataSource.setNativeXA(Boolean.valueOf(string).booleanValue());
    }
}

