/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.HIGH_AVAILABILITY})
class ServiceMember {
    private String name;
    private String svc;
    private String db;
    private String hst;
    private boolean restarted;
    int connCount;
    private MemberStatus status;
    private ConcurrentHashMap<OracleConnection, OracleConnection> connections;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Mon_Sep_30_12:02:33_PDT_2019";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    ServiceMember(String string, String string2, String string3, String string4) {
        this.name = string2;
        this.svc = string;
        this.db = string3;
        this.hst = string4;
        this.restarted = false;
        this.connCount = 0;
        this.status = MemberStatus.UNKNOWN;
        this.connections = new ConcurrentHashMap();
    }

    void up() {
        this.status = MemberStatus.UP;
    }

    void down() {
        this.status = MemberStatus.DOWN;
    }

    boolean isDown() {
        return this.status == MemberStatus.DOWN;
    }

    boolean isUp() {
        return this.status == MemberStatus.UP;
    }

    void addConnection(OracleConnection oracleConnection) {
        this.connections.put(oracleConnection, oracleConnection);
        ++this.connCount;
    }

    void dropConnection(OracleConnection oracleConnection) {
        this.connections.remove(oracleConnection);
        if (this.connCount > 0) {
            --this.connCount;
        }
    }

    void cleanupConnections() throws SQLException {
        ConcurrentHashMap<OracleConnection, OracleConnection> concurrentHashMap = this.connections;
        this.connections = new ConcurrentHashMap();
        for (OracleConnection oracleConnection : concurrentHashMap.keySet()) {
            oracleConnection.abort();
            oracleConnection.close();
        }
        this.connCount = 0;
        concurrentHashMap.clear();
    }

    public String getName() {
        return this.name;
    }

    String getDatabase() {
        return this.db;
    }

    @DisableTrace
    public String toString() {
        return "Service name: " + this.svc + ", Instance name: " + this.name + ", Database name: " + this.db + ", Host name: " + this.hst;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            $$$methodRef$$$10 = ServiceMember.class.getDeclaredConstructor(String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ServiceMember.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ServiceMember.class.getDeclaredMethod("getDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ServiceMember.class.getDeclaredMethod("getName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ServiceMember.class.getDeclaredMethod("cleanupConnections", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ServiceMember.class.getDeclaredMethod("dropConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ServiceMember.class.getDeclaredMethod("addConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ServiceMember.class.getDeclaredMethod("isUp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ServiceMember.class.getDeclaredMethod("isDown", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ServiceMember.class.getDeclaredMethod("down", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ServiceMember.class.getDeclaredMethod("up", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ServiceMember"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class MemberStatus
    extends Enum<MemberStatus> {
        public static final /* enum */ MemberStatus UNKNOWN;
        public static final /* enum */ MemberStatus UP;
        public static final /* enum */ MemberStatus DOWN;
        private static final /* synthetic */ MemberStatus[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static MemberStatus[] values() {
            return (MemberStatus[])$VALUES.clone();
        }

        public static MemberStatus valueOf(String string) {
            return Enum.valueOf(MemberStatus.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = MemberStatus.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = MemberStatus.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = MemberStatus.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            UNKNOWN = new MemberStatus();
            UP = new MemberStatus();
            DOWN = new MemberStatus();
            $VALUES = new MemberStatus[]{UNKNOWN, UP, DOWN};
        }
    }
}

