/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.lmx.CoreException;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleNumber;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.Datum;
import oracle.sql.LnxLib;
import oracle.sql.LnxLibThin;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.PRIMITIVE_DATUM})
public class NUMBER
extends Datum
implements OracleNumber {
    private static final byte[] MAX_LONG;
    private static final byte[] MIN_LONG;
    private static final byte[] MAX_INT;
    private static final byte[] MIN_INT;
    private static final byte[] MAX_SHORT;
    private static final byte[] MIN_SHORT;
    private static final byte[] MAX_BYTE;
    private static final byte[] MIN_BYTE;
    private static final int CHARACTER_ZERO = 48;
    private static final BigDecimal BIGDEC_NEGZERO;
    private static final BigDecimal BIGDEC_ZERO;
    private static final BigDecimal BIGDEC_ONE;
    private static final BigInteger BIGINT_ZERO;
    private static final BigInteger BIGINT_HUND;
    private static final byte DIGEND = 21;
    private static final byte ODIGEND = 9;
    private static final int HUNDIGMAX = 66;
    private static final int BIGINTARRAYMAX = 54;
    private static final double BIGRATIO = 0.1505149978319906;
    private static final int BIGLENMAX = 22;
    static final byte LNXM_NUM = 22;
    static final int LNXSGNBT = 128;
    static final byte LNXDIGS = 20;
    static final byte LNXEXPBS = 64;
    static final double ORANUM_FBASE = 100.0;
    static final int LNXBASE = 100;
    static final byte IEEE_DBL_DIG = 15;
    private static final byte IEEE_FLT_DIG = 6;
    static final int LNXEXPMX = 127;
    static final int LNXEXPMN = 0;
    static final int LNXMXOUT = 40;
    static final int LNXMXFMT = 64;
    private static final byte[] PI;
    private static final byte[] E;
    private static final byte[] LN10;
    private static LnxLib _slnxlib;
    private static LnxLib _thinlib;
    private static int DBL_MAX;
    private static int INT_MAX;
    private static float FLOAT_MAX_INT;
    private static float FLOAT_MIN_INT;
    private static double DOUBLE_MAX_INT;
    private static double DOUBLE_MIN_INT;
    private static double DOUBLE_MAX_INT_2;
    private static double DOUBLE_MIN_INT_2;
    private static String LANGID;
    static final long serialVersionUID = -1656085588913430059L;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;
    private static Executable $$$methodRef$$$75;
    private static Logger $$$loggerRef$$$75;
    private static Executable $$$methodRef$$$76;
    private static Logger $$$loggerRef$$$76;
    private static Executable $$$methodRef$$$77;
    private static Logger $$$loggerRef$$$77;
    private static Executable $$$methodRef$$$78;
    private static Logger $$$loggerRef$$$78;
    private static Executable $$$methodRef$$$79;
    private static Logger $$$loggerRef$$$79;
    private static Executable $$$methodRef$$$80;
    private static Logger $$$loggerRef$$$80;
    private static Executable $$$methodRef$$$81;
    private static Logger $$$loggerRef$$$81;
    private static Executable $$$methodRef$$$82;
    private static Logger $$$loggerRef$$$82;
    private static Executable $$$methodRef$$$83;
    private static Logger $$$loggerRef$$$83;
    private static Executable $$$methodRef$$$84;
    private static Logger $$$loggerRef$$$84;
    private static Executable $$$methodRef$$$85;
    private static Logger $$$loggerRef$$$85;
    private static Executable $$$methodRef$$$86;
    private static Logger $$$loggerRef$$$86;
    private static Executable $$$methodRef$$$87;
    private static Logger $$$loggerRef$$$87;
    private static Executable $$$methodRef$$$88;
    private static Logger $$$loggerRef$$$88;
    private static Executable $$$methodRef$$$89;
    private static Logger $$$loggerRef$$$89;
    private static Executable $$$methodRef$$$90;
    private static Logger $$$loggerRef$$$90;
    private static Executable $$$methodRef$$$91;
    private static Logger $$$loggerRef$$$91;
    private static Executable $$$methodRef$$$92;
    private static Logger $$$loggerRef$$$92;
    private static Executable $$$methodRef$$$93;
    private static Logger $$$loggerRef$$$93;
    private static Executable $$$methodRef$$$94;
    private static Logger $$$loggerRef$$$94;
    private static Executable $$$methodRef$$$95;
    private static Logger $$$loggerRef$$$95;
    private static Executable $$$methodRef$$$96;
    private static Logger $$$loggerRef$$$96;
    private static Executable $$$methodRef$$$97;
    private static Logger $$$loggerRef$$$97;
    private static Executable $$$methodRef$$$98;
    private static Logger $$$loggerRef$$$98;
    private static Executable $$$methodRef$$$99;
    private static Logger $$$loggerRef$$$99;
    private static Executable $$$methodRef$$$100;
    private static Logger $$$loggerRef$$$100;
    private static Executable $$$methodRef$$$101;
    private static Logger $$$loggerRef$$$101;
    private static Executable $$$methodRef$$$102;
    private static Logger $$$loggerRef$$$102;
    private static Executable $$$methodRef$$$103;
    private static Logger $$$loggerRef$$$103;
    private static Executable $$$methodRef$$$104;
    private static Logger $$$loggerRef$$$104;
    private static Executable $$$methodRef$$$105;
    private static Logger $$$loggerRef$$$105;
    private static Executable $$$methodRef$$$106;
    private static Logger $$$loggerRef$$$106;
    private static Executable $$$methodRef$$$107;
    private static Logger $$$loggerRef$$$107;
    private static Executable $$$methodRef$$$108;
    private static Logger $$$loggerRef$$$108;
    private static Executable $$$methodRef$$$109;
    private static Logger $$$loggerRef$$$109;
    private static Executable $$$methodRef$$$110;
    private static Logger $$$loggerRef$$$110;
    private static Executable $$$methodRef$$$111;
    private static Logger $$$loggerRef$$$111;
    private static Executable $$$methodRef$$$112;
    private static Logger $$$loggerRef$$$112;
    private static Executable $$$methodRef$$$113;
    private static Logger $$$loggerRef$$$113;

    public NUMBER() {
        super(NUMBER._makeZero());
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$101, Level.FINEST, NUMBER.class, $$$methodRef$$$101, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$101, Level.FINEST, NUMBER.class, $$$methodRef$$$101, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$101, Level.FINEST, NUMBER.class, $$$methodRef$$$101, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$101, Level.FINEST, NUMBER.class, $$$methodRef$$$101, null, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER(byte[] byArray) {
        super(byArray);
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$102, Level.FINEST, NUMBER.class, $$$methodRef$$$102, null, new Object[]{byArray});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$102, Level.FINEST, NUMBER.class, $$$methodRef$$$102, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$102, Level.FINEST, NUMBER.class, $$$methodRef$$$102, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$102, Level.FINEST, NUMBER.class, $$$methodRef$$$102, null, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER(byte by) {
        super(NUMBER.toBytes(by));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$103, Level.FINEST, NUMBER.class, $$$methodRef$$$103, null, by);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$103, Level.FINEST, NUMBER.class, $$$methodRef$$$103, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$103, Level.FINEST, NUMBER.class, $$$methodRef$$$103, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$103, Level.FINEST, NUMBER.class, $$$methodRef$$$103, null, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER(int n2) {
        super(NUMBER.toBytes(n2));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$104, Level.FINEST, NUMBER.class, $$$methodRef$$$104, null, n2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$104, Level.FINEST, NUMBER.class, $$$methodRef$$$104, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$104, Level.FINEST, NUMBER.class, $$$methodRef$$$104, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$104, Level.FINEST, NUMBER.class, $$$methodRef$$$104, null, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER(long l2) {
        super(NUMBER.toBytes(l2));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$105, Level.FINEST, NUMBER.class, $$$methodRef$$$105, null, l2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$105, Level.FINEST, NUMBER.class, $$$methodRef$$$105, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$105, Level.FINEST, NUMBER.class, $$$methodRef$$$105, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$105, Level.FINEST, NUMBER.class, $$$methodRef$$$105, null, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER(short s2) {
        super(NUMBER.toBytes(s2));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$106, Level.FINEST, NUMBER.class, $$$methodRef$$$106, null, s2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$106, Level.FINEST, NUMBER.class, $$$methodRef$$$106, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$106, Level.FINEST, NUMBER.class, $$$methodRef$$$106, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$106, Level.FINEST, NUMBER.class, $$$methodRef$$$106, null, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER(float f2) {
        super(NUMBER.toBytes(f2));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$107, Level.FINEST, NUMBER.class, $$$methodRef$$$107, null, Float.valueOf(f2));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$107, Level.FINEST, NUMBER.class, $$$methodRef$$$107, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$107, Level.FINEST, NUMBER.class, $$$methodRef$$$107, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$107, Level.FINEST, NUMBER.class, $$$methodRef$$$107, null, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER(double d2) throws SQLException {
        super(NUMBER.toBytes(d2));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$108, Level.FINEST, NUMBER.class, $$$methodRef$$$108, null, d2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$108, Level.FINEST, NUMBER.class, $$$methodRef$$$108, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$108, Level.FINEST, NUMBER.class, $$$methodRef$$$108, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$108, Level.FINEST, NUMBER.class, $$$methodRef$$$108, null, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER(BigDecimal bigDecimal) throws SQLException {
        super(NUMBER.toBytes(bigDecimal));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$109, Level.FINEST, NUMBER.class, $$$methodRef$$$109, null, bigDecimal);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$109, Level.FINEST, NUMBER.class, $$$methodRef$$$109, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$109, Level.FINEST, NUMBER.class, $$$methodRef$$$109, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$109, Level.FINEST, NUMBER.class, $$$methodRef$$$109, null, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER(BigInteger bigInteger) throws SQLException {
        super(NUMBER.toBytes(bigInteger));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$110, Level.FINEST, NUMBER.class, $$$methodRef$$$110, null, bigInteger);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$110, Level.FINEST, NUMBER.class, $$$methodRef$$$110, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$110, Level.FINEST, NUMBER.class, $$$methodRef$$$110, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$110, Level.FINEST, NUMBER.class, $$$methodRef$$$110, null, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER(String string, int n2) throws SQLException {
        super(NUMBER.toBytes(string, n2));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$111, Level.FINEST, NUMBER.class, $$$methodRef$$$111, null, string, n2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$111, Level.FINEST, NUMBER.class, $$$methodRef$$$111, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$111, Level.FINEST, NUMBER.class, $$$methodRef$$$111, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$111, Level.FINEST, NUMBER.class, $$$methodRef$$$111, null, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER(boolean bl) {
        super(NUMBER.toBytes(bl));
        boolean bl2 = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$112, Level.FINEST, NUMBER.class, $$$methodRef$$$112, null, bl);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$112, Level.FINEST, NUMBER.class, $$$methodRef$$$112, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$112, Level.FINEST, NUMBER.class, $$$methodRef$$$112, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$112, Level.FINEST, NUMBER.class, $$$methodRef$$$112, null, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER(Object object) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$113, Level.FINEST, NUMBER.class, $$$methodRef$$$113, null, object);
            }
            if (object instanceof Integer) {
                this.setShareBytes(NUMBER.toBytes((Integer)object));
            } else if (object instanceof Long) {
                this.setShareBytes(NUMBER.toBytes((Long)object));
            } else if (object instanceof Float) {
                this.setShareBytes(NUMBER.toBytes(((Float)object).floatValue()));
            } else if (object instanceof Double) {
                this.setShareBytes(NUMBER.toBytes((Double)object));
            } else if (object instanceof BigInteger) {
                this.setShareBytes(NUMBER.toBytes((BigInteger)object));
            } else if (object instanceof BigDecimal) {
                this.setShareBytes(NUMBER.toBytes((BigDecimal)object));
            } else if (object instanceof Boolean) {
                this.setShareBytes(NUMBER.toBytes((Boolean)object));
            } else if (object instanceof String) {
                this.setShareBytes(this.stringToBytes((String)object));
            } else if (object instanceof Short) {
                this.setShareBytes(NUMBER.toBytes((Short)object));
            } else if (object instanceof Byte) {
                this.setShareBytes(NUMBER.toBytes((Byte)object));
            } else {
                SQLException sQLException = new SQLException("Initialization failed");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$113, Level.FINEST, NUMBER.class, $$$methodRef$$$113, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$113, Level.FINEST, NUMBER.class, $$$methodRef$$$113, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$113, Level.FINEST, NUMBER.class, $$$methodRef$$$113, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$113, Level.FINEST, NUMBER.class, $$$methodRef$$$113, null, throwable2);
            }
            throw throwable;
        }
    }

    public static double toDouble(byte[] byArray) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            double d2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NUMBER.class, $$$methodRef$$$0, null, new Object[]{byArray});
            }
            if (NUMBER._isZero(byArray)) {
                double d3 = 0.0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NUMBER.class, $$$methodRef$$$0, null, d3);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NUMBER.class, $$$methodRef$$$0, null, null);
                }
                return 0.0;
            }
            if (NUMBER._isPosInf(byArray)) {
                double d4 = Double.POSITIVE_INFINITY;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NUMBER.class, $$$methodRef$$$0, null, d4);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NUMBER.class, $$$methodRef$$$0, null, null);
                }
                return Double.POSITIVE_INFINITY;
            }
            if (NUMBER._isNegInf(byArray)) {
                double d5 = Double.NEGATIVE_INFINITY;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NUMBER.class, $$$methodRef$$$0, null, d5);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NUMBER.class, $$$methodRef$$$0, null, null);
                }
                return Double.NEGATIVE_INFINITY;
            }
            String string = null;
            try {
                string = _slnxlib.lnxnuc(byArray, DBL_MAX, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            double d6 = d2 = Double.valueOf(string).doubleValue();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NUMBER.class, $$$methodRef$$$0, null, d6);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NUMBER.class, $$$methodRef$$$0, null, null);
            }
            return d6;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NUMBER.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    public static float toFloat(byte[] byArray) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NUMBER.class, $$$methodRef$$$1, null, new Object[]{byArray});
            }
            float f2 = (float)NUMBER.toDouble(byArray);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NUMBER.class, $$$methodRef$$$1, null, Float.valueOf(f2));
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NUMBER.class, $$$methodRef$$$1, null, null);
            }
            return f2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NUMBER.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    private static long toLongInternal(byte[] byArray, byte[] byArray2, byte[] byArray3) throws SQLException {
        if (NUMBER._isZero(byArray)) {
            return 0L;
        }
        if (NUMBER._isInf(byArray) || NUMBER.compareBytes(byArray, byArray2) > 0 || NUMBER.compareBytes(byArray, byArray3) < 0) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        return NUMBER._getLnxLib().lnxsni(byArray);
    }

    public static long toLong(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NUMBER.class, $$$methodRef$$$3, null, new Object[]{byArray});
            }
            long l2 = NUMBER.toLongInternal(byArray, MAX_LONG, MIN_LONG);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NUMBER.class, $$$methodRef$$$3, null, l2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NUMBER.class, $$$methodRef$$$3, null, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NUMBER.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    public static int toInt(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NUMBER.class, $$$methodRef$$$4, null, new Object[]{byArray});
            }
            int n2 = (int)NUMBER.toLongInternal(byArray, MAX_INT, MIN_INT);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NUMBER.class, $$$methodRef$$$4, null, n2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NUMBER.class, $$$methodRef$$$4, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NUMBER.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    public static short toShort(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NUMBER.class, $$$methodRef$$$5, null, new Object[]{byArray});
            }
            short s2 = (short)NUMBER.toLongInternal(byArray, MAX_SHORT, MIN_SHORT);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NUMBER.class, $$$methodRef$$$5, null, s2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NUMBER.class, $$$methodRef$$$5, null, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NUMBER.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte toByte(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NUMBER.class, $$$methodRef$$$6, null, new Object[]{byArray});
            }
            byte by = (byte)NUMBER.toLongInternal(byArray, MAX_BYTE, MIN_BYTE);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NUMBER.class, $$$methodRef$$$6, null, by);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NUMBER.class, $$$methodRef$$$6, null, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NUMBER.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    public static BigInteger toBigInteger(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NUMBER.class, $$$methodRef$$$7, null, new Object[]{byArray});
            }
            long[] lArray = new long[10];
            int n3 = 9;
            int n4 = 1;
            int n5 = 0;
            if (NUMBER._isZero(byArray)) {
                return BIGINT_ZERO;
            }
            if (NUMBER._isInf(byArray)) {
                SQLException sQLException = new SQLException(CoreException.getMessage((byte)3));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, NUMBER.class, $$$methodRef$$$7, null, sQLException);
                }
                throw sQLException;
            }
            boolean bl2 = NUMBER._isPositive(byArray);
            byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
            if (byArray2[0] < 0) {
                return BIGINT_ZERO;
            }
            int n6 = n2 = Math.min(byArray2[0] + 1, byArray2.length - 1);
            if ((n2 & 1) == 1) {
                lArray[n3] = byArray2[n4];
                n4 = (byte)(n4 + 1);
                --n6;
            } else {
                lArray[n3] = byArray2[n4] * 100 + byArray2[n4 + 1];
                n4 = (byte)(n4 + 2);
                n6 -= 2;
            }
            int n7 = n3;
            while (n6 != 0) {
                long l2 = byArray2[n4] * 100 + byArray2[n4 + 1];
                for (n3 = 9; n3 >= n7; n3 = (int)((byte)(n3 - 1))) {
                    lArray[n3] = (l2 += lArray[n3] * 10000L) & 0xFFFFL;
                    l2 >>= 16;
                }
                if (l2 != 0L) {
                    // empty if block
                }
                n7 = (byte)(n7 - 1);
                lArray[n7] = l2;
                n4 = (byte)(n4 + 2);
                n6 -= 2;
            }
            int n8 = lArray[n7] >> 8 != 0L ? 2 * (9 - n7) + 2 : 2 * (9 - n7) + 1;
            byte[] byArray3 = new byte[n8];
            if ((n8 & 1) == 1) {
                byArray3[n5] = (byte)lArray[n7];
                ++n5;
            } else {
                byArray3[n5] = (byte)(lArray[n7] >> 8);
                byArray3[++n5] = (byte)(lArray[n7] & 0xFFL);
                ++n5;
            }
            for (n7 = (int)((byte)(n7 + 1)); n7 <= 9; n7 = (int)((byte)(n7 + 1))) {
                byArray3[n5] = (byte)(lArray[n7] >> 8);
                byArray3[n5 + 1] = (byte)(lArray[n7] & 0xFFL);
                n5 += 2;
            }
            BigInteger bigInteger = new BigInteger(bl2 ? 1 : -1, byArray3);
            int n9 = byArray2[0] - (n2 - 1);
            return bigInteger.multiply(BIGINT_HUND.pow(n9));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NUMBER.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    public static BigDecimal toBigDecimal(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NUMBER.class, $$$methodRef$$$8, null, new Object[]{byArray});
            }
            long[] lArray = new long[10];
            int n3 = 9;
            int n4 = 1;
            int n5 = 0;
            if (NUMBER._isZero(byArray)) {
                return BIGDEC_ZERO;
            }
            if (NUMBER._isInf(byArray)) {
                SQLException sQLException = new SQLException(CoreException.getMessage((byte)3));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, NUMBER.class, $$$methodRef$$$8, null, sQLException);
                }
                throw sQLException;
            }
            boolean bl2 = NUMBER._isPositive(byArray);
            byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
            int n6 = n2 = byArray2.length - 1;
            if ((n2 & 1) == 1) {
                lArray[n3] = byArray2[n4];
                n4 = (byte)(n4 + 1);
                --n6;
            } else {
                lArray[n3] = byArray2[n4] * 100 + byArray2[n4 + 1];
                n4 = (byte)(n4 + 2);
                n6 -= 2;
            }
            int n7 = n3;
            while (n6 != 0) {
                long l2 = byArray2[n4] * 100 + byArray2[n4 + 1];
                for (n3 = 9; n3 >= n7; n3 = (int)((byte)(n3 - 1))) {
                    lArray[n3] = (l2 += lArray[n3] * 10000L) & 0xFFFFL;
                    l2 >>= 16;
                }
                if (l2 != 0L) {
                    // empty if block
                }
                n7 = (byte)(n7 - 1);
                lArray[n7] = l2;
                n4 = (byte)(n4 + 2);
                n6 -= 2;
            }
            int n8 = lArray[n7] >> 8 != 0L ? 2 * (9 - n7) + 2 : 2 * (9 - n7) + 1;
            byte[] byArray3 = new byte[n8];
            if ((n8 & 1) == 1) {
                byArray3[n5] = (byte)lArray[n7];
                ++n5;
            } else {
                byArray3[n5] = (byte)(lArray[n7] >> 8);
                byArray3[++n5] = (byte)(lArray[n7] & 0xFFL);
                ++n5;
            }
            for (n7 = (int)((byte)(n7 + 1)); n7 <= 9; n7 = (int)((byte)(n7 + 1))) {
                byArray3[n5] = (byte)(lArray[n7] >> 8);
                byArray3[n5 + 1] = (byte)(lArray[n7] & 0xFFL);
                n5 += 2;
            }
            BigInteger bigInteger = new BigInteger(bl2 ? 1 : -1, byArray3);
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            int n9 = byArray2[0] - n2 + 1;
            bigDecimal = bigDecimal.movePointRight(n9 * 2);
            if (n9 < 0 && byArray2[n2] % 10 == 0) {
                bigDecimal = bigDecimal.setScale(-(n9 * 2 + 1));
            }
            return bigDecimal;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NUMBER.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public static String toString(byte[] byArray) {
        int n2;
        int n3 = 0;
        if (NUMBER._isZero(byArray)) {
            return "0";
        }
        if (NUMBER._isPosInf(byArray)) {
            return new Double(Double.POSITIVE_INFINITY).toString();
        }
        if (NUMBER._isNegInf(byArray)) {
            return new Double(Double.NEGATIVE_INFINITY).toString();
        }
        if (!NUMBER.isValid(byArray)) {
            throw new IllegalArgumentException(CoreException.getMessage((byte)11));
        }
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        int n4 = byArray2[0];
        int n5 = n4 - ((n2 = byArray2.length - 1) - 1);
        int n6 = n5 >= 0 ? 2 * (n4 + 1) + 1 : (n4 >= 0 ? 2 * (n2 + 1) : 2 * (n2 - n4) + 3);
        char[] cArray = new char[n6];
        if (!NUMBER._isPositive(byArray)) {
            cArray[n3++] = 45;
        }
        if (n5 >= 0) {
            n3 += NUMBER._byteToChars(byArray2[1], cArray, n3);
            int n7 = 2;
            while (n7 <= n2) {
                NUMBER._byteTo2Chars(byArray2[n7], cArray, n3);
                n3 += 2;
                ++n7;
                --n4;
            }
            if (n4 > 0) {
                while (n4 > 0) {
                    cArray[n3++] = 48;
                    cArray[n3++] = 48;
                    --n4;
                }
            }
        } else {
            int n8 = n2 + n5;
            if (n8 > 0) {
                int n9;
                n3 += NUMBER._byteToChars(byArray2[1], cArray, n3);
                if (n8 == 1) {
                    cArray[n3++] = 46;
                }
                for (n9 = 2; n9 < n2; ++n9) {
                    NUMBER._byteTo2Chars(byArray2[n9], cArray, n3);
                    n3 += 2;
                    if (n8 != n9) continue;
                    cArray[n3++] = 46;
                }
                if (byArray2[n9] % 10 == 0) {
                    n3 += NUMBER._byteToChars((byte)(byArray2[n9] / 10), cArray, n3);
                } else {
                    NUMBER._byteTo2Chars(byArray2[n9], cArray, n3);
                    n3 += 2;
                }
            } else {
                int n10;
                cArray[n3++] = 48;
                cArray[n3++] = 46;
                while (n8 < 0) {
                    cArray[n3++] = 48;
                    cArray[n3++] = 48;
                    ++n8;
                }
                for (n10 = 1; n10 < n2; ++n10) {
                    NUMBER._byteTo2Chars(byArray2[n10], cArray, n3);
                    n3 += 2;
                }
                if (byArray2[n10] % 10 == 0) {
                    n3 += NUMBER._byteToChars((byte)(byArray2[n10] / 10), cArray, n3);
                } else {
                    NUMBER._byteTo2Chars(byArray2[n10], cArray, n3);
                    n3 += 2;
                }
            }
        }
        return new String(cArray, 0, n3);
    }

    public static boolean toBoolean(byte[] byArray) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NUMBER.class, $$$methodRef$$$9, null, new Object[]{byArray});
            }
            if (NUMBER._isZero(byArray)) {
                boolean bl2 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NUMBER.class, $$$methodRef$$$9, null, bl2);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NUMBER.class, $$$methodRef$$$9, null, null);
                }
                return false;
            }
            boolean bl3 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NUMBER.class, $$$methodRef$$$9, null, bl3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NUMBER.class, $$$methodRef$$$9, null, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NUMBER.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(double d2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NUMBER.class, $$$methodRef$$$10, null, d2);
            }
            if (Double.isNaN(d2)) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(CoreException.getMessage((byte)11));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, NUMBER.class, $$$methodRef$$$10, null, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            if (d2 == 0.0 || d2 == -0.0) {
                return NUMBER._makeZero();
            }
            if (d2 == Double.POSITIVE_INFINITY) {
                return NUMBER._makePosInf();
            }
            if (d2 == Double.NEGATIVE_INFINITY) {
                return NUMBER._makeNegInf();
            }
            return NUMBER._getThinLib().lnxren(d2);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NUMBER.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(float f2) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NUMBER.class, $$$methodRef$$$11, null, Float.valueOf(f2));
            }
            if (Float.isNaN(f2)) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(CoreException.getMessage((byte)11));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, NUMBER.class, $$$methodRef$$$11, null, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            if (f2 == 0.0f || f2 == -0.0f) {
                return NUMBER._makeZero();
            }
            if (f2 == Float.POSITIVE_INFINITY) {
                return NUMBER._makePosInf();
            }
            if (f2 == Float.NEGATIVE_INFINITY) {
                return NUMBER._makeNegInf();
            }
            String string = Float.toString(f2);
            try {
                return NUMBER._getLnxLib().lnxcpn(string, false, 0, false, 0, "AMERICAN_AMERICA");
            }
            catch (Exception exception) {
                return null;
            }
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NUMBER.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(long l2) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NUMBER.class, $$$methodRef$$$12, null, l2);
            }
            return NUMBER._getLnxLib().lnxmin(l2);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NUMBER.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(int n2) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, NUMBER.class, $$$methodRef$$$13, null, n2);
            }
            return NUMBER.toBytes((long)n2);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NUMBER.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(short s2) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, NUMBER.class, $$$methodRef$$$14, null, s2);
            }
            return NUMBER.toBytes((long)s2);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NUMBER.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(byte by) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, NUMBER.class, $$$methodRef$$$15, null, by);
            }
            return NUMBER.toBytes((long)by);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NUMBER.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(BigInteger bigInteger) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            long l2;
            int n3;
            int n4;
            byte[] byArray;
            Object object;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, NUMBER.class, $$$methodRef$$$16, null, bigInteger);
            }
            if (bigInteger == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68, "input should not be null").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, NUMBER.class, $$$methodRef$$$16, null, sQLException);
                }
                throw sQLException;
            }
            byte[] byArray2 = new byte[66];
            long[] lArray = new long[54];
            long[] lArray2 = new long[22];
            int n5 = 21;
            int n6 = 0;
            int n7 = 21;
            boolean bl2 = false;
            int n8 = 0;
            boolean bl3 = true;
            if (bigInteger.signum() == 0) {
                return NUMBER._makeZero();
            }
            if (bigInteger.signum() == -1) {
                object = bigInteger.abs();
                bl3 = false;
                byArray = ((BigInteger)object).toByteArray();
                n4 = (int)Math.floor((double)((BigInteger)object).bitLength() * 0.1505149978319906);
            } else {
                byArray = bigInteger.toByteArray();
                n4 = (int)Math.floor((double)bigInteger.bitLength() * 0.1505149978319906);
            }
            if (bigInteger.abs().compareTo(BIGINT_HUND.pow(n4)) < 0) {
                --n4;
            }
            if (byArray.length > 54) {
                SQLException sQLException = new SQLException(CoreException.getMessage((byte)3));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, NUMBER.class, $$$methodRef$$$16, null, sQLException);
                }
                throw sQLException;
            }
            for (n3 = 0; n3 < byArray.length; ++n3) {
                lArray[n3] = byArray[n3] < 0 ? (long)(byArray[n3] + 256) : (long)byArray[n3];
            }
            int n9 = byArray.length;
            switch (n9 % 3) {
                case 2: {
                    lArray2[n5] = (lArray[n6] << 8) + lArray[n6 + 1];
                    n6 = (byte)(n6 + 2);
                    n9 -= 2;
                    break;
                }
                case 1: {
                    lArray2[n5] = lArray[n6];
                    n6 = (byte)(n6 + 1);
                    --n9;
                    break;
                }
                default: {
                    l2 = (lArray[n6] << 16) + (lArray[n6 + 1] << 8) + lArray[n6 + 2];
                    lArray2[n5] = l2 % 1000000L;
                    lArray2[n5 - 1] = l2 / 1000000L;
                    n7 = (byte)(n7 - (lArray2[n5 - 1] != 0L ? 1 : 0));
                    n6 = (byte)(n6 + 3);
                    n9 -= 3;
                }
            }
            while (n9 != 0) {
                l2 = (lArray[n6] << 4) + (lArray[n6 + 1] >> 4);
                for (n5 = 21; n5 >= n7; n5 = (int)((byte)(n5 - 1))) {
                    lArray2[n5] = (l2 += lArray2[n5] << 12) % 1000000L;
                    l2 /= 1000000L;
                }
                if (l2 != 0L) {
                    n7 = (byte)(n7 - 1);
                    lArray2[n7] = l2;
                }
                l2 = ((lArray[n6 + 1] & 0xFL) << 8) + lArray[n6 + 2];
                for (n5 = 21; n5 >= n7; n5 = (int)((byte)(n5 - 1))) {
                    lArray2[n5] = (l2 += lArray2[n5] << 12) % 1000000L;
                    l2 /= 1000000L;
                }
                if (l2 != 0L) {
                    n7 = (byte)(n7 - 1);
                    lArray2[n7] = l2;
                }
                n6 = (byte)(n6 + 3);
                n9 -= 3;
            }
            byArray2[n8] = (byte)(lArray2[n7] / 10000L);
            if (byArray2[n8] != 0) {
                n2 = 3 * (21 - n7) + 3;
                byArray2[n8 + 1] = (byte)(lArray2[n7] % 10000L / 100L);
                byArray2[n8 + 2] = (byte)(lArray2[n7] % 100L);
                n8 += 3;
            } else {
                byArray2[n8] = (byte)(lArray2[n7] % 10000L / 100L);
                if (byArray2[n8] != 0) {
                    n2 = 3 * (21 - n7) + 2;
                    byArray2[n8 + 1] = (byte)(lArray2[n7] % 100L);
                    n8 += 2;
                } else {
                    byArray2[n8] = (byte)lArray2[n7];
                    n2 = 3 * (21 - n7) + 1;
                    ++n8;
                }
            }
            for (n5 = (int)((byte)(n7 + 1)); n5 <= 21; n5 = (int)((byte)(n5 + 1))) {
                byArray2[n8] = (byte)(lArray2[n5] / 10000L);
                byArray2[n8 + 1] = (byte)(lArray2[n5] % 10000L / 100L);
                byArray2[n8 + 2] = (byte)(lArray2[n5] % 100L);
                n8 += 3;
            }
            for (n3 = n8 - 1; n3 >= 0 && byArray2[n3] == 0; --n3) {
                --n2;
            }
            if (n2 > 19) {
                n3 = 20;
                n2 = 19;
                if (byArray2[n3] >= 50) {
                    int n10 = --n3;
                    byArray2[n10] = (byte)(byArray2[n10] + 1);
                    while (byArray2[n3] == 100) {
                        if (n3 == 0) {
                            ++n4;
                            byArray2[n3] = 1;
                            break;
                        }
                        byArray2[n3] = 0;
                        int n11 = --n3;
                        byArray2[n11] = (byte)(byArray2[n11] + 1);
                    }
                    for (n3 = n2 - 1; n3 >= 0 && byArray2[n3] == 0; --n3) {
                        --n2;
                    }
                }
            }
            if (n4 > 62) {
                SQLException sQLException = new SQLException(CoreException.getMessage((byte)3));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, NUMBER.class, $$$methodRef$$$16, null, sQLException);
                }
                throw sQLException;
            }
            object = new byte[n2 + 1];
            object[0] = (byte)n4;
            System.arraycopy(byArray2, 0, object, 1, n2);
            return NUMBER._toLnxFmt((byte[])object, bl3);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NUMBER.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(BigDecimal bigDecimal) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            long l2;
            int n3;
            BigDecimal bigDecimal2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, NUMBER.class, $$$methodRef$$$17, null, bigDecimal);
            }
            if (bigDecimal == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68, "input should not be null").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, NUMBER.class, $$$methodRef$$$17, null, sQLException);
                }
                throw sQLException;
            }
            byte[] byArray = new byte[66];
            long[] lArray = new long[54];
            long[] lArray2 = new long[22];
            int n4 = 21;
            int n5 = 0;
            int n6 = 21;
            int n7 = 0;
            int n8 = 0;
            BigDecimal bigDecimal3 = bigDecimal.abs();
            int n9 = 0;
            if (bigDecimal.signum() == 0) {
                return NUMBER._makeZero();
            }
            boolean bl2 = bigDecimal.signum() != -1;
            int n10 = bigDecimal.scale();
            if (n10 < 0) {
                bigDecimal = bigDecimal.setScale(0);
                n10 = 0;
            }
            int n11 = bigDecimal3.compareTo(BIGDEC_ONE);
            int n12 = 0;
            if (n11 == -1) {
                while ((bigDecimal2 = bigDecimal3.movePointRight(++n12)).compareTo(BIGDEC_ONE) < 0) {
                }
                n9 = -n12;
            } else {
                while ((bigDecimal2 = bigDecimal3.movePointLeft(++n12)).compareTo(BIGDEC_ONE) >= 0) {
                }
                n9 = n12;
            }
            byte[] byArray2 = bigDecimal3.movePointRight(n10).toBigInteger().toByteArray();
            if (byArray2.length > 54) {
                SQLException sQLException = new SQLException(CoreException.getMessage((byte)3));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, NUMBER.class, $$$methodRef$$$17, null, sQLException);
                }
                throw sQLException;
            }
            for (n3 = 0; n3 < byArray2.length; ++n3) {
                lArray[n3] = byArray2[n3] < 0 ? (long)(byArray2[n3] + 256) : (long)byArray2[n3];
            }
            int n13 = byArray2.length;
            switch (n13 % 3) {
                case 2: {
                    lArray2[n4] = (lArray[n5] << 8) + lArray[n5 + 1];
                    n5 = (byte)(n5 + 2);
                    n13 -= 2;
                    break;
                }
                case 1: {
                    lArray2[n4] = lArray[n5];
                    n5 = (byte)(n5 + 1);
                    --n13;
                    break;
                }
                default: {
                    l2 = (lArray[n5] << 16) + (lArray[n5 + 1] << 8) + lArray[n5 + 2];
                    lArray2[n4] = l2 % 1000000L;
                    lArray2[n4 - 1] = l2 / 1000000L;
                    n6 = (byte)(n6 - (lArray2[n4 - 1] != 0L ? 1 : 0));
                    n5 = (byte)(n5 + 3);
                    n13 -= 3;
                }
            }
            while (n13 != 0) {
                l2 = (lArray[n5] << 4) + (lArray[n5 + 1] >> 4);
                for (n4 = 21; n4 >= n6; n4 = (int)((byte)(n4 - 1))) {
                    lArray2[n4] = (l2 += lArray2[n4] << 12) % 1000000L;
                    l2 /= 1000000L;
                }
                if (l2 != 0L) {
                    n6 = (byte)(n6 - 1);
                    lArray2[n6] = l2;
                }
                l2 = ((lArray[n5 + 1] & 0xFL) << 8) + lArray[n5 + 2];
                for (n4 = 21; n4 >= n6; n4 = (int)((byte)(n4 - 1))) {
                    lArray2[n4] = (l2 += lArray2[n4] << 12) % 1000000L;
                    l2 /= 1000000L;
                }
                if (l2 != 0L) {
                    n6 = (byte)(n6 - 1);
                    lArray2[n6] = l2;
                }
                n5 = (byte)(n5 + 3);
                n13 -= 3;
            }
            byArray[n7] = (byte)(lArray2[n6] / 10000L);
            if (byArray[n7] != 0) {
                n2 = 3 * (21 - n6) + 3;
                byArray[n7 + 1] = (byte)(lArray2[n6] % 10000L / 100L);
                byArray[n7 + 2] = (byte)(lArray2[n6] % 100L);
                n7 += 3;
            } else {
                byArray[n7] = (byte)(lArray2[n6] % 10000L / 100L);
                if (byArray[n7] != 0) {
                    n2 = 3 * (21 - n6) + 2;
                    byArray[n7 + 1] = (byte)(lArray2[n6] % 100L);
                    n7 += 2;
                } else {
                    byArray[n7] = (byte)lArray2[n6];
                    n2 = 3 * (21 - n6) + 1;
                    ++n7;
                }
            }
            for (n4 = (int)((byte)(n6 + 1)); n4 <= 21; n4 = (int)((byte)(n4 + 1))) {
                byArray[n7] = (byte)(lArray2[n4] / 10000L);
                byArray[n7 + 1] = (byte)(lArray2[n4] % 10000L / 100L);
                byArray[n7 + 2] = (byte)(lArray2[n4] % 100L);
                n7 += 3;
            }
            for (n3 = n7 - 1; n3 >= 0 && byArray[n3] == 0; --n3) {
                --n2;
            }
            if (n10 > 0 && (n10 & 1) != 0) {
                int n14 = n2;
                byte[] byArray3 = new byte[n14 + 1];
                if (byArray[0] <= 9) {
                    for (n3 = 0; n3 < n14 - 1; ++n3) {
                        byArray3[n3] = (byte)(byArray[n3] % 10 * 10 + byArray[n3 + 1] / 10);
                    }
                    byArray3[n3] = (byte)(byArray[n3] % 10 * 10);
                    if (byArray3[n14 - 1] == 0) {
                        --n2;
                    }
                } else {
                    byArray3[n14] = (byte)(byArray[n14 - 1] % 10 * 10);
                    for (n3 = n14 - 1; n3 > 0; --n3) {
                        byArray3[n3] = (byte)(byArray[n3] / 10 + byArray[n3 - 1] % 10 * 10);
                    }
                    byArray3[n3] = (byte)(byArray[n3] / 10);
                    if (byArray3[n14] > 0) {
                        ++n2;
                    }
                }
                System.arraycopy(byArray3, 0, byArray, 0, n2);
            }
            if (n2 > 20) {
                n3 = 20;
                n2 = 20;
                if (byArray[n3] >= 50) {
                    int n15 = --n3;
                    byArray[n15] = (byte)(byArray[n15] + 1);
                    while (byArray[n3] == 100) {
                        if (n3 == 0) {
                            ++n9;
                            byArray[n3] = 1;
                            break;
                        }
                        byArray[n3] = 0;
                        int n16 = --n3;
                        byArray[n16] = (byte)(byArray[n16] + 1);
                    }
                }
                for (n3 = n2 - 1; n3 >= 0 && byArray[n3] == 0; --n3) {
                    --n2;
                }
            }
            n8 = n9 <= 0 ? (byArray[0] < 10 ? -(2 - n9) / 2 + 1 : -(2 - n9) / 2) : (n9 - 1) / 2;
            if (n8 > 62) {
                SQLException sQLException = new SQLException(CoreException.getMessage((byte)3));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, NUMBER.class, $$$methodRef$$$17, null, sQLException);
                }
                throw sQLException;
            }
            if (n8 <= -65) {
                SQLException sQLException = new SQLException(CoreException.getMessage((byte)2));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, NUMBER.class, $$$methodRef$$$17, null, sQLException);
                }
                throw sQLException;
            }
            byte[] byArray4 = new byte[n2 + 1];
            byArray4[0] = (byte)n8;
            System.arraycopy(byArray, 0, byArray4, 1, n2);
            return NUMBER._toLnxFmt(byArray4, bl2);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NUMBER.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(String string, int n2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n3;
            int n4;
            int n5;
            Object object;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, NUMBER.class, $$$methodRef$$$18, null, string, n2);
            }
            if (string == null || string.length() == 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, NUMBER.class, $$$methodRef$$$18, null, sQLException);
                }
                throw sQLException;
            }
            int n6 = 0;
            int n7 = 0;
            byte[] byArray = new byte[22];
            int n8 = 0;
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 40;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            int n17 = string.indexOf("E");
            if (n17 != -1 || (n17 = string.indexOf("e")) != -1) {
                int n18;
                boolean bl5;
                object = new StringBuffer(string.length() + 5);
                n5 = 0;
                BigDecimal bigDecimal = null;
                boolean bl6 = string.charAt(0) == '-';
                String string2 = string.substring(n17 + 1);
                String string3 = string.substring(bl6 ? 1 : 0, n17);
                bigDecimal = new BigDecimal(string3);
                boolean bl7 = bl5 = string2.charAt(0) == '-';
                if (bl5 || string2.charAt(0) == '+') {
                    string2 = string2.substring(1);
                }
                n5 = Integer.parseInt(string2);
                String string4 = bigDecimal.toString();
                int n19 = string4.indexOf(".");
                int n20 = string4.length();
                int n21 = n20--;
                if (n19 != -1) {
                    string4 = string4.substring(0, n19) + string4.substring(n19 + 1);
                    if (bl5) {
                        n5 -= n19;
                    } else {
                        n21 = ++n5;
                    }
                } else if (bl5) {
                    n5 -= n20;
                } else {
                    n21 = ++n5;
                }
                if (bl6) {
                    ((StringBuffer)object).append("-");
                }
                if (bl5) {
                    ((StringBuffer)object).append("0.");
                    for (n18 = 0; n18 < n5; ++n18) {
                        ((StringBuffer)object).append("0");
                    }
                    ((StringBuffer)object).append(string4);
                } else {
                    n18 = n5 > n20 ? n5 : n20;
                    for (int i2 = 0; i2 < n18; ++i2) {
                        if (n21 == i2) {
                            ((StringBuffer)object).append(".");
                        }
                        ((StringBuffer)object).append(n20 > i2 ? string4.charAt(i2) : (char)'0');
                    }
                }
                string = ((StringBuffer)object).toString();
            }
            string = string.trim();
            int n22 = string.length();
            if (string.charAt(0) == '-') {
                --n22;
                bl2 = false;
                n15 = 1;
            }
            n6 = n22;
            object = new char[n22];
            string.getChars(n15, n22 + n15, (char[])object, 0);
            for (n4 = 0; n4 < n22; ++n4) {
                if (object[n4] != 46) continue;
                bl4 = true;
                break;
            }
            if (!bl4) {
                n2 = 0;
            }
            while (n7 < n6 && object[n7] == 48) {
                ++n7;
                if (!bl4) continue;
                ++n16;
            }
            if (n7 == n6) {
                return NUMBER._makeZero();
            }
            if (n22 >= 2 && object[n7] == 46) {
                ++n7;
                while (n6 > 0 && object[n6 - 1] == 48) {
                    --n6;
                }
                if (n7 == n6) {
                    return NUMBER._makeZero();
                }
                --n9;
                while (n7 < n6 - 1 && object[n7] == 48 && object[n7 + 1] == 48) {
                    --n9;
                    n11 += 2;
                    n7 += 2;
                }
                if (n9 < -65) {
                    SQLException sQLException = new SQLException(CoreException.getMessage((byte)2));
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, NUMBER.class, $$$methodRef$$$18, null, sQLException);
                    }
                    throw sQLException;
                }
                if (n6 - n7 > n12) {
                    n3 = n7 + n12;
                    if (n11 > 0) {
                        n3 += n11;
                    }
                    if (n3 <= n6) {
                        n6 = n3;
                    }
                    n13 = n6;
                    bl3 = true;
                }
                n8 = n6 - n7 >> 1;
                if ((n6 - n7) % 2 != 0) {
                    byArray[n8] = (byte)(Integer.parseInt(new String((char[])object, n6 - 1, 1)) * 10);
                    ++n10;
                    --n6;
                }
                while (n6 > n7) {
                    byArray[--n8] = (byte)Integer.parseInt(new String((char[])object, n6 - 2, 2));
                    n6 -= 2;
                    ++n10;
                }
            } else {
                int n23;
                while (n2 > 0 && n6 > 0 && object[n6 - 1] == 48) {
                    --n6;
                    --n2;
                }
                if (n2 == 0 && n6 > 1) {
                    if (object[n6 - 1] == 46) {
                        --n6;
                    }
                    if (n7 == n6) {
                        return NUMBER._makeZero();
                    }
                    while (n6 > 1 && object[n6 - 2] == 48 && object[n6 - 1] == 48) {
                        n6 -= 2;
                        ++n9;
                    }
                }
                if (n9 > 62) {
                    SQLException sQLException = new SQLException(CoreException.getMessage((byte)3));
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, NUMBER.class, $$$methodRef$$$18, null, sQLException);
                    }
                    throw sQLException;
                }
                if (n6 - n7 - (bl4 ? 1 : 0) > n12) {
                    n3 = n12 + (bl4 ? 1 : 0);
                    n5 = n6 - n3;
                    n6 = n3;
                    if ((n2 -= n5) < 0) {
                        n2 = 0;
                    }
                    bl3 = true;
                    n13 = n6;
                }
                int n24 = n23 = n2 == 0 ? n6 - n7 : n6 - n2 - 1;
                if (n16 > 0) {
                    n23 -= n16;
                }
                if (n23 % 2 != 0) {
                    n14 = Integer.parseInt(new String((char[])object, n7, 1));
                    ++n7;
                    --n23;
                    if (n6 - 1 == n12) {
                        --n2;
                        bl3 = true;
                        n13 = --n6;
                    }
                } else {
                    n14 = Integer.parseInt(new String((char[])object, n7, 2));
                    n7 += 2;
                    n23 -= 2;
                }
                byArray[n8] = (byte)n14;
                ++n8;
                ++n10;
                while (n23 > 0) {
                    byArray[n8] = (byte)Integer.parseInt(new String((char[])object, n7, 2));
                    ++n8;
                    n7 += 2;
                    ++n9;
                    n23 -= 2;
                    ++n10;
                }
                if (n7 < n6) {
                    if (n2 % 2 != 0) {
                        byArray[n8 += n2 / 2] = (byte)(Integer.parseInt(new String((char[])object, n6 - 1, 1)) * 10);
                        --n6;
                        --n2;
                    } else {
                        byArray[n8 += n2 / 2 - 1] = (byte)Integer.parseInt(new String((char[])object, n6 - 2, 2));
                        n6 -= 2;
                        n2 -= 2;
                    }
                    ++n10;
                    --n8;
                }
                while (n2 > 0) {
                    byArray[n8] = (byte)Integer.parseInt(new String((char[])object, n6 - 2, 2));
                    --n8;
                    n6 -= 2;
                    n2 -= 2;
                    ++n10;
                }
            }
            if (bl3) {
                n5 = n10;
                n14 = Integer.parseInt(new String((char[])object, n13, 1));
                if (n14 >= 5) {
                    int n25 = --n5;
                    byArray[n25] = (byte)(byArray[n25] + 1);
                    while (byArray[n5] == 100) {
                        if (n5 == 0) {
                            ++n9;
                            byArray[n5] = 1;
                            break;
                        }
                        byArray[n5] = 0;
                        int n26 = --n5;
                        byArray[n26] = (byte)(byArray[n26] + 1);
                    }
                    for (n4 = n10 - 1; n4 >= 0 && byArray[n4] == 0; --n4) {
                        --n10;
                    }
                }
            }
            byte[] byArray2 = new byte[n10 + 1];
            byArray2[0] = (byte)n9;
            System.arraycopy(byArray, 0, byArray2, 1, n10);
            return NUMBER._toLnxFmt(byArray2, bl2);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, NUMBER.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(boolean bl) {
        boolean bl2 = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, NUMBER.class, $$$methodRef$$$19, null, bl);
            }
            if (bl) {
                return NUMBER.toBytes(1L);
            }
            return NUMBER.toBytes(0L);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, NUMBER.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] toBytes() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, NUMBER.class, $$$methodRef$$$20, this, new Object[0]);
            }
            return this.getBytes();
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, NUMBER.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public double doubleValue() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, NUMBER.class, $$$methodRef$$$21, this, new Object[0]);
            }
            double d2 = NUMBER.toDouble(this.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, NUMBER.class, $$$methodRef$$$21, this, d2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, NUMBER.class, $$$methodRef$$$21, this, null);
            }
            return d2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, NUMBER.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public float floatValue() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, NUMBER.class, $$$methodRef$$$22, this, new Object[0]);
            }
            float f2 = NUMBER.toFloat(this.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, NUMBER.class, $$$methodRef$$$22, this, Float.valueOf(f2));
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, NUMBER.class, $$$methodRef$$$22, this, null);
            }
            return f2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, NUMBER.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long longValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, NUMBER.class, $$$methodRef$$$23, this, new Object[0]);
            }
            long l2 = NUMBER.toLong(this.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, NUMBER.class, $$$methodRef$$$23, this, l2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, NUMBER.class, $$$methodRef$$$23, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, NUMBER.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int intValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, NUMBER.class, $$$methodRef$$$24, this, new Object[0]);
            }
            int n2 = NUMBER.toInt(this.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, NUMBER.class, $$$methodRef$$$24, this, n2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, NUMBER.class, $$$methodRef$$$24, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, NUMBER.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    public short shortValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, NUMBER.class, $$$methodRef$$$25, this, new Object[0]);
            }
            short s2 = NUMBER.toShort(this.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, NUMBER.class, $$$methodRef$$$25, this, s2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, NUMBER.class, $$$methodRef$$$25, this, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, NUMBER.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte byteValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, NUMBER.class, $$$methodRef$$$26, this, new Object[0]);
            }
            byte by = NUMBER.toByte(this.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, NUMBER.class, $$$methodRef$$$26, this, by);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, NUMBER.class, $$$methodRef$$$26, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, NUMBER.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    public BigInteger bigIntegerValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, NUMBER.class, $$$methodRef$$$27, this, new Object[0]);
            }
            return NUMBER.toBigInteger(this.shareBytes());
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, NUMBER.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, NUMBER.class, $$$methodRef$$$28, this, new Object[0]);
            }
            return NUMBER.toBigDecimal(this.shareBytes());
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, NUMBER.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String stringValue() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, NUMBER.class, $$$methodRef$$$29, this, new Object[0]);
            }
            return NUMBER.toString(this.shareBytes());
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, NUMBER.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean booleanValue() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, NUMBER.class, $$$methodRef$$$30, this, new Object[0]);
            }
            boolean bl2 = NUMBER.toBoolean(this.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, NUMBER.class, $$$methodRef$$$30, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, NUMBER.class, $$$methodRef$$$30, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, NUMBER.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, NUMBER.class, $$$methodRef$$$31, this, new Object[0]);
            }
            try {
                return this.bigDecimalValue();
            }
            catch (SQLException sQLException) {
                return new SQLException(sQLException.getMessage());
            }
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, NUMBER.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object makeJdbcArray(int n2) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, NUMBER.class, $$$methodRef$$$32, this, n2);
            }
            BigDecimal[] bigDecimalArray = new BigDecimal[n2];
            return bigDecimalArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, NUMBER.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, NUMBER.class, $$$methodRef$$$33, this, clazz);
            }
            if ((string = clazz.getName()).compareTo("java.lang.Integer") == 0 || string.compareTo("java.lang.Long") == 0 || string.compareTo("java.lang.Float") == 0 || string.compareTo("java.lang.Double") == 0 || string.compareTo("java.math.BigInteger") == 0 || string.compareTo("java.math.BigDecimal") == 0 || string.compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Boolean") == 0 || string.compareTo("java.lang.Byte") == 0 || string.compareTo("java.lang.Short") == 0) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, NUMBER.class, $$$methodRef$$$33, this, bl2);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, NUMBER.class, $$$methodRef$$$33, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, NUMBER.class, $$$methodRef$$$33, this, bl3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, NUMBER.class, $$$methodRef$$$33, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, NUMBER.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER abs() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, NUMBER.class, $$$methodRef$$$34, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxabs(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, NUMBER.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER acos() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, NUMBER.class, $$$methodRef$$$35, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxacos(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, NUMBER.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER add(NUMBER nUMBER) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, NUMBER.class, $$$methodRef$$$36, this, nUMBER);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxadd(this.shareBytes(), nUMBER.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, NUMBER.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER asin() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, NUMBER.class, $$$methodRef$$$37, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxasin(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, NUMBER.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER atan() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, NUMBER.class, $$$methodRef$$$38, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxatan(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, NUMBER.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER atan2(NUMBER nUMBER) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, NUMBER.class, $$$methodRef$$$39, this, nUMBER);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxatan2(this.shareBytes(), nUMBER.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, NUMBER.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER ceil() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, NUMBER.class, $$$methodRef$$$40, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxceil(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, NUMBER.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER cos() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, NUMBER.class, $$$methodRef$$$41, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxcos(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, NUMBER.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER cosh() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, NUMBER.class, $$$methodRef$$$42, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxcsh(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, NUMBER.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER decrement() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, NUMBER.class, $$$methodRef$$$43, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxdec(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, NUMBER.class, $$$methodRef$$$43, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER div(NUMBER nUMBER) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, NUMBER.class, $$$methodRef$$$44, this, nUMBER);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxdiv(this.shareBytes(), nUMBER.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, NUMBER.class, $$$methodRef$$$44, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER exp() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, NUMBER.class, $$$methodRef$$$45, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxexp(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, NUMBER.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER floatingPointRound(int n2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, NUMBER.class, $$$methodRef$$$46, this, n2);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxfpr(this.shareBytes(), n2));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, NUMBER.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER floor() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, NUMBER.class, $$$methodRef$$$47, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxflo(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, NUMBER.class, $$$methodRef$$$47, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER increment() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, NUMBER.class, $$$methodRef$$$48, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxinc(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, NUMBER.class, $$$methodRef$$$48, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER ln() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, NUMBER.class, $$$methodRef$$$49, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxln(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, NUMBER.class, $$$methodRef$$$49, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER log(NUMBER nUMBER) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, NUMBER.class, $$$methodRef$$$50, this, nUMBER);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxlog(this.shareBytes(), nUMBER.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, NUMBER.class, $$$methodRef$$$50, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER mod(NUMBER nUMBER) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, NUMBER.class, $$$methodRef$$$51, this, nUMBER);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxmod(this.shareBytes(), nUMBER.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, NUMBER.class, $$$methodRef$$$51, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER mul(NUMBER nUMBER) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, NUMBER.class, $$$methodRef$$$52, this, nUMBER);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxmul(this.shareBytes(), nUMBER.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, NUMBER.class, $$$methodRef$$$52, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER negate() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, NUMBER.class, $$$methodRef$$$53, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxneg(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, NUMBER.class, $$$methodRef$$$53, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER pow(NUMBER nUMBER) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, NUMBER.class, $$$methodRef$$$54, this, nUMBER);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxbex(this.shareBytes(), nUMBER.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, NUMBER.class, $$$methodRef$$$54, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER pow(int n2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$55, Level.FINEST, NUMBER.class, $$$methodRef$$$55, this, n2);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxpow(this.shareBytes(), n2));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, NUMBER.class, $$$methodRef$$$55, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER round(int n2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$56, Level.FINEST, NUMBER.class, $$$methodRef$$$56, this, n2);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxrou(this.shareBytes(), n2));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, NUMBER.class, $$$methodRef$$$56, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER scale(int n2, int n3, boolean[] blArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$57, Level.FINEST, NUMBER.class, $$$methodRef$$$57, this, n2, n3, blArray);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxsca(this.shareBytes(), n2, n3, blArray));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, NUMBER.class, $$$methodRef$$$57, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER shift(int n2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$58, Level.FINEST, NUMBER.class, $$$methodRef$$$58, this, n2);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxshift(this.shareBytes(), n2));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, NUMBER.class, $$$methodRef$$$58, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER sin() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$59, Level.FINEST, NUMBER.class, $$$methodRef$$$59, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxsin(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, NUMBER.class, $$$methodRef$$$59, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER sinh() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$60, Level.FINEST, NUMBER.class, $$$methodRef$$$60, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxsnh(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, NUMBER.class, $$$methodRef$$$60, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER sqroot() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$61, Level.FINEST, NUMBER.class, $$$methodRef$$$61, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxsqr(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, NUMBER.class, $$$methodRef$$$61, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER sub(NUMBER nUMBER) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$62, Level.FINEST, NUMBER.class, $$$methodRef$$$62, this, nUMBER);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxsub(this.shareBytes(), nUMBER.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, NUMBER.class, $$$methodRef$$$62, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER tan() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$63, Level.FINEST, NUMBER.class, $$$methodRef$$$63, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxtan(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, NUMBER.class, $$$methodRef$$$63, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER tanh() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$64, Level.FINEST, NUMBER.class, $$$methodRef$$$64, this, new Object[0]);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxtnh(this.shareBytes()));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, NUMBER.class, $$$methodRef$$$64, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER truncate(int n2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$65, Level.FINEST, NUMBER.class, $$$methodRef$$$65, this, n2);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxtru(this.shareBytes(), n2));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, NUMBER.class, $$$methodRef$$$65, this, throwable2);
            }
            throw throwable;
        }
    }

    public static NUMBER formattedTextToNumber(String string, String string2, String string3) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$66, Level.FINEST, NUMBER.class, $$$methodRef$$$66, null, string, string2, string3);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxfcn(string, string2, string3));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$66, Level.FINEST, NUMBER.class, $$$methodRef$$$66, null, throwable2);
            }
            throw throwable;
        }
    }

    public static NUMBER textToPrecisionNumber(String string, boolean bl, int n2, boolean bl2, int n3, String string2) throws SQLException {
        boolean bl3 = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$67, Level.FINEST, NUMBER.class, $$$methodRef$$$67, null, string, bl, n2, bl2, n3, string2);
            }
            return new NUMBER(NUMBER._getLnxLib().lnxcpn(string, bl, n2, bl2, n3, string2));
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$67, Level.FINEST, NUMBER.class, $$$methodRef$$$67, null, throwable2);
            }
            throw throwable;
        }
    }

    public String toFormattedText(String string, String string2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$68, Level.FINEST, NUMBER.class, $$$methodRef$$$68, this, string, string2);
            }
            return NUMBER._getLnxLib().lnxnfn(this.shareBytes(), string, string2);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$68, Level.FINEST, NUMBER.class, $$$methodRef$$$68, this, throwable2);
            }
            throw throwable;
        }
    }

    public String toText(int n2, String string) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$69, Level.FINEST, NUMBER.class, $$$methodRef$$$69, this, n2, string);
            }
            return NUMBER._getLnxLib().lnxnuc(this.shareBytes(), n2, string);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$69, Level.FINEST, NUMBER.class, $$$methodRef$$$69, this, throwable2);
            }
            throw throwable;
        }
    }

    public int compareTo(NUMBER nUMBER) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$70, Level.FINEST, NUMBER.class, $$$methodRef$$$70, this, nUMBER);
            }
            int n2 = NUMBER.compareBytes(this.shareBytes(), nUMBER.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$70, Level.FINEST, NUMBER.class, $$$methodRef$$$70, this, n2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$70, Level.FINEST, NUMBER.class, $$$methodRef$$$70, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$70, Level.FINEST, NUMBER.class, $$$methodRef$$$70, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isInf() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$71, Level.FINEST, NUMBER.class, $$$methodRef$$$71, this, new Object[0]);
            }
            boolean bl2 = NUMBER._isInf(this.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, NUMBER.class, $$$methodRef$$$71, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, NUMBER.class, $$$methodRef$$$71, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, NUMBER.class, $$$methodRef$$$71, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isNegInf() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$72, Level.FINEST, NUMBER.class, $$$methodRef$$$72, this, new Object[0]);
            }
            boolean bl2 = NUMBER._isNegInf(this.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$72, Level.FINEST, NUMBER.class, $$$methodRef$$$72, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$72, Level.FINEST, NUMBER.class, $$$methodRef$$$72, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$72, Level.FINEST, NUMBER.class, $$$methodRef$$$72, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isPosInf() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$73, Level.FINEST, NUMBER.class, $$$methodRef$$$73, this, new Object[0]);
            }
            boolean bl2 = NUMBER._isPosInf(this.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$73, Level.FINEST, NUMBER.class, $$$methodRef$$$73, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$73, Level.FINEST, NUMBER.class, $$$methodRef$$$73, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$73, Level.FINEST, NUMBER.class, $$$methodRef$$$73, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isInt() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$74, Level.FINEST, NUMBER.class, $$$methodRef$$$74, this, new Object[0]);
            }
            boolean bl2 = NUMBER._isInt(this.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$74, Level.FINEST, NUMBER.class, $$$methodRef$$$74, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$74, Level.FINEST, NUMBER.class, $$$methodRef$$$74, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$74, Level.FINEST, NUMBER.class, $$$methodRef$$$74, this, throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isValid(byte[] byArray) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, new Object[]{byArray});
            }
            int n2 = byArray.length;
            if (NUMBER._isPositive(byArray)) {
                if (n2 == 1) {
                    boolean bl2 = NUMBER._isZero(byArray);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, bl2);
                        ClioSupport.publicExit();
                        ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, null);
                    }
                    return bl2;
                }
                if (byArray[0] == -1 && byArray[1] == 101) {
                    boolean bl3;
                    boolean bl4 = bl3 = n2 == 2;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, bl3);
                        ClioSupport.publicExit();
                        ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, null);
                    }
                    return bl4;
                }
                if (n2 > 21) {
                    boolean bl5 = false;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, bl5);
                        ClioSupport.publicExit();
                        ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, null);
                    }
                    return false;
                }
                if (byArray[1] < 2 || byArray[n2 - 1] < 2) {
                    boolean bl6 = false;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, bl6);
                        ClioSupport.publicExit();
                        ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, null);
                    }
                    return false;
                }
                for (int i2 = 1; i2 < n2; ++i2) {
                    byte by = byArray[i2];
                    if (by >= 1 && by <= 100) continue;
                    boolean bl7 = false;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, bl7);
                        ClioSupport.publicExit();
                        ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, null);
                    }
                    return false;
                }
                boolean bl8 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, bl8);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, null);
                }
                return true;
            }
            if (n2 < 3) {
                boolean bl9 = NUMBER._isNegInf(byArray);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, bl9);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, null);
                }
                return bl9;
            }
            if (n2 > 21) {
                boolean bl10 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, bl10);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, null);
                }
                return false;
            }
            if (byArray[n2 - 1] != 102) {
                if (n2 <= 20) {
                    boolean bl11 = false;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, bl11);
                        ClioSupport.publicExit();
                        ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, null);
                    }
                    return false;
                }
            } else {
                n2 = (byte)(n2 - 1);
            }
            if (byArray[1] > 100 || byArray[n2 - 1] > 100) {
                boolean bl12 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, bl12);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, null);
                }
                return false;
            }
            for (int i3 = 1; i3 < n2; ++i3) {
                byte by = byArray[i3];
                if (by >= 2 && by <= 101) continue;
                boolean bl13 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, bl13);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, null);
                }
                return false;
            }
            boolean bl14 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, bl14);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, NUMBER.class, $$$methodRef$$$75, null, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isZero() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$76, Level.FINEST, NUMBER.class, $$$methodRef$$$76, this, new Object[0]);
            }
            boolean bl2 = NUMBER._isZero(this.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$76, Level.FINEST, NUMBER.class, $$$methodRef$$$76, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$76, Level.FINEST, NUMBER.class, $$$methodRef$$$76, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$76, Level.FINEST, NUMBER.class, $$$methodRef$$$76, this, throwable2);
            }
            throw throwable;
        }
    }

    public static NUMBER e() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$77, Level.FINEST, NUMBER.class, $$$methodRef$$$77, null, new Object[0]);
            }
            return new NUMBER(E);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$77, Level.FINEST, NUMBER.class, $$$methodRef$$$77, null, throwable2);
            }
            throw throwable;
        }
    }

    public static NUMBER ln10() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$78, Level.FINEST, NUMBER.class, $$$methodRef$$$78, null, new Object[0]);
            }
            return new NUMBER(LN10);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$78, Level.FINEST, NUMBER.class, $$$methodRef$$$78, null, throwable2);
            }
            throw throwable;
        }
    }

    public static NUMBER negInf() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$79, Level.FINEST, NUMBER.class, $$$methodRef$$$79, null, new Object[0]);
            }
            return new NUMBER(NUMBER._makeNegInf());
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$79, Level.FINEST, NUMBER.class, $$$methodRef$$$79, null, throwable2);
            }
            throw throwable;
        }
    }

    public static NUMBER pi() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$80, Level.FINEST, NUMBER.class, $$$methodRef$$$80, null, new Object[0]);
            }
            return new NUMBER(PI);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$80, Level.FINEST, NUMBER.class, $$$methodRef$$$80, null, throwable2);
            }
            throw throwable;
        }
    }

    public static NUMBER posInf() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$81, Level.FINEST, NUMBER.class, $$$methodRef$$$81, null, new Object[0]);
            }
            return new NUMBER(NUMBER._makePosInf());
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$81, Level.FINEST, NUMBER.class, $$$methodRef$$$81, null, throwable2);
            }
            throw throwable;
        }
    }

    public static NUMBER zero() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$82, Level.FINEST, NUMBER.class, $$$methodRef$$$82, null, new Object[0]);
            }
            return new NUMBER(NUMBER._makeZero());
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$82, Level.FINEST, NUMBER.class, $$$methodRef$$$82, null, throwable2);
            }
            throw throwable;
        }
    }

    public int sign() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$83, Level.FINEST, NUMBER.class, $$$methodRef$$$83, this, new Object[0]);
            }
            if (NUMBER._isZero(this.shareBytes())) {
                int n3 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$83, Level.FINEST, NUMBER.class, $$$methodRef$$$83, this, n3);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$83, Level.FINEST, NUMBER.class, $$$methodRef$$$83, this, null);
                }
                return 0;
            }
            int n4 = n2 = NUMBER._isPositive(this.shareBytes()) ? 1 : -1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$83, Level.FINEST, NUMBER.class, $$$methodRef$$$83, this, n2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$83, Level.FINEST, NUMBER.class, $$$methodRef$$$83, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$83, Level.FINEST, NUMBER.class, $$$methodRef$$$83, this, throwable2);
            }
            throw throwable;
        }
    }

    static boolean _isInf(byte[] byArray) {
        return byArray.length == 2 && byArray[0] == -1 && byArray[1] == 101 || byArray[0] == 0 && byArray.length == 1;
    }

    private static boolean _isInt(byte[] byArray) {
        byte by;
        if (NUMBER._isZero(byArray)) {
            return true;
        }
        if (NUMBER._isInf(byArray)) {
            return false;
        }
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        byte by2 = (byte)(byArray2.length - 1);
        return by2 <= (by = byArray2[0]) + 1;
    }

    static boolean _isNegInf(byte[] byArray) {
        return byArray[0] == 0 && byArray.length == 1;
    }

    static boolean _isPosInf(byte[] byArray) {
        return byArray.length == 2 && byArray[0] == -1 && byArray[1] == 101;
    }

    static boolean _isPositive(byte[] byArray) {
        return (byArray[0] & 0xFFFFFF80) != 0;
    }

    static boolean _isZero(byte[] byArray) {
        return byArray[0] == -128 && byArray.length == 1;
    }

    static byte[] _makePosInf() {
        byte[] byArray = new byte[]{-1, 101};
        return byArray;
    }

    static byte[] _makeNegInf() {
        byte[] byArray = new byte[]{0};
        return byArray;
    }

    static byte[] _makeZero() {
        byte[] byArray = new byte[]{-128};
        return byArray;
    }

    static byte[] _fromLnxFmt(byte[] byArray) {
        byte[] byArray2;
        int n2 = byArray.length;
        if (NUMBER._isPositive(byArray)) {
            byArray2 = new byte[n2];
            byArray2[0] = (byte)((byArray[0] & 0xFFFFFF7F) - 65);
            for (int i2 = 1; i2 < n2; ++i2) {
                byArray2[i2] = (byte)(byArray[i2] - 1);
            }
        } else {
            byArray2 = n2 - 1 == 20 && byArray[n2 - 1] != 102 ? new byte[n2] : new byte[n2 - 1];
            byArray2[0] = (byte)((~byArray[0] & 0xFFFFFF7F) - 65);
            for (int i3 = 1; i3 < byArray2.length; ++i3) {
                byArray2[i3] = (byte)(101 - byArray[i3]);
            }
        }
        return byArray2;
    }

    static byte[] _toLnxFmt(byte[] byArray, boolean bl) {
        byte[] byArray2;
        int n2 = byArray.length;
        if (bl) {
            byArray2 = new byte[n2];
            byArray2[0] = (byte)(byArray[0] + 128 + 64 + 1);
            for (int i2 = 1; i2 < n2; ++i2) {
                byArray2[i2] = (byte)(byArray[i2] + 1);
            }
        } else {
            int n3;
            byArray2 = n2 - 1 < 20 ? new byte[n2 + 1] : new byte[n2];
            byArray2[0] = (byte)(~(byArray[0] + 128 + 64 + 1));
            for (n3 = 1; n3 < n2; ++n3) {
                byArray2[n3] = (byte)(101 - byArray[n3]);
            }
            if (n3 <= 20) {
                byArray2[n3] = 102;
            }
        }
        return byArray2;
    }

    private static LnxLib _getLnxLib() {
        if (_slnxlib == null) {
            _slnxlib = new LnxLibThin();
        }
        return _slnxlib;
    }

    private static LnxLib _getThinLib() {
        if (_thinlib == null) {
            _thinlib = new LnxLibThin();
        }
        return _thinlib;
    }

    private static int _byteToChars(byte by, char[] cArray, int n2) {
        if (by < 0) {
            return 0;
        }
        if (by < 10) {
            cArray[n2] = (char)(48 + by);
            return 1;
        }
        if (by < 100) {
            cArray[n2] = (char)(48 + by / 10);
            cArray[n2 + 1] = (char)(48 + by % 10);
            return 2;
        }
        cArray[n2] = 49;
        cArray[n2 + 1] = (char)(48 + by / 10 - 10);
        cArray[n2 + 2] = (char)(48 + by % 10);
        return 3;
    }

    private static void _byteTo2Chars(byte by, char[] cArray, int n2) {
        if (by < 0) {
            cArray[n2] = 48;
            cArray[n2 + 1] = 48;
        } else if (by < 10) {
            cArray[n2] = 48;
            cArray[n2 + 1] = (char)(48 + by);
        } else if (by < 100) {
            cArray[n2] = (char)(48 + by / 10);
            cArray[n2 + 1] = (char)(48 + by % 10);
        } else {
            cArray[n2] = 48;
            cArray[n2 + 1] = 48;
        }
    }

    private static void _printBytes(byte[] byArray) {
        int n2 = byArray.length;
        System.out.print(n2 + ": ");
        for (int i2 = 0; i2 < n2; ++i2) {
            System.out.print(byArray[i2] + " ");
        }
        System.out.println();
    }

    private byte[] stringToBytes(String string) throws SQLException {
        int n2 = 0;
        if ((string = string.trim()).indexOf(46) >= 0) {
            n2 = string.length() - 1 - string.indexOf(46);
        }
        return NUMBER.toBytes(string, n2);
    }

    static {
        try {
            $$$methodRef$$$113 = NUMBER.class.getDeclaredConstructor(Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$113 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$112 = NUMBER.class.getDeclaredConstructor(Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$112 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$111 = NUMBER.class.getDeclaredConstructor(String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$111 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$110 = NUMBER.class.getDeclaredConstructor(BigInteger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$110 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$109 = NUMBER.class.getDeclaredConstructor(BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$109 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$108 = NUMBER.class.getDeclaredConstructor(Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$108 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$107 = NUMBER.class.getDeclaredConstructor(Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$107 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$106 = NUMBER.class.getDeclaredConstructor(Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$106 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$105 = NUMBER.class.getDeclaredConstructor(Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$105 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$104 = NUMBER.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$104 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$103 = NUMBER.class.getDeclaredConstructor(Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$103 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$102 = NUMBER.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$102 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$101 = NUMBER.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$101 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$100 = NUMBER.class.getDeclaredMethod("stringToBytes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$100 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$99 = NUMBER.class.getDeclaredMethod("_printBytes", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$99 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$98 = NUMBER.class.getDeclaredMethod("_byteTo2Chars", Byte.TYPE, char[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$98 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$97 = NUMBER.class.getDeclaredMethod("_byteToChars", Byte.TYPE, char[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$97 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$96 = NUMBER.class.getDeclaredMethod("_getThinLib", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$96 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$95 = NUMBER.class.getDeclaredMethod("_getLnxLib", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$95 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$94 = NUMBER.class.getDeclaredMethod("_toLnxFmt", byte[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$94 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$93 = NUMBER.class.getDeclaredMethod("_fromLnxFmt", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$93 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$92 = NUMBER.class.getDeclaredMethod("_makeZero", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$92 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$91 = NUMBER.class.getDeclaredMethod("_makeNegInf", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$91 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$90 = NUMBER.class.getDeclaredMethod("_makePosInf", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$90 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$89 = NUMBER.class.getDeclaredMethod("_isZero", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$89 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$88 = NUMBER.class.getDeclaredMethod("_isPositive", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$88 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$87 = NUMBER.class.getDeclaredMethod("_isPosInf", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$87 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$86 = NUMBER.class.getDeclaredMethod("_isNegInf", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$86 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$85 = NUMBER.class.getDeclaredMethod("_isInt", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$85 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$84 = NUMBER.class.getDeclaredMethod("_isInf", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$84 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$83 = NUMBER.class.getDeclaredMethod("sign", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$83 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$82 = NUMBER.class.getDeclaredMethod("zero", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$82 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$81 = NUMBER.class.getDeclaredMethod("posInf", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$81 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$80 = NUMBER.class.getDeclaredMethod("pi", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$80 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$79 = NUMBER.class.getDeclaredMethod("negInf", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$79 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$78 = NUMBER.class.getDeclaredMethod("ln10", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$78 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$77 = NUMBER.class.getDeclaredMethod("e", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$76 = NUMBER.class.getDeclaredMethod("isZero", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$75 = NUMBER.class.getDeclaredMethod("isValid", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$74 = NUMBER.class.getDeclaredMethod("isInt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$73 = NUMBER.class.getDeclaredMethod("isPosInf", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$72 = NUMBER.class.getDeclaredMethod("isNegInf", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$71 = NUMBER.class.getDeclaredMethod("isInf", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$70 = NUMBER.class.getDeclaredMethod("compareTo", NUMBER.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$69 = NUMBER.class.getDeclaredMethod("toText", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$68 = NUMBER.class.getDeclaredMethod("toFormattedText", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$67 = NUMBER.class.getDeclaredMethod("textToPrecisionNumber", String.class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$66 = NUMBER.class.getDeclaredMethod("formattedTextToNumber", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$65 = NUMBER.class.getDeclaredMethod("truncate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$64 = NUMBER.class.getDeclaredMethod("tanh", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$63 = NUMBER.class.getDeclaredMethod("tan", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$62 = NUMBER.class.getDeclaredMethod("sub", NUMBER.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$61 = NUMBER.class.getDeclaredMethod("sqroot", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$60 = NUMBER.class.getDeclaredMethod("sinh", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$59 = NUMBER.class.getDeclaredMethod("sin", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$58 = NUMBER.class.getDeclaredMethod("shift", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$57 = NUMBER.class.getDeclaredMethod("scale", Integer.TYPE, Integer.TYPE, boolean[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$56 = NUMBER.class.getDeclaredMethod("round", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$55 = NUMBER.class.getDeclaredMethod("pow", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$54 = NUMBER.class.getDeclaredMethod("pow", NUMBER.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$53 = NUMBER.class.getDeclaredMethod("negate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$52 = NUMBER.class.getDeclaredMethod("mul", NUMBER.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$51 = NUMBER.class.getDeclaredMethod("mod", NUMBER.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$50 = NUMBER.class.getDeclaredMethod("log", NUMBER.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$49 = NUMBER.class.getDeclaredMethod("ln", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$48 = NUMBER.class.getDeclaredMethod("increment", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$47 = NUMBER.class.getDeclaredMethod("floor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$46 = NUMBER.class.getDeclaredMethod("floatingPointRound", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$45 = NUMBER.class.getDeclaredMethod("exp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$44 = NUMBER.class.getDeclaredMethod("div", NUMBER.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$43 = NUMBER.class.getDeclaredMethod("decrement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$42 = NUMBER.class.getDeclaredMethod("cosh", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$41 = NUMBER.class.getDeclaredMethod("cos", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$40 = NUMBER.class.getDeclaredMethod("ceil", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$39 = NUMBER.class.getDeclaredMethod("atan2", NUMBER.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$38 = NUMBER.class.getDeclaredMethod("atan", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$37 = NUMBER.class.getDeclaredMethod("asin", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$36 = NUMBER.class.getDeclaredMethod("add", NUMBER.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$35 = NUMBER.class.getDeclaredMethod("acos", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$34 = NUMBER.class.getDeclaredMethod("abs", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$33 = NUMBER.class.getDeclaredMethod("isConvertibleTo", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$32 = NUMBER.class.getDeclaredMethod("makeJdbcArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$31 = NUMBER.class.getDeclaredMethod("toJdbc", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$30 = NUMBER.class.getDeclaredMethod("booleanValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$29 = NUMBER.class.getDeclaredMethod("stringValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$28 = NUMBER.class.getDeclaredMethod("bigDecimalValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$27 = NUMBER.class.getDeclaredMethod("bigIntegerValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$26 = NUMBER.class.getDeclaredMethod("byteValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$25 = NUMBER.class.getDeclaredMethod("shortValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$24 = NUMBER.class.getDeclaredMethod("intValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$23 = NUMBER.class.getDeclaredMethod("longValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$22 = NUMBER.class.getDeclaredMethod("floatValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$21 = NUMBER.class.getDeclaredMethod("doubleValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$20 = NUMBER.class.getDeclaredMethod("toBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$19 = NUMBER.class.getDeclaredMethod("toBytes", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$18 = NUMBER.class.getDeclaredMethod("toBytes", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$17 = NUMBER.class.getDeclaredMethod("toBytes", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$16 = NUMBER.class.getDeclaredMethod("toBytes", BigInteger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$15 = NUMBER.class.getDeclaredMethod("toBytes", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = NUMBER.class.getDeclaredMethod("toBytes", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = NUMBER.class.getDeclaredMethod("toBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = NUMBER.class.getDeclaredMethod("toBytes", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = NUMBER.class.getDeclaredMethod("toBytes", Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = NUMBER.class.getDeclaredMethod("toBytes", Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = NUMBER.class.getDeclaredMethod("toBoolean", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = NUMBER.class.getDeclaredMethod("toBigDecimal", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = NUMBER.class.getDeclaredMethod("toBigInteger", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = NUMBER.class.getDeclaredMethod("toByte", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = NUMBER.class.getDeclaredMethod("toShort", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = NUMBER.class.getDeclaredMethod("toInt", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = NUMBER.class.getDeclaredMethod("toLong", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = NUMBER.class.getDeclaredMethod("toLongInternal", byte[].class, byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = NUMBER.class.getDeclaredMethod("toFloat", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = NUMBER.class.getDeclaredMethod("toDouble", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        MAX_LONG = NUMBER.toBytes(Long.MAX_VALUE);
        MIN_LONG = NUMBER.toBytes(Long.MIN_VALUE);
        MAX_INT = NUMBER.toBytes(Integer.MAX_VALUE);
        MIN_INT = NUMBER.toBytes(Integer.MIN_VALUE);
        MAX_SHORT = NUMBER.toBytes((short)Short.MAX_VALUE);
        MIN_SHORT = NUMBER.toBytes((short)Short.MIN_VALUE);
        MAX_BYTE = NUMBER.toBytes((byte)127);
        MIN_BYTE = NUMBER.toBytes((byte)-128);
        BIGDEC_NEGZERO = new BigDecimal("-0");
        BIGDEC_ZERO = BigDecimal.valueOf(0L);
        BIGDEC_ONE = BigDecimal.valueOf(1L);
        BIGINT_ZERO = BigInteger.valueOf(0L);
        BIGINT_HUND = BigInteger.valueOf(100L);
        PI = new byte[]{-63, 4, 15, 16, 93, 66, 36, 90, 80, 33, 39, 47, 27, 44, 39, 33, 80, 51, 29, 85, 21};
        E = new byte[]{-63, 3, 72, 83, 82, 83, 85, 60, 5, 53, 36, 37, 3, 88, 48, 14, 53, 67, 25, 98, 77};
        LN10 = new byte[]{-63, 3, 31, 26, 86, 10, 30, 95, 5, 57, 85, 2, 80, 92, 46, 47, 85, 37, 43, 8, 61};
        _thinlib = null;
        DBL_MAX = 40;
        INT_MAX = 15;
        FLOAT_MAX_INT = 2.1474836E9f;
        FLOAT_MIN_INT = -2.1474836E9f;
        DOUBLE_MAX_INT = 2.147483647E9;
        DOUBLE_MIN_INT = -2.147483648E9;
        DOUBLE_MAX_INT_2 = 2.147483649E9;
        DOUBLE_MIN_INT_2 = -2.147483649E9;
        LANGID = "AMERICAN";
    }
}

