/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import oracle.jdbc.logging.annotations.DisableTrace;

public class SSLSocketChannel
extends SocketChannel {
    private final SocketChannel socketChannel;
    private final SSLEngine sslEngine;
    private final SSLSession sslSession;
    private final int minCacheSize;
    private final ByteBuffer[] inputCache;
    private final int minBufferSize;
    private final ByteBuffer[] inputBuffer;
    private final ByteBuffer[] outputBuffer;
    private final ByteBuffer emptyBuffer;
    private SSLEngineResult.HandshakeStatus handshake;
    private int initialized = -1;
    private boolean shutdown;
    private int remainingFromPreviousRead = 0;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;

    public SSLSocketChannel(SocketChannel socketChannel, SSLEngine sSLEngine) {
        super(socketChannel.provider());
        this.socketChannel = socketChannel;
        this.sslEngine = sSLEngine;
        this.sslSession = sSLEngine.getSession();
        this.minCacheSize = this.sslSession.getApplicationBufferSize();
        this.inputCache = new ByteBuffer[]{ByteBuffer.allocate(this.minCacheSize)};
        this.minBufferSize = this.sslSession.getPacketBufferSize();
        this.inputBuffer = new ByteBuffer[]{ByteBuffer.allocate(this.minBufferSize)};
        this.outputBuffer = new ByteBuffer[]{ByteBuffer.allocate(this.minBufferSize)};
        this.emptyBuffer = ByteBuffer.allocate(0);
        this.inputCache[0].limit(0);
        this.outputBuffer[0].limit(0);
    }

    public SocketChannel getUnderlyingChannel() {
        return this.socketChannel;
    }

    @Override
    public Socket socket() {
        return this.socketChannel.socket();
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return this.socketChannel.isConnectionPending();
    }

    @Override
    public boolean connect(SocketAddress socketAddress) throws IOException {
        return this.socketChannel.connect(socketAddress);
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.socketChannel.finishConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.inputCache[0].remaining() > 0) {
            int n2 = this.inputCache[0].remaining();
            if (n2 > 0) {
                if (n2 > byteBuffer.remaining()) {
                    this.remainingFromPreviousRead = n2 - byteBuffer.remaining();
                    n2 = byteBuffer.remaining();
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    byteBuffer.put(this.inputCache[0].get());
                }
            }
            return n2;
        }
        if (this.socketChannel.socket().isInputShutdown()) {
            throw new ClosedChannelException();
        }
        if (this.initialized != 0) {
            this.handshake(1);
            return 0;
        }
        if (this.shutdown) {
            this.shutdown();
            return 0;
        }
        if (this.sslEngine.isInboundDone()) {
            return -1;
        }
        if (this.fill(this.inputBuffer[0]) < 0L && this.inputBuffer[0].position() == 0) {
            return -1;
        }
        while (this.prepare(this.inputCache, this.minCacheSize)) {
            SSLEngineResult sSLEngineResult;
            this.inputBuffer[0].flip();
            try {
                sSLEngineResult = this.sslEngine.unwrap(this.inputBuffer[0], this.inputCache[0]);
            }
            finally {
                this.inputBuffer[0].compact();
                this.inputCache[0].flip();
            }
            SSLEngineResult.Status status = sSLEngineResult.getStatus();
            if (status == SSLEngineResult.Status.OK || status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.runTasks();
                }
            } else {
                if (status == SSLEngineResult.Status.CLOSED) {
                    this.shutdown();
                }
                throw new IOException("Read error '" + (Object)((Object)sSLEngineResult.getStatus()) + '\'');
            }
            if (this.inputBuffer[0].position() != 0 && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
        }
        int n3 = this.inputCache[0].remaining();
        if (n3 > 0) {
            if (n3 > byteBuffer.remaining()) {
                this.remainingFromPreviousRead = n3 - byteBuffer.remaining();
                n3 = byteBuffer.remaining();
            }
            for (int i3 = 0; i3 < n3; ++i3) {
                byteBuffer.put(this.inputCache[0].get());
            }
        }
        return n3;
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        long l2 = 0L;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!byteBufferArray[i2].hasRemaining()) continue;
            int n4 = this.read(byteBufferArray[i2]);
            if (n4 > 0) {
                l2 += (long)n4;
                if (byteBufferArray[i2].hasRemaining()) continue;
                break;
            }
            if (n4 >= 0 || l2 != 0L) break;
            l2 = -1L;
            break;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (this.socketChannel.socket().isOutputShutdown()) {
            throw new ClosedChannelException();
        }
        if (this.initialized != 0) {
            this.handshake(4);
            return 0;
        }
        if (this.shutdown) {
            this.shutdown();
            return 0;
        }
        int n2 = byteBuffer.remaining();
        int n3 = 0;
        while (this.prepare(this.outputBuffer, this.minBufferSize)) {
            SSLEngineResult sSLEngineResult;
            try {
                sSLEngineResult = this.sslEngine.wrap(byteBuffer, this.outputBuffer[0]);
            }
            finally {
                this.outputBuffer[0].flip();
            }
            n3 += sSLEngineResult.bytesConsumed();
            SSLEngineResult.Status status = sSLEngineResult.getStatus();
            if (status == SSLEngineResult.Status.OK) {
                if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.runTasks();
                }
            } else {
                if (status == SSLEngineResult.Status.CLOSED) {
                    this.shutdown();
                }
                throw new IOException("Write error '" + (Object)((Object)sSLEngineResult.getStatus()) + '\'');
            }
            if (n3 < n2) continue;
        }
        this.flush();
        return n3;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        long l2 = 0L;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!byteBufferArray[i2].hasRemaining()) continue;
            int n4 = this.write(byteBufferArray[i2]);
            if (n4 <= 0) break;
            l2 += (long)n4;
            if (!byteBufferArray[i2].hasRemaining()) break;
        }
        return l2;
    }

    public Channel getAdapteeChannel() {
        return this.socketChannel;
    }

    public boolean finished() {
        return this.initialized == 0;
    }

    public int encrypted() {
        return this.outputBuffer[0].remaining();
    }

    public int decrypted() {
        return this.inputCache[0].remaining();
    }

    public synchronized int handshake(int n2) throws IOException {
        if (this.initialized != 0) {
            if (this.handshake == null) {
                this.sslEngine.beginHandshake();
                this.handshake = this.sslEngine.getHandshakeStatus();
            }
            if (this.outputBuffer[0].hasRemaining()) {
                if ((n2 & 4) != 0) {
                    this.flush(this.outputBuffer[0]);
                    this.initialized = this.outputBuffer[0].hasRemaining() ? 4 : 1;
                    n2 = 0;
                } else {
                    this.initialized = 4;
                }
            } else {
                this.initialized = 1;
            }
            while (this.initialized != 0) {
                if (this.handshake == SSLEngineResult.HandshakeStatus.FINISHED) {
                    this.initialized = 0;
                    continue;
                }
                if (this.handshake == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.handshake = this.runTasks();
                    continue;
                }
                if (this.handshake == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    if ((n2 = this.unwrap(n2)) == 0) continue;
                    this.initialized = n2;
                    return this.initialized;
                }
                if (this.handshake == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    if ((n2 = this.wrap(n2)) == 0) continue;
                    this.initialized = n2;
                    return this.initialized;
                }
                throw new IllegalStateException("Unexpected handshake status '" + (Object)((Object)this.handshake) + '\'');
            }
        }
        return this.initialized;
    }

    public synchronized boolean shutdown() throws IOException {
        SSLEngineResult sSLEngineResult;
        this.shutdown = true;
        if (!this.sslEngine.isOutboundDone()) {
            this.sslEngine.closeOutbound();
        }
        if (this.prepare(this.outputBuffer, this.minBufferSize)) {
            sSLEngineResult = this.sslEngine.wrap(this.emptyBuffer, this.outputBuffer[0]);
            if (sSLEngineResult.getStatus() != SSLEngineResult.Status.CLOSED) {
                throw new SSLException("Unexpected shutdown status '" + (Object)((Object)sSLEngineResult.getStatus()) + '\'');
            }
            this.outputBuffer[0].flip();
        } else {
            sSLEngineResult = null;
        }
        this.flush(this.outputBuffer[0]);
        return !this.outputBuffer[0].hasRemaining() && sSLEngineResult != null && sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP;
    }

    public synchronized void flush() throws IOException {
        this.flush(this.outputBuffer[0]);
    }

    @DisableTrace
    public String toString() {
        return "SSLSocketChannel[" + this.socket().toString() + "]";
    }

    public SSLSession getSession() {
        return this.sslSession;
    }

    @Override
    protected synchronized void implCloseSelectableChannel() throws IOException {
        try {
            this.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socketChannel.close();
        this.notifyAll();
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        this.socketChannel.configureBlocking(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int unwrap(int n2) throws IOException {
        try {
            this.fill(this.inputBuffer[0]);
            do {
                SSLEngineResult sSLEngineResult;
                this.prepare(this.inputCache, this.minCacheSize);
                this.inputBuffer[0].flip();
                try {
                    sSLEngineResult = this.sslEngine.unwrap(this.inputBuffer[0], this.inputCache[0]);
                }
                finally {
                    this.inputBuffer[0].compact();
                    this.inputCache[0].flip();
                }
                this.handshake = sSLEngineResult.getHandshakeStatus();
                SSLEngineResult.Status status = sSLEngineResult.getStatus();
                if (status == SSLEngineResult.Status.OK) {
                    if (this.handshake != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                    this.handshake = this.runTasks();
                    continue;
                }
                if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    return 1;
                }
                throw new IOException("Handshake failed '" + (Object)((Object)status) + '\'');
            } while (this.handshake == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
            return 0;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw (IOException)new IOException("IO Error " + exception.getMessage()).initCause(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int wrap(int n2) throws IOException {
        try {
            if (this.prepare(this.outputBuffer, this.minBufferSize)) {
                SSLEngineResult sSLEngineResult;
                try {
                    sSLEngineResult = this.sslEngine.wrap(this.emptyBuffer, this.outputBuffer[0]);
                }
                finally {
                    this.outputBuffer[0].flip();
                }
                this.handshake = sSLEngineResult.getHandshakeStatus();
                SSLEngineResult.Status status = sSLEngineResult.getStatus();
                if (status == SSLEngineResult.Status.OK) {
                    if (this.handshake == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        this.handshake = this.runTasks();
                    }
                } else {
                    throw new IOException("Handshake failed '" + (Object)((Object)status) + '\'');
                }
            }
            if (this.outputBuffer[0].hasRemaining()) {
                this.flush(this.outputBuffer[0]);
            }
            return this.outputBuffer[0].hasRemaining() ? 4 : 0;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw (IOException)new IOException("IO Error " + exception.getMessage()).initCause(exception);
        }
    }

    private long fill(ByteBuffer byteBuffer) throws IOException {
        try {
            long l2 = this.socketChannel.read(byteBuffer);
            if (l2 < 0L) {
                this.sslEngine.closeInbound();
            }
            return l2;
        }
        catch (IOException iOException) {
            try {
                if (!this.sslEngine.isInboundDone()) {
                    this.sslEngine.closeInbound();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
    }

    private long fill(ByteBuffer byteBuffer, int n2) throws IOException {
        try {
            long l2 = this.socketChannel.read(byteBuffer);
            if (l2 < 0L) {
                this.sslEngine.closeInbound();
            }
            return l2;
        }
        catch (IOException iOException) {
            try {
                if (!this.sslEngine.isInboundDone()) {
                    this.sslEngine.closeInbound();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
    }

    private long flush(ByteBuffer byteBuffer) throws IOException {
        try {
            return byteBuffer.hasRemaining() ? (long)this.socketChannel.write(byteBuffer) : 0L;
        }
        catch (IOException iOException) {
            try {
                if (!this.sslEngine.isOutboundDone()) {
                    this.sslEngine.closeOutbound();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.shutdown = true;
            throw iOException;
        }
    }

    private SSLEngineResult.HandshakeStatus runTasks() throws IOException {
        try {
            Runnable runnable;
            while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
                runnable.run();
            }
            return this.sslEngine.getHandshakeStatus();
        }
        catch (Exception exception) {
            throw (IOException)new IOException("IO Error " + exception.getMessage()).initCause(exception);
        }
    }

    private boolean prepare(ByteBuffer[] byteBufferArray, int n2) {
        ByteBuffer byteBuffer = byteBufferArray[0];
        if (byteBuffer.compact().remaining() < n2) {
            int n3 = byteBuffer.position();
            int n4 = n3 + n2;
            if (n4 <= 2 * n2) {
                byteBuffer = ByteBuffer.allocate(n4);
                if (n3 > 0) {
                    byteBufferArray[0].flip();
                    byteBuffer.put(byteBufferArray[0]);
                    byteBufferArray[0] = byteBuffer;
                }
            } else {
                byteBuffer.flip();
                byteBuffer = null;
            }
        }
        return byteBuffer != null;
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return null;
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        return null;
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        return null;
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> socketOption, T t2) throws IOException {
        return null;
    }

    @Override
    public SocketChannel bind(SocketAddress socketAddress) throws IOException {
        return null;
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return null;
    }

    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        return null;
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return null;
    }

    static {
        try {
            $$$methodRef$$$37 = SSLSocketChannel.class.getDeclaredConstructor(SocketChannel.class, SSLEngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = SSLSocketChannel.class.getDeclaredMethod("bind", SocketAddress.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = SSLSocketChannel.class.getDeclaredMethod("setOption", SocketOption.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = SSLSocketChannel.class.getDeclaredMethod("getLocalAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = SSLSocketChannel.class.getDeclaredMethod("getOption", SocketOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = SSLSocketChannel.class.getDeclaredMethod("supportedOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = SSLSocketChannel.class.getDeclaredMethod("bind", SocketAddress.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = SSLSocketChannel.class.getDeclaredMethod("setOption", SocketOption.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = SSLSocketChannel.class.getDeclaredMethod("shutdownInput", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = SSLSocketChannel.class.getDeclaredMethod("shutdownOutput", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = SSLSocketChannel.class.getDeclaredMethod("getRemoteAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = SSLSocketChannel.class.getDeclaredMethod("prepare", ByteBuffer[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = SSLSocketChannel.class.getDeclaredMethod("runTasks", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = SSLSocketChannel.class.getDeclaredMethod("flush", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = SSLSocketChannel.class.getDeclaredMethod("fill", ByteBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = SSLSocketChannel.class.getDeclaredMethod("fill", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = SSLSocketChannel.class.getDeclaredMethod("wrap", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = SSLSocketChannel.class.getDeclaredMethod("unwrap", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = SSLSocketChannel.class.getDeclaredMethod("implConfigureBlocking", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = SSLSocketChannel.class.getDeclaredMethod("implCloseSelectableChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = SSLSocketChannel.class.getDeclaredMethod("getSession", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = SSLSocketChannel.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = SSLSocketChannel.class.getDeclaredMethod("shutdown", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = SSLSocketChannel.class.getDeclaredMethod("handshake", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = SSLSocketChannel.class.getDeclaredMethod("decrypted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = SSLSocketChannel.class.getDeclaredMethod("encrypted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = SSLSocketChannel.class.getDeclaredMethod("finished", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = SSLSocketChannel.class.getDeclaredMethod("getAdapteeChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = SSLSocketChannel.class.getDeclaredMethod("write", ByteBuffer[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = SSLSocketChannel.class.getDeclaredMethod("write", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = SSLSocketChannel.class.getDeclaredMethod("read", ByteBuffer[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = SSLSocketChannel.class.getDeclaredMethod("read", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = SSLSocketChannel.class.getDeclaredMethod("finishConnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = SSLSocketChannel.class.getDeclaredMethod("connect", SocketAddress.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = SSLSocketChannel.class.getDeclaredMethod("isConnectionPending", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = SSLSocketChannel.class.getDeclaredMethod("isConnected", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = SSLSocketChannel.class.getDeclaredMethod("socket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = SSLSocketChannel.class.getDeclaredMethod("getUnderlyingChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

