/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.net.nt.ConnOption;
import oracle.net.nt.DownHostsCacheKey;

class DownHostsCache {
    private static final DownHostsCache SOLE_INSTANCE;
    static int DOWN_HOSTS_TIMEOUT;
    private static final int MIN_TIME_BETWEEN_PURGES = 60;
    private Map<DownHostsCacheKey, LocalDateTime> downHostsCacheMap = new ConcurrentHashMap<DownHostsCacheKey, LocalDateTime>();
    private LocalDateTime lastPurge = LocalDateTime.MIN;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    private DownHostsCache() {
    }

    static DownHostsCache getInstance() {
        return SOLE_INSTANCE;
    }

    LocalDateTime markDownHost(InetAddress inetAddress, int n2) {
        return this.downHostsCacheMap.put(new DownHostsCacheKey(inetAddress.getHostAddress(), n2), LocalDateTime.now());
    }

    void reorderAddresses(InetAddress[] inetAddressArray, int n2) {
        this.refreshCache();
        int n3 = 0;
        int n4 = inetAddressArray.length - 1;
        while (n3 < n4) {
            while (n3 <= n4 && !this.isDownHostsCached(inetAddressArray[n3], n2)) {
                ++n3;
            }
            while (n4 >= n3 && this.isDownHostsCached(inetAddressArray[n4], n2)) {
                --n4;
            }
            if (n3 >= n4) continue;
            DownHostsCache.swap(inetAddressArray, n3, n4);
        }
    }

    private static <T> void swap(T[] TArray, int n2, int n3) {
        T t2 = TArray[n2];
        TArray[n2] = TArray[n3];
        TArray[n3] = t2;
    }

    private void refreshCache() {
        if (LocalDateTime.now().minus(60L, ChronoUnit.SECONDS).isAfter(this.lastPurge)) {
            for (DownHostsCacheKey downHostsCacheKey : this.downHostsCacheMap.keySet()) {
                if (LocalDateTime.now().minus(DOWN_HOSTS_TIMEOUT, ChronoUnit.SECONDS).compareTo(this.downHostsCacheMap.get(downHostsCacheKey)) <= 0) continue;
                this.downHostsCacheMap.remove(downHostsCacheKey);
            }
            this.lastPurge = LocalDateTime.now();
        }
    }

    private boolean isDownHostsCached(InetAddress inetAddress, int n2) {
        DownHostsCacheKey downHostsCacheKey = new DownHostsCacheKey(inetAddress.getHostAddress(), n2);
        return this.downHostsCacheMap.containsKey(downHostsCacheKey);
    }

    LocalDateTime markDownHost(ConnOption connOption) {
        return this.downHostsCacheMap.put(new DownHostsCacheKey(connOption.addr, connOption.port), LocalDateTime.now());
    }

    void reorderAddresses(List<ConnOption> list) {
        this.refreshCache();
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 < n3) {
            while (n2 <= n3 && !this.isDownHostsCached(list.get(n2))) {
                ++n2;
            }
            while (n3 >= n2 && this.isDownHostsCached(list.get(n3))) {
                --n3;
            }
            if (n2 >= n3) continue;
            Collections.swap(list, n2, n3);
        }
    }

    private boolean isDownHostsCached(ConnOption connOption) {
        DownHostsCacheKey downHostsCacheKey = new DownHostsCacheKey(connOption.addr, connOption.port);
        return this.downHostsCacheMap.containsKey(downHostsCacheKey);
    }

    static {
        try {
            $$$methodRef$$$9 = DownHostsCache.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = DownHostsCache.class.getDeclaredMethod("isDownHostsCached", ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = DownHostsCache.class.getDeclaredMethod("reorderAddresses", List.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = DownHostsCache.class.getDeclaredMethod("markDownHost", ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = DownHostsCache.class.getDeclaredMethod("isDownHostsCached", InetAddress.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = DownHostsCache.class.getDeclaredMethod("refreshCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = DownHostsCache.class.getDeclaredMethod("swap", Object[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = DownHostsCache.class.getDeclaredMethod("reorderAddresses", InetAddress[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = DownHostsCache.class.getDeclaredMethod("markDownHost", InetAddress.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = DownHostsCache.class.getDeclaredMethod("getInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        SOLE_INSTANCE = new DownHostsCache();
        DOWN_HOSTS_TIMEOUT = Integer.parseInt("600");
    }
}

