/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.nl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;

public class NLParamParser {
    private String filename;
    private Hashtable ht;
    private Vector linebuffer;
    private int filePermissions = 0;
    private int Commentcnt = 0;
    private int nvStringcnt = 0;
    private int Groupcnt = 0;
    private boolean hasComments = false;
    private boolean hasGroups = false;
    private String[] errstr;
    private int errstrcnt;
    private static final int MAX_ERRORS = 50;
    public static final byte IGNORE_NONE = 0;
    public static final byte IGNORE_NL_EXCEPTION = 1;
    public static final byte IGNORE_FILE_EXCEPTION = 2;
    public static final byte NLPASUCC = 1;
    public static final byte NLPAOVWR = 2;
    public static final byte NLPAFAIL = -1;
    private static boolean DEBUG;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;

    public static NLParamParser createEmptyParamParser() {
        return new NLParamParser();
    }

    private NLParamParser() {
        this.filename = null;
        this.ht = new Hashtable(128);
    }

    public NLParamParser(String string) throws IOException, NLException {
        this(string, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NLParamParser(String string, byte by) throws NLException, IOException {
        this.filename = string;
        this.ht = new Hashtable(128);
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            this.initializeNlpa(bufferedReader, by);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if ((by & 2) == 0) {
                throw new FileNotFoundException(string);
            }
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public NLParamParser(Reader reader) throws IOException, NLException {
        this(reader, 0);
    }

    public NLParamParser(Reader reader, byte by) throws IOException, NLException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        this.filename = null;
        this.ht = new Hashtable(128);
        this.initializeNlpa(bufferedReader, by);
    }

    private void initializeNlpa(BufferedReader bufferedReader, byte by) throws IOException, NLException {
        String string;
        block28: {
            this.linebuffer = new Vector(100, 50);
            this.errstr = new String[50];
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    this.linebuffer.addElement(string);
                }
            }
            catch (IOException iOException) {
                if ((by & 2) != 0) break block28;
                throw new IOException("Unable to read a line from : " + this.filename);
            }
        }
        string = "";
        String string2 = System.getProperty("line.separator");
        String string3 = "";
        String string4 = "";
        for (int i2 = 0; i2 < this.linebuffer.size(); ++i2) {
            block32: {
                String string5;
                block31: {
                    string5 = (String)this.linebuffer.elementAt(i2);
                    if (string5.length() == 0) continue;
                    if (string5.charAt(0) == '#') {
                        if (string5.indexOf(".ORA Configuration ") != -1 || string5.indexOf(" Network Configuration File: ") != -1 || string5.indexOf("Generated by") != -1) {
                            if (!DEBUG) continue;
                            System.out.println(string5 + ": this comment ignored");
                            continue;
                        }
                        if (string3.length() != 0) {
                            string4 = string4 + string5 + string2;
                            continue;
                        }
                        string3 = "COMMENT#" + this.Commentcnt;
                        string4 = string5 + string2;
                        if (this.hasComments) continue;
                        this.hasComments = true;
                        continue;
                    }
                    if (string5.charAt(0) == ' ' || string5.charAt(0) == '\t' || string5.charAt(0) == ')') {
                        if (string4.length() == 0) {
                            if (string.length() == 0) {
                                string5 = this.eatNLPWS(string5);
                            }
                            if ((string5 = this.checkNLPforComments(string5)).length() == 0) continue;
                            string = string + string5 + string2;
                            continue;
                        }
                        if (string.length() == 0 && string4.length() != 0) {
                            string5 = this.eatNLPWS(string5);
                            if ((string5 = this.checkNLPforComments(string5)).length() == 0 || (by & 1) != 0) continue;
                            throw new NLException("InvalidChar-04611", "");
                        }
                        if (string.length() == 0 || string4.length() == 0) continue;
                        string3 = "";
                        string4 = "";
                        string5 = this.checkNLPforComments(string5);
                        string = string + string5 + string2;
                        continue;
                    }
                    if (string.length() == 0 && string4.length() == 0) {
                        string5 = this.checkNLPforComments(string5);
                        string = string + string5 + string2;
                        continue;
                    }
                    if (string.length() == 0 && string4.length() != 0) {
                        block29: {
                            string4 = this.modifyCommentString(string4);
                            try {
                                this.addNLPListElement(string3 + "=" + string4);
                            }
                            catch (NLException nLException) {
                                this.storeError(string, by);
                                if ((by & 1) != 0) break block29;
                                throw nLException;
                            }
                        }
                        string3 = "";
                        string4 = "";
                        ++this.Commentcnt;
                        string5 = this.checkNLPforComments(string5);
                        string = string + string5 + string2;
                        continue;
                    }
                    if (string.length() != 0 && string4.length() == 0) {
                        block30: {
                            try {
                                this.addNLPListElement(string);
                            }
                            catch (NLException nLException) {
                                this.storeError(string, by);
                                if ((by & 1) != 0) break block30;
                                throw nLException;
                            }
                        }
                        string = "";
                        string5 = this.checkNLPforComments(string5);
                        string = string + string5 + string2;
                        continue;
                    }
                    if (string.length() == 0 || string4.length() == 0) continue;
                    try {
                        this.addNLPListElement(string);
                    }
                    catch (NLException nLException) {
                        this.storeError(string, by);
                        if ((by & 1) != 0) break block31;
                        throw nLException;
                    }
                }
                string = "";
                string5 = this.checkNLPforComments(string5);
                string = string + string5 + string2;
                string4 = this.modifyCommentString(string4);
                try {
                    this.addNLPListElement(string3 + "=" + string4);
                }
                catch (NLException nLException) {
                    this.storeError(string, by);
                    if ((by & 1) != 0) break block32;
                    throw nLException;
                }
            }
            string3 = "";
            string4 = "";
            ++this.Commentcnt;
        }
        if (string.length() != 0) {
            block33: {
                try {
                    this.addNLPListElement(string);
                }
                catch (NLException nLException) {
                    this.storeError(string, by);
                    if ((by & 1) != 0) break block33;
                    throw nLException;
                }
            }
            string = "";
        }
        if (string4.length() != 0) {
            block34: {
                string4 = this.modifyCommentString(string4);
                try {
                    this.addNLPListElement(string3 + "=" + string4);
                }
                catch (NLException nLException) {
                    this.storeError(string, by);
                    if ((by & 1) != 0) break block34;
                    throw nLException;
                }
            }
            string3 = "";
            string4 = "";
            ++this.Commentcnt;
        }
    }

    private String modifyCommentString(String string) {
        String string2 = "";
        boolean bl = false;
        block7: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '(': {
                    string2 = string2 + "\\(";
                    continue block7;
                }
                case '=': {
                    string2 = string2 + "\\=";
                    continue block7;
                }
                case ')': {
                    string2 = string2 + "\\)";
                    continue block7;
                }
                case ',': {
                    string2 = string2 + "\\,";
                    continue block7;
                }
                case '\\': {
                    string2 = string2 + "\\\\";
                    continue block7;
                }
                default: {
                    string2 = string2 + string.charAt(i2);
                }
            }
        }
        return string2;
    }

    private String checkNLPforComments(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '#') {
                if (i2 != 0) {
                    if (string.charAt(i2 - 1) != '\\') break;
                    stringBuffer.append(c2);
                    continue;
                }
                return "";
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private String eatNLPWS(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        boolean bl = false;
        while (!bl) {
            char c2;
            if ((c2 = string.charAt(n2++)) != ' ' || c2 != '\t') {
                bl = true;
                int n3 = n2 - 1;
                while (string.charAt(n3) == '\n') {
                    stringBuffer.append(string.charAt(n3));
                    ++n3;
                }
                continue;
            }
            if (c2 != '\n') continue;
            return "";
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNLParams() throws IOException {
        if (this.filename == null) {
            return;
        }
        try (FileWriter fileWriter = null;){
            fileWriter = new FileWriter(this.filename);
            String string = "unknown";
            StringTokenizer stringTokenizer = new StringTokenizer(this.filename, File.separator);
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
            this.writeToStream(fileWriter, string, this.filename);
        }
    }

    public void writeToStream(Writer writer, String string, String string2) {
        PrintWriter printWriter = null;
        printWriter = new PrintWriter(new BufferedWriter(writer));
        printWriter.println("# " + string + " Network Configuration File: " + string2 + "");
        printWriter.println("# Generated by Oracle configuration tools.");
        printWriter.println("");
        if (this.hasGroups) {
            this.saveNLPGroups(printWriter);
        }
        Enumeration enumeration = this.ht.elements();
        while (enumeration.hasMoreElements()) {
            NVPair nVPair = (NVPair)enumeration.nextElement();
            String string3 = nVPair.toString(0, true);
            if (DEBUG) {
                System.out.println("The initial stringified NVPair is:\n" + string3);
            }
            if (string3.equals("")) continue;
            char[] cArray = new char[string3.length() - 2];
            string3.getChars(1, string3.length() - 1, cArray, 0);
            String string4 = new String(cArray);
            if (DEBUG) {
                System.out.println("The modified NV String is:\n" + string4);
            }
            printWriter.println(string4);
            printWriter.println("");
            cArray = null;
        }
        printWriter.close();
    }

    public void saveNLParams(String string) throws FileNotFoundException, IOException {
        String string2 = this.filename;
        this.filename = string;
        this.saveNLParams();
        this.filename = string2;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean configuredInFile() {
        return this.filename != null;
    }

    public int getNLPListSize() {
        this.nvStringcnt = 0;
        Enumeration enumeration = this.ht.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf("COMMENT") != -1) continue;
            ++this.nvStringcnt;
        }
        return this.nvStringcnt;
    }

    public boolean inErrorList(String string) {
        boolean bl = false;
        if (DEBUG) {
            System.out.println("Entering inErrorList():");
        }
        for (int i2 = 0; !(bl && i2 >= this.errstrcnt || this.errstrcnt == 0); ++i2) {
            if (this.errstr[i2].indexOf(string) == -1) continue;
            bl = true;
        }
        return bl;
    }

    public NVPair getNLPListElement(String string) {
        String string2 = string.toUpperCase();
        return (NVPair)this.ht.get(string2);
    }

    public String[] getNLPAllNames() {
        int n2 = this.getNLPListSize();
        String[] stringArray = new String[n2];
        int n3 = 0;
        Enumeration enumeration = this.ht.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf("COMMENT") != -1) continue;
            stringArray[n3++] = string;
        }
        return stringArray;
    }

    public String[] getNLPAllElements() {
        int n2 = this.getNLPListSize();
        String[] stringArray = new String[n2];
        int n3 = 0;
        Enumeration enumeration = this.ht.elements();
        while (enumeration.hasMoreElements()) {
            NVPair nVPair = (NVPair)enumeration.nextElement();
            if (nVPair.getName().indexOf("COMMENT") != -1) continue;
            String string = nVPair.toString();
            stringArray[n3++] = string;
        }
        return stringArray;
    }

    public byte addNLPListElement(String string, Object object) {
        try {
            Object object2 = this.ht.put(string, object);
            return object2 != null ? (byte)2 : 1;
        }
        catch (NullPointerException nullPointerException) {
            if (DEBUG) {
                System.out.println(nullPointerException.getMessage());
            }
            return -1;
        }
    }

    public void addNLPGroupProfile(String[] stringArray) {
        String string = new String("GROUP#" + this.Groupcnt++);
        String[] stringArray2 = stringArray;
        if (!this.hasGroups) {
            this.hasGroups = true;
        }
        this.addNLPListElement(string, stringArray2);
    }

    private String[] getNLPGroupProfile(String string) {
        String string2 = string.toUpperCase();
        return (String[])this.ht.get(string2);
    }

    private void saveNLPGroups(PrintWriter printWriter) {
        for (int i2 = 0; i2 < this.Groupcnt; ++i2) {
            String string = new String("GROUP#" + i2);
            String[] stringArray = this.getNLPGroupProfile(string);
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                String string2 = null;
                String string3 = null;
                NVPair nVPair = null;
                if (DEBUG) {
                    System.out.println("Current Value in Group Profile: " + stringArray[i3]);
                }
                if (stringArray[i3] == null) continue;
                nVPair = this.getNLPListElement(stringArray[i3]);
                if (nVPair != null) {
                    string2 = nVPair.toString(0, true);
                    if (DEBUG) {
                        System.out.println("Parameter Value = " + string2);
                    }
                    char[] cArray = new char[string2.length() - 2];
                    string2.getChars(1, string2.length() - 1, cArray, 0);
                    string3 = new String(cArray);
                    printWriter.println(string3);
                    printWriter.println("");
                    NVPair nVPair2 = this.removeNLPListElement(stringArray[i3]);
                    if (nVPair2 == null && DEBUG) {
                        System.out.println("saveNLPGroups(): Could notremove param from Hashtable");
                    }
                    cArray = null;
                    string3 = null;
                    continue;
                }
                if (!DEBUG) continue;
                System.out.println("No such Parameter in the Table");
            }
            this.removeNLPGroupProfile(string);
        }
    }

    public void addNLPListElement(String string) throws NLException {
        Object object;
        char[] cArray = new char[string.length() + 2];
        String string2 = "";
        if (DEBUG) {
            System.out.println("Entering Method addNLPListElement\n");
            System.out.println("String to add is: " + string + "");
        }
        string.getChars(0, string.length(), cArray, 1);
        if (cArray[1] == '(') {
            string2 = string;
        } else {
            cArray[0] = 40;
            object = System.getProperty("os.name");
            if (((String)object).equals("Windows NT") || ((String)object).equals("Windows 95")) {
                if (cArray[cArray.length - 2] == '/' || cArray[cArray.length - 2] == '\\') {
                    cArray[cArray.length - 2] = 41;
                } else {
                    cArray[cArray.length - 1] = 41;
                }
            } else if (cArray[cArray.length - 2] == '\\') {
                cArray[cArray.length - 2] = 41;
            } else {
                cArray[cArray.length - 1] = 41;
            }
            string2 = new String(cArray);
            if (DEBUG) {
                System.out.println("The modified NV String is: " + string2 + "");
            }
        }
        object = new NVFactory();
        NVPair nVPair = ((NVFactory)object).createNVPair(string2);
        if (nVPair.getRHSType() == NVPair.RHS_NONE) {
            throw new NLException("NullRHS-04612", nVPair.getName());
        }
        String string3 = nVPair.getName();
        String string4 = string3.toUpperCase();
        nVPair.setName(string4);
        if (DEBUG) {
            System.out.println("The final NV String is: " + nVPair.toString() + "");
        }
        byte by = this.addNLPListElement(string4, nVPair);
        switch (by) {
            case 2: {
                if (!DEBUG) break;
                System.out.println("The value for the Name: " + string3 + " was overwritten\n");
                break;
            }
            case -1: {
                if (!DEBUG) break;
                System.out.println("The value for the Name: " + string3 + " could not be inserted\n");
            }
        }
    }

    public NVPair removeNLPListElement(String string) {
        Object v2;
        String string2 = string.toUpperCase();
        if (DEBUG) {
            System.out.println("Trying to remove: " + string2 + " from Table");
        }
        return (v2 = this.ht.remove(string2)) != null ? (NVPair)v2 : null;
    }

    public void removeNLPGroupProfile(String string) {
        String string2 = string.toUpperCase();
        if (DEBUG) {
            System.out.println("Trying to remove: " + string2 + " GroupName from Table");
        }
        Object v2 = this.ht.remove(string2);
    }

    public void removeNLPAllElements() {
        this.ht.clear();
    }

    @DisableTrace
    public String toString() {
        String string = "";
        Enumeration enumeration = this.ht.elements();
        while (enumeration.hasMoreElements()) {
            NVPair nVPair = (NVPair)enumeration.nextElement();
            String string2 = nVPair.toString();
            string = string + string2 + "\n";
        }
        return string;
    }

    public boolean fileHasComments() {
        return this.hasComments;
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void setFilePermissions(int n2) {
        this.filePermissions = n2;
    }

    private void storeError(String string, byte by) throws NLException {
        if (this.errstrcnt < 50) {
            this.errstr[this.errstrcnt++] = string;
        } else if ((by & 1) == 0) {
            throw new NLException("Too many errors", "");
        }
    }

    static {
        try {
            $$$methodRef$$$31 = NLParamParser.class.getDeclaredConstructor(Reader.class, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = NLParamParser.class.getDeclaredConstructor(Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = NLParamParser.class.getDeclaredConstructor(String.class, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = NLParamParser.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = NLParamParser.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = NLParamParser.class.getDeclaredMethod("storeError", String.class, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = NLParamParser.class.getDeclaredMethod("setFilePermissions", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = NLParamParser.class.getDeclaredMethod("println", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = NLParamParser.class.getDeclaredMethod("fileHasComments", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = NLParamParser.class.getDeclaredMethod("removeNLPAllElements", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = NLParamParser.class.getDeclaredMethod("removeNLPGroupProfile", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = NLParamParser.class.getDeclaredMethod("removeNLPListElement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = NLParamParser.class.getDeclaredMethod("addNLPListElement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = NLParamParser.class.getDeclaredMethod("saveNLPGroups", PrintWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = NLParamParser.class.getDeclaredMethod("getNLPGroupProfile", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = NLParamParser.class.getDeclaredMethod("addNLPGroupProfile", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = NLParamParser.class.getDeclaredMethod("addNLPListElement", String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = NLParamParser.class.getDeclaredMethod("getNLPAllElements", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = NLParamParser.class.getDeclaredMethod("getNLPAllNames", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = NLParamParser.class.getDeclaredMethod("getNLPListElement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NLParamParser.class.getDeclaredMethod("inErrorList", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NLParamParser.class.getDeclaredMethod("getNLPListSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NLParamParser.class.getDeclaredMethod("configuredInFile", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NLParamParser.class.getDeclaredMethod("getFilename", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NLParamParser.class.getDeclaredMethod("saveNLParams", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NLParamParser.class.getDeclaredMethod("writeToStream", Writer.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NLParamParser.class.getDeclaredMethod("saveNLParams", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NLParamParser.class.getDeclaredMethod("eatNLPWS", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NLParamParser.class.getDeclaredMethod("checkNLPforComments", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NLParamParser.class.getDeclaredMethod("modifyCommentString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NLParamParser.class.getDeclaredMethod("initializeNlpa", BufferedReader.class, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NLParamParser.class.getDeclaredMethod("createEmptyParamParser", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        DEBUG = false;
    }
}

