/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;

@ProxyFor(value={OracleBlob.class})
@ProxyAccess(value=ACProxyable.class)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class TxnReplayableBlob
extends TxnReplayableBase
implements JDBCReplayable {
    private static final Method GETBINSTREAM_METHOD;
    private static final Method GETBINSTREAM_LONG_METHOD;
    private static final Method GETBINSTREAM_LONG_LONG_METHOD;
    private static final Method SETBINSTREAM_LONG_METHOD;
    protected boolean isFreed = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;

    protected TxnReplayableBlob() {
        this.thisProxyNameInLog = "BLOB" + this.thisProxyNameInLog;
    }

    private static final Method getGetBinaryStreamMethod() {
        try {
            return OracleBlob.class.getMethod("getBinaryStream", new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetBinaryStreamLongMethod() {
        try {
            return OracleBlob.class.getMethod("getBinaryStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetBinaryStreamLongLongMethod() {
        try {
            return OracleBlob.class.getMethod("getBinaryStream", Long.TYPE, Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getSetBinaryStreamLongMethod() {
        try {
            return OracleBlob.class.getMethod("setBinaryStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        if (object instanceof TxnReplayableBase) {
            TxnReplayableBase txnReplayableBase = (TxnReplayableBase)object;
            txnReplayableBase.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="free", args={})})
    protected void postForFree(Method method) {
        super.postForAll(method);
        this.isFreed = true;
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public Object replayOneCall(TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        if (callHistoryEntry == this.headSameProxy) {
            this.isFreed = false;
        }
        return super.replayOneCall(callHistoryEntry, sQLRecoverableException);
    }

    public InputStream getBinaryStream() throws SQLException {
        if (GETBINSTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method method = GETBINSTREAM_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, new Object[0]);
        try {
            OracleBlob oracleBlob = (OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            InputStream inputStream = oracleBlob.canReadBasicLobDataInLocator() ? oracleBlob.getBinaryStream() : oracleBlob.getDBAccess().newInputStream((OracleBlob)((Object)this), oracleBlob.getBufferSize(), 0L);
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public InputStream getBinaryStream(long l2) throws SQLException {
        if (GETBINSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method method = GETBINSTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2);
        try {
            InputStream inputStream;
            OracleBlob oracleBlob = (OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (oracleBlob.canReadBasicLobDataInLocator()) {
                inputStream = oracleBlob.getBinaryStream(l2);
            } else {
                if (l2 < 1L) {
                    SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                inputStream = oracleBlob.getDBAccess().newInputStream((OracleBlob)((Object)this), oracleBlob.getBufferSize(), l2);
            }
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        if (GETBINSTREAM_LONG_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method method = GETBINSTREAM_LONG_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2, l3);
        try {
            InputStream inputStream;
            OracleBlob oracleBlob = (OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (oracleBlob.canReadBasicLobDataInLocator()) {
                inputStream = oracleBlob.getBinaryStream(l2, l3);
            } else {
                long l4 = oracleBlob.length();
                if (l2 < 1L || l3 < 0L || l2 > l4 || l2 - 1L + l3 > l4) {
                    SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                inputStream = oracleBlob.getDBAccess().newInputStream((OracleBlob)((Object)this), oracleBlob.getBufferSize(), l2, l3);
            }
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public OutputStream setBinaryStream(long l2) throws SQLException {
        if (SETBINSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot set binary stream");
        }
        Method method = SETBINSTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2);
        try {
            OracleBlob oracleBlob = (OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            OutputStream outputStream = oracleBlob.getDBAccess().newOutputStream((OracleBlob)((Object)this), oracleBlob.getBufferSize(), l2, true);
            return (OutputStream)this.postForAll(method, outputStream);
        }
        catch (SQLException sQLException) {
            return (OutputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.setBinaryStream(1L);
    }

    public OutputStream getBinaryOutputStream(long l2) throws SQLException {
        return this.setBinaryStream(l2);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        OracleBlob oracleBlob = (OracleBlob)this.getDelegate();
        return oracleBlob.getInternalConnection();
    }

    static {
        try {
            $$$methodRef$$$18 = TxnReplayableBlob.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = TxnReplayableBlob.class.getDeclaredMethod("getInternalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = TxnReplayableBlob.class.getDeclaredMethod("getBinaryOutputStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = TxnReplayableBlob.class.getDeclaredMethod("getBinaryOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = TxnReplayableBlob.class.getDeclaredMethod("setBinaryStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = TxnReplayableBlob.class.getDeclaredMethod("getBinaryStream", Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = TxnReplayableBlob.class.getDeclaredMethod("getBinaryStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = TxnReplayableBlob.class.getDeclaredMethod("getBinaryStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = TxnReplayableBlob.class.getDeclaredMethod("replayOneCall", TxnFailoverManagerImpl.CallHistoryEntry.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = TxnReplayableBlob.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = TxnReplayableBlob.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = TxnReplayableBlob.class.getDeclaredMethod("postForFree", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = TxnReplayableBlob.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = TxnReplayableBlob.class.getDeclaredMethod("postForAll", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = TxnReplayableBlob.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = TxnReplayableBlob.class.getDeclaredMethod("getSetBinaryStreamLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = TxnReplayableBlob.class.getDeclaredMethod("getGetBinaryStreamLongLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = TxnReplayableBlob.class.getDeclaredMethod("getGetBinaryStreamLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = TxnReplayableBlob.class.getDeclaredMethod("getGetBinaryStreamMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        GETBINSTREAM_METHOD = TxnReplayableBlob.getGetBinaryStreamMethod();
        GETBINSTREAM_LONG_METHOD = TxnReplayableBlob.getGetBinaryStreamLongMethod();
        GETBINSTREAM_LONG_LONG_METHOD = TxnReplayableBlob.getGetBinaryStreamLongLongMethod();
        SETBINSTREAM_LONG_METHOD = TxnReplayableBlob.getSetBinaryStreamLongMethod();
    }
}

