/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.jdbc.proxy.AnnotationsRegistry;
import oracle.jdbc.proxy.ClassGenerator;
import oracle.jdbc.proxy.GeneratedProxiesRegistry;
import oracle.jdbc.proxy.ProxyFactory;

public class ProxyExport {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    public static void main(String[] stringArray) throws ClassNotFoundException, IOException {
        if (0 == stringArray.length) {
            System.out.println("Usage:");
            System.out.println("java -classpath ojdbc6.jar oracle.jdbc.proxy.ProxyExport [-d dir] class1 class2 class3 ...");
            System.out.println("  dir - directory to store exported proxy classes");
            System.out.println("  class1 class2 class3 ... - superclasses equipped with @ProxyFor annotation");
            return;
        }
        int n2 = 0;
        String string = "";
        if ("-d".equals(stringArray[0])) {
            if (stringArray.length < 2) {
                System.out.println("wrong directory");
                return;
            }
            string = stringArray[1];
            n2 = 2;
            if (!new File(string).exists()) {
                System.out.println("target directory does not exist");
                return;
            }
            if (0 != string.length() && !string.endsWith(File.separator)) {
                string = string + File.separator;
            }
        }
        ArrayList arrayList = new ArrayList();
        while (n2 < stringArray.length) {
            arrayList.add(Class.forName(stringArray[n2]));
            ++n2;
        }
        ProxyFactory proxyFactory = ProxyFactory.createProxyFactory(arrayList.toArray(new Class[0]));
        AnnotationsRegistry annotationsRegistry = proxyFactory.annotationsRegistry;
        for (AnnotationsRegistry.Value value : annotationsRegistry.values()) {
            Class clazz = value.getSuperclass();
            for (Class clazz2 : value.getIfacesToProxy()) {
                Object object;
                GeneratedProxiesRegistry.Key key = new GeneratedProxiesRegistry.Key(clazz2, clazz);
                byte[] byArray = ClassGenerator.generateBytecode(key, proxyFactory.annotationsRegistry);
                String string2 = key.makePathname();
                int n3 = string2.lastIndexOf(File.separator);
                if (-1 != n3) {
                    object = string2.substring(0, n3);
                    new File(string + (String)object).mkdirs();
                }
                object = new BufferedOutputStream(new FileOutputStream(string + string2));
                ((FilterOutputStream)object).write(byArray);
                ((FilterOutputStream)object).close();
            }
        }
    }

    static {
        try {
            $$$methodRef$$$1 = ProxyExport.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ProxyExport.class.getDeclaredMethod("main", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

