/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.driver.NTFConnection;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CHANGE_NOTIFICATION})
class NTFListener
extends Thread {
    private ArrayList<NTFConnection> connections;
    private int nbOfConnections = 0;
    private boolean needsToBeClosed = false;
    NTFManager dcnManager;
    ServerSocketChannel ssChannel;
    int tcpport;
    public Properties socketOptions;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    NTFListener(NTFManager nTFManager, ServerSocketChannel serverSocketChannel, int n2, Properties properties) {
        this.dcnManager = nTFManager;
        this.connections = new ArrayList(10);
        this.ssChannel = serverSocketChannel;
        this.tcpport = n2;
        this.socketOptions = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Selector selector = Selector.open();
            this.ssChannel.register(selector, 16);
            block5: while (true) {
                selector.select();
                if (this.needsToBeClosed) break;
                Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block5;
                    SelectionKey selectionKey = iterator.next();
                    if ((selectionKey.readyOps() & 0x10) != 16) continue;
                    ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
                    SocketChannel socketChannel = serverSocketChannel.accept();
                    NTFConnection nTFConnection = new NTFConnection(this.dcnManager, socketChannel, this);
                    ArrayList<NTFConnection> arrayList = this.connections;
                    synchronized (arrayList) {
                        this.connections.add(nTFConnection);
                    }
                    nTFConnection.start();
                    iterator.remove();
                }
                break;
            }
            selector.close();
            this.ssChannel.close();
        }
        catch (IOException iOException) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeThisListener() {
        ArrayList<NTFConnection> arrayList = this.connections;
        synchronized (arrayList) {
            for (NTFConnection nTFConnection : this.connections) {
                nTFConnection.closeThisConnection();
                nTFConnection.interrupt();
            }
            this.needsToBeClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseConnection(NTFConnection nTFConnection) {
        ArrayList<NTFConnection> arrayList = this.connections;
        synchronized (arrayList) {
            this.connections.remove(nTFConnection);
        }
    }

    static {
        try {
            $$$methodRef$$$3 = NTFListener.class.getDeclaredConstructor(NTFManager.class, ServerSocketChannel.class, Integer.TYPE, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFListener.class.getDeclaredMethod("releaseConnection", NTFConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFListener.class.getDeclaredMethod("closeThisListener", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFListener.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

