/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.spi;

import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;

public interface OracleResourceProvider<T> {
    public Class<? extends T> providedType();

    public boolean isProviderFor(CharSequence var1);

    public T get(CharSequence var1);

    default public <U> OracleResourceProvider<U> asProviderOf(Class<U> type) {
        Objects.requireNonNull(type, "type is null");
        if (type.isAssignableFrom(this.providedType())) {
            return this;
        }
        throw new UnsupportedOperationException(String.format("Provider of type %s can not provide values of type %s", this.providedType(), type));
    }

    public static <T> T findAndGet(Class<T> type, CharSequence identifier) {
        Objects.requireNonNull(type, "type is null");
        return OracleResourceProvider.find(identifier).orElseThrow(() -> new IllegalStateException("No provider found")).asProviderOf(type).get(identifier);
    }

    public static Optional<OracleResourceProvider<?>> find(CharSequence identifier) {
        Objects.requireNonNull(identifier, "identifier is null");
        for (OracleResourceProvider provider : ServiceLoader.load(OracleResourceProvider.class)) {
            if (!provider.isProviderFor(identifier)) continue;
            return Optional.of(provider);
        }
        return Optional.empty();
    }
}

