/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.time.Duration;
import java.time.Period;
import java.util.Map;
import oracle.jdbc.driver.json.JakartaGeneratorWrapper;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.JsonpGeneratorWrapper;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonValue;

public abstract class AbstractGenerator
implements OracleJsonGenerator {
    AbstractGenerator() {
    }

    @Override
    public abstract OracleJsonGenerator writeKey(String var1);

    @Override
    public final OracleJsonGenerator writeStartObject(String key) {
        this.writeKey(key);
        this.writeStartObject();
        return this;
    }

    @Override
    public final OracleJsonGenerator writeStartArray(String key) {
        this.writeKey(key);
        return this.writeStartArray();
    }

    @Override
    public final OracleJsonGenerator write(String key, OracleJsonValue value) {
        this.writeKey(key);
        return this.write(value);
    }

    @Override
    public final OracleJsonGenerator write(String key, String value) {
        this.writeKey(key);
        return this.write(value);
    }

    @Override
    public final OracleJsonGenerator write(String key, BigInteger value) {
        this.writeKey(key);
        return this.write(value);
    }

    @Override
    public final OracleJsonGenerator write(String key, BigDecimal value) {
        this.writeKey(key);
        return this.write(value);
    }

    @Override
    public final OracleJsonGenerator write(String key, int value) {
        this.writeKey(key);
        return this.write(value);
    }

    @Override
    public final OracleJsonGenerator write(String key, long value) {
        this.writeKey(key);
        return this.write(value);
    }

    @Override
    public final OracleJsonGenerator write(String key, double value) {
        this.writeKey(key);
        return this.write(value);
    }

    @Override
    public final OracleJsonGenerator write(String key, float value) {
        this.writeKey(key);
        return this.write(value);
    }

    @Override
    public final OracleJsonGenerator write(String key, boolean value) {
        this.writeKey(key);
        return this.write(value);
    }

    @Override
    public final OracleJsonGenerator writeNull(String key) {
        this.writeKey(key);
        return this.writeNull();
    }

    @Override
    public OracleJsonGenerator write(String key, Period value) {
        this.writeKey(key);
        return this.write(value);
    }

    @Override
    public OracleJsonGenerator write(String key, Duration value) {
        this.writeKey(key);
        return this.write(value);
    }

    protected abstract OracleJsonGenerator writeBinary(OracleJsonBinary var1);

    protected abstract OracleJsonGenerator writeDouble(OracleJsonDouble var1);

    protected abstract OracleJsonGenerator writeFloat(OracleJsonFloat var1);

    protected abstract OracleJsonGenerator writeOraNumber(OracleJsonDecimal var1);

    protected abstract OracleJsonGenerator writeTimestamp(OracleJsonTimestamp var1);

    protected abstract OracleJsonGenerator writeTimestampTZ(OracleJsonTimestampTZ var1);

    protected abstract OracleJsonGenerator writeDate(OracleJsonDate var1);

    protected abstract OracleJsonGenerator writeString(OracleJsonString var1);

    protected abstract OracleJsonGenerator writeIntervalDS(OracleJsonIntervalDS var1);

    protected abstract OracleJsonGenerator writeIntervalYM(OracleJsonIntervalYM var1);

    protected abstract void writeStringFromParser(OracleJsonParser var1);

    protected abstract void writeDecimalFromParser(OracleJsonParser var1);

    @Override
    public OracleJsonGenerator write(OracleJsonValue value) {
        this.writeOracleJsonValue(value);
        return this;
    }

    private void writeOracleJsonValue(OracleJsonValue value) {
        switch (value.getOracleJsonType()) {
            case OBJECT: {
                OracleJsonObject obj = (OracleJsonObject)value;
                this.writeStartObject();
                for (Map.Entry entry : obj.entrySet()) {
                    this.writeKey((String)entry.getKey());
                    this.writeOracleJsonValue((OracleJsonValue)entry.getValue());
                }
                this.writeEnd();
                break;
            }
            case ARRAY: {
                OracleJsonArray arr = (OracleJsonArray)value;
                this.writeStartArray();
                for (OracleJsonValue v : arr) {
                    this.writeOracleJsonValue(v);
                }
                this.writeEnd();
                break;
            }
            case BINARY: {
                this.writeBinary((OracleJsonBinary)value);
                break;
            }
            case FLOAT: {
                this.writeFloat((OracleJsonFloat)value);
                break;
            }
            case DOUBLE: {
                this.writeDouble((OracleJsonDouble)value);
                break;
            }
            case DECIMAL: {
                this.writeOraNumber((OracleJsonDecimal)value);
                break;
            }
            case STRING: {
                this.writeString((OracleJsonString)value);
                break;
            }
            case TIMESTAMP: {
                this.writeTimestamp((OracleJsonTimestamp)value);
                break;
            }
            case TIMESTAMPTZ: {
                this.writeTimestampTZ((OracleJsonTimestampTZ)value);
                break;
            }
            case DATE: {
                this.writeDate((OracleJsonDate)value);
                break;
            }
            case INTERVALDS: {
                this.writeIntervalDS((OracleJsonIntervalDS)value);
                break;
            }
            case INTERVALYM: {
                this.writeIntervalYM((OracleJsonIntervalYM)value);
                break;
            }
            case TRUE: {
                this.write(true);
                break;
            }
            case FALSE: {
                this.write(false);
                break;
            }
            case NULL: {
                this.writeNull();
            }
        }
    }

    @Override
    public OracleJsonGenerator writeParser(Object o) {
        block6: {
            try {
                if (o instanceof OracleJsonParser) {
                    this.writeOracleJsonParser((OracleJsonParser)o);
                    break block6;
                }
                if (o instanceof Wrapper && ((Wrapper)o).isWrapperFor(OracleJsonParser.class)) {
                    this.writeOracleJsonParser(((Wrapper)o).unwrap(OracleJsonParser.class));
                    break block6;
                }
                if (this.isInstance(o, Jsonp.JAKARTA_JSON_PARSER)) {
                    this.wrap(JakartaGeneratorWrapper.class).writeJsonParser(o);
                    break block6;
                }
                if (this.isInstance(o, Jsonp.JAVAX_JSON_PARSER)) {
                    this.wrap(JsonpGeneratorWrapper.class).writeJsonParser(o);
                    break block6;
                }
                throw new IllegalArgumentException();
            }
            catch (SQLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this;
    }

    private boolean isInstance(Object o, Class<?> c) {
        return c != null && c.isInstance(o);
    }

    private void writeOracleJsonParser(OracleJsonParser parser) {
        block19: while (parser.hasNext()) {
            switch (parser.next()) {
                case START_OBJECT: {
                    this.writeStartObject();
                    continue block19;
                }
                case START_ARRAY: {
                    this.writeStartArray();
                    continue block19;
                }
                case END_ARRAY: 
                case END_OBJECT: {
                    this.writeEnd();
                    continue block19;
                }
                case KEY_NAME: {
                    this.writeKey(parser.getString());
                    continue block19;
                }
                case VALUE_STRING: {
                    this.writeStringFromParser(parser);
                    continue block19;
                }
                case VALUE_TRUE: {
                    this.write(true);
                    continue block19;
                }
                case VALUE_FALSE: {
                    this.write(false);
                    continue block19;
                }
                case VALUE_NULL: {
                    this.writeNull();
                    continue block19;
                }
                case VALUE_BINARY: {
                    this.writeBinary(parser.getValue().asJsonBinary());
                    continue block19;
                }
                case VALUE_DATE: {
                    this.writeDate(parser.getValue().asJsonDate());
                    continue block19;
                }
                case VALUE_DECIMAL: {
                    this.writeDecimalFromParser(parser);
                    continue block19;
                }
                case VALUE_DOUBLE: {
                    this.write(parser.getDouble());
                    continue block19;
                }
                case VALUE_FLOAT: {
                    this.write(parser.getFloat());
                    continue block19;
                }
                case VALUE_INTERVALDS: {
                    this.writeIntervalDS(parser.getValue().asJsonIntervalDS());
                    continue block19;
                }
                case VALUE_INTERVALYM: {
                    this.writeIntervalYM(parser.getValue().asJsonIntervalYM());
                    continue block19;
                }
                case VALUE_TIMESTAMP: {
                    this.writeTimestamp(parser.getValue().asJsonTimestamp());
                    continue block19;
                }
                case VALUE_TIMESTAMPTZ: {
                    this.writeTimestampTZ(parser.getValue().asJsonTimestampTZ());
                    continue block19;
                }
            }
            throw new IllegalStateException();
        }
    }

    @Override
    public <T> T wrap(Class<T> wrapper) {
        try {
            if (Jsonp.hasJakarta() && (Jsonp.isJakartaJsonStream(wrapper) || wrapper == JakartaGeneratorWrapper.class)) {
                return wrapper.cast(new JakartaGeneratorWrapper(this));
            }
            return wrapper.cast(new JsonpGeneratorWrapper(this));
        }
        catch (ClassCastException e) {
            throw OracleJsonExceptions.BAD_WRAP.create(OracleJsonExceptions.ORACLE_FACTORY, e, wrapper.getName());
        }
    }
}

