/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.io.ByteArrayOutputStream;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.crypto.Cipher;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.BuildInfo;
import oracle.jdbc.pool.OracleDataSource;

public class OracleDriver
extends oracle.jdbc.driver.OracleDriver {
    public static final boolean isDMS() {
        return BuildInfo.isDMS();
    }

    public static final boolean isInServer() {
        return BuildInfo.isInServer();
    }

    public static final boolean isJDK14() {
        return BuildInfo.isJDK14();
    }

    public static final boolean isDebug() {
        return true;
    }

    public static final boolean isPrivateDebug() {
        return false;
    }

    public static final String getJDBCVersion() {
        return BuildInfo.getJDBCVersion();
    }

    public static final String getDriverVersion() {
        return BuildInfo.getDriverVersion();
    }

    public static final String getBuildDate() {
        return BuildInfo.getBuildDate();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Oracle " + OracleDriver.getDriverVersion() + " " + OracleDriver.getJDBCVersion() + (OracleDriver.isDMS() ? " DMS" : "") + (OracleDriver.isPrivateDebug() ? " private" : "") + (OracleDriver.isDebug() ? " debug" : "") + (OracleDriver.isInServer() ? " for JAVAVM" : "") + " compiled with " + BuildInfo.getCompilerVersion() + " on " + OracleDriver.getBuildDate());
        if (args != null && args.length > 0 && args[0].equals("getVersion")) {
            System.out.println(OracleDriver.getVersionInformation(args));
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(128);
        DEFAULT_CONNECTION_PROPERTIES.store(os, "Default Connection Properties Resource");
        System.out.println(os.toString("ISO-8859-1"));
        int maxKeySize = Cipher.getMaxAllowedKeyLength("AES");
        if (maxKeySize < 256) {
            System.out.println("***** JCE UNLIMITED STRENGTH NOT INSTALLED ****");
        } else {
            System.out.println("***** JCE UNLIMITED STRENGTH IS INSTALLED ****");
        }
    }

    private static String getVersionInformation(String[] args) throws SQLException {
        if (args.length < 2) {
            System.out.println("Please provide the connection URL.");
            return "";
        }
        String dbVersionInformation = "";
        String DB_URL = args[1];
        OracleDataSource ods = new OracleDataSource();
        ods.setURL(DB_URL);
        try (OracleConnection connection = (OracleConnection)ods.getConnection();){
            DatabaseMetaData dbmd = connection.getMetaData();
            dbVersionInformation = "Database Version: " + dbmd.getDatabaseProductVersion() + System.getProperty("line.separator") + "Installed JDK: " + System.getProperty("java.version");
        }
        return dbVersionInformation;
    }
}

