/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;

public enum RdfAction {
    BOOL,
    INTEGER,
    INT,
    LONG,
    FLOAT,
    DOUBLE,
    VERTEX,
    EDGE,
    STRING,
    TIME,
    DATE,
    RO_STRING_SET,
    VERTEX_LABEL,
    IGNORE;


    public String toKey() {
        return this.name().toLowerCase();
    }

    public PropertyType getPropertyType() {
        switch (this) {
            case BOOL: {
                return PropertyType.BOOLEAN;
            }
            case INTEGER: 
            case INT: {
                return PropertyType.INTEGER;
            }
            case LONG: {
                return PropertyType.LONG;
            }
            case FLOAT: {
                return PropertyType.FLOAT;
            }
            case DOUBLE: {
                return PropertyType.DOUBLE;
            }
            case VERTEX: {
                return PropertyType.VERTEX;
            }
            case EDGE: {
                return PropertyType.EDGE;
            }
            case STRING: {
                return PropertyType.STRING;
            }
            case TIME: 
            case DATE: {
                return PropertyType.TIMESTAMP;
            }
            case RO_STRING_SET: {
                return PropertyType.RO_STRING_SET;
            }
        }
        throw new IllegalStateException("Converting to property type is not supported");
    }

    public static RdfAction fromPropertyType(PropertyType propertyType) {
        switch (propertyType) {
            case INTEGER: {
                return INTEGER;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case BOOLEAN: {
                return BOOL;
            }
            case VERTEX: {
                return VERTEX;
            }
            case STRING: {
                return STRING;
            }
            case TIMESTAMP: {
                return DATE;
            }
            case RO_STRING_SET: {
                return RO_STRING_SET;
            }
        }
        throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"UNSUPPORTED_PROPERTY_TYPE", (Object[])new Object[]{propertyType.toKey()}));
    }
}

