/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import oracle.pgx.common.types.IdType;
import oracle.pgx.config.AbstractEntityProviderConfigBuilder;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.config.ProviderLoadingConfig;
import oracle.pgx.config.RdbmsEntityProviderConfig;

public final class RdbmsEntityProviderConfigBuilder
extends AbstractEntityProviderConfigBuilder<RdbmsEntityProviderConfigBuilder, RdbmsEntityProviderConfig> {
    public RdbmsEntityProviderConfigBuilder() {
        this.values.put(RdbmsEntityProviderConfig.Field.FORMAT.toKey(), ProviderFormat.RDBMS.toString());
    }

    @Override
    public RdbmsEntityProviderConfigBuilder toEntityProviderConfigBuilder() {
        return this;
    }

    @Override
    protected void addDefaultIdTypeIfMissing(Map<String, Object> raw) {
        Function<String, Object> valGetter = raw::get;
        if (!this.hasValue(RdbmsEntityProviderConfig.Field.KEY_TYPE, valGetter)) {
            boolean isEdgeTable = this.hasValue(RdbmsEntityProviderConfig.Field.SOURCE_VERTEX_PROVIDER, valGetter) && this.hasValue(RdbmsEntityProviderConfig.Field.DESTINATION_VERTEX_PROVIDER, valGetter);
            IdType defaultKeyType = isEdgeTable ? IdType.LONG : IdType.INTEGER;
            raw.put(RdbmsEntityProviderConfig.Field.KEY_TYPE.toKey(), defaultKeyType);
        }
    }

    @Override
    protected void addDefaultCreateIndexMappingIfMissing(Map<String, Object> raw) {
        boolean createIndexMapping;
        Function<String, Object> valGetter = raw::get;
        boolean isEdgeTable = this.hasValue(RdbmsEntityProviderConfig.Field.SOURCE_VERTEX_PROVIDER, valGetter) && this.hasValue(RdbmsEntityProviderConfig.Field.DESTINATION_VERTEX_PROVIDER, valGetter);
        boolean bl = createIndexMapping = !isEdgeTable;
        if (!this.hasValue(RdbmsEntityProviderConfig.Field.LOADING, valGetter)) {
            raw.put(RdbmsEntityProviderConfig.Field.LOADING.toKey(), new LinkedHashMap());
        }
        Object loadingSectionObject = valGetter.apply(RdbmsEntityProviderConfig.Field.LOADING.toKey());
        Map loadingSection = (Map)loadingSectionObject;
        loadingSection.putIfAbsent(ProviderLoadingConfig.Field.CREATE_KEY_MAPPING.toKey(), createIndexMapping);
    }

    @Override
    protected RdbmsEntityProviderConfig parseTableConfig(InputStream is) throws IOException {
        return RdbmsEntityProviderConfig.parse(is, true, null, true);
    }

    @Override
    public RdbmsEntityProviderConfigBuilder copyFrom(RdbmsEntityProviderConfig graphConfig) {
        super.copyFrom(graphConfig);
        this.setDataSourceId(graphConfig.getDataSourceId());
        this.setJdbcUrl(graphConfig.getJdbcUrl());
        this.setUsername(graphConfig.getUsername());
        this.setPassword((String)graphConfig.getValues().get(RdbmsEntityProviderConfig.Field.PASSWORD));
        this.setDatabaseTableName(graphConfig.getLoadedDatabaseTableName());
        if (!graphConfig.hasDefaultValue(RdbmsEntityProviderConfig.Field.NUM_CONNECTIONS)) {
            this.setNumConnections(graphConfig.getNumConnections());
        }
        this.setMaxPreFetchedRows(graphConfig.getMaxPrefetchedRows());
        this.setSchema(graphConfig.getSchema());
        this.setAsOf(graphConfig.getAsOf());
        this.setHasKeys(graphConfig.hasKeys());
        this.setKeyColumn(graphConfig.getKeyColumn());
        this.setSourceColumn(graphConfig.getSourceColumn());
        this.setDestinationColumn(graphConfig.getDestinationColumn());
        return (RdbmsEntityProviderConfigBuilder)this.getThis();
    }

    public RdbmsEntityProviderConfigBuilder setDataSourceId(String dsId) {
        this.values.put(RdbmsEntityProviderConfig.Field.DATA_SOURCE_ID.toKey(), dsId);
        return this;
    }

    public RdbmsEntityProviderConfigBuilder setJdbcUrl(String url) {
        this.values.put(RdbmsEntityProviderConfig.Field.JDBC_URL.toKey(), url);
        return this;
    }

    public RdbmsEntityProviderConfigBuilder setUsername(String un) {
        this.values.put(RdbmsEntityProviderConfig.Field.USERNAME.toKey(), un);
        return this;
    }

    public RdbmsEntityProviderConfigBuilder setDataTableName(String dataTableName) {
        return this.setDatabaseTableName(dataTableName);
    }

    public RdbmsEntityProviderConfigBuilder setDatabaseTableName(String databaseTableName) {
        this.values.put(RdbmsEntityProviderConfig.Field.DATABASE_TABLE_NAME.toKey(), databaseTableName);
        return this;
    }

    public RdbmsEntityProviderConfigBuilder setNumConnections(int c) {
        this.values.put(RdbmsEntityProviderConfig.Field.NUM_CONNECTIONS.toKey(), c);
        return this;
    }

    public RdbmsEntityProviderConfigBuilder setKeyColumn(String nKey) {
        this.values.put(RdbmsEntityProviderConfig.Field.KEY_COLUMN.toKey(), nKey);
        return this;
    }

    public RdbmsEntityProviderConfigBuilder setSourceColumn(String fromVkey) {
        this.values.put(RdbmsEntityProviderConfig.Field.SOURCE_COLUMN.toKey(), fromVkey);
        return this;
    }

    public RdbmsEntityProviderConfigBuilder setDestinationColumn(String toVkey) {
        this.values.put(RdbmsEntityProviderConfig.Field.DESTINATION_COLUMN.toKey(), toVkey);
        return this;
    }

    public RdbmsEntityProviderConfigBuilder setMaxPreFetchedRows(int maxPreFetchedRows) {
        this.values.put(RdbmsEntityProviderConfig.Field.MAX_PREFETCHED_ROWS.toKey(), maxPreFetchedRows);
        return this;
    }

    public RdbmsEntityProviderConfigBuilder setSchema(String schema) {
        this.values.put(RdbmsEntityProviderConfig.Field.SCHEMA.toKey(), schema);
        return this;
    }

    public RdbmsEntityProviderConfigBuilder setAsOf(String asOf) {
        this.values.put(RdbmsEntityProviderConfig.Field.AS_OF.toKey(), asOf);
        return this;
    }

    public RdbmsEntityProviderConfigBuilder setParallelHintDegree(int parallelHintDegree) {
        this.values.put(RdbmsEntityProviderConfig.Field.PARALLEL_HINT_DEGREE.toKey(), parallelHintDegree);
        return this;
    }
}

